//*initialization*/
// Provide and create the initialization webapp.
dojo.provide("webapp.initialization.controlDataBase");
dojo.declare("webapp.initialization.controlDataBase",[ICTouchAPI.webApplication],{

	//*********************************************************************
	// attributs
	numberInitStep : 0,
	initWidget : {},
	//boolSafeMode : true,
	initMessage : "",
	_timeCountDown : 0,
	boolSettingsButton : false,
	initImage : null,
	// Value of the setting EnableWebappBlutooth, used to load of not the webapp bluetooth in step 5
	_boolWebappBluetoothEnableState: true,
	// Boolean indicating if we entered in the setting webapp in step 5
	_boolInSettingStep5: false,
	// Boolean indicating if we received the end_of_init event
	_boolEndOfInitReceived: false,
	// handler of the event iFrame.show
	_handlerIFrameShow: null,
	discoveryLoginWidget : null,

	//********************************************************************
	// Constructor
	constructor: function()	{
		this.initImage = new Image();
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep1.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep2.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep3.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep4.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep5.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep6.jpg";


		this.numberInitStep  = 0;
		this.initMessage = "";
		// get the safe mode status
		//this.boolSafeMode = ICTouchAPI.webApplicationManager.getSafeModeStatus();
		// subscribe to events
		ICTouchAPI.eventServices.subscribeToEvent(this, "init_step_infra", this.onInitStepChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "end_of_init", this.onEndOfInit);
		ICTouchAPI.eventServices.subscribeToEvent(this, "reboot", this.onReboot);
		ICTouchAPI.eventServices.subscribeToEvent(this, "init_message", this.onMessage);
		ICTouchAPI.eventServices.subscribeToEvent(this, "DMLoginRequest", this.onDMLoginRequest);

		// Load webapp bluetooth in step 5 (if webapp bluetooth is enabled, so subscibe to the setting to check that)
		ICTouchAPI.settingServices.getSetting("EnableWebappBluetooth", this, this.setWebappBluetoothEnableState);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableWebappBluetooth", this.setWebappBluetoothEnableState);

	},

	unload: function() {
		ICTouchAPI.settingServices.unsubscribeToSetting(this, "EnableWebappBluetooth");

		// To be sure that we unsubscribe from any event
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "init_step_infra");
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "end_of_init");
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "reboot");
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "init_message");

		return true;
	},

	//**********************************************************************
	// Public Methods

	getInitWidget: function(){

		return this.initWidget;
	},

	getNumberInitStep : function(){
		return this.numberInitStep;
	},

	getInitMessage : function(){
		return this.initMessage;
	},

	setNumberInitStep : function(number){
		this.numberInitStep = number;
		if(this.initWidget && this.numberInitStep < 6){
			this.initWidget.changeStep(this.numberInitStep);
			this.initWidget.changeMessage("");
		}
		// If we received the init_step_infra 4 event, clear the cache of settings
		if (this.numberInitStep == 4) {
			ICTouchAPI.settingServices._clearCachedCategories();
		}
		// If we received the init_step_infra 6 event, look for loading the bluetooth webapp in step 5
		if (this.numberInitStep == 6) {
			this._loadBluetoothStep5();
		}
	},

	setStateOfSettingsButton : function(state){
		this.boolSettingsButton = state;
		if (this.initWidget){
			this.initWidget.setStateOfSettingsButton(state);
		}
	},

	getStateOfSettingsButton: function(){
		return this.boolSettingsButton;
	},

	//*********************************************************************
	// CallBack methods

	onMessage : function(message){
		this.initMessage = message.value;
		if(this.initWidget){
			this.initWidget.changeMessage(this.initMessage);
		}
	},

	onInitStepChanged : function(number){
		// the argument of event is in format JSON, so we need
		// to search the value of obejt
		this.setNumberInitStep(number.value);
	},

	onDMLoginRequest : function() {
		// On DMLoginRequest, just switch to a login screen
		ICTouchAPI.transitionServices.getScreen({name: "webapp.initialization.getDiscoveryLogin",
			params: {},
			position: "FullScreen"
		});
	},

	onEndOfInit : function(){
		var that = this;
		if (ICTouchAPI.webApplicationManager.applicationsStillLoading()) {
			setTimeout(function() {
				that.onEndOfInit();
				},
			500);
		} else {

			// unsubscribe events
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"end_of_init");
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"init_step_infra");
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"init_message");
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"reboot");

			//display the last step 'end_of_init"'
			if(this.initWidget){
				this.initWidget.goEndStep();
				this.initWidget.changeMessage("");
			}

			this.setBoolEndOfInitReceived(true);

			if (!this.getBoolInSettingStep5()) {
				this._continueLoading();
			}
		}
	},

	_loadBluetoothStep5: function () {
			// when we receive the init_step_infra 6, if the webapp bluetooth is enabled, load it and show the settings button
			if (this.getWebappBluetoothEnableState()) {
				ICTouchAPI.webApplicationManager.loadWebapp('bluetooth');
				ICTouchAPI.keyboardServices.preloadKeyboard(ICTouchAPI.KeyboardTypes.NUM);
				this.setStateOfSettingsButton(true);
			}
	},


	/**
         * _continueLoading is used to launch the load of the webapp using initFirstScreen
         * This function is used in the callback of the end_of_init event if we are not entered in the
		 * setting webapp in step 5, otherwise it is used when we press on the back button of the setting webapp
         */
	_continueLoading: function () {
		dojo.publish("load step 6");
			//reinitilaize the callback button which has been modified if the user
			//has clicked on "settings" button"
			webapp.settings.setByDefaultDirectionCallBackButton();
		webapp.initialization.setStateOfSettingsButton(false);
			//To load the webapps and render the first screen of phone set
			ICTouchAPI.initFirstScreen();
	},

	/**
         * onReboot is a callback function, it is called after the "reboot" event
         * This function activates a countdown from the time in second given in
         * argument
         * @param {time: integer}
         */
	onReboot : function(time){
		// test if the widget is intancied and if the time is upper than 0s
		// if time=0 it is not useful to display, the reboot is imminent
		if(this.initWidget && time.value >0){
			this.initWidget.inactivButtonsRender();
			this._timeCountDown = time.value;
			this._countDown();
		}
	},

	// loop until the countdown reaches 0
	// At each passed second, the user is informed
	_countDown : function(){
		// callback _countDown method after 1 second
		// warning the code goes on
		var counter = setTimeout(this,1000);
		// clear the timeout if the countdown = 0 in order to break the loop
		if(this._timeCountDown===0){
			clearTimeout(counter);
			this.initWidget.changeMessage("Reboot ");
		}
		else {
			this.initWidget.changeMessage("Reboot in "+this._timeCountDown+"s");
		}

		// decrement the countdown
		this._timeCountDown--;
	},

	setWebappBluetoothEnableState: function(objSetting) {
		if (objSetting && typeof objSetting.jsValue === "boolean") {
			this._boolWebappBluetoothEnableState = objSetting.jsValue;
	}
	},

	getWebappBluetoothEnableState: function() {
		return this._boolWebappBluetoothEnableState;
	},

	setBoolInSettingStep5: function(value) {
		if (value!=null && typeof value === "boolean") {
			this._boolInSettingStep5 = value;
		}
	},

	getBoolInSettingStep5: function() {
		return this._boolInSettingStep5;
	},

	setBoolEndOfInitReceived: function(value) {
		if (value!=null && typeof value === "boolean") {
			this._boolEndOfInitReceived = value;
		}
	},

	getBoolEndOfInitReceived: function() {
		return this._boolEndOfInitReceived;
	},	

	sendDiscovery: function() {
		// Get login and password from inputFields
		var login = this.discoveryLoginWidget.objInputName.getInputFieldContent();
		var password = this.discoveryLoginWidget.objPasswordName.getInputFieldContent();

		// Send information to DM by core function DMLogin
		ICTouchAPI.APIServices.Platform.DMLogin({params:[login, password]});

		// Turn back to normal init screen
		ICTouchAPI.transitionServices.getScreen({name: "webapp.initialization.initializationWidget", params: {}});

		// Clear password inputField to be sure it is empty on bad authentification cases
		this.discoveryLoginWidget.objPasswordName.setInputFieldContent("");
	}

});
/*initialization*/
// Provide and create the initialization webapp.
dojo.require("webapp.initialization.controlDataBase");
dojo.provide("webapp.initialization");
dojo.declare("webapp.initialization",webapp.initialization.controlDataBase,{
});

webapp.initialization = new webapp.initialization();
/**
 * @author CADART
 * @ver 1
 * @class InitializationWidget
 */

dojo.provide("webapp.initialization.initializationWidgetBase");
dojo.declare("webapp.initialization.initializationWidgetBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

		//**********************************************************************
		// attributs of InitializationWidget class

		// dom de la div global
		domInitialization : "",
		arrActionButtons : [],
		domArrActionButtons : [],
		//numberOfInitStep: 0,
		//currentInitStep : "",
		domMessage : {},
		strLabel : "",
		strMessage : "",
		//initMessage : "",
		safeModeStatus : "",		
		
		cssFile         :'main.css',

		attributeMap : {
			strMessage : {
				node : "domMessage",
				type : "innerHTML"
			}
		},
        //cssFile       : dojo.moduleUrl("webapp.initialization","themes/default/css/main.css"),

		//**********************************************************************
		// Constructor

		constructor : function(){
			// initialize the attibuts of instance
			//initialize the array of action buttons
			this.initArrActionButtons();
			//  reset the DOMs
			this.domArrActionButtons = [];
			this.domLabel = {};
			this.domMessage = {};
			this.strLabel = "";
			this.strMessage = "";
			// initialize the number of step
			//this.numberOfInitStep = webapp.initialization.getNumberInitStep();
			// initialize the initialization message
			//this.initMessage = webapp.initialization.getInitMessage();

			// make association between this and webapp.initialization.controlData
			webapp.initialization.initWidget = this;
			ICTouchAPI.skinServices.linkWebappsStyles("webapp.mainframe","webapp.settings",false,false,true,false);
			ICTouchAPI.skinServices.linkWebappsStyles("webapp.appbarframe","webapp.settings",true,false,false,false);

		},

		//**********************************************************************
		// private methods of InitializationWidget class

		//initialize the array of action buttons
		initArrActionButtons: function() {
			//toDo instancier des boutons, safemode dépend de la valeur appli manager
			//clear the actionButton array
			this.arrActionButtons = [];
			// instances of button of initialization widget
			var strStatusOfSettingsButton;
			var stateOfSettingsButton = webapp.initialization.getStateOfSettingsButton();
			if(stateOfSettingsButton){
				strStatusOfSettingsButton = "onDisplay";
			}
			else {
				strStatusOfSettingsButton = "unavailable";
			}
			var settingButton = new UIElements.AppButton.AppButtonControl({
				strButtonName:"settingOfInit",
				strButtonLabel:_("setting","webapp.initialization"),
				callback:{context:this, func:this._onClickSetting},
				strButtonIcon:'settings-application',
				strButtonStatus:strStatusOfSettingsButton
			});
			// var settingButton = new UIElements.AppButton.AppButtonControl({strButtonName:"settingOfInit", strButtonLabel:"setting",callback:{context:this, func:this._onClickSetting},strButtonIcon:''});

			if(ICTouchAPI.webApplicationManager.getSafeModeStatus()){
				this.safeModeStatus = 'notif-16px-on';
			}
			else {
                this.safeModeStatus = 'notif-16px-off';
            }
			var safeModeButton = new UIElements.AppButton.AppButtonControl({
				strButtonName:"safeMode",
				strButtonLabel:_("safe mode","webapp.initialization"),
				callback:{context:this, func:this._onClickSafeMode},
				strButtonIcon:'settings-initialization-safemode',
				strStatusIcon:this.safeModeStatus
				});
			// initialize the actionButton array
			this.arrActionButtons.push(settingButton);
			this.arrActionButtons.push(safeModeButton);
		},

		postCreate : function(){
			var numberInit = webapp.initialization.getNumberInitStep();

			this.changeMessage(webapp.initialization.getInitMessage());

			// place the action buttons
			for(var index = 0; index< this.arrActionButtons.length;index++){
				this.arrActionButtons[index].placeAt(this.domArrActionButtons[index], "replace");

				dojo.addClass(this.domInitialization,"onDisplay");
			}

			setTimeout(function() {
				ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
					params:["presentationReady"]
					});
			}, 1000);


			this.setStateOfSettingsButton(true);

			ICTouchAPI.eventServices.subscribeToEvent(webapp.initialization, "show_webapp_setting", this._launchSetting);
		},

		//**********************************************************************
		// public methods of InitializationWidget class

		/**
         * display method displays or removes the initialization screen
         * depending on the value of argument.
         * @param {boolean}
         */
		display : function(state){

			if(state){
				dojo.removeClass(this.domInitialization,"offDisplay");
				dojo.addClass(this.domInitialization,"onDisplay");
			}
			else {
				dojo.removeClass(this.domInitialization,"onDisplay");
				dojo.addClass(this.domInitialization,"offDisplay");
			}
		},

		changeStep : function(number){
			dojo.addClass(this.domInitialization, "bgStep"+(number));
			//this.numberOfInitStep = number;
			//when the initialization reaches the step4 - Software update
			// the action buttons become inactive
			if(number>=4){
				this.inactivButtonsRender();
			}
		},



		changeMessage : function(message){
			var msg;
			if (message.isI18Ned) {
				msg = message.getTranslation();
			} else  {
				msg = _(message,"webapp.initialization").getTranslation();
			}
			this.attr("strMessage", msg);
		},

		changeLabel : function(label){
			var lbl;
			if (label.isI18Ned) {
				lbl = label.getTranslation();
			} else  {
				lbl = label;
			}
			this.attr("strLabel", lbl);
		},

		goEndStep : function(){
			var number = 6; // step6 is the last step
			this.changeStep(number);
		},

		/*remove : function(){
            return;

            var node = document.getElementById("webapp.userinfo.getInitialization");
            //node.removeChild(node)
        },*/

		setStateOfSettingsButton: function(state){
			for(var index = 0; index < this.arrActionButtons.length; index++){
				var buttonName = this.arrActionButtons[index].getButtonName();

				if(buttonName ==="settingOfInit"){

					if(state){
						this.arrActionButtons[index].show();
					}
					else{
						this.arrActionButtons[index].greyTint();
					}
				}
			}
		},

		//*********************************************************************
		// private methods

		// to render inactiv the action buttons
		inactivButtonsRender : function(){
			for(var index = 0; index < this.arrActionButtons.length; index++){
				this.arrActionButtons[index].greyTint();
			}
		},

		_onClickSetting : function(){
			/*ICTouchAPI.APIServices.Platform.initLock({
				params: [true],
				context: this,
				callback: function(authorised){
							if( authorised){
								webapp.settings.setBackButton("webapp.initialization.initializationWidget");
								ICTouchAPI.transitionServices.getScreen({
									name:"webapp.settings.getSettings",
									params:{}
								});
							}
							else {
								this.changeMessage("action not authorized");
							}
						}
			});*/

        //callback for enterMMI
        var funcEnterMMI = function(authorised){
            if( authorised){
				// If the setting button is pressed in step 5, manage the bluetooth webapp and the loading of the step 6
				if (webapp.initialization.getNumberInitStep() > 3) {
					// set the boolean BoolInSettingStep5 to true :
					// if we receive the end of init event while we are in the setting webapp
					// the load of the webapp must be postponed to the moment when we leave the setting webapp
					webapp.initialization.setBoolInSettingStep5(true);
					webapp.initialization._handlerIFrameShow = dojo.subscribe("iframe.show", null, function(strFrameId) {
						if (strFrameId == "webapp.initialization.initializationWidget") {
							//reinitilaize the callback button which has been modified if the user
							//has clicked on "settings" button"
							webapp.settings.setByDefaultDirectionCallBackButton();

							// clear the subscription to the event iframe.show
							dojo.unsubscribe(webapp.initialization._handlerIFrameShow);
							webapp.initialization._handlerIFrameShow = null;

							// set the boolean BoolInSettingStep5 to false : we are not in the setting webapp anymore
							// so if the end_of_init is received while we already left the setting webapp, the load of the
							// webapp is done in treatment of the end_of_init event
							webapp.initialization.setBoolInSettingStep5(false);

							// If we already received the end_of_init event while we are in the settings,
							// we load the webapp using the _continueLoading function
							if (webapp.initialization.getBoolEndOfInitReceived()) {
								//To load the webapps and render the first screen of phone set
								webapp.initialization._continueLoading();
							}
						}
					});
				}
                webapp.settings.setBackButton("webapp.initialization.initializationWidget");
                ICTouchAPI.transitionServices.getScreen({
                    name:"webapp.settings.getSettings",
                    params:{}
                });
            }else{
                this.changeMessage("Action not authorized");
            }
        };
        //we call the enterMMI function to check our capability to enter into the setting webapp
        ICTouchAPI.settingServices.enterMMI({context : this, callback : funcEnterMMI});



		},

		_launchSetting : function() {
			webapp.settings.setBackButton("webapp.initialization.initializationWidget");
			ICTouchAPI.transitionServices.getScreen({
				name:"webapp.settings.getSettings",
				params:{}
			});
		},


		_onClickSafeMode: function(){

			if(ICTouchAPI.webApplicationManager.toggleSafeMode()){
				this.safeModeStatus = 'notif-16px-on';
			}
			else{
                this.safeModeStatus = 'notif-16px-off';
            }


			for(var index = 0; index < this.arrActionButtons.length; index++){
				var buttonName = this.arrActionButtons[index].getButtonName();

				if(buttonName ==="safeMode"){
					this.arrActionButtons[index].setStatusIcon(this.safeModeStatus);

				}
			}
		}

	}
	);
dojo.require("webapp.initialization.initializationWidgetBase");
dojo.provide("webapp.initialization.initializationWidget");
dojo.declare("webapp.initialization.initializationWidget",
	webapp.initialization.initializationWidgetBase,
	{
		templatePath: dojo.moduleUrl("webapp.initialization","templates/initializationWidget8082.html"),
	}
);
dojo.provide("webapp.initialization.getDiscoveryLoginBase");
dojo.declare("webapp.initialization.getDiscoveryLoginBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objInputName		: null,
		objPasswordName		: null,
		exclusiveIframe		: true,

		constructor : function() {
			this.objInputName = null;
			this.objPasswordName = null;
		},

		postCreate : function() {
			this.webapp.discoveryLoginWidget = this;
			
			this.objInputName = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strDefaultMode: ICTouchAPI.KeyboardAlphanumMode.NUMERIC,
				strInputText: "",
				isMultiLines: false
			}, this.domInputLogin);

			this.objPasswordName = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strDefaultMode: ICTouchAPI.KeyboardAlphanumMode.NUMERIC,
				strInputText: "",
				isMultiLines: false,
				boolPassword: true
			}, this.domInputPassword);

			new UIElements.AppButton.ButtonControl({
				strButtonName: "DISCOVERY_LOGIN_BTN",
				strButtonLabel: "",
				strButtonIcon: "generic-ok",
				callback: function() {
					webapp.initialization.sendDiscovery();
				}
			}, this.domLoginButton);					
		}
	}
);dojo.require("webapp.initialization.getDiscoveryLoginBase");
dojo.provide("webapp.initialization.getDiscoveryLogin");
dojo.declare("webapp.initialization.getDiscoveryLogin",
	webapp.initialization.getDiscoveryLoginBase,
	{
		templatePath	: dojo.moduleUrl("webapp.initialization","templates/getDiscoveryLogin8082.html"),
	}
);
