/**
 * @author CADART
 * @ver 1
 * @class InitializationWidget
 */

dojo.provide("webapp.initialization.initializationWidgetBase");
dojo.declare("webapp.initialization.initializationWidgetBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

		//**********************************************************************
		// attributs of InitializationWidget class

		// dom de la div global
		domInitialization : "",
		arrActionButtons : [],
		domArrActionButtons : [],
		//numberOfInitStep: 0,
		//currentInitStep : "",
		domMessage : {},
		strLabel : "",
		strMessage : "",
		//initMessage : "",
		safeModeStatus : "",		
		
		cssFile         :'main.css',

		attributeMap : {
			strMessage : {
				node : "domMessage",
				type : "innerHTML"
			}
		},
        //cssFile       : dojo.moduleUrl("webapp.initialization","themes/default/css/main.css"),

		//**********************************************************************
		// Constructor

		constructor : function(){
			// initialize the attibuts of instance
			//initialize the array of action buttons
			this.initArrActionButtons();
			//  reset the DOMs
			this.domArrActionButtons = [];
			this.domLabel = {};
			this.domMessage = {};
			this.strLabel = "";
			this.strMessage = "";
			// initialize the number of step
			//this.numberOfInitStep = webapp.initialization.getNumberInitStep();
			// initialize the initialization message
			//this.initMessage = webapp.initialization.getInitMessage();

			// make association between this and webapp.initialization.controlData
			webapp.initialization.initWidget = this;
			ICTouchAPI.skinServices.linkWebappsStyles("webapp.mainframe","webapp.settings",false,false,true,false);
			ICTouchAPI.skinServices.linkWebappsStyles("webapp.appbarframe","webapp.settings",true,false,false,false);

		},

		//**********************************************************************
		// private methods of InitializationWidget class

		//initialize the array of action buttons
		initArrActionButtons: function() {
			//toDo instancier des boutons, safemode dépend de la valeur appli manager
			//clear the actionButton array
			this.arrActionButtons = [];
			// instances of button of initialization widget
			var strStatusOfSettingsButton;
			var stateOfSettingsButton = webapp.initialization.getStateOfSettingsButton();
			if(stateOfSettingsButton){
				strStatusOfSettingsButton = "onDisplay";
			}
			else {
				strStatusOfSettingsButton = "unavailable";
			}
			var settingButton = new UIElements.AppButton.AppButtonControl({
				strButtonName:"settingOfInit",
				strButtonLabel:_("setting","webapp.initialization"),
				callback:{context:this, func:this._onClickSetting},
				strButtonIcon:'settings-application',
				strButtonStatus:strStatusOfSettingsButton
			});
			// var settingButton = new UIElements.AppButton.AppButtonControl({strButtonName:"settingOfInit", strButtonLabel:"setting",callback:{context:this, func:this._onClickSetting},strButtonIcon:''});

			if(ICTouchAPI.webApplicationManager.getSafeModeStatus()){
				this.safeModeStatus = 'notif-16px-on';
			}
			else {
                this.safeModeStatus = 'notif-16px-off';
            }
			var safeModeButton = new UIElements.AppButton.AppButtonControl({
				strButtonName:"safeMode",
				strButtonLabel:_("safe mode","webapp.initialization"),
				callback:{context:this, func:this._onClickSafeMode},
				strButtonIcon:'settings-initialization-safemode',
				strStatusIcon:this.safeModeStatus
				});
			// initialize the actionButton array
			this.arrActionButtons.push(settingButton);
			this.arrActionButtons.push(safeModeButton);
		},

		postCreate : function(){
			var numberInit = webapp.initialization.getNumberInitStep();

			this.changeMessage(webapp.initialization.getInitMessage());

			// place the action buttons
			for(var index = 0; index< this.arrActionButtons.length;index++){
				this.arrActionButtons[index].placeAt(this.domArrActionButtons[index], "replace");

				dojo.addClass(this.domInitialization,"onDisplay");
			}

			setTimeout(function() {
				ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
					params:["presentationReady"]
					});
			}, 1000);


			this.setStateOfSettingsButton(true);

			ICTouchAPI.eventServices.subscribeToEvent(webapp.initialization, "show_webapp_setting", this._launchSetting);
		},

		//**********************************************************************
		// public methods of InitializationWidget class

		/**
         * display method displays or removes the initialization screen
         * depending on the value of argument.
         * @param {boolean}
         */
		display : function(state){

			if(state){
				dojo.removeClass(this.domInitialization,"offDisplay");
				dojo.addClass(this.domInitialization,"onDisplay");
			}
			else {
				dojo.removeClass(this.domInitialization,"onDisplay");
				dojo.addClass(this.domInitialization,"offDisplay");
			}
		},

		changeStep : function(number){
			dojo.addClass(this.domInitialization, "bgStep"+(number));
			//this.numberOfInitStep = number;
			//when the initialization reaches the step4 - Software update
			// the action buttons become inactive
			if(number>=4){
				this.inactivButtonsRender();
			}
		},



		changeMessage : function(message){
			var msg;
			if (message.isI18Ned) {
				msg = message.getTranslation();
			} else  {
				msg = _(message,"webapp.initialization").getTranslation();
			}
			this.attr("strMessage", msg);
		},

		changeLabel : function(label){
			var lbl;
			if (label.isI18Ned) {
				lbl = label.getTranslation();
			} else  {
				lbl = label;
			}
			this.attr("strLabel", lbl);
		},

		goEndStep : function(){
			var number = 6; // step6 is the last step
			this.changeStep(number);
		},

		/*remove : function(){
            return;

            var node = document.getElementById("webapp.userinfo.getInitialization");
            //node.removeChild(node)
        },*/

		setStateOfSettingsButton: function(state){
			for(var index = 0; index < this.arrActionButtons.length; index++){
				var buttonName = this.arrActionButtons[index].getButtonName();

				if(buttonName ==="settingOfInit"){

					if(state){
						this.arrActionButtons[index].show();
					}
					else{
						this.arrActionButtons[index].greyTint();
					}
				}
			}
		},

		//*********************************************************************
		// private methods

		// to render inactiv the action buttons
		inactivButtonsRender : function(){
			for(var index = 0; index < this.arrActionButtons.length; index++){
				this.arrActionButtons[index].greyTint();
			}
		},

		_onClickSetting : function(){
			/*ICTouchAPI.APIServices.Platform.initLock({
				params: [true],
				context: this,
				callback: function(authorised){
							if( authorised){
								webapp.settings.setBackButton("webapp.initialization.initializationWidget");
								ICTouchAPI.transitionServices.getScreen({
									name:"webapp.settings.getSettings",
									params:{}
								});
							}
							else {
								this.changeMessage("action not authorized");
							}
						}
			});*/

        //callback for enterMMI
        var funcEnterMMI = function(authorised){
            if( authorised){
				// If the setting button is pressed in step 5, manage the bluetooth webapp and the loading of the step 6
				if (webapp.initialization.getNumberInitStep() > 3) {
					// set the boolean BoolInSettingStep5 to true :
					// if we receive the end of init event while we are in the setting webapp
					// the load of the webapp must be postponed to the moment when we leave the setting webapp
					webapp.initialization.setBoolInSettingStep5(true);
					webapp.initialization._handlerIFrameShow = dojo.subscribe("iframe.show", null, function(strFrameId) {
						if (strFrameId == "webapp.initialization.initializationWidget") {
							//reinitilaize the callback button which has been modified if the user
							//has clicked on "settings" button"
							webapp.settings.setByDefaultDirectionCallBackButton();

							// clear the subscription to the event iframe.show
							dojo.unsubscribe(webapp.initialization._handlerIFrameShow);
							webapp.initialization._handlerIFrameShow = null;

							// set the boolean BoolInSettingStep5 to false : we are not in the setting webapp anymore
							// so if the end_of_init is received while we already left the setting webapp, the load of the
							// webapp is done in treatment of the end_of_init event
							webapp.initialization.setBoolInSettingStep5(false);

							// If we already received the end_of_init event while we are in the settings,
							// we load the webapp using the _continueLoading function
							if (webapp.initialization.getBoolEndOfInitReceived()) {
								//To load the webapps and render the first screen of phone set
								webapp.initialization._continueLoading();
							}
						}
					});
				}
                webapp.settings.setBackButton("webapp.initialization.initializationWidget");
                ICTouchAPI.transitionServices.getScreen({
                    name:"webapp.settings.getSettings",
                    params:{}
                });
            }else{
                this.changeMessage("Action not authorized");
            }
        };
        //we call the enterMMI function to check our capability to enter into the setting webapp
        ICTouchAPI.settingServices.enterMMI({context : this, callback : funcEnterMMI});



		},

		_launchSetting : function() {
			webapp.settings.setBackButton("webapp.initialization.initializationWidget");
			ICTouchAPI.transitionServices.getScreen({
				name:"webapp.settings.getSettings",
				params:{}
			});
		},


		_onClickSafeMode: function(){

			if(ICTouchAPI.webApplicationManager.toggleSafeMode()){
				this.safeModeStatus = 'notif-16px-on';
			}
			else{
                this.safeModeStatus = 'notif-16px-off';
            }


			for(var index = 0; index < this.arrActionButtons.length; index++){
				var buttonName = this.arrActionButtons[index].getButtonName();

				if(buttonName ==="safeMode"){
					this.arrActionButtons[index].setStatusIcon(this.safeModeStatus);

				}
			}
		}

	}
	);
