//*initialization*/
// Provide and create the initialization webapp.
dojo.provide("webapp.initialization.controlDataBase");
dojo.declare("webapp.initialization.controlDataBase",[ICTouchAPI.webApplication],{

	//*********************************************************************
	// attributs
	numberInitStep : 0,
	initWidget : {},
	//boolSafeMode : true,
	initMessage : "",
	_timeCountDown : 0,
	boolSettingsButton : false,
	initImage : null,
	// Value of the setting EnableWebappBlutooth, used to load of not the webapp bluetooth in step 5
	_boolWebappBluetoothEnableState: true,
	// Boolean indicating if we entered in the setting webapp in step 5
	_boolInSettingStep5: false,
	// Boolean indicating if we received the end_of_init event
	_boolEndOfInitReceived: false,
	// handler of the event iFrame.show
	_handlerIFrameShow: null,
	discoveryLoginWidget : null,

	//********************************************************************
	// Constructor
	constructor: function()	{
		this.initImage = new Image();
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep1.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep2.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep3.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep4.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep5.jpg";
		this.initImage.src = "/webapp/initialization/themes/Default/images/initializationStep6.jpg";


		this.numberInitStep  = 0;
		this.initMessage = "";
		// get the safe mode status
		//this.boolSafeMode = ICTouchAPI.webApplicationManager.getSafeModeStatus();
		// subscribe to events
		ICTouchAPI.eventServices.subscribeToEvent(this, "init_step_infra", this.onInitStepChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "end_of_init", this.onEndOfInit);
		ICTouchAPI.eventServices.subscribeToEvent(this, "reboot", this.onReboot);
		ICTouchAPI.eventServices.subscribeToEvent(this, "init_message", this.onMessage);
		ICTouchAPI.eventServices.subscribeToEvent(this, "DMLoginRequest", this.onDMLoginRequest);

		// Load webapp bluetooth in step 5 (if webapp bluetooth is enabled, so subscibe to the setting to check that)
		ICTouchAPI.settingServices.getSetting("EnableWebappBluetooth", this, this.setWebappBluetoothEnableState);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableWebappBluetooth", this.setWebappBluetoothEnableState);

	},

	unload: function() {
		ICTouchAPI.settingServices.unsubscribeToSetting(this, "EnableWebappBluetooth");

		// To be sure that we unsubscribe from any event
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "init_step_infra");
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "end_of_init");
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "reboot");
		ICTouchAPI.eventServices.unsubscribeToEvent(this, "init_message");

		return true;
	},

	//**********************************************************************
	// Public Methods

	getInitWidget: function(){

		return this.initWidget;
	},

	getNumberInitStep : function(){
		return this.numberInitStep;
	},

	getInitMessage : function(){
		return this.initMessage;
	},

	setNumberInitStep : function(number){
		this.numberInitStep = number;
		if(this.initWidget && this.numberInitStep < 6){
			this.initWidget.changeStep(this.numberInitStep);
			this.initWidget.changeMessage("");
		}
		// If we received the init_step_infra 4 event, clear the cache of settings
		if (this.numberInitStep == 4) {
			ICTouchAPI.settingServices._clearCachedCategories();
		}
		// If we received the init_step_infra 6 event, look for loading the bluetooth webapp in step 5
		if (this.numberInitStep == 6) {
			this._loadBluetoothStep5();
		}
	},

	setStateOfSettingsButton : function(state){
		this.boolSettingsButton = state;
		if (this.initWidget){
			this.initWidget.setStateOfSettingsButton(state);
		}
	},

	getStateOfSettingsButton: function(){
		return this.boolSettingsButton;
	},

	//*********************************************************************
	// CallBack methods

	onMessage : function(message){
		this.initMessage = message.value;
		if(this.initWidget){
			this.initWidget.changeMessage(this.initMessage);
		}
	},

	onInitStepChanged : function(number){
		// the argument of event is in format JSON, so we need
		// to search the value of obejt
		this.setNumberInitStep(number.value);
	},

	onDMLoginRequest : function() {
		// On DMLoginRequest, just switch to a login screen
		ICTouchAPI.transitionServices.getScreen({name: "webapp.initialization.getDiscoveryLogin",
			params: {},
			position: "FullScreen"
		});
	},

	onEndOfInit : function(){
		var that = this;
		if (ICTouchAPI.webApplicationManager.applicationsStillLoading()) {
			setTimeout(function() {
				that.onEndOfInit();
				},
			500);
		} else {

			// unsubscribe events
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"end_of_init");
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"init_step_infra");
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"init_message");
			ICTouchAPI.eventServices.unsubscribeToEvent(this,"reboot");

			//display the last step 'end_of_init"'
			if(this.initWidget){
				this.initWidget.goEndStep();
				this.initWidget.changeMessage("");
			}

			this.setBoolEndOfInitReceived(true);

			if (!this.getBoolInSettingStep5()) {
				this._continueLoading();
			}
		}
	},

	_loadBluetoothStep5: function () {
			// when we receive the init_step_infra 6, if the webapp bluetooth is enabled, load it and show the settings button
			if (this.getWebappBluetoothEnableState()) {
				ICTouchAPI.webApplicationManager.loadWebapp('bluetooth');
				ICTouchAPI.keyboardServices.preloadKeyboard(ICTouchAPI.KeyboardTypes.NUM);
				this.setStateOfSettingsButton(true);
			}
	},


	/**
         * _continueLoading is used to launch the load of the webapp using initFirstScreen
         * This function is used in the callback of the end_of_init event if we are not entered in the
		 * setting webapp in step 5, otherwise it is used when we press on the back button of the setting webapp
         */
	_continueLoading: function () {
		dojo.publish("load step 6");
			//reinitilaize the callback button which has been modified if the user
			//has clicked on "settings" button"
			webapp.settings.setByDefaultDirectionCallBackButton();
		webapp.initialization.setStateOfSettingsButton(false);
			//To load the webapps and render the first screen of phone set
			ICTouchAPI.initFirstScreen();
	},

	/**
         * onReboot is a callback function, it is called after the "reboot" event
         * This function activates a countdown from the time in second given in
         * argument
         * @param {time: integer}
         */
	onReboot : function(time){
		// test if the widget is intancied and if the time is upper than 0s
		// if time=0 it is not useful to display, the reboot is imminent
		if(this.initWidget && time.value >0){
			this.initWidget.inactivButtonsRender();
			this._timeCountDown = time.value;
			this._countDown();
		}
	},

	// loop until the countdown reaches 0
	// At each passed second, the user is informed
	_countDown : function(){
		// callback _countDown method after 1 second
		// warning the code goes on
		var counter = setTimeout(this,1000);
		// clear the timeout if the countdown = 0 in order to break the loop
		if(this._timeCountDown===0){
			clearTimeout(counter);
			this.initWidget.changeMessage("Reboot ");
		}
		else {
			this.initWidget.changeMessage("Reboot in "+this._timeCountDown+"s");
		}

		// decrement the countdown
		this._timeCountDown--;
	},

	setWebappBluetoothEnableState: function(objSetting) {
		if (objSetting && typeof objSetting.jsValue === "boolean") {
			this._boolWebappBluetoothEnableState = objSetting.jsValue;
	}
	},

	getWebappBluetoothEnableState: function() {
		return this._boolWebappBluetoothEnableState;
	},

	setBoolInSettingStep5: function(value) {
		if (value!=null && typeof value === "boolean") {
			this._boolInSettingStep5 = value;
		}
	},

	getBoolInSettingStep5: function() {
		return this._boolInSettingStep5;
	},

	setBoolEndOfInitReceived: function(value) {
		if (value!=null && typeof value === "boolean") {
			this._boolEndOfInitReceived = value;
		}
	},

	getBoolEndOfInitReceived: function() {
		return this._boolEndOfInitReceived;
	},	

	sendDiscovery: function() {
		// Get login and password from inputFields
		var login = this.discoveryLoginWidget.objInputName.getInputFieldContent();
		var password = this.discoveryLoginWidget.objPasswordName.getInputFieldContent();

		// Send information to DM by core function DMLogin
		ICTouchAPI.APIServices.Platform.DMLogin({params:[login, password]});

		// Turn back to normal init screen
		ICTouchAPI.transitionServices.getScreen({name: "webapp.initialization.initializationWidget", params: {}});

		// Clear password inputField to be sure it is empty on bad authentification cases
		this.discoveryLoginWidget.objPasswordName.setInputFieldContent("");
	}

});
