#!/bin/sh

if [ $# == 0 ]
then
   echo "No parameter: need password value or __RESET_TO_DEFAULT__"
   exit 1
fi

# get password
value=$1

if [ "$value" == "__RESET_TO_DEFAULT__"  -o "$value" == "*tx8000#" ]
then
   # reset admin password to default
   value="*tx8000#"
   # don't forget to also reset password change flag
   rm -f /home/admin/.pwd.changed
else
   # indicate that password has been changed
   touch -f /home/admin/.pwd.changed
fi

# crms00278717
rm -f /etc/shadow+
rm -f /etc/shadow-
# call the chpasswd tool to update pw (using MD5)
echo "admin:$value" | /usr/sbin/chpasswd -m
