#!/bin/sh
#
#  This script will configure/deconfigure the network interfaces of a device 
#  using the 'ifconfig' configuration utility, and the 'udhcp' DHCP client. 
#
#  Usage:
#     if_setup.sh up|down|reconfig
#        up         - configure network interfaces
#        down       - deconfigure network interfaces
#        reconfig   - reconfigure network interface after phone boots up, should be used after if_setup.sh down

############
# CHANGELOG
#===========
# 2010/08/18    CRMS00258266    Thanh lam NGUYEN
#               Fix functions return code
#               as "RETURN" is an alias which ends in "return", the return code has to be an immediate or memorized in a variable !!!
#
# 2010/08/23    CRMS00236814    Thanh lam NGUYEN
#               Check duplicate ip before setting it in Static mode
#
# 2010/08/11    CRMS00251533    Thanh lam NGUYEN
#               Add markers for the DNS hook to work
#
# 2010/03/26    CRMS00225368    Thanh lam NGUYEN
#               Fix the content of ENETCFG_INTERFACE for NVCURRENT_ROOT
#
# 2010/02/26    CRMS00152511    Thanh lam NGUYEN
#               update the use of /etc/functions
#               remove the driver on stop.
# 
# 2010/04/15    CRMS00218317	alexca
#               cannot update the udhcpc AVA vlan
#                  
# 2010/04/28    CRMS00230582    alexca
#               cannot receive offer when beginning
#
# 2010/06/27    CRMS00241451    alexca
#               Update ENETCFG_VLAN_ENBALE when needed 
#
# 2010/07/14    crms00243163	alexca
#               Do not read interface from /config/dhcp/enet.cfg when interface down
#
# 2010/07/22    CRMS00240761    jasonaz
#               Sleep 5 seconds for vlan acquirment by LLDP
#
# 2010/09/14    CRMS00257236    alexca
#               New DSCP/802.1p scenario implementation
#
# 2010/10/15    CRMS00267205    alexca
#               802.1p only can be set from 0 to 6
#
# 2011/02/14    CRMS00293844    alexca
#               Rollback 802.1p scenario 
#
# 2011/03/03    CRMS00296013    michelsu
#               Duplicate IP address popup
#
# 2011/03/22    CRMS00300718    jasonaz
#               Start of IP Phone is not ok when in VLAN environment
#
# 2011/09/01    CRMS00334363    jasonaz
#               Initialize of IP Phone failed in tagged port with Omnistack 6148
# 
################

#
# Read configuration & helpers
# ============================
# This has to be done early in order to be able to get all the functions
CONFIG=/etc/sysconfig
. $CONFIG
FUNCHELPER=/etc/functions
. $FUNCHELPER

#
# Function definiton
# ==================
help()
{
    echo "Usage: if_setup.sh [interface1 itnerface2 ...] up|down|reconfig"
    exit 1
}

setVlan()
{
    local - FUNCTION=setVlan
    ENTER_FUNCTION
    local vlan=$1

    # bring up $ENETCFG_INTERFACE
    ifconfig $ENETCFG_INTERFACE 0.0.0.0 up
    # remove previous vlan
    [[ -n "$INTERFACE" ]] && [[ -n "${INTERFACE//[^.]}" ]] && [[ "${INTERFACE#*.}" != "$vlan" ]] && vconfig rem $INTERFACE
    # add Vlan
    if [[ "${INTERFACE#*.}" != "$vlan" ]]; then
        vconfig add $ENETCFG_INTERFACE $vlan
        INTERFACE=$ENETCFG_INTERFACE.$vlan
        ifconfig $INTERFACE up
        ifconfig $INTERFACE down
        ifconfig $INTERFACE up
#crms00257236 alexca+
#crms00267205 alexca+
#crms00293844 alexca+
        vconfig set_egress_map $INTERFACE 0 0 >/dev/null
        vconfig set_egress_map $INTERFACE 1 1 >/dev/null 
        vconfig set_egress_map $INTERFACE 2 2 >/dev/null
        vconfig set_egress_map $INTERFACE 3 3 >/dev/null
        vconfig set_egress_map $INTERFACE 4 4 >/dev/null
        vconfig set_egress_map $INTERFACE 5 5 >/dev/null
        vconfig set_egress_map $INTERFACE 6 6 >/dev/null
        vconfig set_egress_map $INTERFACE 7 7 >/dev/null
#crms00293844 alexca-
#crms00267205 alexca-
#crms00257236 alexca-
#crms00241451 alexca+
        updateCurrentConfig enet.cfg --noread
#crms00241451 alexca-
    fi 
    RETURN 0
}

configInterface()
{
    local - FUNCTION=configInterface
    ENTER_FUNCTION
    local ret=0 \
          CURRENTMAC CMAC_VALUE EMAC_VALUE

    loadNetworkModules
    ret=$?
    [[ $ret -ne 0 ]] && { RETURN $ret; }

    # hw config
# CRMS00258266
    configEthHw || { ret=$?; RETURN $ret; }
# CRMS00258266 END

    # mac address
    INTERFACE=$ENETCFG_INTERFACE
    CURRENTMAC=$($busybox ifconfig $INTERFACE | $busybox sed '/HWaddr/{s/^.*HWaddr[[:blank:]]*//;p};d')
    CMAC_VALUE=$((0x${CURRENTMAC//:}))
    EMAC_VALUE=$((0x${ENETCFG_MACADDR//:}))
    if [ "$CMAC_VALUE" == "0" -a "$CMAC_VALUE" != "$EMAC_VALUE" ]; then
        ifconfig $INTERFACE hw ether $ENETCFG_MACADDR
    fi
    CURRENTMAC=$($busybox ifconfig $INTERFACE | $busybox sed '/HWaddr/{s/^.*HWaddr[[:blank:]]*//;p};d')
    CMAC_VALUE=$((0x${CURRENTMAC//:}))
    [[ "$CMAC_VALUE" != "$EMAC_VALUE" ]] && { RETURN 1; }
    
    # check the link status
# CRMS00258266
    checkLinkStatus || { ret=$?; RETURN $ret; }
# CRMS00258266 END
    
    #crms00230582 alexca+                                                           
# CRMS00334363 jasonaz+
    ifconfig $INTERFACE up                       
# CRMS00334363 jasonaz-
    ifconfig $INTERFACE down  
    ifconfig $INTERFACE up                       
    #crms00230582 alexca-       
    
    # set local vlan if any defined
    case "$ENETCFG_VLAN_ENABLE" in
         [Tt][Rr][Uu][Ee]*|[Yy][Ee][Ss]*|[Ee][Nn][Aa]Bb][Ll][Ee]*) : "${attr}VLAN is enable${default}"
            setVlan $ENETCFG_VLAN
        ;;
    esac
    
    # 802.1x
    /etc/init.d/wpa start

    # LLDP
    # CR 00225444
    # The lldp paquets should never be tagged
# CRMS00236814
    if  ! ps -w | grep lldpagent | grep -v grep >/dev/null 2>&1; then
	#crms00241451 alexca+
        lldpagent -i ${ENETCFG_INTERFACE}
	#crms00241451 alexca-
        #CRMS00240761 jasonaz+
        sleep 8 
        #CRMS00240761 jasonaz-
    fi
# CRMS00236814 end
    # CR 00225444

    [[ -f $NVLLDP_ROOT/enet.cfg ]] && readConfig
    case "$ENETCFG_VLAN_ENABLE" in
        [Tt][Rr][Uu][Ee]*|[Yy][Ee][Ss]*|[Ee][Nn][Aa]Bb][Ll][Ee]*) : "${attr}VLAN is enable${default}"
            setVlan $ENETCFG_VLAN
        ;;
    esac

    # ADDR
    case "$ENETCFG_DHCP_MODE" in
        [Ss]tatic) : "${attr}Static mode${default}"
            # STATIC
# CRMS00236814
            : "${attr}Waiting for $ENETCFG_IPADDR to be free...${default}"
            POPUPID="DUPIP_STEP3"
            # crms00296013+
            popupDisplayed=0
            # crms00296013-
            stdout="$(arping -c 2 -w 3 -D -I $ENETCFG_INTERFACE $ENETCFG_IPADDR 2>&1)"
            while [[ $? -ne 0 ]]; do
                # Display the error
                : "${attr}stdout=$stdout${default}"
                dupmac=$(echo "$stdout" | awk '/reply from/{mac=$5; gsub( /[][]/, "", mac ); print mac}')
                : "${attr}dupmac=$dupmac${default}"
                # reformat the mac to AA:BB:CC:DD:EE:FF format
                eval " \
                IFS=\":\"; \
                set -- \$dupmac; \
                dupmac=\$(printf \"%02X-%02X-%02X-%02X-%02X-%02X\" \$((0x\$1)) \$((0x\$2)) \$((0x\$3)) \$((0x\$4)) \$((0x\$5)) \$((0x\$6))); \
                unset IFS
                "
                : "${attr}dupmac=$dupmac${default}"
                MESSAGE="Duplicate IP ${ipAddr:-$ENETCFG_IPADDR} used by [$dupmac]"
                # crms00296013+
                # display only once without timeout
                if [ "$popupDisplayed" == "0" ]; then
                   popupDisplayed=1
                   displaypopup -i $POPUPID -l error $MESSAGE
                fi
                # crms00296013+
                displaymsg ""
                displaymsg "$MESSAGE"
                sleep 10
                stdout="$(arping -c 2 -w 3 -D -I $ENETCFG_INTERFACE $ENETCFG_IPADDR)"
                # IP address is aready in used
            done
            displaypopup -i $POPUPID -k 
            displaymsg ""
# CRMS00236814 end
            : "${attr}Assign $ENETCFG_IPADDR to $INTERFACE...${default}"
            ifconfig $INTERFACE $ENETCFG_IPADDR netmask $ENETCFG_SUBNET
        ;;
        *) : "${attr}Dynamic mode${default}"
            # DHCP
            # ====
            # The most recently bound IP address for each network interface is stored
            # in a configuration file called ip-addr-${interface}, e.g. ip-addr-eth0,
            # by the DHCP client. This same IP address will be requested in the DHCP
            # discover sent by this device.
            #
            # Note that the DHCP client makes a backup of the config file before
            # modifying it. And then deletes the backup after the modification is
            # complete. If the backup still exists at this point, then we need to
            # assume that the device was reset during this update operation and the
            # contents of the config file are bogus. In this situation, turf the
            # config file, and revert to the backup.
            # 
            if [ -f $NVDHCP_ROOT/ip-addr-$ENETCFG_INTERFACE.bk ];
            then
                cp -f ${NVDHCP_ROOT}/ip-addr-${ENETCFG_INTERFACE}.bk ${NVDHCP_ROOT}/ip-addr-${ENETCFG_INTERFACE}
                rm -f ${NVDHCP_ROOT}/ip-addr-${ENETCFG_INTERFACE}.bk
            fi

            if [ -f ${NVDHCP_ROOT}/ip-addr-${ENETCFG_INTERFACE} ];
            then
                . ${NVDHCP_ROOT}/ip-addr-${ENETCFG_INTERFACE}

                ip_addr_saved=ip_address_saved_${ENETCFG_INTERFACE}
                eval ip_addr_saved=\$$ip_addr_saved
            fi

            #
            # Spawn the DHCP client. Try to use the most recently bound IP address 
            # for this device. Also, run the client in "background" mode so that it 
            # doesn't bail if we don't initially obtain an IP address.
            #
#crms00218317 alexca+
# CRMS00225743
            udhcpc -b -S -i $INTERFACE -s /usr/share/udhcpc/default.script -p /var/run/udhcpc.${INTERFACE}.pid ${ip_addr_saved+-r $ip_addr_saved}
# CRMS00225743
#crms00218317 alexca-
            if [ -f $NVDHCP_ROOT/enet.cfg ]; then
                readConfig
				#crms00241451 alexca+
                INTERFACE=${ENETCFG_INTERFACE//.*}
				#crms00241451 alexca-
                case "$ENETCFG_VLAN_ENABLE" in
                    [Tt][Rr][Uu][Ee]*|[Yy][Ee][Ss]*|[Ee][Nn][Aa]Bb][Ll][Ee]*) : "${attr}VLAN is enable${default}"
# CRMS00225368
                        INTERFACE=${ENETCFG_INTERFACE//.*}.$ENETCFG_VLAN
# CRMS00225368 END
                    ;;
                esac
            else
                # something happened, no response from DHCP server
                RETURN 1
            fi
        ;;
    esac
    # start the interface
    ifconfig $INTERFACE up
    ifconfig $INTERFACE down
    ifconfig $INTERFACE up

    # add domain name
    : "${attr}Updating /etc/hosts${default}"
    HOSTS="$(cat /etc/hosts)"
    echo "$HOSTS" | awk "/$HOSTNAME/{next}{print}END{print \"$ENETCFG_IPADDR	${ENETCFG_DOMAIN:+$HOSTNAME.$ENETCFG_DOMAIN }$HOSTNAME\"}" > /etc/hosts

    # update DNS server
    (
        : "${attr}Updating /etc/resolv.conf${default}"
# CRMS00251533
        data="${ENETCFG_DOMAIN:+search $ENETCFG_DOMAIN}\n"
        if [[ "${ENETCFG_DNS1}" != "0.0.0.0" ]]; then 
            data="${data}nameserver $ENETCFG_DNS1 "
        fi
        data="$data# ENETCFG_DNS1\n"
        if [[ "${ENETCFG_DNS2}" != "0.0.0.0" ]]; then 
            data="${data}nameserver $ENETCFG_DNS2 "
        fi
        data="$data# ENETCFG_DNS2\n"
        if [[ "${ENETCFG_DNS3}" != "0.0.0.0" ]]; then 
            data="${data}nameserver $ENETCFG_DNS3 "
        fi
        data="$data# ENETCFG_DNS3\n"
        echo "$data" >/etc/resolv.conf
# CRMS00251533 END
    )
# CRMS00300718 jasonaz+
    ifconfig ${ENETCFG_INTERFACE%%.*} up 
    ifconfig ${ENETCFG_INTERFACE%%.*} down
    ifconfig ${ENETCFG_INTERFACE%%.*} up 
# CRMS00300718 jasonaz-
    # add the default route
    : "${attr}Updating default router${default}"
    route add default gw $ENETCFG_ROUTER

## CRMS00152511
    # create the current value for
    : "${attr}Updating current config information${default}"
    updateCurrentConfig enet.cfg --noread
## CRMS00152511 END
    RETURN 0
}


RET=0
readConfig

#
# Process command line
# ====================
if [[ $# -lt 1 ]]; then
    echo "Error - incorrect number of parameters!"
    help
fi

while [[ $# -ne 0 ]]; do
    case "$1" in
        up|down|reconfig) : "${attr}action definition ($1)${default}"
            config_type=$1
        ;;
        lo|loopback) : "${attr}add lo interface${default}"
            interfaces="${interfaces:+$interfaces }lo"
        ;;
        $ENETCFG_INTERFACE) : "${attr}add lan interface${default}"
            interfaces="${interfaces:+$interfaces }$1"
        ;;
        *) : "${attr}Unknown argument${default}"
            help
            exit 1
        ;;
    esac
    shift
done

if [ -z "${config_type:-}" ]; then
    help
    exit 1
fi

# set the default values if needed
echo "${interfaces:=lo $ENETCFG_INTERFACE}" > /dev/null

#
# Misc variables.
#
resolv_conf="/etc/resolv.conf"

interfaces="${interfaces} "
: "${attr}interfaces=[$interfaces]${default}"
while [[ ! -z "${interfaces}" ]]; do
    case "${interfaces%% *}_${config_type}" in
        ############
        # LOOPBACK #
        ############
        # UP
        #===
        lo_up) : "${attr}loopback up${default}"
            ifconfig lo 127.0.0.1 netmask 255.0.0.0 up
            RET=$?
        ;;
        # DOWN & RECONFIG
        #================
        lo_*) : "${attr}looback $config_type (do nothing)${default}"
        ;;
        ######################
        # $ENETCFG_INTERFACE #
        ######################
        # UP & RECONFIG
        #==============
        ${ENETCFG_INTERFACE}_up) : "${attr}$ENETCFG_INTERFACE $config_type${default}"
            # check if already up
            ifconfig ${ENETCFG_INTERFACE} | grep -A 1 "inet addr" | grep -q "UP" || configInterface
            RET=$?
        ;;
        ${ENETCFG_INTERFACE}_reconfig) : "${attr}$ENETCFG_INTERFACE $config_type${default}"
            configInterface
            RET=$?
        ;;
        # DOWN
        #=====
        ${ENETCFG_INTERFACE}_down) : "${attr}$ENETCFG_INTERFACE $config_type${default}"
            case "$ENETCFG_DHCP_MODE" in
                [Ss]tatic) : "${attr}static MODE${default}"
                ;;
                *) : "${attr}DHCP MODE${default}"
                    #crms00243163 alexca+
                    #. $NVDHCP_ROOT/enet.cfg
                    # DHCP
                    if [ -f /var/run/udhcpc.*.pid ]; then
                        kill -USR2 $(cat /var/run/udhcpc.*.pid)
                        usleep 100000
                        kill -TERM $(cat /var/run/udhcpc.*.pid)
                    fi
                    #crms00243163 alexca-
                ;;
            esac
			#crms00243163 alexca+
			readCurrentConfig
			ENETCFG_INTERFACE=${ENETCFG_INTERFACE//.*}
			#crms00243163 alexca-
            if [ "$ENETCFG_VLAN_ENABLE" == "true" ]; then
                vconfig rem $ENETCFG_INTERFACE.$ENETCFG_VLAN
            fi
            echo "Sending EAP logoff"
            wpa_cli -p /var/run/wpa_supplicant logoff
# CRMS00236814
            rm /var/log/8021X_log.txt 2>/dev/null
            #killall lldpagent 2>/dev/null
            [[ -x /etc/init.d/dupip ]] && /etc/init.d/dupip stop
            [[ -x /etc/init.d/linkd ]] && /etc/init.d/linkd stop
# CRMS00236814 end
            modprobe -r $ENETCFG_INTERFACE
            RET=$?
        ;;
    esac
    # remove the first word and leading spaces
    interfaces=${interfaces#* } interfaces=${interfaces## }
done
exit $RET
