#!/bin/sh
#
# Load the ethernet interface

#
# 'config_type' indicates if network interfaces should be setup or torn down.
#
config_type=$1
[ $config_type != up ] && [ $config_type != down ] && [ $config_type != reconfig ] && echo "Incorrect config_type '${config_type}'" && exit 1

set -x

NET_DRIVER=bcmring_net

if [ $config_type = up ]; then

        modprobe ${NET_DRIVER}
fi

unset x


# A zero return value indicates that the network interface should be
# configured using the default process (e.g. udhcpc, ifconfig).
exit 0
