dojo.provide("webapp.help.controlBase");
dojo.declare("webapp.help.controlBase",
	ICTouchAPI.webApplication,
	{
        objContentContainer : null,
        container : null,
        list : null,

        VHE_SCROLL_OFFSET   :   260,

		constructor : function()
		{
            ICTouchAPI.settingServices.subscribeToSetting(this, "IsHelpAvailable", this.checkHelp);
			ICTouchAPI.settingServices.subscribeToSetting(this, "Language", this.languageChanged);
		},

        checkHelp : function (objSetting) {
            if (objSetting.jsValue) {
                dojo.publish("showHelpEvent");
            } else {
                dojo.publish("hideHelpEvent");
            }
        },

		load:function () {
		//help
		dojo.publish("needHelpEvent",["help",[]]);
		},

		languageChanged : function(objSetting){
			this.data.reloadHelp();
		},

        buttonCallback : function(buttonId) {
            switch(buttonId)
            {
                case webapp.help.data.BACK:
                    if (webapp.help.data.strCurrentBackTransition) {
                        ICTouchAPI.transitionServices.back();
                        //ICTouchAPI.transitionServices.getScreen({name: webapp.help.data.strCurrentBackTransition, params: {}});
                    } else {
                       dojo.publish("OpenHomepage");
                    }
                    break;

                case webapp.help.data.PREVIOUS:
					this.loadPrevious();
                    break;

                case webapp.help.data.NEXT:
					this.loadNext();
                    break;

                default:
                    console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
                    break;
            }
        },

		updateButtons : function(){
			//Get Appbar and buttons
			var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
			var nextBtn = appBar.getButton(this.data.NEXT);
			var previousBtn = appBar.getButton(this.data.PREVIOUS);

			//If we are at the first sub-chapter
			if (this.data.intCurrentSelectedIteMList <= 1) {
				if (previousBtn){
					previousBtn.greyTint();
				}
				//If we are not at the last sub-chapter (excetionnal case of only one subchapter)
				if (nextBtn && this.data.intCurrentSelectedIteMList < this.data._arrList.length - 1){
					nextBtn.show();
				}
			}
			//If we are at the last sub-chapter
			else if (this.data.intCurrentSelectedIteMList >= this.data._arrList.length - 1){
				if (nextBtn){
					nextBtn.greyTint();
				}
				//If we are not at the first sub-chapter (excetionnal case of only one subchapter)
				if (previousBtn && this.data.intCurrentSelectedIteMList > 1 ){
					previousBtn.show();
				}
			}
			//If we are not at the first and not the last
			else{
				if (previousBtn){
					previousBtn.show();
				}
				if (nextBtn){
					nextBtn.show();
				}
			}
		},


        fillHelp : function(response) {
            // remove current widget and replace it
			if (this.objContentContainer) {
				this.removeWidget(this.objContentContainer.strWidgetName);
			}

            webapp.help.data.strHelpContent = response;
            this.container.refresh();

        },

        loadChapter : function(chapterName, curWebapp) {

            webapp.help.data.strCurrentBackTransition = ICTouchAPI.transitionServices._objCurrentScreen.id;
            webapp.help.loadInternalChapter(chapterName, curWebapp);
        },

		loadPrevious: function() {
			var data = webapp.help.data;

			var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
			var nextBtn = appBar.getButton(webapp.help.data.NEXT);
			var previousBtn = appBar.getButton(webapp.help.data.PREVIOUS);
			//test for a valid previous operation
			if (data.intCurrentSelectedIteMList > 1 &&  data.intCurrentSelectedIteMList <= data._arrList.length){
				data.intCurrentSelectedIteMList--;
				//if the previous subchapter is in fact a title then skip it
				if (webapp.help.data._arrList[data.intCurrentSelectedIteMList].strType === "title") {
					this.loadPrevious();
					return;
				}
				//if this is the first subchapter then gray the next button
				if (data.intCurrentSelectedIteMList <= 1) {
					if (previousBtn){
						previousBtn.greyTint();
                    }
				}
				//display previous subchapter
				this.selectChapterById(data.intCurrentSelectedIteMList);
				//show next button
				if (nextBtn){
					nextBtn.show();
                }
			}
		},

		loadNext: function() {
			var data = webapp.help.data;

			var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
			var nextBtn = appBar.getButton(webapp.help.data.NEXT);
			var previousBtn = appBar.getButton(webapp.help.data.PREVIOUS);
			//test for a valid next operation
			if (data.intCurrentSelectedIteMList >= 0 &&  data.intCurrentSelectedIteMList < data._arrList.length - 1) {
				data.intCurrentSelectedIteMList++;
				//if the next subchapter is in fact a title then skip it
				if (webapp.help.data._arrList[data.intCurrentSelectedIteMList].strType === "title") {
					this.loadNext();
					return;
				}
				//if this is the last subchapter then gray the next button
				if (data.intCurrentSelectedIteMList >= data._arrList.length - 1) {
					if (nextBtn){
						nextBtn.greyTint();
                    }
				}
				//display the new subchapter
				this.selectChapterById(data.intCurrentSelectedIteMList);
				//show the previous button
				if (previousBtn){
					previousBtn.show();
                }
			}
		},

		selectChapterById: function(intId) {

			if (webapp.help.data.objListUI) {
				webapp.help.data.objListUI.selectItemByIndex(intId, false);
			}
			webapp.help.data.getHtmlFile(intId);
		},

        loadInternalChapter : function(chapterName, curWebapp) {
            ICTouchAPI.transitionServices.getScreen({name: "webapp.help.getOnlineHelp", params: {}});
            var strDefPath = dojo.moduleUrl("webapp." + curWebapp, "help/" + chapterName).path;
            var strLocPath = dojo.moduleUrl("webapp." + curWebapp, "help/" + dojo.locale + "/" + chapterName).path;
			//console.log("loadInternalChapter: strDefPath :" + strDefPath);
			//console.log("loadInternalChapter: strLocPath :" + strLocPath);
            var arr = webapp.help.data.getOnlineHelpList();
             for (var i = 0; i < arr.length; i++) {
                if (arr[i].strPath) {
                    if (strDefPath === arr[i].strPath.path || strLocPath === arr[i].strPath.path) {
                        if (webapp.help.data.objListUI) {
                            webapp.help.data.objListUI.selectItemByIndex(i, false);
							webapp.help.data.intCurrentSelectedIteMList = i;
                        }
                        webapp.help.data.getHtmlFile(i);
                        return;
                    }
                }
            }
        },

        jumpTo : function(anchor) {
            if (this.objContentContainer.scroll) {
                var arrLinks = dojo.query("a", this.objContentContainer.domContainerContent);
                if (arrLinks) {
                    for (var i = 0; i < arrLinks.length; i++) {
                        if (anchor === arrLinks[i].name) {
                            //this.objContentContainer.scroll._objScroll.moveToDom(arrLinks[i]);
							webapp.help.data.intCurrentSelectedIteMList = i;
                        }
                    }
                }
            }
        }
	}
);
dojo.require("webapp.help.controlBase");
dojo.provide("webapp.help");
dojo.declare("webapp.help",
	webapp.help.controlBase,
	{

	}
);

webapp.help=new webapp.help();
dojo.provide("webapp.help.dataBase");

dojo.declare("webapp.help.dataBase", null, {
	arrHelpWebapps		: [],
	arrHelpWidgets		: [],
	_arrAppButtons      : [],
	_arrSysButtons      : [],
	strTitle			: "Help",
	strHelpContent              : "",
	strOnlineHelpContainerTitle	: "",
	_arrList                    : [],
	strCurrentWebapp            : "",
	intCurrentSelectedIteMList	: -1,
	objListUI                   : null,
	_nbChapter                  : null,
	_nbSubChapter               : null,
	_helpBoolState              : null,
	_updateHelpButtonToDo       : false,
	strCurrentBackTransition    : "",

	// Buttons definition
	BACK        : "BACK_BTN",
	PREVIOUS    : "PREVIOUS_BTN",
	NEXT        : "NEXT_BTN",

	constructor : function(){
		var func = {context:webapp.help, func:webapp.help.buttonCallback};

		this._arrSysButtons[this.PREVIOUS] ={ objbutton: "" , button: {
			strButtonName: this.PREVIOUS,
			strButtonLabel: _('Back', 'ICTouchAPI'),
			callback : func,
			strButtonIcon: 'generic-back',
			strStatusText:'',
			strStatusIcon:''
		}};
		this._arrSysButtons[this.NEXT] = { objbutton: "" , button:{
			strButtonName: this.NEXT,
			strButtonLabel: _('Next', 'ICTouchAPI'),
			callback : func,
			strButtonIcon: 'generic-next',
			strStatusText:'',
			strStatusIcon:''
		}};

		dojo.subscribe("needHelpEvent", this, this.loadList);
		this._nbChapter = 0;
		this._nbSubChapter = 0;
		ICTouchAPI.settingServices.getSettingValue("IsHelpAvailable", this, this.loadedHelpState);
	},

		loadedHelpState : function (settingValue) {
			if (settingValue !== null && settingValue !== undefined) {
				this._helpBoolState = settingValue;
				if (this._updateHelpButtonToDo) {
					if (this._helpBoolState) {
						dojo.publish("showHelpEvent");
					}else{
						dojo.publish("hideHelpEvent");
					}
					this._updateHelpButtonToDo = false;
				}
			}
		},

	getAppButtons: function(){
		//return	this._arrAppButtons //ICTouchAPI.i18nServices.translate(this._arrAppButtons, "webapp.help");
		return this._arrSysButtons;
	},

	getAppBarAppButtons: function(){
		return this._arrSysButtons;
		//return	ICTouchAPI.i18nServices.translate(this._arrSysButtons(strButtonLabel), "webapp.help");
	},

	getOnlineHelpContainerTitle: function(){
		return this.strOnlineHelpContainerTitle;
	},

	getOnlineHelpListTitle: function(){
		return _(this.strTitle, "webapp.help");//ICTouchAPI.i18nServices.translate(this.strTitle, "webapp.help");
	},

	getOnlineHelpContent: function(){
		return this.strHelpContent;
	},

	getOnlineHelpList: function() {
		return this._arrList;
	},

	reloadHelp : function(){
		this._arrList = [];
		this._nbChapter = 0;
		for (var i=0;i<this.arrHelpWebapps.length;i++){
			this.loadList(this.arrHelpWebapps[i],this.arrHelpWidgets[this.arrHelpWebapps[i]]);
		}
	},


	loadList : function(strWebapp, strWidgetList) {
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp." + strWebapp, "webapp.help",true,false);
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp.help","webapp." + strWebapp,true,true,true);

		if(this.arrHelpWebapps.indexOf(strWebapp) == -1){
			this.arrHelpWebapps.push(strWebapp);
		}
		this.arrHelpWidgets[strWebapp] = strWidgetList;

		//console.log("reception  HELP EVENT webapp=" + strWebapp + " widget= " + strWidgetList);
		var jsonPath = dojo.moduleUrl("webapp." + strWebapp, "help/" + dojo.locale + "/help.json");
		//console.log("jsonpath= " + jsonPath);
		var that=this;
		dojo.xhrGet({
			url: jsonPath,
			handleAs: 'json',
			contextData: {
				context: this,
				strWebapp: strWebapp
			},
			helpPath: "help/" + dojo.locale + "/",

			load: function(helpObj, ioArgs){that.loadedJson(helpObj, ioArgs, strWidgetList)},
			error: function(error, ioArgs){
				if (error.status !== 404) {
					//console.log("help / loadList: error " + error + " url:"+ioArgs.url);
				}
				else {
					// Try to load default language help
					var jsonDefPath = dojo.moduleUrl("webapp."+ ioArgs.args.contextData.strWebapp, "help/help.json");
					//console.log("jsonDefPath= " + jsonDefPath);
					dojo.xhrGet({
						url: jsonDefPath,
						handleAs: 'json',
						contextData: ioArgs.args.contextData,
						helpPath: "help/",
						load: function(helpObj, ioArgs){that.loadedJson(helpObj, ioArgs, strWidgetList)},
						error: function(error, ioArgs){
							if (error.status !== 404) {
								console.log("help / loadList: error " + error + " url:"+ioArgs.url);
							}
						}
					});
				}
			}
		});	//End dojo.xhrGet
	},

	loadedJson : function(helpObj, ioArgs, strWidgetList) {
		//console.log("loadedJson en cours");
		var ctx = ioArgs.args.contextData.context;
		ctx._nbChapter++;
		ctx._nbSubChapter = 1;
		ctx._arrList.push( {
			strPrimaryContent: ctx._nbChapter + " " + helpObj.name,
			strType: "title"
		} );

		//console.log("loadlList -> helpObj" + helpObj);
		//console.log("loadlList -> ioArgs" + ioArgs);
		for (var i = 0; i < helpObj.chapters.length; i++) {
			//console.log("webapp." + ioArgs.args.contextData.strWebapp, ioArgs.args.helpPath + helpObj.chapters[i].html);
			var htmlPath = dojo.moduleUrl("webapp." + ioArgs.args.contextData.strWebapp, ioArgs.args.helpPath + helpObj.chapters[i].html);
			ctx._arrList.push({
				intIndex: ctx._arrList.length,
				strPrimaryContent: ctx._nbChapter + "." + ctx._nbSubChapter + " " + helpObj.chapters[i].name,
				strPath: htmlPath,
				strWebapp: ioArgs.args.contextData.strWebapp,
				strAppBarId:helpObj.chapters[i].appBarId,
				strHtmlFile : helpObj.chapters[i].html
			});
//                if (helpObj.chapters[i].appBarId) {
//                    var chapter = helpObj.chapters[i].html;
//                    var func = dojo.hitch(this, webapp.help.loadChapter, chapter ,ioArgs.args.contextData.strWebapp);
//                    var objButton = new UIElements.AppButton.AppButtonControl({strButtonLabel: _('Help', "webapp.help"), strButtonName: 'homepageBtnHelp', callback : func, strButtonIcon: 'app-64px-settings', strStatusText:'', strStatusIcon:''});
//                    ICTouchAPI.ActionBarServices.addOtherWebAppButton(ioArgs.args.contextData.strWebapp, helpObj.chapters[i].appBarId, objButton);
//                    objButton.addEventsShowing("showHelpEvent");
//                    objButton.addEventsHiding("hideHelpEvent");
//                    if (ctx._helpBoolState == null) {
//                        // help state setting has not been received, remember that updating button is to do
//                        ctx._updateHelpButtonToDo = true;
//                    } else {
//                        if (!ctx._helpBoolState){
//                            objButton.hide();
//                        }
//                    }
//               }
		   ctx._nbSubChapter++;
		}

		for (i=0; i<strWidgetList.length; i++) {
			var strWidget = strWidgetList[i];
			var chapter = helpObj.chapters[0].html;
			var func = { context: this, func:function(){webapp.help.loadChapter(chapter ,ioArgs.args.contextData.strWebapp)} };
			var objButton = new UIElements.AppButton.AppButtonControl({strButtonLabel: _('Help',"webapp.help"), strButtonName: 'homepageBtnHelp', callback : func, strButtonIcon: 'help-application', strStatusText:'', strStatusIcon:''});
				// pour le moment on la laisse dans la zone droite (non static button)
				//ICTouchAPI.ActionBarServices.addStaticButton(ioArgs.args.contextData.strWebapp, strWidget, objButton);
				ICTouchAPI.AppBarServices.addOtherWebAppButton(ioArgs.args.contextData.strWebapp, strWidget, objButton);
			// }

			objButton.addEventsShowing("showHelpEvent");
			objButton.addEventsHiding("hideHelpEvent");
			if (ctx._helpBoolState == null) {
				// help state setting has not been received, remember that updating button is to do
				ctx._updateHelpButtonToDo = true;
			} else {
				if (!ctx._helpBoolState){
					objButton.hide();
				}
			}
		}
		if (webapp.help.list){
			webapp.help.list.refresh();
		}
	},

	getHtmlFile : function(id){
		if ((id || id === 0) && this._arrList[id].strPath) {
			this.strCurrentWebapp = this._arrList[id].strWebapp;
			this.strOnlineHelpContainerTitle = this._arrList[id].strPrimaryContent;
			this.intCurrentSelectedIteMList = id;
			dojo.xhrGet({
				url: this._arrList[id].strPath,
				handleAs: 'text',
				// La fonction est dans le control
				//load: dojo.hitch(webapp.help, webapp.help.fillHelp)
				load: function(response) {webapp.help.fillHelp(response)}
			});
		}
		webapp.help.updateButtons();
	},

	isPreviousHome : function() {
		if (this.strCurrentBackTransition){
			return false;
        }
		else{
			return true;
        }
    }
});
dojo.require("webapp.help.dataBase");
dojo.provide("webapp.help.data");

dojo.declare("webapp.help.data", webapp.help.dataBase, {

});

webapp.help.data = new webapp.help.data();
dojo.provide("webapp.help.getOnlineHelpBase");
dojo.declare("webapp.help.getOnlineHelpBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelp.html"),
		cssFile : ['main.css','icons.css'],

        helpContainer   : null,

                constructor:function(){

                    this.stealth();
                },

		postCreate:function(){
			this.helpContainer = new UIElements.ApplicationMode.ThirdControl({
				menu : {
					name    : "webapp.help.getOnlineHelpList",
					params  : {}
				},

				container : {
					name    : "webapp.help.getOnlineHelpContainer",
					params  : {}
				}
            },this.mainPart);
            webapp.help.container = this.helpContainer.getContainer();
                webapp.help.list = this.helpContainer.getMenu();

		// Create the static back button
                var backFunc = {context:webapp.help, func:webapp.help.buttonCallback, param:webapp.help.data.BACK};
				ICTouchAPI.AppBarServices.addExitButton("help", "getOnlineHelp",webapp.help.data.isPreviousHome(), backFunc);

                var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
                var arrButtons = webapp.help.data.getAppBarAppButtons();
                for (var i in arrButtons) {
                    var objButton = new UIElements.AppButton.AppButtonControl(arrButtons[i].button);
                    arrButtons[i].objbutton = objButton;
                    appBar.addActionButton(objButton);
                }
                ICTouchAPI.AppBarServices.updateAppBar("help", "getOnlineHelp");

				webapp.help.updateButtons();
				if (webapp.help.data.objListUI) {
					webapp.help.data.objListUI.selectItemByIndex(webapp.help.data.intCurrentSelectedIteMList, false);
				}
            },

            destroy : function(){
                this.helpContainer.destroy();
                this.inherited(arguments);
            }
    }
);dojo.require("webapp.help.getOnlineHelpBase");
dojo.provide("webapp.help.getOnlineHelp");
dojo.declare("webapp.help.getOnlineHelp",
	webapp.help.getOnlineHelpBase,
	{
		templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelp8082.html"),
    }
);dojo.provide("webapp.help.getOnlineHelpContainerBase");
dojo.declare("webapp.help.getOnlineHelpContainerBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
        templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelpContainer.html"),

		postCreate:function(){
			this.container = new UIElements.Container.ContainerControl(
	        {
				objTitle: {
					strLabel        : webapp.help.data.getOnlineHelpContainerTitle()
				},

				objContent: {
                    name    : "webapp.help.getOnlineHelpContainerContent",
					params  : {}
				}
	        }, this.domContainer);
			webapp.help.objContentContainer = this.container.getContent();
            webapp.help.objContentContainer.attr("strContent", webapp.help.data.getOnlineHelpContent());

            var arrLinks = dojo.query("a", webapp.help.objContentContainer.domContainerContent);
            var i,curWebapp;
            if (arrLinks) {
                for (i = 0; i < arrLinks.length; i++) {
                    if (arrLinks[i].href) {
                        var chapter = ICTouchAPI.tools.basename(arrLinks[i].href);
                        var anchor = ICTouchAPI.tools.anchor(chapter);
                        curWebapp = webapp.help.data.strCurrentWebapp;
                        if (anchor !== ""){
                            arrLinks[i].href = "javascript:webapp.help.jumpTo('" + anchor + "')";
                        }
                        else{
                            arrLinks[i].href = "javascript:webapp.help.loadInternalChapter('" + chapter +"' , '" + curWebapp + "')";
                        }
                    }
                }
            }
            //we replace the URL of pictures to display it
            var arrImgs=dojo.query("img",webapp.help.objContentContainer.domContainerContent);
            if(arrImgs){

                for(i=0;i<arrImgs.length;i++){

                    if(arrImgs[i].src){
                        curWebapp = webapp.help.data.strCurrentWebapp;
                        var url="http://localhost/webapp/";
                        var temp=arrImgs[i].src.slice(16);//remove http:/127.0.0.1/ from string
                        arrImgs[i].src=url+curWebapp+"/help"+temp;
                    }
                }


            }

		}/*,//do not use until you want a crash
        destroy : function(){
            this.container.destroy();
            //this.inherited(arguments);
        }*/
	}
);
dojo.require("webapp.help.getOnlineHelpContainerBase");
dojo.provide("webapp.help.getOnlineHelpContainer");
dojo.declare("webapp.help.getOnlineHelpContainer",
    webapp.help.getOnlineHelpContainerBase,
    {
        templatePath	: dojo.moduleUrl("webapp.help","templates/getOnlineHelpContainer8082.html"),
	}
);
dojo.provide("webapp.help.getOnlineHelpContainerContentBase");
dojo.declare("webapp.help.getOnlineHelpContainerContentBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
        templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelpContainerContent.html"),
		i18n : "webapp.help",
		strContent: "",
                scroll : null,



        postCreate:function(){
			webapp.help.dom_test=this;
                        this.scroll = FXScroll.init({
				"handler" : this.domContainerContent,
				"easing" : true,
				"scrollType" : "vertical"
                        });
		},

		// Maniere automatise de remplir le innerHTML en fonction de l'attribut
		attributeMap: {
			strContent: {node: "domContainerContent", type: "innerHTML"}
		},

        destroy : function(){
            if(this.scroll){
                    this.scroll=null;
            }
            this.inherited(arguments);
        }

	 });dojo.require("webapp.help.getOnlineHelpContainerContentBase");
dojo.provide("webapp.help.getOnlineHelpContainerContent");
dojo.declare("webapp.help.getOnlineHelpContainerContent",
    webapp.help.getOnlineHelpContainerContentBase,
    {
        templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelpContainerContent8082.html"),
	}
);dojo.provide("webapp.help.getOnlineHelpListBase");
dojo.declare("webapp.help.getOnlineHelpListBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelpList.html"),
        containerList   : null,

        postCreate:function(){
            this.containerList=new UIElements.Container.ContainerControl(

                {
                objTitle: {
                    strLabel    : webapp.help.data.getOnlineHelpListTitle()
                 },

                objContent: {
                    name    : "webapp.help.getOnlineHelpListContent",
                    params  : {}
                    }
                }, this.domList);
            },

            destroy : function(){
                this.containerList.destroy();
                this.inherited(arguments);
            },

			refresh : function(){
				this.containerList.refresh();
			}
	}
);
dojo.require("webapp.help.getOnlineHelpListBase");
dojo.provide("webapp.help.getOnlineHelpList");
dojo.declare("webapp.help.getOnlineHelpList",
	webapp.help.getOnlineHelpListBase,
	{
		templatePath	: dojo.moduleUrl("webapp.help","templates/getOnlineHelpList8082.html"),
	}
);
dojo.provide("webapp.help.getOnlineHelpListContentBase");
dojo.declare("webapp.help.getOnlineHelpListContentBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelpListContent.html"),

		postCreate:function(){
            var arrList = webapp.help.data.getOnlineHelpList();
            var func = {context:webapp.help.data, func:webapp.help.data.getHtmlFile};
            webapp.help.data.objListUI = new UIElements.MenuList.MenuListControl({arrItems: arrList, autoSelectFirst : false, callback: func}, this.domListContent);
		}
	}
);
dojo.require("webapp.help.getOnlineHelpListContentBase");
dojo.provide("webapp.help.getOnlineHelpListContent");
dojo.declare("webapp.help.getOnlineHelpListContent",
	webapp.help.getOnlineHelpListContentBase,
	{
		templatePath: dojo.moduleUrl("webapp.help","templates/getOnlineHelpListContent8082.html"),
	}
);
