dojo.provide("webapp.help.dataBase");

dojo.declare("webapp.help.dataBase", null, {
	arrHelpWebapps		: [],
	arrHelpWidgets		: [],
	_arrAppButtons      : [],
	_arrSysButtons      : [],
	strTitle			: "Help",
	strHelpContent              : "",
	strOnlineHelpContainerTitle	: "",
	_arrList                    : [],
	strCurrentWebapp            : "",
	intCurrentSelectedIteMList	: -1,
	objListUI                   : null,
	_nbChapter                  : null,
	_nbSubChapter               : null,
	_helpBoolState              : null,
	_updateHelpButtonToDo       : false,
	strCurrentBackTransition    : "",

	// Buttons definition
	BACK        : "BACK_BTN",
	PREVIOUS    : "PREVIOUS_BTN",
	NEXT        : "NEXT_BTN",

	constructor : function(){
		var func = {context:webapp.help, func:webapp.help.buttonCallback};

		this._arrSysButtons[this.PREVIOUS] ={ objbutton: "" , button: {
			strButtonName: this.PREVIOUS,
			strButtonLabel: _('Back', 'ICTouchAPI'),
			callback : func,
			strButtonIcon: 'generic-back',
			strStatusText:'',
			strStatusIcon:''
		}};
		this._arrSysButtons[this.NEXT] = { objbutton: "" , button:{
			strButtonName: this.NEXT,
			strButtonLabel: _('Next', 'ICTouchAPI'),
			callback : func,
			strButtonIcon: 'generic-next',
			strStatusText:'',
			strStatusIcon:''
		}};

		dojo.subscribe("needHelpEvent", this, this.loadList);
		this._nbChapter = 0;
		this._nbSubChapter = 0;
		ICTouchAPI.settingServices.getSettingValue("IsHelpAvailable", this, this.loadedHelpState);
	},

		loadedHelpState : function (settingValue) {
			if (settingValue !== null && settingValue !== undefined) {
				this._helpBoolState = settingValue;
				if (this._updateHelpButtonToDo) {
					if (this._helpBoolState) {
						dojo.publish("showHelpEvent");
					}else{
						dojo.publish("hideHelpEvent");
					}
					this._updateHelpButtonToDo = false;
				}
			}
		},

	getAppButtons: function(){
		//return	this._arrAppButtons //ICTouchAPI.i18nServices.translate(this._arrAppButtons, "webapp.help");
		return this._arrSysButtons;
	},

	getAppBarAppButtons: function(){
		return this._arrSysButtons;
		//return	ICTouchAPI.i18nServices.translate(this._arrSysButtons(strButtonLabel), "webapp.help");
	},

	getOnlineHelpContainerTitle: function(){
		return this.strOnlineHelpContainerTitle;
	},

	getOnlineHelpListTitle: function(){
		return _(this.strTitle, "webapp.help");//ICTouchAPI.i18nServices.translate(this.strTitle, "webapp.help");
	},

	getOnlineHelpContent: function(){
		return this.strHelpContent;
	},

	getOnlineHelpList: function() {
		return this._arrList;
	},

	reloadHelp : function(){
		this._arrList = [];
		this._nbChapter = 0;
		for (var i=0;i<this.arrHelpWebapps.length;i++){
			this.loadList(this.arrHelpWebapps[i],this.arrHelpWidgets[this.arrHelpWebapps[i]]);
		}
	},


	loadList : function(strWebapp, strWidgetList) {
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp." + strWebapp, "webapp.help",true,false);
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp.help","webapp." + strWebapp,true,true,true);

		if(this.arrHelpWebapps.indexOf(strWebapp) == -1){
			this.arrHelpWebapps.push(strWebapp);
		}
		this.arrHelpWidgets[strWebapp] = strWidgetList;

		//console.log("reception  HELP EVENT webapp=" + strWebapp + " widget= " + strWidgetList);
		var jsonPath = dojo.moduleUrl("webapp." + strWebapp, "help/" + dojo.locale + "/help.json");
		//console.log("jsonpath= " + jsonPath);
		var that=this;
		dojo.xhrGet({
			url: jsonPath,
			handleAs: 'json',
			contextData: {
				context: this,
				strWebapp: strWebapp
			},
			helpPath: "help/" + dojo.locale + "/",

			load: function(helpObj, ioArgs){that.loadedJson(helpObj, ioArgs, strWidgetList)},
			error: function(error, ioArgs){
				if (error.status !== 404) {
					//console.log("help / loadList: error " + error + " url:"+ioArgs.url);
				}
				else {
					// Try to load default language help
					var jsonDefPath = dojo.moduleUrl("webapp."+ ioArgs.args.contextData.strWebapp, "help/help.json");
					//console.log("jsonDefPath= " + jsonDefPath);
					dojo.xhrGet({
						url: jsonDefPath,
						handleAs: 'json',
						contextData: ioArgs.args.contextData,
						helpPath: "help/",
						load: function(helpObj, ioArgs){that.loadedJson(helpObj, ioArgs, strWidgetList)},
						error: function(error, ioArgs){
							if (error.status !== 404) {
								console.log("help / loadList: error " + error + " url:"+ioArgs.url);
							}
						}
					});
				}
			}
		});	//End dojo.xhrGet
	},

	loadedJson : function(helpObj, ioArgs, strWidgetList) {
		//console.log("loadedJson en cours");
		var ctx = ioArgs.args.contextData.context;
		ctx._nbChapter++;
		ctx._nbSubChapter = 1;
		ctx._arrList.push( {
			strPrimaryContent: ctx._nbChapter + " " + helpObj.name,
			strType: "title"
		} );

		//console.log("loadlList -> helpObj" + helpObj);
		//console.log("loadlList -> ioArgs" + ioArgs);
		for (var i = 0; i < helpObj.chapters.length; i++) {
			//console.log("webapp." + ioArgs.args.contextData.strWebapp, ioArgs.args.helpPath + helpObj.chapters[i].html);
			var htmlPath = dojo.moduleUrl("webapp." + ioArgs.args.contextData.strWebapp, ioArgs.args.helpPath + helpObj.chapters[i].html);
			ctx._arrList.push({
				intIndex: ctx._arrList.length,
				strPrimaryContent: ctx._nbChapter + "." + ctx._nbSubChapter + " " + helpObj.chapters[i].name,
				strPath: htmlPath,
				strWebapp: ioArgs.args.contextData.strWebapp,
				strAppBarId:helpObj.chapters[i].appBarId,
				strHtmlFile : helpObj.chapters[i].html
			});
//                if (helpObj.chapters[i].appBarId) {
//                    var chapter = helpObj.chapters[i].html;
//                    var func = dojo.hitch(this, webapp.help.loadChapter, chapter ,ioArgs.args.contextData.strWebapp);
//                    var objButton = new UIElements.AppButton.AppButtonControl({strButtonLabel: _('Help', "webapp.help"), strButtonName: 'homepageBtnHelp', callback : func, strButtonIcon: 'app-64px-settings', strStatusText:'', strStatusIcon:''});
//                    ICTouchAPI.ActionBarServices.addOtherWebAppButton(ioArgs.args.contextData.strWebapp, helpObj.chapters[i].appBarId, objButton);
//                    objButton.addEventsShowing("showHelpEvent");
//                    objButton.addEventsHiding("hideHelpEvent");
//                    if (ctx._helpBoolState == null) {
//                        // help state setting has not been received, remember that updating button is to do
//                        ctx._updateHelpButtonToDo = true;
//                    } else {
//                        if (!ctx._helpBoolState){
//                            objButton.hide();
//                        }
//                    }
//               }
		   ctx._nbSubChapter++;
		}

		for (i=0; i<strWidgetList.length; i++) {
			var strWidget = strWidgetList[i];
			var chapter = helpObj.chapters[0].html;
			var func = { context: this, func:function(){webapp.help.loadChapter(chapter ,ioArgs.args.contextData.strWebapp)} };
			var objButton = new UIElements.AppButton.AppButtonControl({strButtonLabel: _('Help',"webapp.help"), strButtonName: 'homepageBtnHelp', callback : func, strButtonIcon: 'help-application', strStatusText:'', strStatusIcon:''});
				// pour le moment on la laisse dans la zone droite (non static button)
				//ICTouchAPI.ActionBarServices.addStaticButton(ioArgs.args.contextData.strWebapp, strWidget, objButton);
				ICTouchAPI.AppBarServices.addOtherWebAppButton(ioArgs.args.contextData.strWebapp, strWidget, objButton);
			// }

			objButton.addEventsShowing("showHelpEvent");
			objButton.addEventsHiding("hideHelpEvent");
			if (ctx._helpBoolState == null) {
				// help state setting has not been received, remember that updating button is to do
				ctx._updateHelpButtonToDo = true;
			} else {
				if (!ctx._helpBoolState){
					objButton.hide();
				}
			}
		}
		if (webapp.help.list){
			webapp.help.list.refresh();
		}
	},

	getHtmlFile : function(id){
		if ((id || id === 0) && this._arrList[id].strPath) {
			this.strCurrentWebapp = this._arrList[id].strWebapp;
			this.strOnlineHelpContainerTitle = this._arrList[id].strPrimaryContent;
			this.intCurrentSelectedIteMList = id;
			dojo.xhrGet({
				url: this._arrList[id].strPath,
				handleAs: 'text',
				// La fonction est dans le control
				//load: dojo.hitch(webapp.help, webapp.help.fillHelp)
				load: function(response) {webapp.help.fillHelp(response)}
			});
		}
		webapp.help.updateButtons();
	},

	isPreviousHome : function() {
		if (this.strCurrentBackTransition){
			return false;
        }
		else{
			return true;
        }
    }
});
