dojo.provide("webapp.help.controlBase");
dojo.declare("webapp.help.controlBase",
	ICTouchAPI.webApplication,
	{
        objContentContainer : null,
        container : null,
        list : null,

        VHE_SCROLL_OFFSET   :   260,

		constructor : function()
		{
            ICTouchAPI.settingServices.subscribeToSetting(this, "IsHelpAvailable", this.checkHelp);
			ICTouchAPI.settingServices.subscribeToSetting(this, "Language", this.languageChanged);
		},

        checkHelp : function (objSetting) {
            if (objSetting.jsValue) {
                dojo.publish("showHelpEvent");
            } else {
                dojo.publish("hideHelpEvent");
            }
        },

		load:function () {
		//help
		dojo.publish("needHelpEvent",["help",[]]);
		},

		languageChanged : function(objSetting){
			this.data.reloadHelp();
		},

        buttonCallback : function(buttonId) {
            switch(buttonId)
            {
                case webapp.help.data.BACK:
                    if (webapp.help.data.strCurrentBackTransition) {
                        ICTouchAPI.transitionServices.back();
                        //ICTouchAPI.transitionServices.getScreen({name: webapp.help.data.strCurrentBackTransition, params: {}});
                    } else {
                       dojo.publish("OpenHomepage");
                    }
                    break;

                case webapp.help.data.PREVIOUS:
					this.loadPrevious();
                    break;

                case webapp.help.data.NEXT:
					this.loadNext();
                    break;

                default:
                    console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
                    break;
            }
        },

		updateButtons : function(){
			//Get Appbar and buttons
			var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
			var nextBtn = appBar.getButton(this.data.NEXT);
			var previousBtn = appBar.getButton(this.data.PREVIOUS);

			//If we are at the first sub-chapter
			if (this.data.intCurrentSelectedIteMList <= 1) {
				if (previousBtn){
					previousBtn.greyTint();
				}
				//If we are not at the last sub-chapter (excetionnal case of only one subchapter)
				if (nextBtn && this.data.intCurrentSelectedIteMList < this.data._arrList.length - 1){
					nextBtn.show();
				}
			}
			//If we are at the last sub-chapter
			else if (this.data.intCurrentSelectedIteMList >= this.data._arrList.length - 1){
				if (nextBtn){
					nextBtn.greyTint();
				}
				//If we are not at the first sub-chapter (excetionnal case of only one subchapter)
				if (previousBtn && this.data.intCurrentSelectedIteMList > 1 ){
					previousBtn.show();
				}
			}
			//If we are not at the first and not the last
			else{
				if (previousBtn){
					previousBtn.show();
				}
				if (nextBtn){
					nextBtn.show();
				}
			}
		},


        fillHelp : function(response) {
            // remove current widget and replace it
			if (this.objContentContainer) {
				this.removeWidget(this.objContentContainer.strWidgetName);
			}

            webapp.help.data.strHelpContent = response;
            this.container.refresh();

        },

        loadChapter : function(chapterName, curWebapp) {

            webapp.help.data.strCurrentBackTransition = ICTouchAPI.transitionServices._objCurrentScreen.id;
            webapp.help.loadInternalChapter(chapterName, curWebapp);
        },

		loadPrevious: function() {
			var data = webapp.help.data;

			var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
			var nextBtn = appBar.getButton(webapp.help.data.NEXT);
			var previousBtn = appBar.getButton(webapp.help.data.PREVIOUS);
			//test for a valid previous operation
			if (data.intCurrentSelectedIteMList > 1 &&  data.intCurrentSelectedIteMList <= data._arrList.length){
				data.intCurrentSelectedIteMList--;
				//if the previous subchapter is in fact a title then skip it
				if (webapp.help.data._arrList[data.intCurrentSelectedIteMList].strType === "title") {
					this.loadPrevious();
					return;
				}
				//if this is the first subchapter then gray the next button
				if (data.intCurrentSelectedIteMList <= 1) {
					if (previousBtn){
						previousBtn.greyTint();
                    }
				}
				//display previous subchapter
				this.selectChapterById(data.intCurrentSelectedIteMList);
				//show next button
				if (nextBtn){
					nextBtn.show();
                }
			}
		},

		loadNext: function() {
			var data = webapp.help.data;

			var appBar = ICTouchAPI.AppBarServices.getAppBar("help", "getOnlineHelp");
			var nextBtn = appBar.getButton(webapp.help.data.NEXT);
			var previousBtn = appBar.getButton(webapp.help.data.PREVIOUS);
			//test for a valid next operation
			if (data.intCurrentSelectedIteMList >= 0 &&  data.intCurrentSelectedIteMList < data._arrList.length - 1) {
				data.intCurrentSelectedIteMList++;
				//if the next subchapter is in fact a title then skip it
				if (webapp.help.data._arrList[data.intCurrentSelectedIteMList].strType === "title") {
					this.loadNext();
					return;
				}
				//if this is the last subchapter then gray the next button
				if (data.intCurrentSelectedIteMList >= data._arrList.length - 1) {
					if (nextBtn){
						nextBtn.greyTint();
                    }
				}
				//display the new subchapter
				this.selectChapterById(data.intCurrentSelectedIteMList);
				//show the previous button
				if (previousBtn){
					previousBtn.show();
                }
			}
		},

		selectChapterById: function(intId) {

			if (webapp.help.data.objListUI) {
				webapp.help.data.objListUI.selectItemByIndex(intId, false);
			}
			webapp.help.data.getHtmlFile(intId);
		},

        loadInternalChapter : function(chapterName, curWebapp) {
            ICTouchAPI.transitionServices.getScreen({name: "webapp.help.getOnlineHelp", params: {}});
            var strDefPath = dojo.moduleUrl("webapp." + curWebapp, "help/" + chapterName).path;
            var strLocPath = dojo.moduleUrl("webapp." + curWebapp, "help/" + dojo.locale + "/" + chapterName).path;
			//console.log("loadInternalChapter: strDefPath :" + strDefPath);
			//console.log("loadInternalChapter: strLocPath :" + strLocPath);
            var arr = webapp.help.data.getOnlineHelpList();
             for (var i = 0; i < arr.length; i++) {
                if (arr[i].strPath) {
                    if (strDefPath === arr[i].strPath.path || strLocPath === arr[i].strPath.path) {
                        if (webapp.help.data.objListUI) {
                            webapp.help.data.objListUI.selectItemByIndex(i, false);
							webapp.help.data.intCurrentSelectedIteMList = i;
                        }
                        webapp.help.data.getHtmlFile(i);
                        return;
                    }
                }
            }
        },

        jumpTo : function(anchor) {
            if (this.objContentContainer.scroll) {
                var arrLinks = dojo.query("a", this.objContentContainer.domContainerContent);
                if (arrLinks) {
                    for (var i = 0; i < arrLinks.length; i++) {
                        if (anchor === arrLinks[i].name) {
                            //this.objContentContainer.scroll._objScroll.moveToDom(arrLinks[i]);
							webapp.help.data.intCurrentSelectedIteMList = i;
                        }
                    }
                }
            }
        }
	}
);
