#!/bin/sh
##=======================================================================
##history
##  2011-11-02 milai crms00312717 Strange behavior when mounting an USB key
##  2012-01-06 milai crms00354312 Remove the popup after an usb key is mounted
##======================================================================== 
logfile="/dev/null"
DEVICE="/dev/flash_disk"
MOUNT_POINT="/mnt/removable/usb_disk"
mountLockFile="/tmp/.mountedFlash"
file_fct="/usr/sbin/usb_mass_storage/usb_key_id"
USB_KEY_MOUNT_EVENT="USB_KEY_MOUNTED"
CliGate="/usr/bin/ICTApplication/ICTCliGateLite"
DBUS_SEND="/bin/dbus-send"
SLEEP_TIME=2

#milai crms00312717+
MOUNTING_LOCK_DIR="/tmp/.mounting_flash_disk"
DEVICE="$1"

echo "----$DEVICE: mount begin---- " >> $logfile

if [ $# -ne 1 ]
then
	echo "$DEVICE: paramter num is wrong " >> $logfile
        echo "----$DEVICE: END----" >> $logfile
	exit 1
fi

# RW access now handled in cert scripts
MOUNT_OPT="-t vfat -o ro,utf8=true"             #milai crms00337779(WRKcrms00342776)

source /etc/profile

if [ -f $mountLockFile ]
then
	echo "$DEVICE: $mountLockFile exist, Usb disk already mounted" >> $logfile
	echo "----$DEVICE: END----" >> $logfile
	exit 0
fi

if mkdir $MOUNTING_LOCK_DIR
then
     echo "$DEVICE: mkdir $MOUNTING_LOCK_DIR OK,try to mount usb key" >> $logfile
else
     echo "$DEVICE: $MOUNTING_LOCK_DIR exist,do nothing" >> $logfile
     echo "----$DEVICE: END----" >> $logfile
     exit 0
fi

sleep $SLEEP_TIME

FILES=`ls /dev/ |grep ^sd`
echo "$FILES" >> $logfile
	
if [ ! -d $MOUNT_POINT ]
then 
	echo "create mount point $MOUNT_POINT" >> $logfile
	mkdir -p $MOUNT_POINT >> $logfile
fi

for FILE in $FILES
do
	DEV=/dev/$FILE
	
	echo "Try to mount $DEV" >> $logfile
	
	if mount $MOUNT_OPT $DEV $MOUNT_POINT
	then
    		source $file_fct
    
   		echo "Mount $DEV on $MOUNT_POINT ok" >> $logfile
    
    		usbKeyId=`usb_get_key_id  $DEV`
    		echo "$usbKeyId" >> $mountLockFile
    		echo "Add $usbKeyId to $mountLockFile" >> $logfile
    
    		echo "$MOUNT_POINT" >> $mountLockFile
    		echo "Add $MOUNT_POINT to $mountLockFile" >> $logfile
    
    		echo "`udevinfo -q name -n $DEV`" >> $mountLockFile
    		echo "Add `udevinfo -q name -n $DEV` to $mountLockFile" >> $logfile
    
    		echo "Sending event $usbKeyId connected at mountPoint" >> $logfile
    
    		if [ -x "$DBUS_SEND" ]
    		then 
      			$DBUS_SEND --type=signal --print-reply --reply-timeout=30 /ICTGate com.alcatel.ICTouch.ICTInterface.event string:"$USB_KEY_MOUNT_EVENT" string:"string:MOUNT_POINT=$MOUNT_POINT;string:ID=$usbKeyId"
                        #displaypopup "$DEV was mounted on $MOUNT_POINT" #crms00354312 milai
    		fi
    		
    		break
	else
    		echo "Usb storage device $DEV could not be connected" >> $logfile
	fi
done

echo "Remove $MOUNTING_LOCK_DIR" >> $logfile
rm -fr $MOUNTING_LOCK_DIR
echo "----$DEVICE: END----" >> $logfile
#milai crms00312717-
exit 0
