/*connectivity*/
// Provide and create the connectivity webapp.
dojo.provide("webapp.connectivity.controlBase");
dojo.declare("webapp.connectivity.controlBase",[ICTouchAPI.webApplication],{

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.connectivity", "webapp.connectivity", true, true, true);
	},

	load : function() {
		// Broadcast connectivity_status_request
		ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
			params:["connectivity_status_request"]
		});
	},

	loaded : function() {
		// Subscribe to connectivity_changed event
		ICTouchAPI.eventServices.subscribeToEvent(this, "connectivity_changed", this._connectivityChanged);
	},

	_getItemPosition : function(item) {
		var position;
		if (this.data._arrConnectivityIconsPositions[item] != undefined) {
			position = this.data._arrConnectivityIconsPositions[item] - 1;
		}
		else {
			position = -1;
		}
		return position;
	},

	_connectivityChanged : function() {
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var item = args["item"];
		var status = args["status"];

		ICTouchAPI.debugServices.debug("webapp.connectivity.controlBase - _connectivityChanged - "+item+" - "+status);
		
		var arrCellsLength = this.data._arrCells.length;

		// If an item needs to be displayed
		if (status != "off" && !this.data.isIconHidden(item,status)) {
			
			// Check if item is already displayed
			var itemAlreadyDisplayed = false;
			for (var i=0; i<arrCellsLength; i++) {
				if (this.data._arrCells[i].item == item) {
					// Status of item is updated
					this.data._arrCells[i].status = status;
					itemAlreadyDisplayed = true;
					break;
				}
			}
			
			// If item not already displayed
			if (!itemAlreadyDisplayed) {
				// Place item on the first free cell in this.data._arrCells
				for (i=0; i<arrCellsLength; i++) {
					if (this.data._arrCells[i].item == "") {
						this.data._arrCells[i] = {
							item : item,
							status : status
						};
						break;
					}
				}
				
				// Sort this.data._arrCells so that positions are taken into account
				for (i=arrCellsLength-1; i>0; i--) {
					if (this.data._arrCells[i].item != "") {
						if (this._getItemPosition(this.data._arrCells[i].item) < this._getItemPosition(this.data._arrCells[i-1].item)) {
							var temp = {
								item : this.data._arrCells[i].item,
								status : this.data._arrCells[i].status
							};
							this.data._arrCells[i] = {
								item : this.data._arrCells[i-1].item,
								status : this.data._arrCells[i-1].status
							};
							this.data._arrCells[i-1] = {
								item : temp.item,
								status : temp.status
							};
						}
					}
				}
			}
		}
		// Status = off means the item must be removed
		else {
			// Looking for a cell containing this item
			for (i=0; i<arrCellsLength; i++) {
				// If current cell contains item, the icon gets removed from it
				if (this.data._arrCells[i].item == item) {
					this.data._arrCells[i] = {
						item : "",
						status : ""
					};
				}

				// If current cell is empty whereas next cell displays an item
				if (i < (arrCellsLength - 1) &&
					this.data._arrCells[i].item == "" &&
					this.data._arrCells[i+1].item != "") {
					// Item of next cell is moved to current cell
					this.data._arrCells[i] = {
						item : this.data._arrCells[i+1].item,
						status : this.data._arrCells[i+1].status
					};
					// Next cell does not display the item anymore
					this.data._arrCells[i+1] = {
						item : "",
						status : ""
					};
				}
			}
		}
		if (this.data._objConnectivityUI !== null) {
			// don't try to refresh the screen if it's not displayed already
		// Now that this.data._arrCells is up to date, dom can be refreshed
		this.data._objConnectivityUI.refreshDomArrConnectivityIcons();
	}
	}
});
/*connectivity*/
// Provide and create the connectivity webapp.
dojo.require("webapp.connectivity.controlBase");
dojo.provide("webapp.connectivity");
dojo.declare("webapp.connectivity",webapp.connectivity.controlBase,{});

webapp.connectivity=new webapp.connectivity();

dojo.provide("webapp.connectivity.dataBase");
dojo.declare("webapp.connectivity.dataBase",null,{
	// this._arrConnectivityIconsPositions[name_of_item] contains the fixed position for the specified item
	// this fixed position is available in 'ConnectivityIconsPositions' setting's value
	_arrConnectivityIconsPositions : [],
	// this._arrCells[i] contains an object which attributes are "item" and "status"
	// each object represents the current state of the cell
	_arrCells : [],

	_arrItemsCssClasses : [],
	_arrHiddenIcons : [],

	_objConnectivityUI      : null,

	constructor : function() {
		// At the beginning, no connectivity icon is displayed
		for (var i=0; i<=7; i++) {
			this._arrCells[i] = {
				item : "",
				status : ""
			};
		}

		ICTouchAPI.settingServices.getSettingValue("ConnectivityIconsPositions", this, this._loadedConnectivityIconsPositions);
		ICTouchAPI.settingServices.getSetting("HiddenConnectivityIcons", this, this._loadedHiddenIcons);
		ICTouchAPI.settingServices.subscribeToSetting(webapp.connectivity, "HiddenConnectivityIcons", this._loadedHiddenIcons);

		this.buildCssClassesArray();
	},

	_loadedConnectivityIconsPositions : function(arrConnectivityIconsPositions) {
		if (arrConnectivityIconsPositions) {
			for (var i in arrConnectivityIconsPositions) {
				var obj = dojo.fromJson(arrConnectivityIconsPositions[i]);
				// Each connectivity icon has its own position
				this._arrConnectivityIconsPositions[obj.name] = obj.pos;
			}
		}
	},

	_loadedHiddenIcons : function(objSetting){
		if(objSetting){
			var arrHidden = dojo.fromJson(objSetting.jsValue);
			if (arrHidden) {
				this._arrHiddenIcons = [];
				for (var i in arrHidden) {
					if (typeof(this._arrHiddenIcons[arrHidden[i].item]) == "undefined"){
						this._arrHiddenIcons[arrHidden[i].item] = [];
					}
					this._arrHiddenIcons[arrHidden[i].item][arrHidden[i].status] = true;
				}
			}
		}
	},

	isIconHidden : function(item,status){
		if (this._arrHiddenIcons[item]){
			if (this._arrHiddenIcons[item][status] === true){
				return true;
			}
		}
		return false;
	},

	getCorrespondingCssClass : function(item,status){
		if (this._arrItemsCssClasses[item] && this._arrItemsCssClasses[item][status]){
			var test = "connectivity-" + this._arrItemsCssClasses[item][status] + "-16";
			return test;
		}
		else{
			var test = "connectivity-" + item + "-" +status + "-16";
			return test;
		}
	},

	buildCssClassesArray : function(){
		this._arrItemsCssClasses["ethernet-link"] = [];
		this._arrItemsCssClasses["ethernet-link"]["1000"] = "ethernet-link-green";
		this._arrItemsCssClasses["ethernet-link"]["100"] = "ethernet-link-yellow";
		this._arrItemsCssClasses["ethernet-link"]["10"] = "ethernet-link-orange";
		this._arrItemsCssClasses["ethernet-link"]["disconnected"] = "ethernet-link-red";

		this._arrItemsCssClasses["secure-mode"] = [];
		this._arrItemsCssClasses["secure-mode"]["on"] = "encryption";

		this._arrItemsCssClasses["usb"] = [];
		this._arrItemsCssClasses["usb"]["on"] = "usb";

		this._arrItemsCssClasses["bluetooth"] = [];
		this._arrItemsCssClasses["bluetooth"]["paired"] = "bluetooth";

		this._arrItemsCssClasses["headset"] = [];
		this._arrItemsCssClasses["headset"]["on"] = "headset";

		this._arrItemsCssClasses["wakeup"] = [];
		this._arrItemsCssClasses["wakeup"]["on"] = "wakeup";

		this._arrItemsCssClasses["ringsilent"] = [];
		this._arrItemsCssClasses["ringsilent"]["on"] = "ringsilent";

		this._arrItemsCssClasses["interphony"] = [];
		this._arrItemsCssClasses["interphony"]["on"] = "interphony";

		this._arrItemsCssClasses["camera"] = [];
		this._arrItemsCssClasses["camera"]["on"] = "camera-active";
		this._arrItemsCssClasses["camera"]["ok"] = "camera-ok";

		this._arrItemsCssClasses["supervision"] = [];
		this._arrItemsCssClasses["supervision"]["on"] = "supervision";

		this._arrItemsCssClasses["process"] = [];
		this._arrItemsCssClasses["process"]["on"] = "process";

		this._arrItemsCssClasses["audioquality"] = [];
		this._arrItemsCssClasses["audioquality"]["on"] = "quality-audio";

		this._arrItemsCssClasses["hideIdentity"] = [];
		this._arrItemsCssClasses["hideIdentity"]["on"] = "anonymous";
	},

	getConnectivityIcons : function() {
		return this._arrCells;
	}
});
dojo.require("webapp.connectivity.dataBase");
dojo.provide("webapp.connectivity.data");
dojo.declare("webapp.connectivity.data",webapp.connectivity.dataBase,{});

webapp.connectivity.data=new webapp.connectivity.data();
dojo.provide("webapp.connectivity.getConnectivityBase");
dojo.declare("webapp.connectivity.getConnectivityBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		arrConnectivity	: [],
		domArrConnectivityIcons	: [],
		domDate : null,

		constructor	: function(){
			this.arrConnectivity = webapp.connectivity.data.getConnectivityIcons();
		},

		postCreate:function(){
			webapp.connectivity.data._objConnectivityUI = this;
			ICTouchAPI.skinServices.linkWebappsStyles("webapp.connectivity","webapp.date");
			new webapp.date.getDate({}, this.domDate);
		},

		destroy	: function(){
			this.inherited("destroy", arguments);
		},


		refreshDomArrConnectivityIcons : function() {
			var length = this.arrConnectivity.length;
			var classCss;
			
			for (var i = 0; i < length; ++i) {
				var domSpan = this.domArrConnectivityIcons[i].children[0];
				dojo.removeClass(domSpan);
				if (this.arrConnectivity[i].item != "") {
					classCss = webapp.connectivity.data.getCorrespondingCssClass(this.arrConnectivity[i].item,this.arrConnectivity[i].status);
					dojo.addClass(domSpan,classCss);
				}
			}
		},

		
	}
	);
dojo.require("webapp.connectivity.getConnectivityBase");
dojo.provide("webapp.connectivity.getConnectivity");
dojo.declare("webapp.connectivity.getConnectivity",
	webapp.connectivity.getConnectivityBase,
	{	
		templatePath	: dojo.moduleUrl("webapp.connectivity","templates/getConnectivity8082.html"),
	}
	);
