dojo.provide("webapp.connectivity.dataBase");
dojo.declare("webapp.connectivity.dataBase",null,{
	// this._arrConnectivityIconsPositions[name_of_item] contains the fixed position for the specified item
	// this fixed position is available in 'ConnectivityIconsPositions' setting's value
	_arrConnectivityIconsPositions : [],
	// this._arrCells[i] contains an object which attributes are "item" and "status"
	// each object represents the current state of the cell
	_arrCells : [],

	_arrItemsCssClasses : [],
	_arrHiddenIcons : [],

	_objConnectivityUI      : null,

	constructor : function() {
		// At the beginning, no connectivity icon is displayed
		for (var i=0; i<=7; i++) {
			this._arrCells[i] = {
				item : "",
				status : ""
			};
		}

		ICTouchAPI.settingServices.getSettingValue("ConnectivityIconsPositions", this, this._loadedConnectivityIconsPositions);
		ICTouchAPI.settingServices.getSetting("HiddenConnectivityIcons", this, this._loadedHiddenIcons);
		ICTouchAPI.settingServices.subscribeToSetting(webapp.connectivity, "HiddenConnectivityIcons", this._loadedHiddenIcons);

		this.buildCssClassesArray();
	},

	_loadedConnectivityIconsPositions : function(arrConnectivityIconsPositions) {
		if (arrConnectivityIconsPositions) {
			for (var i in arrConnectivityIconsPositions) {
				var obj = dojo.fromJson(arrConnectivityIconsPositions[i]);
				// Each connectivity icon has its own position
				this._arrConnectivityIconsPositions[obj.name] = obj.pos;
			}
		}
	},

	_loadedHiddenIcons : function(objSetting){
		if(objSetting){
			var arrHidden = dojo.fromJson(objSetting.jsValue);
			if (arrHidden) {
				this._arrHiddenIcons = [];
				for (var i in arrHidden) {
					if (typeof(this._arrHiddenIcons[arrHidden[i].item]) == "undefined"){
						this._arrHiddenIcons[arrHidden[i].item] = [];
					}
					this._arrHiddenIcons[arrHidden[i].item][arrHidden[i].status] = true;
				}
			}
		}
	},

	isIconHidden : function(item,status){
		if (this._arrHiddenIcons[item]){
			if (this._arrHiddenIcons[item][status] === true){
				return true;
			}
		}
		return false;
	},

	getCorrespondingCssClass : function(item,status){
		if (this._arrItemsCssClasses[item] && this._arrItemsCssClasses[item][status]){
			var test = "connectivity-" + this._arrItemsCssClasses[item][status] + "-16";
			return test;
		}
		else{
			var test = "connectivity-" + item + "-" +status + "-16";
			return test;
		}
	},

	buildCssClassesArray : function(){
		this._arrItemsCssClasses["ethernet-link"] = [];
		this._arrItemsCssClasses["ethernet-link"]["1000"] = "ethernet-link-green";
		this._arrItemsCssClasses["ethernet-link"]["100"] = "ethernet-link-yellow";
		this._arrItemsCssClasses["ethernet-link"]["10"] = "ethernet-link-orange";
		this._arrItemsCssClasses["ethernet-link"]["disconnected"] = "ethernet-link-red";

		this._arrItemsCssClasses["secure-mode"] = [];
		this._arrItemsCssClasses["secure-mode"]["on"] = "encryption";

		this._arrItemsCssClasses["usb"] = [];
		this._arrItemsCssClasses["usb"]["on"] = "usb";

		this._arrItemsCssClasses["bluetooth"] = [];
		this._arrItemsCssClasses["bluetooth"]["paired"] = "bluetooth";

		this._arrItemsCssClasses["headset"] = [];
		this._arrItemsCssClasses["headset"]["on"] = "headset";

		this._arrItemsCssClasses["wakeup"] = [];
		this._arrItemsCssClasses["wakeup"]["on"] = "wakeup";

		this._arrItemsCssClasses["ringsilent"] = [];
		this._arrItemsCssClasses["ringsilent"]["on"] = "ringsilent";

		this._arrItemsCssClasses["interphony"] = [];
		this._arrItemsCssClasses["interphony"]["on"] = "interphony";

		this._arrItemsCssClasses["camera"] = [];
		this._arrItemsCssClasses["camera"]["on"] = "camera-active";
		this._arrItemsCssClasses["camera"]["ok"] = "camera-ok";

		this._arrItemsCssClasses["supervision"] = [];
		this._arrItemsCssClasses["supervision"]["on"] = "supervision";

		this._arrItemsCssClasses["process"] = [];
		this._arrItemsCssClasses["process"]["on"] = "process";

		this._arrItemsCssClasses["audioquality"] = [];
		this._arrItemsCssClasses["audioquality"]["on"] = "quality-audio";

		this._arrItemsCssClasses["hideIdentity"] = [];
		this._arrItemsCssClasses["hideIdentity"]["on"] = "anonymous";
	},

	getConnectivityIcons : function() {
		return this._arrCells;
	}
});
