/*connectivity*/
// Provide and create the connectivity webapp.
dojo.provide("webapp.connectivity.controlBase");
dojo.declare("webapp.connectivity.controlBase",[ICTouchAPI.webApplication],{

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.connectivity", "webapp.connectivity", true, true, true);
	},

	load : function() {
		// Broadcast connectivity_status_request
		ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
			params:["connectivity_status_request"]
		});
	},

	loaded : function() {
		// Subscribe to connectivity_changed event
		ICTouchAPI.eventServices.subscribeToEvent(this, "connectivity_changed", this._connectivityChanged);
	},

	_getItemPosition : function(item) {
		var position;
		if (this.data._arrConnectivityIconsPositions[item] != undefined) {
			position = this.data._arrConnectivityIconsPositions[item] - 1;
		}
		else {
			position = -1;
		}
		return position;
	},

	_connectivityChanged : function() {
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var item = args["item"];
		var status = args["status"];

		ICTouchAPI.debugServices.debug("webapp.connectivity.controlBase - _connectivityChanged - "+item+" - "+status);
		
		var arrCellsLength = this.data._arrCells.length;

		// If an item needs to be displayed
		if (status != "off" && !this.data.isIconHidden(item,status)) {
			
			// Check if item is already displayed
			var itemAlreadyDisplayed = false;
			for (var i=0; i<arrCellsLength; i++) {
				if (this.data._arrCells[i].item == item) {
					// Status of item is updated
					this.data._arrCells[i].status = status;
					itemAlreadyDisplayed = true;
					break;
				}
			}
			
			// If item not already displayed
			if (!itemAlreadyDisplayed) {
				// Place item on the first free cell in this.data._arrCells
				for (i=0; i<arrCellsLength; i++) {
					if (this.data._arrCells[i].item == "") {
						this.data._arrCells[i] = {
							item : item,
							status : status
						};
						break;
					}
				}
				
				// Sort this.data._arrCells so that positions are taken into account
				for (i=arrCellsLength-1; i>0; i--) {
					if (this.data._arrCells[i].item != "") {
						if (this._getItemPosition(this.data._arrCells[i].item) < this._getItemPosition(this.data._arrCells[i-1].item)) {
							var temp = {
								item : this.data._arrCells[i].item,
								status : this.data._arrCells[i].status
							};
							this.data._arrCells[i] = {
								item : this.data._arrCells[i-1].item,
								status : this.data._arrCells[i-1].status
							};
							this.data._arrCells[i-1] = {
								item : temp.item,
								status : temp.status
							};
						}
					}
				}
			}
		}
		// Status = off means the item must be removed
		else {
			// Looking for a cell containing this item
			for (i=0; i<arrCellsLength; i++) {
				// If current cell contains item, the icon gets removed from it
				if (this.data._arrCells[i].item == item) {
					this.data._arrCells[i] = {
						item : "",
						status : ""
					};
				}

				// If current cell is empty whereas next cell displays an item
				if (i < (arrCellsLength - 1) &&
					this.data._arrCells[i].item == "" &&
					this.data._arrCells[i+1].item != "") {
					// Item of next cell is moved to current cell
					this.data._arrCells[i] = {
						item : this.data._arrCells[i+1].item,
						status : this.data._arrCells[i+1].status
					};
					// Next cell does not display the item anymore
					this.data._arrCells[i+1] = {
						item : "",
						status : ""
					};
				}
			}
		}
		if (this.data._objConnectivityUI !== null) {
			// don't try to refresh the screen if it's not displayed already
		// Now that this.data._arrCells is up to date, dom can be refreshed
		this.data._objConnectivityUI.refreshDomArrConnectivityIcons();
	}
	}
});
