dojo.provide("webapp.agenda.controlBase");
dojo.declare("webapp.agenda.controlBase",[ICTouchAPI.webApplication],
{
	currentStatus: 0,
	objAppBar: null,
	uiParticipants: null,
	uiEditEvent: null,
	uiTime: null,
	uiAlarm: null,
	toasterUI: null,
	objEventPopup : null,
	objFunctionPopup : null,
	indexToSelectOnOpen : null,
	_isPreviewPlaying : false,
	popupAlarm : [],

	constructor: function()
	{
//		ICTouchAPI.tools.registerHomepageButton(["webapp.agenda.getAgenda", "AGENDA_BTN", "agenda-application", _('Calendar',"webapp.agenda")]);
//		ICTouchAPI.tools.registerHomepageKey(["webapp.agenda.getAgenda", "AGENDA_BTN", "agenda-application", _('Calendar',"webapp.agenda")]);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getAgendaCalendarContainer","webapp.agenda");
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getAgendaPreview","webapp.agenda");
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp.wakeup","webapp.filesmanager",true,false,true,false);

		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AlarmStarted", this.notifyAlarmStarted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AlarmStopped",this.notifyAlarmStopped);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AgendaContentChanged", this.onAgendaContentChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "PlannedEventNotification", this.updateAgendaNotification);

		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_COMM", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_DIAL", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_USER", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_EVENT", this.eventPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged",this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);
		dojo.subscribe("ReloadPool",this,function() {
			this.data.loadRingingSources();
		});

		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "New_Appointment",
			strNotificationLabel: _("New Appointment", "webapp.agenda"),
			intNotificationValue: 0,
			callback: {
				context:"webapp.agenda",
				func:this.onNotifyNewAppointment
			}
		});
		//listening the enable preview setting
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableAgendaPreview", this._registerHomePageContainer);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableAgendaCalendarPreview", this._registerHomePageCalendarContainer);
		//registering or not hte webapp on initialization
		this.loadEnablePreview();
	},

	//ENABLE PREVIEW
	//loading the enable preview setting
	loadEnablePreview:function(){
		ICTouchAPI.settingServices.getSetting("EnableAgendaPreview", this, this._registerHomePageContainer);
		ICTouchAPI.settingServices.getSetting("EnableAgendaCalendarPreview", this, this._registerHomePageCalendarContainer);
	},
	//registering or unregistering the preview
	_registerHomePageCalendarContainer : function(objSetting){

		if (objSetting){
			if(objSetting.jsValue === true){
				//the calendar preview is only for 8082 targets
				try{
					//calendar preview
					ICTouchAPI.tools.registerHomepageContainer(["webapp.agenda.getAgendaCalendarContainer", this]);
				}catch(err){
					console.error("agenda._registerHomePageContainer called for a 8082 instruction");
				}
			}else{
				try{
					ICTouchAPI.tools.unregisterHomepageContainer(["webapp.agenda.getAgendaCalendarContainer"]);
				}catch(err){
					console.error("agenda._registerHomePageContainer called for a 8082 instruction");
				}
			}
		}
	},

	_registerHomePageContainer : function(objSetting){
		if (objSetting ){
			if(objSetting.jsValue === true){
				ICTouchAPI.tools.registerHomepageContainer(["webapp.agenda.getAgendaPreview", this]);
			}
			else{
				ICTouchAPI.tools.unregisterHomepageContainer(["webapp.agenda.getAgendaPreview"]);
			}
		}
	},
	//END OF ENABLE PREVIEW

	load : function ()
	{
		//help
		var widgetsTab = [];
		var i;
		for(var i=0; i<webapp.agenda.data.NB_STATUS; i++) {
			widgetsTab.push("agendastatus"+i);
		}
		dojo.publish("needHelpEvent",["agenda",widgetsTab]);
		ICTouchAPI.settingServices.subscribeToSetting(this, "RingingBeforeValues", this.data.loadedRingingTimes);
	},

	onDateFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			this.data.loadList();
		}
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data._24hformat = objSetting.jsValue;
			this.data.loadList();
		}
	},

	/**
    * Agenda Content changed.
	*/
	onAgendaContentChanged:function() {
		webapp.agenda.data.loadList();
		this.data._arrEventListDetails = [];
		webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_HOME, _("Appointment Details", "webapp.agenda"));
	},

	/**
	 * Clicked on the topBar Notification
	 */
	onNotifyNewAppointment: function (){
		// we have to reset counter
		webapp.agenda.data.intNbPlannedEventNotified = 0;
		// update the notification element
		ICTouchAPI.notificationServices.setNotificationValue("New_Appointment", 0);
		//manage the LED
		ICTouchAPI.ledServices.desactivate('event', 'ON');
		// Load details of the last notified appointment
		if (webapp.agenda.data.lastNotifiedEventId){
			webapp.agenda.data.loadDetails(webapp.agenda.data.lastNotifiedEventId);
			if(webapp.agenda.objClickableUI) {
				// Update the selected item in the menu list so that it corresponds to the displayed event
				webapp.agenda.objClickableUI.selectItemByIndex(webapp.agenda.data.lastNotifiedEventId,false);
			} else {
				webapp.agenda.indexToSelectOnOpen = webapp.agenda.data.lastNotifiedEventId;
			}
		}
		// show Agenda Webapp
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.agenda.getAgenda",
			params: {}
		});

	},

	eventOtherPhysicalKeyEvent : function() {
		var lstPopup = this.popupAlarm;
		for(var i in lstPopup){
			this.closeAlarmPopup(webapp.agenda, webapp.agenda.stopAlarm, lstPopup[i],lstPopup[i]);
		}
	},

	eventPhysicalKeyEvent : function() {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			// show webapp agenda
			var lstPopup = this.popupAlarm;
			for(var i in lstPopup){
				this.closeAlarmPopup(webapp.agenda, webapp.agenda.stopAlarm, lstPopup[i],lstPopup[i]);
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params: {}
			});
		}
	},

	/**
	 * Notified a planned event will arrived in XX delay time (set by setting)
	 */
	updateAgendaNotification:function(args){
		//Store the id of the notified event
		webapp.agenda.data.lastNotifiedEventId = args.value.id;
		//Increment the counter of notified events
		webapp.agenda.data.intNbPlannedEventNotified++;
		//manage the LED
		ICTouchAPI.ledServices.activate('event', 'ON');
		//Update the notification bar
		ICTouchAPI.notificationServices.incNotification("New_Appointment");
	},


	notifyAlarmStarted : function(objEvent) {
		objEvent = objEvent.value;
		var data = webapp.agenda.data;
		ICTouchAPI.ledServices.activate('event', 'ON');
		// check if it is an event of type wakeup
		if(objEvent.classType === "APPOINTMENT")
		{
			// flag to alarming status
			//data.boolIsAlarming = true;

			if(objEvent.alarm.value.idCapabilities !== undefined){
				ICTouchAPI.CapabilityServices.getOnceCapabilities("Agenda",objEvent,objEvent.alarm.value.idCapabilities,this, this.displayPopup);
			}


		}
	},

	displayPopup : function(arrCapabilities,objEvent){
		// popup
		var objDate = new Date(0, 0, 0, objEvent.beginDate.datetime.hour, objEvent.beginDate.datetime.minute, 0);
		var strContent = (objEvent.label || _("Appointment","webapp.agenda")) + " - " + ICTouchAPI.tools.getFormatedTime(objDate.getHours(), objDate.getMinutes(), this.data.is24HourFormat());
		var buttonNb = 0;
		var arrButtons = [];
		var popupAlarm = {
			strTitle: _("Appointment alarm", "webapp.agenda"),
			strType: "info",
			strContent: strContent,
			id: objEvent.alarm.value.id
		};
		this.popupAlarm.push(popupAlarm.id);
		if(arrCapabilities && arrCapabilities.Stop && arrCapabilities.Repeat)
		{
			if(arrCapabilities.Stop.state===ICTouchAPI.CapabilityServices.AVAILABLE){
				arrButtons[buttonNb++] = {
					strButtonName : this.data.STOP_BTN,
					strButtonLabel: _('Stop','webapp.agenda'),
					callback : function(){
						webapp.agenda.closeAlarmPopup(webapp.agenda, webapp.agenda.stopAlarm, objEvent.alarm.value.id, popupAlarm.id);
					}
				};
				this.objFunctionPopup = webapp.agenda.stopAlarm;
				this.objEventPopup = objEvent;
			}
			if(arrCapabilities.Repeat.state===ICTouchAPI.CapabilityServices.AVAILABLE) {
				arrButtons[buttonNb++] = {
					strButtonName : this.data.REPEAT_BTN,
					strButtonLabel: _('Repeat','webapp.agenda'),
					callback : function(){
						webapp.agenda.closeAlarmPopup(webapp.agenda, webapp.agenda.repeatAlarm, objEvent, popupAlarm.id);
					}
				};
				this.objFunctionPopup = webapp.agenda.repeatAlarm;
				this.objEventPopup = objEvent;
			}
		}
		popupAlarm.arrPopupButtons = arrButtons;
		if(buttonNb === 0) {
			popupAlarm.arrPopupButtons[0] = {
				strButtonName : this.data.CLOSE_BTN,
				strButtonLabel:  _('Close','webapp.agenda'),
				callback : function(){
					webapp.agenda.closeAlarmPopup(webapp.agenda,null,null,popupAlarm.id);
				}
			};
			this.objFunctionPopup = null;
			this.objEventPopup = null;
		}
		ICTouchAPI.popupServices.addNewPopup(popupAlarm, "MIDDLE");

	},

	getToaster : function(lstChoice) {
		var toasterTitle;
		var ui = null;
		var currentId;
		var i;

		//Time before ringing
		if(lstChoice === "RingingBeforeValues"){
			toasterTitle = this.uiEditEvent.arrTitles[11].strLabel;
			if(this.data.arrRingingTimes.length>0) {
				//Select current value
				currentId = parseInt(this.data.ringingTimesValue.intIndex);
				for (i in this.data.arrRingingTimes) {
					if(parseInt(this.data.arrRingingTimes[i].intIndex) === currentId) {
						this.data.arrRingingTimes[i].boolSelected = true;
					}
					else {
						this.data.arrRingingTimes[i].boolSelected = false;
					}
				}
			}
			//Instentiate time menu
			ui = new UIElements.SelectList.SelectListControl(
			{
				arrItems: webapp.agenda.data.arrRingingTimes,
				_arrSelectedItemsIndex: [0]
			});
		}
		//Audio files ringing
		else{
			toasterTitle = this.uiEditEvent.arrTitles[10].strLabel;
			if(this.data.arrRingingSources.length>0) {
				//Select current value
				currentId = this.data.ringingSourcesValue.objSource.id;
				for (i in this.data.arrRingingSources) {
					if(this.data.arrRingingSources[i].objSource.id === currentId) {
						this.data.arrRingingSources[i].boolSelected = true;
					}
					else {
						this.data.arrRingingSources[i].boolSelected = false;
					}
				}
			}
			//Instentiate ring menu
			ui = new UIElements.SelectList.SelectListControl(
			{
				arrItems: webapp.agenda.data.arrRingingSources,
				buttonCallback : dojo.hitch(webapp.agenda, webapp.agenda.previewMelody),
				_arrSelectedItemsIndex: [0]
			});
		}

		this.toasterUI = ICTouchAPI.toasterServices.showDialogBox(ui, {
			strTitle: toasterTitle,
			funcOk: {
				context:this,
				func:this.getToasterValidated,
				param:lstChoice
			},
			funcCancel: {
				context:this,
				func:this.getToasterCanceled
			}
		});


	},

	getToasterValidated : function(lstChoice){
		var uiSetting = this.toasterUI.getContent();
		if(lstChoice==="RingingBeforeValues"){
			this.data.ringingTimesValue = uiSetting.arrItems[uiSetting.getSelected()[0]];
			this.uiEditEvent._arrPresentationListEntries[11].strContent = webapp.agenda.data.ringingTimesValue.strLabel;
			this.uiEditEvent.listUI.setItemTextContent(11, webapp.agenda.data.ringingTimesValue.strLabel);
			this.data.objNewEvent.alarmReminderDelay = parseInt(webapp.agenda.data.ringingTimesValue.intIndex,10);
		}else{
			if (this._isPreviewPlaying){
				ICTouchAPI.APIServices.IctMPInterface.stopPreview({});
				this._isPreviewPlaying = false;
			}
			this.data.ringingSourcesValue = uiSetting.arrItems[uiSetting.getSelected()[0]];
			this.uiEditEvent._arrPresentationListEntries[10].strContent = webapp.agenda.data.ringingSourcesValue.strLabel;
			this.uiEditEvent.listUI.setItemTextContent(10, webapp.agenda.data.ringingSourcesValue.strLabel);
			this.data.objNewEvent.alarm.value.idFile = this.data.ringingSourcesValue.objSource.id;
		}
		//webapp.agenda.uiEditEvent.refresh();
		this.getToasterCanceled();
	},

	getToasterCanceled: function () {
		if (this._isPreviewPlaying){
			ICTouchAPI.APIServices.IctMPInterface.stopPreview({});
			this._isPreviewPlaying = false;
		}
		ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
        //this.toasterUI.destroy();
		delete this.toasterUI;
	},

	alarmStateChanged : function() {
		if(webapp.agenda.uiEditEvent._arrPresentationListEntries[8].objContent.attr('intIndex')===0){
			webapp.agenda.uiEditEvent._arrPresentationListEntries[9].boolEnabled = false;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(9, true);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[9].objContent.setValue(0);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[9].objContent.setSeekable(false);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[10].boolEnabled = false;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(10, true);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[11].boolEnabled = false;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(11, true);
			webapp.agenda.data.objNewEvent.alarmState=false;
		}else{
			if(webapp.agenda.data.arrRingingSources.length!==0){
				webapp.agenda.uiEditEvent._arrPresentationListEntries[9].boolEnabled = true;
				webapp.agenda.uiEditEvent._arrPresentationListEntries[10].boolEnabled = true;
				webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(9, false);
				webapp.agenda.uiEditEvent._arrPresentationListEntries[9].objContent.setSeekable(true);
				webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(10, false);
			}
			webapp.agenda.uiEditEvent._arrPresentationListEntries[11].boolEnabled = true;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(11, false);

			webapp.agenda.data.objNewEvent.alarmState=true;
		}
	},

	onDayChanged : function(){
		var dateNow = new Date();
		var arr = this.data.getList();
		var tabElem;
		for (var i=0; i<arr.length;i++){
			if (typeof (arr[i].intIndex) == "undefined"){ //If the selectItem in MenuList is not an Appointment (no appointment id)
				tabElem = arr[i];
				if(dojo.date.compare(tabElem.date, dateNow,"date") == 0){ //It is the today list ?
					tabElem.strPrimaryContent = "TODAY";
					this.data._intTodayPositionInList = i; //update int, for the "backToToday" Functionnality
				}
				else{
					tabElem.strPrimaryContent = ICTouchAPI.tools.getFormatedDate(tabElem.date,this.data._dateFormat);
				}
				//Update display if already created
				if (this.objClickableUI){
					this.objClickableUI.updatePrimaryContent(i,tabElem.strPrimaryContent);
				}
				//refresh preview list
			}
		}
		this.data._arrEventListPreview = [];
		var iMax = this.data._arrEventList.length;
		for(i=0; i<iMax; i++) {
			var obj = this.data._arrEventList[i]; // an event
			if(obj.strType==="normal" && dojo.date.compare(obj.date, dateNow,"date") === 0) {
				this.data._arrEventListPreview.push({
					strRightIcon : obj.strPrimaryIcon,
					//strLeftIcon : 'presence-24-offline',
					//strTime:"10:12",
					strPrimaryIcon : obj.strPrimaryIcon,
					strSecondaryContent : obj.strSecondaryContent,
					strPrimaryContent: obj.strPrimaryContent,
					strType: "normal",
					intIndex: obj.intIndex
				});
			}
		}
		//Update preview if already created
		if( this.previewContainer ){
			this.previewContainer.refresh();
		}
		if( this.previewCalendarContainer){
			this.previewCalendarContainer.refresh();
		}
	},

	occurenceChanged : function() {
		var occurenceArr = ["ONE_TIME", "DAILY", "WEEKLY", "MONTHLY"];
		webapp.agenda.data.objNewEvent.repetitionPeriod = occurenceArr[webapp.agenda.uiEditEvent._arrPresentationListEntries[7].objContent.attr('intIndex')];
		//webapp.agenda.uiEditEvent.refresh();
	},

	closeAlarmPopup : function(context, callback, callbackParams, poupupId) {
		// flag in not alarming status
		//this.data.boolIsAlarming = false;
		var lstPopup = ICTouchAPI.popupServices.getPopupsByPriority(1);
		var _popup = null;
		var j;
		for(var i in lstPopup){
			if(lstPopup[i].id!==undefined && lstPopup[i].id!==null){
				if(lstPopup[i].id==poupupId){
					_popup=lstPopup[i];
					for(j=0 ; j <  this.popupAlarm.length ; j++){
						if(this.popupAlarm[j]!==undefined && this.popupAlarm[j]!==null){
							if(this.popupAlarm[j]==poupupId){
								console.error("SPLICE : " + poupupId);
								this.popupAlarm.splice(j,1);
								break;
							}
						}
					}
					break;
				}
			}
		}

		this.objEventPopup = null;
		this.objFunctionPopup = null;

		//if(context.popupAlarm !== null)
		if(_popup !== null)
		{
			ICTouchAPI.popupServices.removePopupByID(_popup);
			//context.popupAlarm = null;
		}
		if (callback){
			callback(callbackParams);
		}
		ICTouchAPI.ledServices.desactivate('event', 'ON');
	},

	notifyAlarmStopped : function(objEvent) {
		//cr 287773 : Reload the list to refresh alarm status
        this.data.loadList();
		objEvent = objEvent.value;
		// check if it is an event of type appointment
		if(objEvent.classType === "APPOINTMENT")
		{
			// remove popup
			this.closeAlarmPopup(this,null,null,objEvent.alarm.value.id);
		}
	},

	stopAlarm:function(id) {
		// call core
		ICTouchAPI.APIServices.Agenda.stopAlarm({
			params:[id],
			context:this
		});
	},

	repeatAlarm:function(objEvent) {
		// call core
		ICTouchAPI.APIServices.Agenda.repeatAlarm({
			params:[objEvent.alarm.value.id],
			context:this
		});
	},

	getAgendaParticipantsAvailability : function() {
		var data = webapp.agenda.data;
		var status = ICTouchAPI.CapabilityServices.getCapability("Agenda","AgendaParticipants");
		if (status === ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.AGENDA_PARTICIPANTS = data.ENABLE;
		} else {
			data.AGENDA_PARTICIPANTS = data.DISABLE;
		}
	},

	previewMelody : function(intIndex) {
		var url = this.data.getRingingSources()[intIndex].objSource.url;
		ICTouchAPI.APIServices.IctMPInterface.preview({params: [url]});
		this._isPreviewPlaying = true;
	}

});
dojo.require("webapp.agenda.controlBase");
dojo.provide("webapp.agenda");
dojo.declare("webapp.agenda",webapp.agenda.controlBase,{

	_boolChangeScreen : false,

	buttonCallback : function(buttonId) {
		var data = webapp.agenda.data;
		switch(buttonId)
		{
			// The back button load the last container
			case data.BACK:
				switch(data._strContainerPath)
				{
					case "webapp.agenda.getAgendaDetails" :
						dojo.publish("OpenHomepage");
						break;
					case "webapp.agenda.getAgendaEditEvent" :
						data.loadBackPopUp();
						break;
					case "webapp.agenda.getAgendaCalendar" :
						if(data.currentCalendarType === data.CALENDAR_TYPE_GOTODAY){
							if(data.objCurrentEvent){
								data.switchContainer("getAgendaDetails", data.STATUS_DETAILS, _("Calendar: Event details","webapp.agenda"));
							}
							else{
								data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Homepage","webapp.agenda"));
							}
						}
						else{
							data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						}
						break;
					case  "webapp.agenda.getAgendaAlarmEdit" :
						data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					// Participants may be used in next version
					// case "webapp.agenda.getAgendaParticipantEdit" :
					// data._arrParticipants = data.objNewEvent.participant;
					// data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event Edition","webapp.agenda"));
					// break;
					case "webapp.agenda.getAgendaTimeEdit" :
						this.saveTime();
						data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					default :
						data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Event details","webapp.agenda"));
						break;
				}
				break;
			case data.BACK_TO_TODAY:
				this.data.goToToday();
				break;
			case data.GO_TO_DAY:
				this.data.setCalendar(data.CALENDAR_TYPE_GOTODAY, this.data.NONE);
				break;
			case data.DELETE:
				this.data.deletePopup();
				break;
			case data.MODIFY:
				this.data.newEvent(data.NEW_EVENT_MODIFY);
				break;
			case data.ADD:
				if(data._strContainerPath === "webapp.agenda.getAgendaDetails") {
					this.data.newEvent(data.NEW_EVENT_ADD);
				} else if(data._strContainerPath === "webapp.agenda.getAgendaParticipantEdit") {
					this.uiParticipants.push();
				}
				break;
			case data.SAVE:
				this.TrySaveEvent();
				break;
			case data.VALIDATE:
				if(data._strContainerPath === "webapp.agenda.getAgendaAlarmEdit") {
					this.uiAlarm.updateAlarm();
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
				} else if(data._strContainerPath === "webapp.agenda.getAgendaParticipantEdit") {
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
						}
				break;
			case data.SEARCH:
				break;
			case data.REMOVE:
				if(data._strContainerPath === "webapp.agenda.getAgendaParticipantEdit") {
					this.uiParticipants.pop();
				}
				break;
			default:

				break;
		}
	},

	unlock : function(WebappName){

		console.log("unlock webapp agenda");
		var path = this.data.getContainerPath();
		if(path == "webapp.agenda.getAgendaEditEvent" ||
			path == "webapp.agenda.getAgendaTimeEdit" ||
			path == "webapp.agenda.getAgendaCalendar"){
			var context = this;
			if(!this.data.objBackPopup){
				//popup
				var popupData = {
					strTitle: _("Save changes","webapp.agenda"),
					strType: "warning",
					strContent: _("Save the changes before exiting ?","webapp.agenda"),
					arrPopupButtons: [
						{
						strButtonName: context.data.YES_BTN,
						strButtonLabel:  _("Yes", 'ICTouchAPI'),
						strButtonIcon: "generic-ok",
						callback: function() {
							context.data.closeBackPopup();
							context.data.objBackPopup = null;
							if(context.data._strContainerPath === "webapp.agenda.getAgendaTimeEdit") {
									this.saveTime();
							}
							//webapp.agenda.data._goBackToHomeAgenda();
							context.TrySaveEvent();
							delete context;
							dojo.publish("unlockTransition",[context._boolChangeScreen]);
							}
						},
						{
						strButtonName: context.data.NO_BTN,
						strButtonLabel:  _("No", 'ICTouchAPI'),
						strButtonIcon: "generic-cancel",
						callback: function() {
							context.data.closeBackPopup();
							context.data._goBackToHomeAgenda();
							context.data.objBackPopup = null;
							delete context;
							dojo.publish("unlockTransition",[true]);
						}
						}
					]
				};

			}
				var currentScreenSaver = webapp.screensaver.data.getCurrentScreensaverScreen();
				if(WebappName == currentScreenSaver){
					dojo.publish("unlockTransition",[true]);
				}else{
				context.data.objBackPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
				}
			//save
		}else{
			dojo.publish("unlockTransition",[true]);
		}
	},

	saveTime : function(){
		var time = this.uiTime.getTime();
		var data = this.data;
		if(data.currentStartEnd === data.START){
			var objBeginDate = data.objNewEvent.beginDate.datetime;
			var objEndDate = data.objNewEvent.endDate.datetime;
			var delta = (time.hour - objBeginDate.hour)*60 + (time.minute - objBeginDate.minute);
			var base = parseInt(objEndDate.hour) * 60 + parseInt(objEndDate.minute);
			objBeginDate.minute = "" + time.minute;
			objBeginDate.hour = "" + time.hour;
			//Shift end time if edit new event and if end date(include time) is lower thand start date(include time)
			if(data.currentEventStatus === data.NEW_EVENT_ADD) {
				var finale = Math.min(base + delta,(24*60)-1);
				finale = Math.max(finale,0);
				if(data.compareDateOfEvent(data.objNewEvent)===-1) {
					objEndDate.minute = "" + finale % 60;
					objEndDate.hour = "" + ((finale - finale % 60) / 60) % 24;
					//if end date(include time) is still lower thand start date(include time), value of end time is start time
					if(data.compareDateOfEvent(data.objNewEvent)===-1) {
						objEndDate.minute = objBeginDate.minute;
						objEndDate.hour = objBeginDate.hour;
					}
				}
			}
		} else if(data.currentStartEnd === data.END) {
			data.objNewEvent.endDate.datetime.minute = "" + time.minute;
			data.objNewEvent.endDate.datetime.hour = "" + time.hour;
		}
	},

	TrySaveEvent : function(){
		this._boolChangeScreen = false;
		webapp.agenda.data.objNewEvent.alarmState = this.uiEditEvent.getUIElement("ring").attr('intIndex')===1?true:false;
		var _millisec = null;
		if(webapp.agenda.data.objNewEvent.alarmState){

			webapp.agenda.data.objNewEvent.alarm.value.volume = this.uiEditEvent.getUIElement("volume").getValue();
			if(webapp.agenda.data.objNewEvent.alarmState){
				var _date = webapp.agenda.data.objNewEvent.beginDate.datetime;
				var _bdate = new Date(_date.year, _date.month - 1, _date.day, _date.hour, _date.minute);
				_millisec = _bdate.getTime();
				_millisec = _millisec - (parseInt(webapp.agenda.data.objNewEvent.alarmReminderDelay,10)*60000);
			}

			if(webapp.agenda.data.ringingSourcesValue!==null){
				webapp.agenda.data.objNewEvent.alarm.value.idFile = webapp.agenda.data.ringingSourcesValue.objSource.id;
			}
		}else{
			webapp.agenda.data.objNewEvent.alarm.value.volume = 0;
		}
		var bTemp = webapp.agenda.data.objNewEvent.beginDate.datetime;
		var eTemp = webapp.agenda.data.objNewEvent.endDate.datetime;
		var beginDate = new Date(bTemp.year, bTemp.month - 1, bTemp.day, bTemp.hour, bTemp.minute);
		var endDate = new Date(eTemp.year, eTemp.month - 1, eTemp.day, eTemp.hour, eTemp.minute);
		if (webapp.agenda.data.objNewEvent.label !== "" && webapp.agenda.data.objNewEvent.label)
		{
			if (endDate > beginDate)
			{
				if (endDate >= Date.now())
				{
					if(_millisec===null || (_millisec!==null && _millisec >= Date.now() ))
					{
						if(webapp.agenda.data.currentEventStatus === webapp.agenda.data.NEW_EVENT_ADD)
						{
							this._boolChangeScreen = true;
							ICTouchAPI.APIServices.Agenda.addPlannedAppointment({
								params:[webapp.agenda.data.objNewEvent],
								context:this,
								callback:function(id){
									webapp.agenda.data.loadDetails(id);
								}
							});
							webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_DETAILS);
						}
						else if(webapp.agenda.data.currentEventStatus === webapp.agenda.data.NEW_EVENT_MODIFY)
						{//if this as a modification of an already existing event, refresh the details about it
							this._boolChangeScreen = true;
							ICTouchAPI.APIServices.Agenda.modifyPlannedAppointment({
								params:[webapp.agenda.data.objNewEvent],
								context:this
							}) ;
							webapp.agenda.data.loadDetails(webapp.agenda.data.objNewEvent.id);
							webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_DETAILS);
						}
					}else{
						webapp.agenda.data.loadInformativeDisplay("Alarm date is set in the past!", "Warning", "warning");
					}
				}
				else
				{
					webapp.agenda.data.loadInformativeDisplay("Event is set in the past!", "Warning", "warning");
				}
			}
			else
			{
				webapp.agenda.data.loadInformativeDisplay("End Date is lower than the Begin Date of the Appointment", "Error occured in new Appointment", "error");
			}
		}
		else
		{
			webapp.agenda.data.loadInformativeDisplay("Please complete the Label of your new event", "Warning", "error");
		}
	},

	load : function ()
	{
		this.inherited(arguments);
	},

	setHomepageContainer : function (strWebapp,  div) {
		if(strWebapp==="webapp.agenda.getAgendaCalendarContainer"){
			webapp.agenda.previewCalendarContainer = new webapp.agenda.getAgendaCalendarContainer({}, div);
		}else if(strWebapp==="webapp.agenda.getAgendaPreview"){
			webapp.agenda.previewContainer = new webapp.agenda.getAgendaPreview({}, div);
		}
	}
});

webapp.agenda=new webapp.agenda();
dojo.provide("webapp.agenda.dataBase");

dojo.declare("webapp.agenda.dataBase", null, {
	_arrAppButtons          : [],
	_arrSysButtons          : [],
	_arrEventList           : [],
	_arrEventListDetails    : [],
	_arrEventListPreview    : [],
	_arrCalendarPlannedEvents: [],


	_strContainerPath       : "webapp.agenda.getAgendaDetails", //default details
	_strTitle               : "", // default nothing

	_agendaListTitle        : "",
	_intTodayPositionInList : null,

	_dateFormat             : "",
	_24hformat              : false, // 12 \ 24
	AGENDA_STOP             : true,
	AGENDA_REPEAT           : true,

	_arrParticipants        : [],

	arrRingingSources       : [],
	arrRingingTimes         : [],
	ringingTimesValue       : null,
	ringingSourcesValue     : null,
	objCurrentEvent         : null,
	objNewEvent             : null,
	boolIsAlarming			: false,
	intNbPlannedEventNotified : 0,
	boolPreviewSelected		: false,
	currentSelectedItem     : null,
	objBackPopup			: null,

	// For the Dashboard container in MR mode
	nbOfEvents				: 0,

	// Attribute that define which period do we select with the Calendar
	currentStartEnd         : 3,
	START                   : 1, // Selecting start of period
	END                     : 2, // End of period
	NONE                    : 3, // Load current date

	currentEventStatus      : 0,
	NEW_EVENT_MODIFY        : 1,
	NEW_EVENT_ADD           : 2,

	currentCalendarType     : null,
	CALENDAR_TYPE_GOTODAY   : 1,
	CALENDAR_TYPE_ADD       : 2,

	// Capabilities
	AGENDA_ADD              : true,
	AGENDA_MODIFY           : true,
	AGENDA_PARTICIPANTS     : false,

	ENABLE                  : true,
	DISABLE                 : false,

	// const Button
	BACK                    : "BACK_BTN",
	BACK_TO_TODAY           : "BACK_TO_TODAY_BTN",
	GO_TO_DAY               : "GOTO_DAY_BTN",
	DELETE                  : "DELETE_BTN",
	MODIFY                  : "MODIFY_BTN",
	ADD                     : "ADD_BTN",
	SAVE                    : "SAVE_BTN",
	SEARCH                  : "SEARCH_BTN",
	REMOVE                  : "REMOVE_BTN",
	STOP_BTN                : "STOP_BTN",
	REPEAT_BTN              : "REPEAT_BTN",
	SNOOZE_BTN              : "SNOOZE_BTN",
	CLOSE_BTN               : "CLOSE_BTN",
	YES_BTN                 : "YES_BTN",
	NO_BTN                  : "NO_BTN",

	// const Status
	STATUS_HOME             : 0,
	STATUS_DETAILS			: 1,
	STATUS_EDIT				: 2,
	STATUS_DATE				: 3,
	STATUS_TIME				: 4,
	STATUS_ALARM			: 5,
	STATUS_PARTICIPANTS		: 6,
	NB_STATUS				: 7,

	// const types of Events
	TYPE_ALL                : 0,
	TYPE_APPOINTMENT        : "APPOINTMENT",
	TYPE_WAKEUP             : "WAKEUP",
	// const occurences
	OCCUR_ONE_TIME          : 0,
	OCCUR_DAILY             : 1,
	OCCUR_WEEKLY            : 2,
	OCCUR_MONTHLY           : 3,


	// LEDS and LEDS STATUS
	LED_AGENDA : 7,

	LED_STATUS_OFF : 0,
	LED_STATUS_ON  : 1,

	constructor : function(){
		// definition of buttons
		var func = {
			context:webapp.agenda,
			func:webapp.agenda.buttonCallback
		};

		var arrButtons = [];
		arrButtons.push({
			strButtonName: this.GO_TO_DAY,
			strButtonLabel: _('Go to', 'webapp.agenda'),
			strButtonIcon: 'agenda-goto-day',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.BACK_TO_TODAY,
			strButtonLabel: _('Today', 'webapp.agenda'),
			strButtonIcon: 'agenda-today',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.ADD,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'agenda-add-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			capabilities: [{
				module : "Agenda",
				capability:"EventCreation"
			}]
		});
		this._arrAppButtons[this.STATUS_HOME] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.DELETE,
			strButtonLabel:  _('Delete', 'ICTouchAPI'),
			strButtonIcon: 'agenda-delete-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.MODIFY,
			strButtonLabel: _('Modify', 'ICTouchAPI'),
			strButtonIcon: 'agenda-edit-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			capabilities: [{
				module : "Agenda",
				capability:"EventModification"
			}]
		});
		arrButtons.push({
			strButtonName: this.GO_TO_DAY,
			strButtonLabel: _('Go to', 'webapp.agenda'),
			strButtonIcon: 'agenda-goto-day',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.BACK_TO_TODAY,
			strButtonLabel: _('Today', 'webapp.agenda'),
			strButtonIcon: 'agenda-today',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.ADD,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'agenda-add-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			capabilities: [{
				module : "Agenda",
				capability:"EventCreation"
			}]
		});
		this._arrAppButtons[this.STATUS_DETAILS] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.SAVE,
			strButtonLabel:  _('Save', 'ICTouchAPI'),
			strButtonIcon: 'agenda-save-modified-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		this._arrAppButtons[this.STATUS_EDIT] = arrButtons;

		arrButtons = [];
		this._arrAppButtons[this.STATUS_DATE] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.VALIDATE,
			strButtonLabel:  _('Save', 'ICTouchAPI'),
			strButtonIcon: 'agenda-accept',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		this._arrAppButtons[this.STATUS_ALARM] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.VALIDATE,
			strButtonLabel:  _('Save', 'ICTouchAPI'),
			strButtonIcon: 'agenda-accept',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.SEARCH,
			strButtonLabel:  _('Search', 'ICTouchAPI'),
			strButtonIcon: 'app-64px-search',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.ADD,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'app-64px-add',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.REMOVE,
			strButtonLabel: _('Delete', 'ICTouchAPI'),
			strButtonIcon: 'app-64px-remove',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		this._arrAppButtons[this.STATUS_PARTICIPANTS] = arrButtons;
		this._agendaListTitle= _("Planning", "webapp.agenda");

		for (var j = 0; j < this.NB_STATUS; j++) {
			var appBar = ICTouchAPI.AppBarServices.getAppBar("agenda", "agendastatus" + j);
			for (var k in this._arrAppButtons[j]) {
				var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[j][k]);
				appBar.addActionButton(objButton);
			}
		}

		// load settings and list
		this.loadAll();
	},

	loadAll : function() {
		// before list, load setting
		this._getSettings();
	},

	// gets the settings for the app
	_getSettings : function(){
		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			// save the setting
			if (objSetting !== null){
				this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			}
			// get another setting
			ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
				// save the setting
				if(value !== null){
					this._24hformat = value;
				}
				this.loadList();
			});
		});
		this.loadRingingSources();
		ICTouchAPI.settingServices.getSetting("RingingBeforeValues",this, this.loadedRingingTimes);
	},

	loadList : function() {
		// get events type appointment
		ICTouchAPI.APIServices.Agenda.findPlannedEventByType({
			params:[this.TYPE_APPOINTMENT],
			context:this,
			callback:this.loadedList
		});
	},

	loadedList : function(_arr) {
		// fill _arrEventList

		this._arrEventList = [];
		this._arrEventListPreview = [];
		this._arrCalendarPlannedEvents = [];

		var arrTemp = []; // temporary table for sorting

		// first sorting of the elements, by day and ducplicate them
		// if they cross days
		var dateBegin;
		for (var i = 0; i < _arr.length; i++)
		{
			// dates from the object plannedEvent (no time just date)
			// Warning : javascript months starts at 0 (january..)
			dateBegin = new Date(_arr[i].beginDate.datetime.year, _arr[i].beginDate.datetime.month - 1, _arr[i].beginDate.datetime.day);
			var dateEnd   = null;
			_arr[i].boolEnd = false;
			_arr[i].boolStart = true;
			if(_arr[i].endDate !== null)
			{
				dateEnd = new Date(_arr[i].endDate.datetime.year, _arr[i].endDate.datetime.month - 1, _arr[i].endDate.datetime.day);
				//timeEnd is equal to 000 if hour minute and second are null and the day is not conciderated as a real day
				var timeEnd = _arr[i].endDate.datetime.hour+_arr[i].endDate.datetime.minute+_arr[i].endDate.datetime.second;
				// When we display the event, show something different if the event doesn't end the same day
				_arr[i].boolEnd = ( dojo.date.compare(dateBegin, dateEnd, "date") === 0 );
			}

			// key date for the array format : day-month-year
			var strBeginDateKey = dateBegin.format('yyyy-MM-dd',dojo.locale);

			if(!arrTemp.hasOwnProperty(strBeginDateKey)) {
				// the key does not exist, create it
				arrTemp[strBeginDateKey] = [];
			}

			// add the event to the day
			arrTemp[strBeginDateKey].push(dojo.clone(_arr[i]));


			if(dateEnd !== null && (dateEnd !== dateBegin) && timeEnd != "000") {
				/**
				 * For every event that span over multiple days we need to duplicate it
				 * because we have an array for each day
				 */


				// dateTemp is the iterator that will start the day after the origin until the end
				var dateTemp = dateBegin;

				// we add a day to the iterator & compute the diff
				dateTemp = dojo.date.add(dateTemp, "day", 1);
				var dateDiff = dojo.date.compare(dateTemp, dateEnd, "date");
				while(dateDiff <= 0)
				{
					_arr[i].boolEnd = ( dateDiff === 0);
					_arr[i].boolStart = false;
					// format the key for the table
					var strKey = dateTemp.format('yyyy-MM-dd',dojo.locale);

					if(!arrTemp.hasOwnProperty(strKey)) {
						// If the key does not exist, create it
						arrTemp[strKey] = [];
					}
					// add the event to the curent day
					arrTemp[strKey].push(dojo.clone(_arr[i]));

					// we add a day to the iterator & compute the diff
					dateTemp = dojo.date.add(dateTemp, "day", 1);
					dateDiff = dojo.date.compare(dateTemp, dateEnd, "date");
				}
			}
		}

		// we must sort the temporary list by date
		// We have to sort the Keys of this array
		var keys = [];
		for(var k in arrTemp)
		{
			if(arrTemp.hasOwnProperty(k))
			{
				keys.push(k);
			}
		}
		// sorting key by ascending order
		keys.sort(function (a, b) {
			//return (b > a) - (b < a); //descending
			return (b < a) - (b > a); //ascending
		});


		// populate the array for the clickable list
		this._arrEventList = [];

		var dateNow   = new Date();
		var boolToday = false; // default not today
		// filling
		// through the keys of the table
		for (var j = 0; j < keys.length; j++)
		{
			var key = keys[j];

			if(arrTemp.hasOwnProperty(key))
			{
				// gets date from the key year-month-day
				var arrDate = key.split('-');
				dateBegin = new Date(arrDate[0], arrDate[1]-1, arrDate[2]);
				// add title to the day
				if(dojo.date.compare(dateBegin, dateNow,"date") === 0)
				{
					// Today !
					this._arrEventList.push({
						strPrimaryContent: _("TODAY", "webapp.agenda"),
						strType: "title",
						date : dateBegin // private property for our data
					});
					boolToday = true;
					// save the position of the Today Title in the List
					this._intTodayPositionInList = this._arrEventList.length;

					// We add a title, so we have events to push to
					// the table for the calendar
					//var planned = {}; planned.date = dateBegin;
					//this._arrCalendarPlannedEvents.push(planned);
					var strKeyDate = dateBegin.format('yyyy-MM-dd',dojo.locale);

					this._arrCalendarPlannedEvents[strKeyDate] = true;
				}
				else
				{
					this._arrEventList.push({
						strPrimaryContent: _(ICTouchAPI.tools.getFormatedDate(dateBegin,this._dateFormat), "webapp.agenda"),
						strType: "title",
						date : dateBegin // private property for our data
					});
					boolToday = false;

					var strDateKey = dateBegin.format('yyyy-MM-dd',dojo.locale);

					this._arrCalendarPlannedEvents[strDateKey] = true;
				}

				// sort the elements added previously  by time increase sort
				arrTemp[key].sort(function(a,b) {
					// a and b are two planned events
					// test hours
					if(a.beginDate.datetime.hour > b.beginDate.datetime.hour){
						return 1;
					}
					else if(a.beginDate.datetime.hour < b.beginDate.datetime.hour){
						return -1;
					}
					else //hours =, to test minutes
					{
						if(a.beginDate.datetime.hour > b.beginDate.datetime.hour){
							return 1;
						}
						else if(a.beginDate.datetime.hour < b.beginDate.datetime.hour){
							return -1;
						}
						else{
							return 0;
						}
					}
				});

				// through the table add plannedEvents
				for(var keyTemp in arrTemp[key])
				{
					var obj = arrTemp[key][keyTemp]; // an event
					var strTime = this._formatTime(obj);

					// add planned event to the list
					this._arrEventList.push({
						strPrimaryIcon : (obj.alarmState) ? 'clock' : '',
						strSecondaryContent : strTime,
						strPrimaryContent: obj.label,
						strType: "normal",
						intIndex: obj.id,
						date : dateBegin // private property for our data
					});

					// add planned event to the preview List
					if(boolToday)
					{
						this._arrEventListPreview.push({
							strRightIcon : (obj.alarmState) ? 'clock' : '',
							strPrimaryIcon : (obj.alarmState) ? 'clock' : '',
							strSecondaryContent : strTime,
							strPrimaryContent: obj.label,
							strType: "normal",
							intIndex: obj.id
						});
					}
				}
			}
		}
		this.nbOfEvents = this._arrEventListPreview.length;

		// refresh Lists
		if( webapp.agenda.mainWidget ){
			webapp.agenda.mainWidget.reloadMenu();
		}
		if( webapp.agenda.previewContainer ){
			webapp.agenda.previewContainer.refresh();
		}
		if( webapp.agenda.previewCalendarContainer){
			webapp.agenda.previewCalendarContainer.refresh();
		}
	},

	/**
	 * Format time according to objEvent
	 * if boolStart is defined then it's the first day of the event
	 * if boolEnd is defined then it's the last day
	 * both can be true if it's a one day event
	 * both can be false if it's the middle of the event
	 */
	_formatTime : function(objEvent) {
		// time print format hours:minutes-hours:minutes
		var strTimeStart = ICTouchAPI.tools.getFormatedTime(objEvent.beginDate.datetime.hour, objEvent.beginDate.datetime.minute, this._24hformat);
		if(!objEvent.endDate)
		{
			// We can't have more then one day if we don't have any end date
			return strTimeStart;
		}
		var strTimeEnd = ICTouchAPI.tools.getFormatedTime(objEvent.endDate.datetime.hour, objEvent.endDate.datetime.minute, this._24hformat);
		if( objEvent.boolStart && objEvent.boolEnd )
		{
			return strTimeStart + '-' + strTimeEnd;
		}
		else if( !objEvent.boolStart && objEvent.boolEnd )
		{
			return _(["Ending",strTimeEnd], "webapp.agenda");
		}
		else if( objEvent.boolStart && !objEvent.boolEnd )
		{
			return _(["Starting",strTimeStart], "webapp.agenda");
		}
		else
		{
			return _("Whole day", "webapp.agenda");
		}
	},

	loadDetails : function (plannedEventId) {
		if(plannedEventId!=-1){
			// get a planned event by Id
			ICTouchAPI.APIServices.Agenda.getAppointmentById({
				params:[plannedEventId],
				context:this,
				callback:this.loadedDetails
			}) ;
		//this.currentEvent = plannedEventId;
		}else{
			this.loadInformativeDisplay("The maximum number of appointments has been reached", "Warning", "error");
		}
	},



	loadVeryNextAppDetails : function() {
		//Search the very next appointment
		if(this._arrEventList && this._arrEventList.length > 1){

			ICTouchAPI.APIServices.Agenda.findPlannedEventByType({
				params:[this.TYPE_APPOINTMENT],
				context:this,
				callback:function(_arrApp){
					if(!this.boolPreviewSelected){
						var dateNow = new Date();
						var milli = dateNow.getTime();
						var minMilli = milli;
						var idVeryNext;
						for(var i in _arrApp){
							var dTemp = _arrApp[i].beginDate.datetime;
							var _cBeginDate = new Date(dTemp.year, dTemp.month - 1, dTemp.day, dTemp.hour, dTemp.minute);
							var	_cMilli = _cBeginDate.getTime();
							var _cEcart = _cMilli - milli;
							if( _cEcart > 0 && _cEcart < minMilli){
								minMilli = _cEcart;
								idVeryNext = _arrApp[i].id;
							}
						}
						if(webapp.agenda.objClickableUI && idVeryNext!==null){
							webapp.agenda.objClickableUI.selectItemByIndex(idVeryNext, true);
						//webapp.agenda.data.loadDetails(idVeryNext);
						}
					}
				}
			});
		}
	},

	loadedDetails : function (objPlannedEvent) {
		this.objCurrentEvent = objPlannedEvent;
		// fill details
		this._arrEventListDetails = [];

		if(objPlannedEvent !== null)
		{
			// description
			this._arrEventListDetails.push({
				strLabel: _(["Description", ":"], "webapp.agenda"),
				strContent: objPlannedEvent.description ? objPlannedEvent.description : ""
			});
			// place
			this._arrEventListDetails.push({
				strLabel: _(["Place", ":"], "webapp.agenda"),
				strContent: objPlannedEvent.place ? objPlannedEvent.place : ""
			});
			// dates
			var dateBegin = new Date(objPlannedEvent.beginDate.datetime.year, objPlannedEvent.beginDate.datetime.month - 1, objPlannedEvent.beginDate.datetime.day);
			var dateEnd   = null;
			if(objPlannedEvent.endDate !== null){
				dateEnd = new Date(objPlannedEvent.endDate.datetime.year, objPlannedEvent.endDate.datetime.month - 1, objPlannedEvent.endDate.datetime.day);
			}
			this._arrEventListDetails.push({
				strLabel: _(["Start Date", ":"], "webapp.agenda") ,
				strContent: ICTouchAPI.tools.getFormatedDate(dateBegin,this._dateFormat)
			});
			this._arrEventListDetails.push({
				strLabel: _(["Start Time", ":"], "webapp.agenda"),
				strContent: ICTouchAPI.tools.getFormatedTime(objPlannedEvent.beginDate.datetime.hour, objPlannedEvent.beginDate.datetime.minute, this._24hformat)
			});
			if(dateEnd !== null) {
				this._arrEventListDetails.push({
					strLabel:  _(["End Date", ":"], "webapp.agenda") ,
					strContent: ICTouchAPI.tools.getFormatedDate(dateEnd,this._dateFormat)
				});
				this._arrEventListDetails.push({
					strLabel:  _(["End Time", ":"], "webapp.agenda"),
					strContent: ICTouchAPI.tools.getFormatedTime(objPlannedEvent.endDate.datetime.hour, objPlannedEvent.endDate.datetime.minute, this._24hformat)
				});
			}
			// occurence
			/*this._arrEventListDetails.push({
				strLabel:  _(["Occurrence", ":"], "webapp.agenda"),
				strContent: objPlannedEvent.repetitionPeriod ? objPlannedEvent.repetitionPeriod : ""
			});*/
			// alarm
			this._arrEventListDetails.push({
				strLabel:  _(["Ringing alarm", ":"], "webapp.agenda"),
				strContent: (objPlannedEvent.alarmState)? _("On", "ICTouchAPI") : _("Off", "ICTouchAPI")
			});

			if(objPlannedEvent.alarmState && objPlannedEvent.alarm!=null && objPlannedEvent.alarm.value && objPlannedEvent.alarm.value.idFile!=null) {
				var ringName = _("None", "webapp.agenda");
				var iMax = this.arrRingingSources.length;
				for(var i=0; i<iMax; i++) {
					if(this.arrRingingSources[i].objSource.id===objPlannedEvent.alarm.value.idFile) {
						ringName = this.arrRingingSources[i].strLabel;
						break;
					}
				}
				this._arrEventListDetails.push({
					strLabel:  _(["Alarm source", ":"], "webapp.agenda") ,
					strContent: ringName
				});

			}else{
				this._arrEventListDetails.push({
					strLabel:  _(["Alarm source", ":"], "webapp.agenda"),
					strContent: _("None", "webapp.agenda")
				});
			}
			if(objPlannedEvent.alarmReminderDelay===0){
				this._arrEventListDetails.push({
					strLabel: _(["Alarm time", ":"], "webapp.agenda"),
					strContent: webapp.agenda.data.arrRingingTimes[0].strLabel
				});
			}else{
				for(var i in webapp.agenda.data.arrRingingTimes)
				{
					if(objPlannedEvent.alarmReminderDelay===parseInt(webapp.agenda.data.arrRingingTimes[i].intIndex,10)){
						this._arrEventListDetails.push({
							strLabel: _(["Alarm time", ":"], "webapp.agenda") ,
							strContent: webapp.agenda.data.arrRingingTimes[i].strLabel
						});
						break;
					}

				}
			}
		}
		// set details view
		this.boolPreviewSelected = false;
		this.switchContainer("getAgendaDetails", this.STATUS_DETAILS, _("Appointment Details", "webapp.agenda"));
	},

	// Function called when we create a new event
	newEvent: function(button) {
		this.currentEventStatus = button;
		if(this.currentEventStatus === this.NEW_EVENT_ADD) {
			webapp.agenda.objClickableUI.deselect();
			this.objNewEvent = {};
		} else if (this.currentEventStatus === this.NEW_EVENT_MODIFY){
			this.objNewEvent = dojo.clone(this.objCurrentEvent);
		}
		var dateTime = new Date();
		if(!this.objNewEvent.id){
			this.objNewEvent.id = -1;
		}
		if(!this.objNewEvent.classType){
			this.objNewEvent.classType = "APPOINTMENT";
		}
		if(!this.objNewEvent.beginDate){
			this.objNewEvent.beginDate = {
				datetime:{
					day : dateTime.getDate(),
					month : dateTime.getMonth() + 1,
					year : dateTime.getFullYear(),
					minute : dateTime.getMinutes(),
					hour : dateTime.getHours()
				}
			};
		}
		if(!this.objNewEvent.alarmReminderDelay){
			this.objNewEvent.alarmReminderDelay = 0;
		}
		dateTime.setHours(dateTime.getHours() + 1);
		if(!this.objNewEvent.endDate){
			this.objNewEvent.endDate = {
				datetime:{
					day : dateTime.getDate(),
					month : dateTime.getMonth() + 1,
					year : dateTime.getFullYear(),
					minute : dateTime.getMinutes(),
					hour : dateTime.getHours()
				}
			};
		}
		if(!this.objNewEvent.repetitionPeriod){
			this.objNewEvent.repetitionPeriod = "ONE_TIME";
		}
		//ICTouchAPI.settingServices.getSettingValue("RingingBeforeValues", this, this.loadedRingingTimes);
		if (!this.objNewEvent.alarm) {
			this.objNewEvent.alarm = {
				type: "Alarm",
				value: {
					id: -1,
					idFile: -1,
					idCapabilities: -1,
					volume: 5
				}
			};
		}
		if (this.objNewEvent.description === null) {
			this.objNewEvent.description = "";
		}

		if (this.objNewEvent.place === null) {
			this.objNewEvent.place = "";
		}
		// set editEvent view
		this.switchContainer("getAgendaEditEvent", this.STATUS_EDIT, _("Event Edit","webapp.agenda"));
	},

	loadRingingSources : function() {
		ICTouchAPI.APIServices.FileManager.getFilesInPool({
			params:[ICTouchAPI.tools.POOL_AM,0,50],
			context:this,
			callback:this.loadedRingingSources
		});
	},

	loadedRingingSources : function(_arr) {
		this.arrRingingSources = [];
		for (var i in _arr) {
			this.arrRingingSources.push({
				intIndex: i,
				strLabel: _(_arr[i].name,"webapp.settings"),
				strActionIcon : "filesmanager-play",
				objSource: _arr[i]
			});
		}
	},

	loadedRingingTimes : function(objSetting) {
		this.arrRingingTimes = [];
		for (var i in objSetting.allowedValues) {
			this.arrRingingTimes.push({
				intIndex: objSetting.allowedValues[i].id,
				strLabel: _(objSetting.allowedValues[i].name,"webapp.settings")
			});
		}
	},

	getRingingTimes : function(){
		return this.arrRingingTimes;
	},

	getRingingSources : function(){
		return this.arrRingingSources;
	},

	refreshDetails : function () {
		// set details view
		this._strContainerPath = "webapp.agenda.getAgendaDetails";
		this.intStatus = this.STATUS_DETAILS;
		// refresh
		webapp.agenda.updateActionBar();
		webapp.agenda.container.refresh();
	},

	// go to Today in clickable List
	goToToday : function() {
		// we know were is the element Today (saved at loaded List)
		// if it is set we go to today !
		if(this._intTodayPositionInList) {
			// position selectList at that element
			webapp.agenda.objClickableUI.selectItemByPosition(this._intTodayPositionInList, true);
		} else {
			webapp.agenda.mainWidget.reloadMenu();
		}
	},

	timeSelector : function(startEnd) {
		// startEnd say if it's start or end field that we want to edit
		this.currentStartEnd = startEnd;
		// set timeEdit view
		this.switchContainer("getAgendaTimeEdit", this.STATUS_TIME, _("Time Event Edit","webapp.agenda"));
	},

	participantsSelector : function(){
		// set participantEdit view
		this.switchContainer("getAgendaParticipantEdit", this.STATUS_PARTICIPANTS, _("Participant Event Edit","webapp.agenda"));
	},

	// init the calendar
	// @param <CONST> calendarType (Type are add or gotoday)
	setCalendar : function (calendarType, startEnd) {
		this.currentCalendarType = calendarType;
		if(startEnd){
			this.currentStartEnd = startEnd;
		}
		// set calendar view
		this.switchContainer("getAgendaCalendar", this.STATUS_DATE, _("Date Event Edit","webapp.agenda"), true);
	},

	// return the callback called after a click on a date
	// on the calendar UIElement
	getCalendarCallBack : function () {
		switch(this.currentCalendarType) {
			case this.CALENDAR_TYPE_GOTODAY:
				return {
					context:webapp.agenda,
					func:webapp.agenda.data.goToDay
				};
			case this.CALENDAR_TYPE_ADD:
				return {
					context:webapp.agenda.data,
					func:webapp.agenda.data.setDate
				};
			default:
				return function() {};
		}
	},

	// Set the date after clicking on it
	setDate: function(dateFromCalendar) {
		var currentDate ;
		var otherDate ;
		// Store the date to modify
		if(this.currentStartEnd===this.START){
			currentDate = this.objNewEvent.beginDate.datetime;
			otherDate = this.objNewEvent.endDate.datetime;
			var oldDate = new Date(currentDate.year,currentDate.month-1,currentDate.day);
		}
		if(this.currentStartEnd===this.END){
			currentDate = this.objNewEvent.endDate.datetime;
		}

		var dateString = dojo.date.stamp.toISOString(dateFromCalendar);

		currentDate.day = dateString.substring(8,10);
		currentDate.month = dateString.substring(5,7);
		currentDate.year = dateString.substring(0,4);

		//If end date is lower than begin date, change end date
		if(otherDate && (this.currentEventStatus === this.NEW_EVENT_ADD)
				&& this.compareDateOfEvent(this.objNewEvent)===-1){
			var newDate = new Date(currentDate.year,currentDate.month-1,currentDate.day);
			var delta = dojo.date.difference(oldDate, newDate, "day");
			oldDate = new Date(otherDate.year,otherDate.month-1,otherDate.day);
			newDate = dojo.date.add(oldDate, "day", delta);
			dateString = dojo.date.stamp.toISOString(newDate);
			otherDate.day = dateString.substring(8,10);
			otherDate.month = dateString.substring(5,7);
			otherDate.year = dateString.substring(0,4);
			//If end date is stilllower than begin date, end date = start date
			if(this.compareDateOfEvent(this.objNewEvent)===-1) {
				otherDate.day = currentDate.day;
				otherDate.month = currentDate.month;
				otherDate.year = currentDate.year;
				otherDate.hour = currentDate.hour;
				otherDate.minute = currentDate.minute;
		}
		}

		// set editEvent view
		this.switchContainer("getAgendaEditEvent", this.STATUS_EDIT, _("Event Edit","webapp.agenda"));
	},

	// set a new content for the container of the agenda and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle) {
		if(pageName !== "") {
			this._strContainerPath = "webapp.agenda."+pageName;
		}
		if(pageTitle) {
			this._strTitle = pageTitle;
		}
		if(webapp.agenda.mainWidget) {
			this.updateAppBar(status);
			webapp.agenda.mainWidget.reloadContainer();
		}
	},

	// set the action bar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.agenda.currentStatus = status;

		// button callback
		var backFunc = {
			context:webapp.agenda,
			func:webapp.agenda.buttonCallback,
			param:this.BACK
		};
		ICTouchAPI.AppBarServices.addExitButton("agenda","agendastatus"+status,this.isPreviousHome(), backFunc);

		ICTouchAPI.AppBarServices.setAppBar("agenda", "agendastatus"+status, "getAgenda");
	},

	// return the array of obj width date for the calendar
	getCalendarEvents : function() {
		return this._arrCalendarPlannedEvents;
	},

	// scroll the menuList UIElement to the day (selected
	// via the calendar or) passed in parameter
	// @param <date> dateFromCalendar
	goToDay : function (dateFromCalendar) {
		// search the position of this date in the itemList
		var position = 0;
		var arrEventList = this.data._arrEventList;
		for(var i=arrEventList.length-1;i>=0;i--)
		{
			// we're searching only in title element
			if(arrEventList[i].strType === "title")
			{
				// check next title item
				if(dojo.date.compare(arrEventList[i].date, dateFromCalendar,"date") === 1)
				{
					continue;
				}
				// we find our item
				else if(dojo.date.compare(arrEventList[i].date, dateFromCalendar,"date") === 0)
				{
					position = i+1;
					break;
				}
			}
		}

		// go to this position if we found it
		if(position) {
			webapp.agenda.objClickableUI.selectItemByPosition(position,true);
		}
	},

	deleteEvent: function() {
		var eventId = this.objCurrentEvent.id;
		this.objNewEvent = null;
		ICTouchAPI.APIServices.Agenda.removePlannedEvent({
			params:["APPOINTMENT", eventId],
			context:this,
			callback:function() {}
		}) ;
		this._arrEventListDetails = [];
		webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_HOME, _("Appointment Details", "webapp.agenda"));

	},

	// Open a new popup with a specific type
	deletePopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Confirm deletion","webapp.agenda"),
			strType: "warning",
			strContent: _("Are you sure you want to delete ?","webapp.agenda"),
			arrPopupButtons: [{
				strButtonName: this.YES_BTN,
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				strButtonIcon: "generic-ok",
				callback: function() {
					context.deleteEvent();
					context.closeDeletePopup();
				}
			},{
				strButtonName: this.NO_BTN,
				strButtonLabel:  _("No", 'ICTouchAPI'),
				strButtonIcon: "generic-cancel",
				callback: function() {
					context.closeDeletePopup();
				}
			}]
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},
	// Open a new popup with a specific type
	loadInformativeDisplay : function(infoText, title, type) {
		var context = this;
		var buttons = [];
		buttons.push({
			strButtonLabel:  _("Ok", 'ICTouchAPI'),
			callback: function() {
				context.closeDeletePopup();
				return "ok";
			}
		});
		if (type === "warning"){
			buttons.push({
				strButtonLabel:  _("Cancel", 'ICTouchAPI'),
				callback: function() {
					context.closeDeletePopup();

					return "cancel";
				}
			});
		}
		var popupData = {
			strTitle: _(title,"webapp.agenda"),
			strType: type,
			strContent: _(infoText,"webapp.agenda"),
			arrPopupButtons: buttons
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	loadBackPopUp:function(){
		if(!this.objBackPopup){
			var context = this;
			var popupData = {
				strTitle: _("Save changes","webapp.agenda"),
				strType: "warning",
				strContent: _("Save the changes before exiting ?","webapp.agenda"),
				arrPopupButtons: [{
					strButtonName: this.YES_BTN,
					strButtonLabel:  _("Yes", 'ICTouchAPI'),
					strButtonIcon: "generic-ok",
					callback: function() {
						context.closeBackPopup();
						context.objBackPopup = null;
						webapp.agenda.TrySaveEvent();
					}
				},{
					strButtonName: this.NO_BTN,
					strButtonLabel:  _("No", 'ICTouchAPI'),
					strButtonIcon: "generic-cancel",
					callback: function() {
						context.closeBackPopup();
						context.objBackPopup = null;
						webapp.agenda.data._goBackToHomeAgenda();
					}
				}]
			};
			this.objBackPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		}
	},



	_goBackToHomeAgenda : function(){
		if(this.objCurrentEvent){
			this.switchContainer("getAgendaDetails", this.STATUS_DETAILS, "Calendar: Event details");
		}
		else{
			this.switchContainer("getAgendaDetails", this.STATUS_HOME, "Calendar: Homepage");
		}
	},

	// Hide the popup
	closeDeletePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.objPopup);
	},

	closeBackPopup : function(){
		ICTouchAPI.popupServices.removePopup(this.objBackPopup);
	},
	getAppBarAppButtons : function(){
		return this._arrAppButtons[webapp.agenda.currentStatus];
	},

	getAppBarSysButtons : function(){
		return this._arrSysButtons;
	},

	getContainerTitle : function() {
		return this._strTitle;
	},

	getContainerPath : function(){
		return this._strContainerPath;
	},

	getList : function() {
		return this._arrEventList;
	},

	getDayEvents : function(date){
		var dayEvents = [];
		for (var i=0; i<this._arrEventList.length; i++){
			if(this._arrEventList[i].strType === "normal" && dojo.date.compare(this._arrEventList[i].date, date,"date") === 0){
				dayEvents.push(this._arrEventList[i]);
			}
		}
		return dayEvents;
	},

	getListPreview : function() {
		return this._arrEventListPreview;
	},

	getDetails : function(){
		return this._arrEventListDetails;
	},

	getAgendaListTitle : function(){
		return this._agendaListTitle;
	},

	isPreviousHome : function() {
		if(this._strContainerPath === "webapp.agenda.getAgendaDetails") {
			return true;
		}
		else {
			return false;
		}
	},

	is24HourFormat : function() {
		return this._24hformat;
	},

	//Compare Date of 1 event
	//Return 0 if begin date is equal to end date, -1 if begin begin date is higher to end date, 1 if begin date is lower to end date
	compareDateOfEvent : function(objEvent) {
		var objBeginDate = objEvent.beginDate.datetime;
		var objEndDate = objEvent.endDate.datetime;
		var beginDate = new Date(objBeginDate.year, objBeginDate.month, objBeginDate.day, (objBeginDate.hour), parseInt(objBeginDate.minute), 0);
		var endDate = new Date(objEndDate.year, objEndDate.month, objEndDate.day, parseInt(objEndDate.hour), parseInt(objEndDate.minute), 0);
		return(dojo.date.compare(endDate, beginDate));
	}


});
dojo.require("webapp.agenda.dataBase");
dojo.provide("webapp.agenda.data");

dojo.declare("webapp.agenda.data", webapp.agenda.dataBase, {});

webapp.agenda.data = new webapp.agenda.data();dojo.provide("webapp.agenda.getAgendaBase");
dojo.declare("webapp.agenda.getAgendaBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

	}
);dojo.require("webapp.agenda.getAgendaBase");
dojo.provide("webapp.agenda.getAgenda");
dojo.declare("webapp.agenda.getAgenda",
	webapp.agenda.getAgendaBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgenda8082.html"),
		cssFile : ['icons.css', 'main8082.css'],

		postCreate:function(){
			var arrEventList = webapp.agenda.data.getList();
			// function on click to get details
			var func = {
				context:webapp.agenda.data,
				func:webapp.agenda.data.loadDetails
				};
			var data = webapp.agenda.data;
			var am = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: arrEventList,
						callback: func
					}
				},

				container : {
					name    : "UIElements.PresentationList.PresentationListControl",
					autoSelectFirst : false,
					params  : {
						arrItems : webapp.agenda.data.getDetails(),
						boolShowLabel: true
					}
				},
				objContainerTitle : {
					strLabel : data.getContainerTitle()
					},
				objMenuTitle : {
					strLabel : data.getAgendaListTitle()
					}
			},this.mainPart);
			this.container = am.getContainer();
			this.menu = am.getMenu();
			webapp.agenda.mainWidget = this;
			webapp.agenda.agendaList = am.getMenu();
			webapp.agenda.objClickableUI = am.getMenu().getContent();
			data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Homepage","webapp.agenda"));

			//If an item has to be open when entering the webapp (open using preview events)
			if (webapp.agenda.indexToSelectOnOpen){
				webapp.agenda.objClickableUI.selectItemByIndex(webapp.agenda.indexToSelectOnOpen, true);
				webapp.agenda.indexToSelectOnOpen = null;
			}
		},

		reloadMenu: function() {
			var data = webapp.agenda.data;
			var arrEventList = webapp.agenda.data.getList();
			// function on click to get details
			var func = {
				context:webapp.agenda.data,
				func:webapp.agenda.data.loadDetails
				};
			this.menu.reload({
				objTitle: {
					strLabel : data.getAgendaListTitle()
					},
				objContent: {
					name: "UIElements.MenuList.MenuListControl",
					params: {
						arrItems: arrEventList,
						callback: func
					}
				}
			});
			webapp.agenda.objClickableUI = this.menu.getContent();
		},

		reloadContainer: function(params) {
			var data = webapp.agenda.data;
			var tmpParams = params?params:{};
			if(this.container)
				this.container.reload({
					objTitle: {
						strLeftIcon : null,
						strLabel : data.getContainerTitle(),
						strRightIcon : null
					},
					objContent: {
						name: data.getContainerPath(),
						params: tmpParams
					}
				});
		}
	}
	);
dojo.provide("webapp.agenda.getAgendaListBase");
dojo.declare("webapp.agenda.getAgendaListBase", 
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		postCreate:function() {
			// data events
			var arrEventList = webapp.agenda.data.getList();
			// function on click to get details
			var func = {context:webapp.agenda.data, func:webapp.agenda.data.loadDetails};
			webapp.agenda.objClickableUI = new UIElements.MenuList.MenuListControl({ arrItems: arrEventList, callback: func }, this.domList);
		}
	}
);
dojo.require("webapp.agenda.getAgendaListBase");
dojo.provide("webapp.agenda.getAgendaList");

dojo.declare("webapp.agenda.getAgendaList", 
	webapp.agenda.getAgendaListBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaList8082.html")
	}
);
dojo.provide("webapp.agenda.getAgendaDetailsBase");
dojo.declare("webapp.agenda.getAgendaDetailsBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		listUI : {},

		postCreate:function(){
			var list = webapp.agenda.data.getDetails();
			this.listUI = new UIElements.PresentationList.PresentationListControl({
				arrItems : list,
				boolShowLabel: true
			}, this.domDetails);
		}
	});
dojo.require("webapp.agenda.getAgendaDetailsBase");
dojo.provide("webapp.agenda.getAgendaDetails");
dojo.declare("webapp.agenda.getAgendaDetails", 
	webapp.agenda.getAgendaDetailsBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaDetails8082.html")
	}
);
dojo.provide("webapp.agenda.getAgendaTimeEditBase");
dojo.declare("webapp.agenda.getAgendaTimeEditBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domItems		: [],
		arrItems		: [],
		boolScroll      : true,
		timeout			: null,

		constructor: function() {
			this.domItems = [];
		},

		postCreate : function() {
			this.arrItems = [];
			webapp.agenda.uiTime = this;
			var data = webapp.agenda.data;
			data.currentWidget = this;
			var date = null;
			if(data.currentStartEnd === data.START) {
				date = data.objNewEvent.beginDate.datetime;
			} else {
				date = data.objNewEvent.endDate.datetime;
			}

			this.objAlarmTimeUI = new UIElements.ValueSelect.TimeSelect({
				intHourValue: date.hour,
				intMinuteValue: date.minute,
				is24hourFormat : webapp.agenda.data._24hformat
			}, this.domTime);
		},

		getTime: function() {
			var minutes = this.objAlarmTimeUI.getValue()[1];
			var hours = this.objAlarmTimeUI.getValue()[0];
			return {
				hour: hours,
				minute: minutes
			};
		},

		destroy : function () {
			this.inherited(arguments);
		}
	});dojo.require("webapp.agenda.getAgendaTimeEditBase");
dojo.provide("webapp.agenda.getAgendaTimeEdit");
dojo.declare("webapp.agenda.getAgendaTimeEdit",
	webapp.agenda.getAgendaTimeEditBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaTimeEdit8082.html"),
	});dojo.provide("webapp.agenda.getAgendaAlarmEditBase");
dojo.declare("webapp.agenda.getAgendaAlarmEditBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		boolScroll  : true,
		source      : null,
		time        : 0,
		sourceUI    : null,
		timesUI     : null,

		SOURCE      : 0,
		TIMES       : 1,

		postCreate : function() {
			this.source = null;
			this.time = 0;
			webapp.agenda.uiAlarm = this;
			var data = webapp.agenda.data;
			var arrSource = data.getRingingSources();
			var arrTime = data.getRingingTimes();
			var i;
			for (i in arrSource){
				arrSource[i].boolSelected = (data.objNewEvent.alarm.value.sourcePath === arrSource[i].objSource.path);
			}
			for (i in arrTime){
				arrTime[i].boolSelected = (data.objNewEvent.alarm.time === arrTime[i].objSource.value);
			}
			// Then create list
			var funcSource = {
				context:this,
				func:this.onClickRingingSource
				};
			var funcTime = {
				context:this,
				func:this.onClickRingingTime
				};
			if (arrSource.length > 0) {
				this.sourceUI = new UIElements.SelectList.SelectListControl({
					arrItems: arrSource,
					boolMultiselect: false,
					itemCallback: funcSource,
					boolScroll: false
				}, this.domAlarmType);
			}
			if (arrTime.length > 0) {
				this.timesUI = new UIElements.SelectList.SelectListControl({
					arrItems: arrTime,
					boolMultiselect: false,
					itemCallback: funcTime,
					boolScroll: false
				}, this.domAlarmTime);
			}
			var params = {
				boolSnap: false
			};
		},

		onClickRingingSource : function(strIndex) {
			var data = webapp.agenda.data;
			var _arr = data.getRingingSources();
			this.source = dojo.clone(_arr[parseInt(strIndex,10)].objSource);
		},

		onClickRingingTime : function(strIndex) {
			var data = webapp.agenda.data;
			var _arr = data.getRingingTimes();
			this.time = ""+_arr[parseInt(strIndex,10)].objSource.value;
		},

		updateAlarm : function() {
			var data = webapp.agenda.data;
			if(this.source) {
				data.objNewEvent.alarm.value.sourcePath = this.source.path;
				data.objNewEvent.alarm.value.sourceType = this.source.type;
			}
			if(this.time){
				data.objNewEvent.alarm.time = ""+this.time;
			}
		},

		destroy : function () {
			// Destroy the scroll
			if(this.sourceUI){
				this.sourceUI.destroy();
			}
			if(this.timesUI){
				this.sourceUI.destroy();
			}
			this.inherited(arguments);
		}
	});dojo.require("webapp.agenda.getAgendaAlarmEditBase");
dojo.provide("webapp.agenda.getAgendaAlarmEdit");
dojo.declare("webapp.agenda.getAgendaAlarmEdit",
	webapp.agenda.getAgendaAlarmEditBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaAlarmEdit8082.html"),
	});dojo.provide("webapp.agenda.getAgendaEditEventBase");
dojo.declare("webapp.agenda.getAgendaEditEventBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		event : null,

		descriptionUI : null,
		labelUI : null,
		placeUI : null,
		occurenceUI : null,
		volumeUI : null,
		ringUI : null,
		listUI : null,
		boolScroll : true,
		arrTitles : [],
		domTitle : [],
		domContent : [],
		_arrPresentationListEntries	: [],

		constructor : function() {
			this.domTitle = [];
			this.arrTitles = [];
			this.domContent = [];
			this.arrTitles.push({
				strLabel : _("Label", "webapp.agenda"),
				id : "label"
			});
			this.arrTitles.push({
				strLabel : _("Description", "webapp.agenda"),
				id : "description"
			});
			this.arrTitles.push({
				strLabel : _("Place", "webapp.agenda"),
				id : "place"
			});
			this.arrTitles.push({
				strLabel : _("Start Date", "webapp.agenda"),
				id : "startDate"
			});
			this.arrTitles.push({
				strLabel : _("Start Time", "webapp.agenda"),
				id : "startTime"
			});
			this.arrTitles.push({
				strLabel : _("End Date", "webapp.agenda"),
				id : "endDate"
			});
			this.arrTitles.push({
				strLabel : _("End Time", "webapp.agenda"),
				id : "endTime"
			});
			this.arrTitles.push({
				strLabel : _("Occurrence", "webapp.agenda"),
				id : "occurence"
			});
			// Participants may be used in next version
			// this.arrTitles.push({strLabel : "Participants : ", id : "participants"});
			this.arrTitles.push({
				strLabel : _("Alarm", "webapp.agenda"),
				id : "alarm"
			});
			this.arrTitles.push({
				strLabel : _("Volume", "webapp.agenda"),
				id : "volume"
			});
			this.arrTitles.push({
				strLabel : _("Type", "webapp.agenda"),
				id : "alarmType"
			});
			this.arrTitles.push({
				strLabel : _("Time", "webapp.agenda"),
				id : "alarmTime"
			});
			webapp.agenda.uiEditEvent = this;
		},

		postCreate : function() {
			var data = webapp.agenda.data;
			var event = data.objNewEvent;
			var context = this;
			webapp.agenda.data.ringingSourcesValue = null;
			webapp.agenda.data.ringingTimesValue = null;

			this._arrPresentationListEntries = [];
			//Add the label line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[0].strLabel,
				objContent :  new UIElements.InputField.InputFieldControl({
					keyboardType: "alphaNum",
					strInputText: "",
					strInputTitle : this.arrTitles[0].strLabel,
					isMultiLines: false,
					funcCallback: function(strContent) {
						event.label = strContent;
					}
				})
			});

			//Add the Description Line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[1].strLabel,
				objContent :  new UIElements.InputField.InputFieldControl({
					keyboardType: "alphaNum",
					strInputText: "",
					strInputTitle : this.arrTitles[1].strLabel,
					isMultiLines: true,
					intMaxLine	: 2,
					funcCallback: function(strContent) {
						event.description = strContent;
					}
				})
			});

			//Add the place line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[2].strLabel,
				objContent :  new UIElements.InputField.InputFieldControl({
					keyboardType: "alphaNum",
					strInputText: "",
					strInputTitle : this.arrTitles[2].strLabel,
					isMultiLines: false,
					funcCallback: function(strContent) {
						event.place = strContent;
					}
				})
			});

			//Add the start date line
			var dateBegin;
			if(event.beginDate.datetime.day){
				dateBegin = ICTouchAPI.tools.getFormatedDate(
					new Date(event.beginDate.datetime.year,
						event.beginDate.datetime.month - 1,
						event.beginDate.datetime.day),
					data._dateFormat);
			}
			else{
				dateBegin = "----/--/--";
			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[3].strLabel,
				strContent :  dateBegin ,
				callback :  function(){
					context.saveEvent();
					data.setCalendar(data.CALENDAR_TYPE_ADD, data.START);
				}
			});

			//Add the start time line
			var hourBegin;
//			if(typeof(event.beginDate.datetime.hour) == "number" || typeof(event.beginDate.datetime.minute) == "number" ){
				hourBegin = ICTouchAPI.tools.getFormatedTime(event.beginDate.datetime.hour, event.beginDate.datetime.minute, data._24hformat);
//			}
//			else{
//				hourBegin = "--:--";
//			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[4].strLabel,
				strContent :  hourBegin,
				callback :  function(){
					context.saveEvent();
					data.timeSelector(data.START);
				}
			});

			//Add the end date line
			var dateEnd;
			if(event.endDate.datetime.day){
				dateEnd = ICTouchAPI.tools.getFormatedDate(
					new Date(event.endDate.datetime.year,
						event.endDate.datetime.month - 1,
						event.endDate.datetime.day),
					data._dateFormat);
			}
			else{
				dateEnd = "----/--/--";
			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[5].strLabel,
				strContent :  dateEnd ,
				callback :  function(){
					context.saveEvent();
					data.setCalendar(data.CALENDAR_TYPE_ADD, data.END);
				}
			});

			//Add the end time line
			var hourEnd;
			if(event.endDate.datetime.hour || event.endDate.datetime.minute ){
				hourEnd = ICTouchAPI.tools.getFormatedTime(event.endDate.datetime.hour, event.endDate.datetime.minute, data._24hformat);
			}
			else{
				hourEnd = "--:--";
			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[6].strLabel,
				strContent :  hourEnd,
				callback :  function(){
					context.saveEvent();
					data.timeSelector(data.END);
				}
			});

			//Add the occurence line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[7].strLabel,
				objContent :  new UIElements.OptionChooser.OptionChooserControl({
					intMaximum : 4,
					intSteps : 1,
					boolShowButton : true,
					arrItems : [_("once","webapp.agenda"), _("daily","webapp.agenda"), _("weekly","webapp.agenda"), _("monthly","webapp.agenda")],
					funcCallback : {
						context:this,
						func:webapp.agenda.occurenceChanged
					},
					intSliderWidth:250
				})
			});

			//Add the alarm line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[8].strLabel,
				objContent :  new UIElements.OptionChooser.OptionChooserControl({
					intMaximum : 2,
					intSteps : 1,
					boolShowButton : true,
					arrItems : [_("Off","ICTouchAPI"),_("On","ICTouchAPI")],
					funcCallback : {
						context:this,
						func:webapp.agenda.alarmStateChanged
					},
					intSliderWidth:180
				})
			});

			//Add the alarm volume line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[9].strLabel,
				boolEnabled: false,
				objContent :  new UIElements.Slider.Linear({
					intMinimum: 0,
					intMaximum: 9,
					boolShowTime: false,
					boolSeekable: false,
					intSliderWidth:250
				})
			});


			//Add the alarm type line
			var alarmSrcType = "";

			if(data.arrRingingSources.length===0){
				alarmSrcType = _("No source available", 'webapp.agenda');
			}else{
				var selected = false;
				alarmSrcType = data.arrRingingSources[0].strLabel;
				if(event.alarm) {
					var iMax = data.arrRingingSources.length;
					for(var i=0; i<iMax; i++) {
						if(data.arrRingingSources[i].objSource.id===event.alarm.value.idFile) {
							data.ringingSourcesValue = data.arrRingingSources[i];
							alarmSrcType = data.arrRingingSources[i].strLabel;
							selected = true;
							break;
				}
			}
				}
				if(!selected) {
					data.ringingSourcesValue = data.arrRingingSources[0];
					alarmSrcType = data.ringingSourcesValue.strLabel;
				}
			}

			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[10].strLabel,
				strContent : alarmSrcType,
				boolEnabled: false,
				callback : {
					context:webapp.agenda,
					func:webapp.agenda.getToaster,
					param:"RingingSourceValues"
				}
			});


			//Add the alarm time line
			var _strLabel = "";


			if(event.alarmReminderDelay===0){
				_strLabel=webapp.agenda.data.arrRingingTimes[0].strLabel;
				webapp.agenda.data.ringingTimesValue=0;
				data.ringingTimesValue = data.arrRingingTimes[0];
			}
			else{
				for(var i in webapp.agenda.data.arrRingingTimes)
				{
					if(event.alarmReminderDelay===parseInt(webapp.agenda.data.arrRingingTimes[i].intIndex,10)){
						data.ringingTimesValue = data.arrRingingTimes[i];
						_strLabel=webapp.agenda.data.arrRingingTimes[i].strLabel;
						break;
					}

				}
			}

			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[11].strLabel,
				strContent: _strLabel,
				boolEnabled: false,
				callback: {
					context:webapp.agenda,
					func:webapp.agenda.getToaster,
					param:"RingingBeforeValues"
				}
			});

			this.fillContent();

			this.listUI = new UIElements.PresentationList.PresentationListControl({
				arrItems: this._arrPresentationListEntries,
				boolShowLabel: true
			}, this.domScroll);

			//Hide the occurence Filed (descoped from R200)
			var domOccurence = this.getUIElement("occurence").domNode.parentNode.parentNode;
			dojo.style(domOccurence, "display", "none");
		},

		fillContent : function() {
			var data = webapp.agenda.data;
			var event = data.objNewEvent;
			if(event.label){
				this._arrPresentationListEntries[0].objContent.setInputFieldContent(event.label);
			}
			if(event.description){
				this._arrPresentationListEntries[1].objContent.setInputFieldContent(event.description);
			}
			if(event.place)
			{
				this._arrPresentationListEntries[2].objContent.setInputFieldContent(event.place);
			}

			this._arrPresentationListEntries[9].objContent.setValue(event.alarm.value.volume);
			this._arrPresentationListEntries[10].callback = {
				context:webapp.agenda,
				func:webapp.agenda.getToaster,
				param:"RingingSourceValues"
			};
			this._arrPresentationListEntries[11].callback = {
				context:webapp.agenda,
				func:webapp.agenda.getToaster,
				param:"RingingBeforeValues"
			};

			if(event.alarmState){
				this._arrPresentationListEntries[8].objContent.attr('intIndex', 1);
				if(webapp.agenda.data.arrRingingSources.length!=0){
					this._arrPresentationListEntries[9].objContent.setSeekable(true);
					this._arrPresentationListEntries[9].boolEnabled = true;
					this._arrPresentationListEntries[10].boolEnabled = true;

				}
				this._arrPresentationListEntries[11].boolEnabled = true;

			}else{
				this._arrPresentationListEntries[8].objContent.attr('intIndex', 0);
				this._arrPresentationListEntries[9].objContent.setSeekable(false);
				this._arrPresentationListEntries[9].boolEnabled = false;
				this._arrPresentationListEntries[10].boolEnabled = false;
				this._arrPresentationListEntries[11].boolEnabled = false;
			}
			var occurenceArr = ["ONE_TIME", "DAILY", "WEEKLY", "MONTHLY"];
			if(event.repetitionPeriod!==undefined) {
				for (var i in occurenceArr) {
					if(event.repetitionPeriod === occurenceArr[i]){
						this._arrPresentationListEntries[7].objContent._setIntIndexAttr(parseInt(i,10));
					}				}
			} else {
				this._arrPresentationListEntries[7].objContent._setIntIndexAttr(0);
			}
		},

		getUIElement : function (element){
			switch(element)
			{
				case "volume" :
					return this._arrPresentationListEntries[9].objContent;
				case "ring" :
					return this._arrPresentationListEntries[8].objContent;
				case "occurence"  :
					return this._arrPresentationListEntries[7].objContent;
				default :
					return null;
			}

		},

		saveEvent : function() {
			var event = webapp.agenda.data.objNewEvent;
			if(this._arrPresentationListEntries[8].objContent.attr('intIndex')){
				event.alarm.value.volume = this._arrPresentationListEntries[9].objContent.getValue();
			}
			event.alarmState = this._arrPresentationListEntries[8].objContent.attr('intIndex');
		},

		destroy : function () {
			this.inherited(arguments);
		}
	});
dojo.require("webapp.agenda.getAgendaEditEventBase");
dojo.provide("webapp.agenda.getAgendaEditEvent");
dojo.declare("webapp.agenda.getAgendaEditEvent", 
	webapp.agenda.getAgendaEditEventBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaEditEvent8082.html"),
	});
/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaPreviewBase");
dojo.declare("webapp.agenda.getAgendaPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		id : null,
		_clicked:function(){
			if(!webapp.agenda.data.boolPreviewSelected)
			{
				webapp.agenda.data.loadVeryNextAppDetails();
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params:  {}
			});
		}
	}
	);
/*Webapplication: Agenda - Widget: Preview*/
dojo.require("webapp.agenda.getAgendaPreviewBase");
dojo.provide("webapp.agenda.getAgendaPreview");
dojo.declare("webapp.agenda.getAgendaPreview",
	webapp.agenda.getAgendaPreviewBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaPreview8082.html"),
		containerPreview    : null,

		postCreate:function(){
			this.containerPreview=new UIElements.Container.ContainerControl(
			{
				objTitle: {
					strLabel : webapp.agenda.data.getAgendaListTitle()
				},
				objContent: {
					name : "webapp.agenda.getAgendaPreviewList",
					params : {}
				}
			}, this.domAgendaPreview);
		},

		destroy : function(){
			this.inherited(arguments);
		}
	}
	);
/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaPreviewListBase");
dojo.declare("webapp.agenda.getAgendaPreviewListBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
	}
);
/*Webapplication: Agenda - Widget: Preview*/
dojo.require("webapp.agenda.getAgendaPreviewListBase");
dojo.provide("webapp.agenda.getAgendaPreviewList");
dojo.declare("webapp.agenda.getAgendaPreviewList",
	webapp.agenda.getAgendaPreviewListBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaPreviewList8082.html"),
		menuListPreview : null,

		postCreate:function(){
			var func = {
				context:this,
				func:this.loadAppointment
				};
			var arrEventList = webapp.agenda.data.getListPreview();
			this.menuListPreview = new UIElements.MenuList.MenuListControl({
				arrItems : arrEventList,
				autoSelectFirst : false,
				boolPreview : true,
				callback : func
			}, this.domAgendaPreviewList);
		},

		loadAppointment:function(idApp){
			webapp.agenda.data.boolPreviewSelected = true;
			//If the webapp is already loaded
			if (webapp.agenda.objClickableUI){
			webapp.agenda.objClickableUI.selectItemByIndex(idApp, true);
			}
			else{ //Inform to open the item when entering
				webapp.agenda.indexToSelectOnOpen = idApp;
			}
		},
		destroy : function(){
			if(this.menuListPreview) {
				this.menuListPreview.destroy();
			}
			this.inherited(arguments);
		}

	}
	);
/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaCalendarBase");
dojo.declare("webapp.agenda.getAgendaCalendarBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objCalendar: null,
		_objContent : null,
		_objTitle : null,
		clickLeftIconHandle : null,
		clickRightIconHandle : null,

		constructor: function() {
			this._arrConnects = [];
		},

		postCreate:function(){
            this.subscribe("languageChanged",this.refreshDate);
			var data = webapp.agenda.data;
			var mainWidget = webapp.agenda.mainWidget;

			// Initialize the Title box of the container
			this._objTitle = mainWidget.container.getTitle();
			this._objTitle.attr("strLeftIcon", "calendar-left");
			this._objTitle.attr("strRightIcon", "calendar-right");

			// Create the calendar
			this.objCalendar = new UIElements.Calendar.CalendarControl({
				onValueSelectedCallBack		: {
					context:this,
					func:this.onValueSelectedCallBack
					},
				arrPlannedEvents			: webapp.agenda.data.getCalendarEvents(),
				strCalendarType				: "medium"
			}, this.domAgendaCalendar);

			var date;
			if( data.currentStartEnd === data.START || data.currentStartEnd === data.END )
			{
				// Set the current displayed date to the event value if available
				var datetime;
				if(data.currentStartEnd === data.START) {
					datetime = data.objNewEvent.beginDate.datetime;
				} else {
					datetime = data.objNewEvent.endDate.datetime;
				}
				date = new Date(parseInt(datetime.year, 10), parseInt(datetime.month, 10)-1 /* months in Date object begin by 0 */, parseInt(datetime.day, 10));
			}
			else
			{
				date = new Date();
			}

			this.clickLeftIconHandle = dojo.connect(this._objTitle, "clickLeftIcon", this, this._decMonth);
			this.clickRightIconHandle = dojo.connect(this._objTitle, "clickRightIcon", this, this._incMonth);

			this.objCalendar.selectDate(date);
			this.titleUpdate(date);
		},

		// Decrease month on the calendar and the title
		_decMonth: function() {
			var value = this.objCalendar.decMonth();
			this.titleUpdate(value);
		},

		// Increase month on the calendar and the title
		_incMonth: function() {
			var value = this.objCalendar.incMonth();
			this.titleUpdate(value);
		},

		// Returns the date as a string
		getDisplayDate: function() {
			return this.objCalendar.attr("displayMonth");
		},

		destroy: function()	{
			dojo.disconnect(this.clickLeftIconHandle);
			dojo.disconnect(this.clickRightIconHandle);
			if( this.objCalendar ){
				this.objCalendar.destroy();
			}
			this.inherited(arguments);
		},

		// Callback when we click on a day in the calendar : Update the title and fire the calendar callback defined in the Data
		onValueSelectedCallBack: function(newDate) {
			this.titleUpdate(newDate);
			var callback = webapp.agenda.data.getCalendarCallBack();
			callback.func.call(callback.context, this.objCalendar.getValue());
		},

		// Update the title according to the new date
		titleUpdate : function(newDate) {
			if (this._objTitle) {
				var strMonth = newDate.format('MMMM yyyy',dojo.locale);
				this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
			}
		},

		refreshDate : function() {
			var date = this.objCalendar.getDate();
			this.titleUpdate(date);
			this.objCalendar.refreshDays();
		}
	});
/*Webapplication: Agenda - Widget: Preview*/
dojo.require("webapp.agenda.getAgendaCalendarBase");
dojo.provide("webapp.agenda.getAgendaCalendar");
dojo.declare("webapp.agenda.getAgendaCalendar",
	webapp.agenda.getAgendaCalendarBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaCalendar8082.html")
	}
);
/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaCalendarPreviewBase");
dojo.declare("webapp.agenda.getAgendaCalendarPreviewBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objCalendar: null,
		objEventList: null,
		onValueSelectedCallBack: null,
		handler : null,

		postCreate:function(){
			// callback
			this.objCalendar = new UIElements.Calendar.CalendarControl({
				onValueSelectedCallBack	: this.onValueSelectedCallBack,
				arrPlannedEvents		: webapp.agenda.data.getCalendarEvents(),
				strCalendarType			: "small"
			}, this.domAgendaCalendar);

			//get the events of today
			var arrForPreview = webapp.agenda.data.getDayEvents(new Date());

			var func = {
				context:this,
				func:this.loadAppointment
				};

			this.objEventList = new UIElements.MenuList.MenuListControl({
				arrItems: arrForPreview,
				autoSelectFirst : false,
				callback: func
			}, this.domEventList);
			this.handler = dojo.connect(this.objEventList, "onClick", this, this._clicked);


			FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});

		},

		loadAppointment:function(idApp){

			//If the webapp is already loaded
			if (webapp.agenda.objClickableUI){
				webapp.agenda.objClickableUI.selectItemByIndex(idApp, true);
			}
			else{ //Inform to open the item when entering
				webapp.agenda.indexToSelectOnOpen = idApp;
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params:  {}
			});
		},

		getDisplayDate: function() {
			return this.objCalendar.attr("displayMonth");
		},

		destroy: function()	{
			if( this.objCalendar ){
				this.objCalendar.destroy();
			}
			dojo.disconnect(this.handler);
			this.inherited(arguments);
		},

		_clicked:function(event){
			if (dojo.hasClass(event.target, "MenuListContainer")) {
				if(!webapp.agenda.data.boolPreviewSelected)
				{
					webapp.agenda.data.loadVeryNextAppDetails();
	}
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.agenda.getAgenda",
					params:  {}
				});
			}
		}
	}
	);
/*Webapplication: Agenda - Widget: Preview*/
dojo.require("webapp.agenda.getAgendaCalendarPreviewBase");
dojo.provide("webapp.agenda.getAgendaCalendarPreview");
dojo.declare("webapp.agenda.getAgendaCalendarPreview",
	webapp.agenda.getAgendaCalendarPreviewBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaCalendarPreview8082.html"),
	}
);
/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaCalendarContainerBase");
dojo.declare("webapp.agenda.getAgendaCalendarContainerBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		_objContent : null,
		_objTitle : null,
		container : null,
		clickTitleHandle : null,

		constructor: function() {
			this._arrConnects = [];
			dojo.subscribe("languageChanged",this,this.refreshDate);
		},

		postMixInProperties:function(){
		},

		postCreate:function(){
			this.container = new UIElements.Container.ContainerControl(
			{
				objTitle: {
					strLabel : "Month" ,
					strLeftIcon		: "calendar-left",
					strRightIcon	: "calendar-right"
				},
				objContent: {
					name : "webapp.agenda.getAgendaCalendarPreview",
					params : {
						onValueSelectedCallBack: {
							context:this,
							func:this.onValueSelectedCallBack
						}
					}
				}
			}, this.domAgendaCalendarContainer);

			this.clickTitleHandle = dojo.connect(this.container.getTitle(), "clickTitle", this, this._clicked);

			this._objTitle = this.container.getTitle();
			this._objContent = this.container.getContent();
			this.connect(this._objTitle, "clickLeftIcon", this._decMonth);
			this.connect(this._objTitle, "clickRightIcon", this._incMonth);

			var strMonth = this._objContent.getDisplayDate();
			this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
		},

		onValueSelectedCallBack: function(newDate) {
			if (this._objTitle) {
				var strMonth = this._objContent.getDisplayDate();
				this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
			}

			//Get all the events of the given day
			var events = webapp.agenda.data.getDayEvents(newDate);

			//Empty the MenuList
			this._objContent.objEventList.emptyItems();
			var newItem;
			//For each item
			for (var i=0 ; i<events.length ; i++){
				//Copy it! Not a reference to the one in the other MenuList elements
				newItem = {};
				newItem.intIndex = events[i].intIndex;
				newItem.strPrimaryContent =  events[i].strPrimaryContent;
				newItem.strPrimaryIcon =  events[i].strPrimaryIcon;
				newItem.strSecondaryContent =  events[i].strSecondaryContent;
				newItem.strType =  "normal";

				//Add it to the Preview MenuList
				this._objContent.objEventList.pushItem(newItem,true);
			}


		},

		_decMonth: function() {
			var value = this._objContent.objCalendar.decMonth();
			this.onValueSelectedCallBack(value);
		},

		_incMonth: function() {
			var value = this._objContent.objCalendar.incMonth();
			this.onValueSelectedCallBack(value);
		},

		destroy : function(){
			dojo.disconnect(this.handler);
			this.inherited(arguments);
		},

		_clicked:function(event){
			if(!webapp.agenda.data.boolPreviewSelected)
			{
				webapp.agenda.data.loadVeryNextAppDetails();
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params:  {}
			});
		},

		// Update the title according to the new date
		titleUpdate : function(newDate) {
			if (this._objTitle) {
				var strMonth = newDate.format('MMMM yyyy',dojo.locale);
				this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
			}
		},

		refreshDate : function() {
			var date = this._objContent.objCalendar.getDate();
			this.titleUpdate(date);
			this._objContent.objCalendar.refreshDays();
		}

	}
	);
/*Webapplication: Agenda - Widget: Preview*/
dojo.require("webapp.agenda.getAgendaCalendarContainerBase");
dojo.provide("webapp.agenda.getAgendaCalendarContainer");
dojo.declare("webapp.agenda.getAgendaCalendarContainer",
	webapp.agenda.getAgendaCalendarContainerBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaCalendarContainer8082.html"),
	}
);
dojo.provide("webapp.agenda.getAgendaToasterBase");
dojo.declare("webapp.agenda.getAgendaToasterBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		elementUI				: null,
		secondElementUI			: null,
		domToasterElement		: null,
		domToasterSecondElement	: null,
		domToasterButton		: null,
		selectList				: null,
		button                  : null,

		postCreate:function(){

			this.button = new UIElements.SimpleButton.SimpleButtonControl({
				strButtonType: 'ActionButton',
				strButtonText: _('Ok','ICTouchAPI'),
				funcCallback: dojo.hitch(this,this.buttonPressed)
			}, this.domToasterButton);
		},

		setElement : function(ui){
			var domElement = this.domToasterElement;
			this.elementUI = ui;

			this.elementUI.placeAt(domElement, "replace");
		},

		buttonPressed : function(){
			webapp.agenda.getToasterValidated(this, this.selectList);
		},

		destroy: function(){
			this.inherited(arguments);
		}
	}
	);

dojo.require("webapp.agenda.getAgendaToasterBase");
dojo.provide("webapp.agenda.getAgendaToaster");
dojo.declare("webapp.agenda.getAgendaToaster",
	webapp.agenda.getAgendaToasterBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaToaster8082.html"),
	}
);

dojo.provide("webapp.agenda.getAgendaParticipantEditBase");
dojo.declare("webapp.agenda.getAgendaParticipantEditBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		boolScroll : true,
		participantListUI : null,
		nameUI : null,
		emailUI : null,
		objPopup : null,

		_arrParticipantsPrint : [],

		constructor: function() {

		},

		postCreate : function() {
			webapp.agenda.data.currentWidget = this;
			var data = webapp.agenda.data;
			webapp.agenda.uiParticipants = this;
			this.arrTranslate();
			// List of the current participants
			this.participantListUI = new UIElements.SelectList.SelectListControl({
				arrItems: this._arrParticipantsPrint,
				intContainerSize: 4,
				boolMultiselect: true,
				itemCallback: null
			}, this.domParticipant);

			// Fields name and E-mail
			this.nameUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: false
			}, this.domName);
			this.emailUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: false
			}, this.domEmail);

			// Scroll
			var params = {
				boolSpan: false
			};
		},

		arrTranslate: function() {
			var data = webapp.agenda.data;
			this._arrParticipantsPrint = [];
			for (var i=0; i<data._arrParticipants.length;i++)
			{
				this._arrParticipantsPrint.push({
					strLabel: data._arrParticipants[i].name + " : " + data._arrParticipants[i].email,
					intIndex:i
				});
			}
		},

		// Add a new participant
		push : function() {
			var data = webapp.agenda.data;
			if(this.nameUI.getInputFieldContent() !== "") {
				if(this.emailUI.getInputFieldContent() === ""){
					this.newPopup("Warning");
				}
				data._arrParticipants.push({
					name:this.nameUI.getInputFieldContent(),
					email:this.emailUI.getInputFieldContent()
				});
			} else {
				this.newPopup("Error");
			}

			webapp.agenda.mainWidget.reloadContainer();
		},

		// Open a new popup with a specific type
		newPopup : function(type) {
			var context = this;
			var popupData = {
				strTitle: type,
				strWidgetName: "webapp.agenda.getAgendaParticipantPopup",
				arrPopupButtons: [{
					strButtonLabel:  _("Ok", "ICTouchAPI"),
					callback: function() {
						context.closePopup();
					}
				}]
			};
			this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		},

		// Hide the popup
		closePopup : function() {
			ICTouchAPI.popupServices.removePopup(this.objPopup);
		},

		// Remove every selected participant
		pop : function() {
			var newArrParticipants = [];
			var data = webapp.agenda.data;
			var selectedIndex = [];
			selectedIndex = this.participantListUI.getSelected();
			var j=0;
			for (var i=0; i<data._arrParticipants.length;i++)
			{
				if(selectedIndex[j] === i)
				{
					j++;
				}
				else
				{
					newArrParticipants.push(data._arrParticipants[i]);
				}
			}
			data._arrParticipants = newArrParticipants;
			webapp.agenda.mainWidget.reloadContainer();
		},

		destroy : function () {
			this.participantListUI.destroy();
			this.nameUI.destroy();
			this.emailUI.destroy();
			this.inherited(arguments);
		}
	});dojo.require("webapp.agenda.getAgendaParticipantEditBase");
dojo.provide("webapp.agenda.getAgendaParticipantEdit");
dojo.declare("webapp.agenda.getAgendaParticipantEdit",
	webapp.agenda.getAgendaParticipantEditBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaParticipantEdit8082.html"),
	});dojo.provide("webapp.agenda.getAgendaParticipantPopupBase");
dojo.declare("webapp.agenda.getAgendaParticipantPopupBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		postCreate:function(){
			webapp.agenda.data.currentWidget = this;
		}
	});dojo.require("webapp.agenda.getAgendaParticipantPopupBase");
dojo.provide("webapp.agenda.getAgendaParticipantPopup");
dojo.declare("webapp.agenda.getAgendaParticipantPopup",
	webapp.agenda.getAgendaParticipantPopupBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaParticipantPopup8082.html")
	});
	