dojo.require("webapp.agenda.getAgendaTimeEditBase");
dojo.provide("webapp.agenda.getAgendaTimeEdit");
dojo.declare("webapp.agenda.getAgendaTimeEdit",
	webapp.agenda.getAgendaTimeEditBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgendaTimeEdit8052.html"),
		cssFile : 'main8052.css',

		intFocus		: 0,

		postCreate : function() {
			this.inherited(arguments);
			ICTouchAPI.navigationServices.changeFocus(this);
		},

		updateFocus: function() {
			var len = this.domItems.length;
			if( len < 1 )
				return;
			this.intFocus = Math.max(0, Math.min(len-1, this.intFocus)); // Clamp intFocus value between 0 and list.length-1

			for(var i=0; i<len; ++i)
			{
				var obj = this.domItems[i];
				dojo.toggleClass(obj, "focus", (i == this.intFocus));
			}
		},

		navigate: function(action) {
			switch(action)
			{
				case "UP":
					this.intFocus--;
					this.updateFocus();
					break;
				case "DOWN":
					this.intFocus++;
					this.updateFocus();
					break;
				case "OK":
					webapp.agenda.buttonCallback(webapp.agenda.data.VALIDATE);
					break;
				default :
					var obj = this.arrItems[this.intFocus];
					obj.navigate(action);
					break;
			}
		}
	});