dojo.provide("webapp.agenda.getAgendaParticipantEditBase");
dojo.declare("webapp.agenda.getAgendaParticipantEditBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		boolScroll : true,
		participantListUI : null,
		nameUI : null,
		emailUI : null,
		objPopup : null,

		_arrParticipantsPrint : [],

		constructor: function() {

		},

		postCreate : function() {
			webapp.agenda.data.currentWidget = this;
			var data = webapp.agenda.data;
			webapp.agenda.uiParticipants = this;
			this.arrTranslate();
			// List of the current participants
			this.participantListUI = new UIElements.SelectList.SelectListControl({
				arrItems: this._arrParticipantsPrint,
				intContainerSize: 4,
				boolMultiselect: true,
				itemCallback: null
			}, this.domParticipant);

			// Fields name and E-mail
			this.nameUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: false
			}, this.domName);
			this.emailUI = new UIElements.InputField.InputFieldControl({
				keyboardType: "alphaNum",
				strInputText: "",
				isMultiLines: false
			}, this.domEmail);

			// Scroll
			var params = {
				boolSpan: false
			};
		},

		arrTranslate: function() {
			var data = webapp.agenda.data;
			this._arrParticipantsPrint = [];
			for (var i=0; i<data._arrParticipants.length;i++)
			{
				this._arrParticipantsPrint.push({
					strLabel: data._arrParticipants[i].name + " : " + data._arrParticipants[i].email,
					intIndex:i
				});
			}
		},

		// Add a new participant
		push : function() {
			var data = webapp.agenda.data;
			if(this.nameUI.getInputFieldContent() !== "") {
				if(this.emailUI.getInputFieldContent() === ""){
					this.newPopup("Warning");
				}
				data._arrParticipants.push({
					name:this.nameUI.getInputFieldContent(),
					email:this.emailUI.getInputFieldContent()
				});
			} else {
				this.newPopup("Error");
			}

			webapp.agenda.mainWidget.reloadContainer();
		},

		// Open a new popup with a specific type
		newPopup : function(type) {
			var context = this;
			var popupData = {
				strTitle: type,
				strWidgetName: "webapp.agenda.getAgendaParticipantPopup",
				arrPopupButtons: [{
					strButtonLabel:  _("Ok", "ICTouchAPI"),
					callback: function() {
						context.closePopup();
					}
				}]
			};
			this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		},

		// Hide the popup
		closePopup : function() {
			ICTouchAPI.popupServices.removePopup(this.objPopup);
		},

		// Remove every selected participant
		pop : function() {
			var newArrParticipants = [];
			var data = webapp.agenda.data;
			var selectedIndex = [];
			selectedIndex = this.participantListUI.getSelected();
			var j=0;
			for (var i=0; i<data._arrParticipants.length;i++)
			{
				if(selectedIndex[j] === i)
				{
					j++;
				}
				else
				{
					newArrParticipants.push(data._arrParticipants[i]);
				}
			}
			data._arrParticipants = newArrParticipants;
			webapp.agenda.mainWidget.reloadContainer();
		},

		destroy : function () {
			this.participantListUI.destroy();
			this.nameUI.destroy();
			this.emailUI.destroy();
			this.inherited(arguments);
		}
	});