dojo.provide("webapp.agenda.getAgendaEditEventBase");
dojo.declare("webapp.agenda.getAgendaEditEventBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		event : null,

		descriptionUI : null,
		labelUI : null,
		placeUI : null,
		occurenceUI : null,
		volumeUI : null,
		ringUI : null,
		listUI : null,
		boolScroll : true,
		arrTitles : [],
		domTitle : [],
		domContent : [],
		_arrPresentationListEntries	: [],

		constructor : function() {
			this.domTitle = [];
			this.arrTitles = [];
			this.domContent = [];
			this.arrTitles.push({
				strLabel : _("Label", "webapp.agenda"),
				id : "label"
			});
			this.arrTitles.push({
				strLabel : _("Description", "webapp.agenda"),
				id : "description"
			});
			this.arrTitles.push({
				strLabel : _("Place", "webapp.agenda"),
				id : "place"
			});
			this.arrTitles.push({
				strLabel : _("Start Date", "webapp.agenda"),
				id : "startDate"
			});
			this.arrTitles.push({
				strLabel : _("Start Time", "webapp.agenda"),
				id : "startTime"
			});
			this.arrTitles.push({
				strLabel : _("End Date", "webapp.agenda"),
				id : "endDate"
			});
			this.arrTitles.push({
				strLabel : _("End Time", "webapp.agenda"),
				id : "endTime"
			});
			this.arrTitles.push({
				strLabel : _("Occurrence", "webapp.agenda"),
				id : "occurence"
			});
			// Participants may be used in next version
			// this.arrTitles.push({strLabel : "Participants : ", id : "participants"});
			this.arrTitles.push({
				strLabel : _("Alarm", "webapp.agenda"),
				id : "alarm"
			});
			this.arrTitles.push({
				strLabel : _("Volume", "webapp.agenda"),
				id : "volume"
			});
			this.arrTitles.push({
				strLabel : _("Type", "webapp.agenda"),
				id : "alarmType"
			});
			this.arrTitles.push({
				strLabel : _("Time", "webapp.agenda"),
				id : "alarmTime"
			});
			webapp.agenda.uiEditEvent = this;
		},

		postCreate : function() {
			var data = webapp.agenda.data;
			var event = data.objNewEvent;
			var context = this;
			webapp.agenda.data.ringingSourcesValue = null;
			webapp.agenda.data.ringingTimesValue = null;

			this._arrPresentationListEntries = [];
			//Add the label line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[0].strLabel,
				objContent :  new UIElements.InputField.InputFieldControl({
					keyboardType: "alphaNum",
					strInputText: "",
					strInputTitle : this.arrTitles[0].strLabel,
					isMultiLines: false,
					funcCallback: function(strContent) {
						event.label = strContent;
					}
				})
			});

			//Add the Description Line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[1].strLabel,
				objContent :  new UIElements.InputField.InputFieldControl({
					keyboardType: "alphaNum",
					strInputText: "",
					strInputTitle : this.arrTitles[1].strLabel,
					isMultiLines: true,
					intMaxLine	: 2,
					funcCallback: function(strContent) {
						event.description = strContent;
					}
				})
			});

			//Add the place line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[2].strLabel,
				objContent :  new UIElements.InputField.InputFieldControl({
					keyboardType: "alphaNum",
					strInputText: "",
					strInputTitle : this.arrTitles[2].strLabel,
					isMultiLines: false,
					funcCallback: function(strContent) {
						event.place = strContent;
					}
				})
			});

			//Add the start date line
			var dateBegin;
			if(event.beginDate.datetime.day){
				dateBegin = ICTouchAPI.tools.getFormatedDate(
					new Date(event.beginDate.datetime.year,
						event.beginDate.datetime.month - 1,
						event.beginDate.datetime.day),
					data._dateFormat);
			}
			else{
				dateBegin = "----/--/--";
			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[3].strLabel,
				strContent :  dateBegin ,
				callback :  function(){
					context.saveEvent();
					data.setCalendar(data.CALENDAR_TYPE_ADD, data.START);
				}
			});

			//Add the start time line
			var hourBegin;
//			if(typeof(event.beginDate.datetime.hour) == "number" || typeof(event.beginDate.datetime.minute) == "number" ){
				hourBegin = ICTouchAPI.tools.getFormatedTime(event.beginDate.datetime.hour, event.beginDate.datetime.minute, data._24hformat);
//			}
//			else{
//				hourBegin = "--:--";
//			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[4].strLabel,
				strContent :  hourBegin,
				callback :  function(){
					context.saveEvent();
					data.timeSelector(data.START);
				}
			});

			//Add the end date line
			var dateEnd;
			if(event.endDate.datetime.day){
				dateEnd = ICTouchAPI.tools.getFormatedDate(
					new Date(event.endDate.datetime.year,
						event.endDate.datetime.month - 1,
						event.endDate.datetime.day),
					data._dateFormat);
			}
			else{
				dateEnd = "----/--/--";
			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[5].strLabel,
				strContent :  dateEnd ,
				callback :  function(){
					context.saveEvent();
					data.setCalendar(data.CALENDAR_TYPE_ADD, data.END);
				}
			});

			//Add the end time line
			var hourEnd;
			if(event.endDate.datetime.hour || event.endDate.datetime.minute ){
				hourEnd = ICTouchAPI.tools.getFormatedTime(event.endDate.datetime.hour, event.endDate.datetime.minute, data._24hformat);
			}
			else{
				hourEnd = "--:--";
			}
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[6].strLabel,
				strContent :  hourEnd,
				callback :  function(){
					context.saveEvent();
					data.timeSelector(data.END);
				}
			});

			//Add the occurence line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[7].strLabel,
				objContent :  new UIElements.OptionChooser.OptionChooserControl({
					intMaximum : 4,
					intSteps : 1,
					boolShowButton : true,
					arrItems : [_("once","webapp.agenda"), _("daily","webapp.agenda"), _("weekly","webapp.agenda"), _("monthly","webapp.agenda")],
					funcCallback : {
						context:this,
						func:webapp.agenda.occurenceChanged
					},
					intSliderWidth:250
				})
			});

			//Add the alarm line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[8].strLabel,
				objContent :  new UIElements.OptionChooser.OptionChooserControl({
					intMaximum : 2,
					intSteps : 1,
					boolShowButton : true,
					arrItems : [_("Off","ICTouchAPI"),_("On","ICTouchAPI")],
					funcCallback : {
						context:this,
						func:webapp.agenda.alarmStateChanged
					},
					intSliderWidth:180
				})
			});

			//Add the alarm volume line
			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[9].strLabel,
				boolEnabled: false,
				objContent :  new UIElements.Slider.Linear({
					intMinimum: 0,
					intMaximum: 9,
					boolShowTime: false,
					boolSeekable: false,
					intSliderWidth:250
				})
			});


			//Add the alarm type line
			var alarmSrcType = "";

			if(data.arrRingingSources.length===0){
				alarmSrcType = _("No source available", 'webapp.agenda');
			}else{
				var selected = false;
				alarmSrcType = data.arrRingingSources[0].strLabel;
				if(event.alarm) {
					var iMax = data.arrRingingSources.length;
					for(var i=0; i<iMax; i++) {
						if(data.arrRingingSources[i].objSource.id===event.alarm.value.idFile) {
							data.ringingSourcesValue = data.arrRingingSources[i];
							alarmSrcType = data.arrRingingSources[i].strLabel;
							selected = true;
							break;
				}
			}
				}
				if(!selected) {
					data.ringingSourcesValue = data.arrRingingSources[0];
					alarmSrcType = data.ringingSourcesValue.strLabel;
				}
			}

			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[10].strLabel,
				strContent : alarmSrcType,
				boolEnabled: false,
				callback : {
					context:webapp.agenda,
					func:webapp.agenda.getToaster,
					param:"RingingSourceValues"
				}
			});


			//Add the alarm time line
			var _strLabel = "";


			if(event.alarmReminderDelay===0){
				_strLabel=webapp.agenda.data.arrRingingTimes[0].strLabel;
				webapp.agenda.data.ringingTimesValue=0;
				data.ringingTimesValue = data.arrRingingTimes[0];
			}
			else{
				for(var i in webapp.agenda.data.arrRingingTimes)
				{
					if(event.alarmReminderDelay===parseInt(webapp.agenda.data.arrRingingTimes[i].intIndex,10)){
						data.ringingTimesValue = data.arrRingingTimes[i];
						_strLabel=webapp.agenda.data.arrRingingTimes[i].strLabel;
						break;
					}

				}
			}

			this._arrPresentationListEntries.push({
				strLabel: this.arrTitles[11].strLabel,
				strContent: _strLabel,
				boolEnabled: false,
				callback: {
					context:webapp.agenda,
					func:webapp.agenda.getToaster,
					param:"RingingBeforeValues"
				}
			});

			this.fillContent();

			this.listUI = new UIElements.PresentationList.PresentationListControl({
				arrItems: this._arrPresentationListEntries,
				boolShowLabel: true
			}, this.domScroll);

			//Hide the occurence Filed (descoped from R200)
			var domOccurence = this.getUIElement("occurence").domNode.parentNode.parentNode;
			dojo.style(domOccurence, "display", "none");
		},

		fillContent : function() {
			var data = webapp.agenda.data;
			var event = data.objNewEvent;
			if(event.label){
				this._arrPresentationListEntries[0].objContent.setInputFieldContent(event.label);
			}
			if(event.description){
				this._arrPresentationListEntries[1].objContent.setInputFieldContent(event.description);
			}
			if(event.place)
			{
				this._arrPresentationListEntries[2].objContent.setInputFieldContent(event.place);
			}

			this._arrPresentationListEntries[9].objContent.setValue(event.alarm.value.volume);
			this._arrPresentationListEntries[10].callback = {
				context:webapp.agenda,
				func:webapp.agenda.getToaster,
				param:"RingingSourceValues"
			};
			this._arrPresentationListEntries[11].callback = {
				context:webapp.agenda,
				func:webapp.agenda.getToaster,
				param:"RingingBeforeValues"
			};

			if(event.alarmState){
				this._arrPresentationListEntries[8].objContent.attr('intIndex', 1);
				if(webapp.agenda.data.arrRingingSources.length!=0){
					this._arrPresentationListEntries[9].objContent.setSeekable(true);
					this._arrPresentationListEntries[9].boolEnabled = true;
					this._arrPresentationListEntries[10].boolEnabled = true;

				}
				this._arrPresentationListEntries[11].boolEnabled = true;

			}else{
				this._arrPresentationListEntries[8].objContent.attr('intIndex', 0);
				this._arrPresentationListEntries[9].objContent.setSeekable(false);
				this._arrPresentationListEntries[9].boolEnabled = false;
				this._arrPresentationListEntries[10].boolEnabled = false;
				this._arrPresentationListEntries[11].boolEnabled = false;
			}
			var occurenceArr = ["ONE_TIME", "DAILY", "WEEKLY", "MONTHLY"];
			if(event.repetitionPeriod!==undefined) {
				for (var i in occurenceArr) {
					if(event.repetitionPeriod === occurenceArr[i]){
						this._arrPresentationListEntries[7].objContent._setIntIndexAttr(parseInt(i,10));
					}				}
			} else {
				this._arrPresentationListEntries[7].objContent._setIntIndexAttr(0);
			}
		},

		getUIElement : function (element){
			switch(element)
			{
				case "volume" :
					return this._arrPresentationListEntries[9].objContent;
				case "ring" :
					return this._arrPresentationListEntries[8].objContent;
				case "occurence"  :
					return this._arrPresentationListEntries[7].objContent;
				default :
					return null;
			}

		},

		saveEvent : function() {
			var event = webapp.agenda.data.objNewEvent;
			if(this._arrPresentationListEntries[8].objContent.attr('intIndex')){
				event.alarm.value.volume = this._arrPresentationListEntries[9].objContent.getValue();
			}
			event.alarmState = this._arrPresentationListEntries[8].objContent.attr('intIndex');
		},

		destroy : function () {
			this.inherited(arguments);
		}
	});
