dojo.require("webapp.agenda.getAgendaEditEventBase");
dojo.provide("webapp.agenda.getAgendaEditEvent");
dojo.declare("webapp.agenda.getAgendaEditEvent",
	webapp.agenda.getAgendaEditEventBase,
	{
		templatePath	: dojo.moduleUrl("webapp.agenda","templates/getAgendaEditEvent8052.html"),
		intFocus 		: 0,

		postCreate: function() {
			ICTouchAPI.navigationServices.changeFocus(this);
			this.inherited(arguments);
			this.occurenceUI.setSliderWidth(140);
			this.ringUI.setSliderWidth(140);
			this.volumeUI.setSliderWidth(140);

		},

		updateFocus: function() {
			var len = this.domTitle.length;
			if( len < 1 )
				return;
			this.intFocus = Math.max(0, Math.min(len-1, this.intFocus)); // Clamp intFocus value between 0 and list.length-1

			for(var i=0; i<len; ++i)
			{
				var obj = this.domTitle[i];
				dojo.toggleClass(obj, "focus", (i == this.intFocus));
			}
			if(this.intFocus == 0)
				this.descriptionUI.deployKeyboard();
			if(this.intFocus == 1)
				this.placeUI.deployKeyboard();
		},

		_increaseFocus : function() {
			this.intFocus++;
			this.updateFocus();
		},

		_decreaseFocus : function() {
			this.intFocus--;
			this.updateFocus();
		},

		navigate: function(action) {
			switch(action)
			{
				case "UP":
					this._decreaseFocus();
					break;
				case "DOWN":
					this._increaseFocus();
					break;
				case "OK":
					var obj = this.domTitle[this.intFocus];
					var event = {
						currentTarget: obj
					};
					event.currentTarget.id = this.arrTitles[this.intFocus].id;
					this._clicked(event);
					break;
				default :
					switch(this.arrTitles[this.intFocus].id)
					{
						case "occurence" :
							this.occurenceUI.navigate(action);
							break;
						case "alarm" :
							this.ringUI.navigate(action);
							break;
						case "volume" :
							this.volumeUI.navigate(action);
							break;
						default :
							break;
					}
					break;
			}
		}
	});
