/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaCalendarPreviewBase");
dojo.declare("webapp.agenda.getAgendaCalendarPreviewBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objCalendar: null,
		objEventList: null,
		onValueSelectedCallBack: null,
		handler : null,

		postCreate:function(){
			// callback
			this.objCalendar = new UIElements.Calendar.CalendarControl({
				onValueSelectedCallBack	: this.onValueSelectedCallBack,
				arrPlannedEvents		: webapp.agenda.data.getCalendarEvents(),
				strCalendarType			: "small"
			}, this.domAgendaCalendar);

			//get the events of today
			var arrForPreview = webapp.agenda.data.getDayEvents(new Date());

			var func = {
				context:this,
				func:this.loadAppointment
				};

			this.objEventList = new UIElements.MenuList.MenuListControl({
				arrItems: arrForPreview,
				autoSelectFirst : false,
				callback: func
			}, this.domEventList);
			this.handler = dojo.connect(this.objEventList, "onClick", this, this._clicked);


			FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});

		},

		loadAppointment:function(idApp){

			//If the webapp is already loaded
			if (webapp.agenda.objClickableUI){
				webapp.agenda.objClickableUI.selectItemByIndex(idApp, true);
			}
			else{ //Inform to open the item when entering
				webapp.agenda.indexToSelectOnOpen = idApp;
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params:  {}
			});
		},

		getDisplayDate: function() {
			return this.objCalendar.attr("displayMonth");
		},

		destroy: function()	{
			if( this.objCalendar ){
				this.objCalendar.destroy();
			}
			dojo.disconnect(this.handler);
			this.inherited(arguments);
		},

		_clicked:function(event){
			if (dojo.hasClass(event.target, "MenuListContainer")) {
				if(!webapp.agenda.data.boolPreviewSelected)
				{
					webapp.agenda.data.loadVeryNextAppDetails();
	}
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.agenda.getAgenda",
					params:  {}
				});
			}
		}
	}
	);
