/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaCalendarContainerBase");
dojo.declare("webapp.agenda.getAgendaCalendarContainerBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		_objContent : null,
		_objTitle : null,
		container : null,
		clickTitleHandle : null,

		constructor: function() {
			this._arrConnects = [];
			dojo.subscribe("languageChanged",this,this.refreshDate);
		},

		postMixInProperties:function(){
		},

		postCreate:function(){
			this.container = new UIElements.Container.ContainerControl(
			{
				objTitle: {
					strLabel : "Month" ,
					strLeftIcon		: "calendar-left",
					strRightIcon	: "calendar-right"
				},
				objContent: {
					name : "webapp.agenda.getAgendaCalendarPreview",
					params : {
						onValueSelectedCallBack: {
							context:this,
							func:this.onValueSelectedCallBack
						}
					}
				}
			}, this.domAgendaCalendarContainer);

			this.clickTitleHandle = dojo.connect(this.container.getTitle(), "clickTitle", this, this._clicked);

			this._objTitle = this.container.getTitle();
			this._objContent = this.container.getContent();
			this.connect(this._objTitle, "clickLeftIcon", this._decMonth);
			this.connect(this._objTitle, "clickRightIcon", this._incMonth);

			var strMonth = this._objContent.getDisplayDate();
			this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
		},

		onValueSelectedCallBack: function(newDate) {
			if (this._objTitle) {
				var strMonth = this._objContent.getDisplayDate();
				this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
			}

			//Get all the events of the given day
			var events = webapp.agenda.data.getDayEvents(newDate);

			//Empty the MenuList
			this._objContent.objEventList.emptyItems();
			var newItem;
			//For each item
			for (var i=0 ; i<events.length ; i++){
				//Copy it! Not a reference to the one in the other MenuList elements
				newItem = {};
				newItem.intIndex = events[i].intIndex;
				newItem.strPrimaryContent =  events[i].strPrimaryContent;
				newItem.strPrimaryIcon =  events[i].strPrimaryIcon;
				newItem.strSecondaryContent =  events[i].strSecondaryContent;
				newItem.strType =  "normal";

				//Add it to the Preview MenuList
				this._objContent.objEventList.pushItem(newItem,true);
			}


		},

		_decMonth: function() {
			var value = this._objContent.objCalendar.decMonth();
			this.onValueSelectedCallBack(value);
		},

		_incMonth: function() {
			var value = this._objContent.objCalendar.incMonth();
			this.onValueSelectedCallBack(value);
		},

		destroy : function(){
			dojo.disconnect(this.handler);
			this.inherited(arguments);
		},

		_clicked:function(event){
			if(!webapp.agenda.data.boolPreviewSelected)
			{
				webapp.agenda.data.loadVeryNextAppDetails();
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params:  {}
			});
		},

		// Update the title according to the new date
		titleUpdate : function(newDate) {
			if (this._objTitle) {
				var strMonth = newDate.format('MMMM yyyy',dojo.locale);
				this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
			}
		},

		refreshDate : function() {
			var date = this._objContent.objCalendar.getDate();
			this.titleUpdate(date);
			this._objContent.objCalendar.refreshDays();
		}

	}
	);
