/*Webapplication: Agenda - Widget: Preview*/
dojo.provide("webapp.agenda.getAgendaCalendarBase");
dojo.declare("webapp.agenda.getAgendaCalendarBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objCalendar: null,
		_objContent : null,
		_objTitle : null,
		clickLeftIconHandle : null,
		clickRightIconHandle : null,

		constructor: function() {
			this._arrConnects = [];
		},

		postCreate:function(){
            this.subscribe("languageChanged",this.refreshDate);
			var data = webapp.agenda.data;
			var mainWidget = webapp.agenda.mainWidget;

			// Initialize the Title box of the container
			this._objTitle = mainWidget.container.getTitle();
			this._objTitle.attr("strLeftIcon", "calendar-left");
			this._objTitle.attr("strRightIcon", "calendar-right");

			// Create the calendar
			this.objCalendar = new UIElements.Calendar.CalendarControl({
				onValueSelectedCallBack		: {
					context:this,
					func:this.onValueSelectedCallBack
					},
				arrPlannedEvents			: webapp.agenda.data.getCalendarEvents(),
				strCalendarType				: "medium"
			}, this.domAgendaCalendar);

			var date;
			if( data.currentStartEnd === data.START || data.currentStartEnd === data.END )
			{
				// Set the current displayed date to the event value if available
				var datetime;
				if(data.currentStartEnd === data.START) {
					datetime = data.objNewEvent.beginDate.datetime;
				} else {
					datetime = data.objNewEvent.endDate.datetime;
				}
				date = new Date(parseInt(datetime.year, 10), parseInt(datetime.month, 10)-1 /* months in Date object begin by 0 */, parseInt(datetime.day, 10));
			}
			else
			{
				date = new Date();
			}

			this.clickLeftIconHandle = dojo.connect(this._objTitle, "clickLeftIcon", this, this._decMonth);
			this.clickRightIconHandle = dojo.connect(this._objTitle, "clickRightIcon", this, this._incMonth);

			this.objCalendar.selectDate(date);
			this.titleUpdate(date);
		},

		// Decrease month on the calendar and the title
		_decMonth: function() {
			var value = this.objCalendar.decMonth();
			this.titleUpdate(value);
		},

		// Increase month on the calendar and the title
		_incMonth: function() {
			var value = this.objCalendar.incMonth();
			this.titleUpdate(value);
		},

		// Returns the date as a string
		getDisplayDate: function() {
			return this.objCalendar.attr("displayMonth");
		},

		destroy: function()	{
			dojo.disconnect(this.clickLeftIconHandle);
			dojo.disconnect(this.clickRightIconHandle);
			if( this.objCalendar ){
				this.objCalendar.destroy();
			}
			this.inherited(arguments);
		},

		// Callback when we click on a day in the calendar : Update the title and fire the calendar callback defined in the Data
		onValueSelectedCallBack: function(newDate) {
			this.titleUpdate(newDate);
			var callback = webapp.agenda.data.getCalendarCallBack();
			callback.func.call(callback.context, this.objCalendar.getValue());
		},

		// Update the title according to the new date
		titleUpdate : function(newDate) {
			if (this._objTitle) {
				var strMonth = newDate.format('MMMM yyyy',dojo.locale);
				this._objTitle.attr("strLabel", ICTouchAPI.tools.ucfirst(strMonth));
			}
		},

		refreshDate : function() {
			var date = this.objCalendar.getDate();
			this.titleUpdate(date);
			this.objCalendar.refreshDays();
		}
	});
