dojo.provide("webapp.agenda.getAgendaAlarmEditBase");
dojo.declare("webapp.agenda.getAgendaAlarmEditBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		boolScroll  : true,
		source      : null,
		time        : 0,
		sourceUI    : null,
		timesUI     : null,

		SOURCE      : 0,
		TIMES       : 1,

		postCreate : function() {
			this.source = null;
			this.time = 0;
			webapp.agenda.uiAlarm = this;
			var data = webapp.agenda.data;
			var arrSource = data.getRingingSources();
			var arrTime = data.getRingingTimes();
			var i;
			for (i in arrSource){
				arrSource[i].boolSelected = (data.objNewEvent.alarm.value.sourcePath === arrSource[i].objSource.path);
			}
			for (i in arrTime){
				arrTime[i].boolSelected = (data.objNewEvent.alarm.time === arrTime[i].objSource.value);
			}
			// Then create list
			var funcSource = {
				context:this,
				func:this.onClickRingingSource
				};
			var funcTime = {
				context:this,
				func:this.onClickRingingTime
				};
			if (arrSource.length > 0) {
				this.sourceUI = new UIElements.SelectList.SelectListControl({
					arrItems: arrSource,
					boolMultiselect: false,
					itemCallback: funcSource,
					boolScroll: false
				}, this.domAlarmType);
			}
			if (arrTime.length > 0) {
				this.timesUI = new UIElements.SelectList.SelectListControl({
					arrItems: arrTime,
					boolMultiselect: false,
					itemCallback: funcTime,
					boolScroll: false
				}, this.domAlarmTime);
			}
			var params = {
				boolSnap: false
			};
		},

		onClickRingingSource : function(strIndex) {
			var data = webapp.agenda.data;
			var _arr = data.getRingingSources();
			this.source = dojo.clone(_arr[parseInt(strIndex,10)].objSource);
		},

		onClickRingingTime : function(strIndex) {
			var data = webapp.agenda.data;
			var _arr = data.getRingingTimes();
			this.time = ""+_arr[parseInt(strIndex,10)].objSource.value;
		},

		updateAlarm : function() {
			var data = webapp.agenda.data;
			if(this.source) {
				data.objNewEvent.alarm.value.sourcePath = this.source.path;
				data.objNewEvent.alarm.value.sourceType = this.source.type;
			}
			if(this.time){
				data.objNewEvent.alarm.time = ""+this.time;
			}
		},

		destroy : function () {
			// Destroy the scroll
			if(this.sourceUI){
				this.sourceUI.destroy();
			}
			if(this.timesUI){
				this.sourceUI.destroy();
			}
			this.inherited(arguments);
		}
	});