dojo.require("webapp.agenda.getAgendaBase");
dojo.provide("webapp.agenda.getAgenda");
dojo.declare("webapp.agenda.getAgenda",
	webapp.agenda.getAgendaBase,
	{
		templatePath: dojo.moduleUrl("webapp.agenda","templates/getAgenda8082.html"),
		cssFile : ['icons.css', 'main8082.css'],

		postCreate:function(){
			var arrEventList = webapp.agenda.data.getList();
			// function on click to get details
			var func = {
				context:webapp.agenda.data,
				func:webapp.agenda.data.loadDetails
				};
			var data = webapp.agenda.data;
			var am = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: arrEventList,
						callback: func
					}
				},

				container : {
					name    : "UIElements.PresentationList.PresentationListControl",
					autoSelectFirst : false,
					params  : {
						arrItems : webapp.agenda.data.getDetails(),
						boolShowLabel: true
					}
				},
				objContainerTitle : {
					strLabel : data.getContainerTitle()
					},
				objMenuTitle : {
					strLabel : data.getAgendaListTitle()
					}
			},this.mainPart);
			this.container = am.getContainer();
			this.menu = am.getMenu();
			webapp.agenda.mainWidget = this;
			webapp.agenda.agendaList = am.getMenu();
			webapp.agenda.objClickableUI = am.getMenu().getContent();
			data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Homepage","webapp.agenda"));

			//If an item has to be open when entering the webapp (open using preview events)
			if (webapp.agenda.indexToSelectOnOpen){
				webapp.agenda.objClickableUI.selectItemByIndex(webapp.agenda.indexToSelectOnOpen, true);
				webapp.agenda.indexToSelectOnOpen = null;
			}
		},

		reloadMenu: function() {
			var data = webapp.agenda.data;
			var arrEventList = webapp.agenda.data.getList();
			// function on click to get details
			var func = {
				context:webapp.agenda.data,
				func:webapp.agenda.data.loadDetails
				};
			this.menu.reload({
				objTitle: {
					strLabel : data.getAgendaListTitle()
					},
				objContent: {
					name: "UIElements.MenuList.MenuListControl",
					params: {
						arrItems: arrEventList,
						callback: func
					}
				}
			});
			webapp.agenda.objClickableUI = this.menu.getContent();
		},

		reloadContainer: function(params) {
			var data = webapp.agenda.data;
			var tmpParams = params?params:{};
			if(this.container)
				this.container.reload({
					objTitle: {
						strLeftIcon : null,
						strLabel : data.getContainerTitle(),
						strRightIcon : null
					},
					objContent: {
						name: data.getContainerPath(),
						params: tmpParams
					}
				});
		}
	}
	);
