dojo.provide("webapp.agenda.dataBase");

dojo.declare("webapp.agenda.dataBase", null, {
	_arrAppButtons          : [],
	_arrSysButtons          : [],
	_arrEventList           : [],
	_arrEventListDetails    : [],
	_arrEventListPreview    : [],
	_arrCalendarPlannedEvents: [],


	_strContainerPath       : "webapp.agenda.getAgendaDetails", //default details
	_strTitle               : "", // default nothing

	_agendaListTitle        : "",
	_intTodayPositionInList : null,

	_dateFormat             : "",
	_24hformat              : false, // 12 \ 24
	AGENDA_STOP             : true,
	AGENDA_REPEAT           : true,

	_arrParticipants        : [],

	arrRingingSources       : [],
	arrRingingTimes         : [],
	ringingTimesValue       : null,
	ringingSourcesValue     : null,
	objCurrentEvent         : null,
	objNewEvent             : null,
	boolIsAlarming			: false,
	intNbPlannedEventNotified : 0,
	boolPreviewSelected		: false,
	currentSelectedItem     : null,
	objBackPopup			: null,

	// For the Dashboard container in MR mode
	nbOfEvents				: 0,

	// Attribute that define which period do we select with the Calendar
	currentStartEnd         : 3,
	START                   : 1, // Selecting start of period
	END                     : 2, // End of period
	NONE                    : 3, // Load current date

	currentEventStatus      : 0,
	NEW_EVENT_MODIFY        : 1,
	NEW_EVENT_ADD           : 2,

	currentCalendarType     : null,
	CALENDAR_TYPE_GOTODAY   : 1,
	CALENDAR_TYPE_ADD       : 2,

	// Capabilities
	AGENDA_ADD              : true,
	AGENDA_MODIFY           : true,
	AGENDA_PARTICIPANTS     : false,

	ENABLE                  : true,
	DISABLE                 : false,

	// const Button
	BACK                    : "BACK_BTN",
	BACK_TO_TODAY           : "BACK_TO_TODAY_BTN",
	GO_TO_DAY               : "GOTO_DAY_BTN",
	DELETE                  : "DELETE_BTN",
	MODIFY                  : "MODIFY_BTN",
	ADD                     : "ADD_BTN",
	SAVE                    : "SAVE_BTN",
	SEARCH                  : "SEARCH_BTN",
	REMOVE                  : "REMOVE_BTN",
	STOP_BTN                : "STOP_BTN",
	REPEAT_BTN              : "REPEAT_BTN",
	SNOOZE_BTN              : "SNOOZE_BTN",
	CLOSE_BTN               : "CLOSE_BTN",
	YES_BTN                 : "YES_BTN",
	NO_BTN                  : "NO_BTN",

	// const Status
	STATUS_HOME             : 0,
	STATUS_DETAILS			: 1,
	STATUS_EDIT				: 2,
	STATUS_DATE				: 3,
	STATUS_TIME				: 4,
	STATUS_ALARM			: 5,
	STATUS_PARTICIPANTS		: 6,
	NB_STATUS				: 7,

	// const types of Events
	TYPE_ALL                : 0,
	TYPE_APPOINTMENT        : "APPOINTMENT",
	TYPE_WAKEUP             : "WAKEUP",
	// const occurences
	OCCUR_ONE_TIME          : 0,
	OCCUR_DAILY             : 1,
	OCCUR_WEEKLY            : 2,
	OCCUR_MONTHLY           : 3,


	// LEDS and LEDS STATUS
	LED_AGENDA : 7,

	LED_STATUS_OFF : 0,
	LED_STATUS_ON  : 1,

	constructor : function(){
		// definition of buttons
		var func = {
			context:webapp.agenda,
			func:webapp.agenda.buttonCallback
		};

		var arrButtons = [];
		arrButtons.push({
			strButtonName: this.GO_TO_DAY,
			strButtonLabel: _('Go to', 'webapp.agenda'),
			strButtonIcon: 'agenda-goto-day',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.BACK_TO_TODAY,
			strButtonLabel: _('Today', 'webapp.agenda'),
			strButtonIcon: 'agenda-today',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.ADD,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'agenda-add-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			capabilities: [{
				module : "Agenda",
				capability:"EventCreation"
			}]
		});
		this._arrAppButtons[this.STATUS_HOME] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.DELETE,
			strButtonLabel:  _('Delete', 'ICTouchAPI'),
			strButtonIcon: 'agenda-delete-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.MODIFY,
			strButtonLabel: _('Modify', 'ICTouchAPI'),
			strButtonIcon: 'agenda-edit-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			capabilities: [{
				module : "Agenda",
				capability:"EventModification"
			}]
		});
		arrButtons.push({
			strButtonName: this.GO_TO_DAY,
			strButtonLabel: _('Go to', 'webapp.agenda'),
			strButtonIcon: 'agenda-goto-day',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.BACK_TO_TODAY,
			strButtonLabel: _('Today', 'webapp.agenda'),
			strButtonIcon: 'agenda-today',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.ADD,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'agenda-add-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			capabilities: [{
				module : "Agenda",
				capability:"EventCreation"
			}]
		});
		this._arrAppButtons[this.STATUS_DETAILS] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.SAVE,
			strButtonLabel:  _('Save', 'ICTouchAPI'),
			strButtonIcon: 'agenda-save-modified-event',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		this._arrAppButtons[this.STATUS_EDIT] = arrButtons;

		arrButtons = [];
		this._arrAppButtons[this.STATUS_DATE] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.VALIDATE,
			strButtonLabel:  _('Save', 'ICTouchAPI'),
			strButtonIcon: 'agenda-accept',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		this._arrAppButtons[this.STATUS_ALARM] = arrButtons;

		arrButtons = [];
		arrButtons.push({
			strButtonName: this.VALIDATE,
			strButtonLabel:  _('Save', 'ICTouchAPI'),
			strButtonIcon: 'agenda-accept',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.SEARCH,
			strButtonLabel:  _('Search', 'ICTouchAPI'),
			strButtonIcon: 'app-64px-search',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.ADD,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'app-64px-add',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		arrButtons.push({
			strButtonName: this.REMOVE,
			strButtonLabel: _('Delete', 'ICTouchAPI'),
			strButtonIcon: 'app-64px-remove',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		});
		this._arrAppButtons[this.STATUS_PARTICIPANTS] = arrButtons;
		this._agendaListTitle= _("Planning", "webapp.agenda");

		for (var j = 0; j < this.NB_STATUS; j++) {
			var appBar = ICTouchAPI.AppBarServices.getAppBar("agenda", "agendastatus" + j);
			for (var k in this._arrAppButtons[j]) {
				var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[j][k]);
				appBar.addActionButton(objButton);
			}
		}

		// load settings and list
		this.loadAll();
	},

	loadAll : function() {
		// before list, load setting
		this._getSettings();
	},

	// gets the settings for the app
	_getSettings : function(){
		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			// save the setting
			if (objSetting !== null){
				this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			}
			// get another setting
			ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
				// save the setting
				if(value !== null){
					this._24hformat = value;
				}
				this.loadList();
			});
		});
		this.loadRingingSources();
		ICTouchAPI.settingServices.getSetting("RingingBeforeValues",this, this.loadedRingingTimes);
	},

	loadList : function() {
		// get events type appointment
		ICTouchAPI.APIServices.Agenda.findPlannedEventByType({
			params:[this.TYPE_APPOINTMENT],
			context:this,
			callback:this.loadedList
		});
	},

	loadedList : function(_arr) {
		// fill _arrEventList

		this._arrEventList = [];
		this._arrEventListPreview = [];
		this._arrCalendarPlannedEvents = [];

		var arrTemp = []; // temporary table for sorting

		// first sorting of the elements, by day and ducplicate them
		// if they cross days
		var dateBegin;
		for (var i = 0; i < _arr.length; i++)
		{
			// dates from the object plannedEvent (no time just date)
			// Warning : javascript months starts at 0 (january..)
			dateBegin = new Date(_arr[i].beginDate.datetime.year, _arr[i].beginDate.datetime.month - 1, _arr[i].beginDate.datetime.day);
			var dateEnd   = null;
			_arr[i].boolEnd = false;
			_arr[i].boolStart = true;
			if(_arr[i].endDate !== null)
			{
				dateEnd = new Date(_arr[i].endDate.datetime.year, _arr[i].endDate.datetime.month - 1, _arr[i].endDate.datetime.day);
				//timeEnd is equal to 000 if hour minute and second are null and the day is not conciderated as a real day
				var timeEnd = _arr[i].endDate.datetime.hour+_arr[i].endDate.datetime.minute+_arr[i].endDate.datetime.second;
				// When we display the event, show something different if the event doesn't end the same day
				_arr[i].boolEnd = ( dojo.date.compare(dateBegin, dateEnd, "date") === 0 );
			}

			// key date for the array format : day-month-year
			var strBeginDateKey = dateBegin.format('yyyy-MM-dd',dojo.locale);

			if(!arrTemp.hasOwnProperty(strBeginDateKey)) {
				// the key does not exist, create it
				arrTemp[strBeginDateKey] = [];
			}

			// add the event to the day
			arrTemp[strBeginDateKey].push(dojo.clone(_arr[i]));


			if(dateEnd !== null && (dateEnd !== dateBegin) && timeEnd != "000") {
				/**
				 * For every event that span over multiple days we need to duplicate it
				 * because we have an array for each day
				 */


				// dateTemp is the iterator that will start the day after the origin until the end
				var dateTemp = dateBegin;

				// we add a day to the iterator & compute the diff
				dateTemp = dojo.date.add(dateTemp, "day", 1);
				var dateDiff = dojo.date.compare(dateTemp, dateEnd, "date");
				while(dateDiff <= 0)
				{
					_arr[i].boolEnd = ( dateDiff === 0);
					_arr[i].boolStart = false;
					// format the key for the table
					var strKey = dateTemp.format('yyyy-MM-dd',dojo.locale);

					if(!arrTemp.hasOwnProperty(strKey)) {
						// If the key does not exist, create it
						arrTemp[strKey] = [];
					}
					// add the event to the curent day
					arrTemp[strKey].push(dojo.clone(_arr[i]));

					// we add a day to the iterator & compute the diff
					dateTemp = dojo.date.add(dateTemp, "day", 1);
					dateDiff = dojo.date.compare(dateTemp, dateEnd, "date");
				}
			}
		}

		// we must sort the temporary list by date
		// We have to sort the Keys of this array
		var keys = [];
		for(var k in arrTemp)
		{
			if(arrTemp.hasOwnProperty(k))
			{
				keys.push(k);
			}
		}
		// sorting key by ascending order
		keys.sort(function (a, b) {
			//return (b > a) - (b < a); //descending
			return (b < a) - (b > a); //ascending
		});


		// populate the array for the clickable list
		this._arrEventList = [];

		var dateNow   = new Date();
		var boolToday = false; // default not today
		// filling
		// through the keys of the table
		for (var j = 0; j < keys.length; j++)
		{
			var key = keys[j];

			if(arrTemp.hasOwnProperty(key))
			{
				// gets date from the key year-month-day
				var arrDate = key.split('-');
				dateBegin = new Date(arrDate[0], arrDate[1]-1, arrDate[2]);
				// add title to the day
				if(dojo.date.compare(dateBegin, dateNow,"date") === 0)
				{
					// Today !
					this._arrEventList.push({
						strPrimaryContent: _("TODAY", "webapp.agenda"),
						strType: "title",
						date : dateBegin // private property for our data
					});
					boolToday = true;
					// save the position of the Today Title in the List
					this._intTodayPositionInList = this._arrEventList.length;

					// We add a title, so we have events to push to
					// the table for the calendar
					//var planned = {}; planned.date = dateBegin;
					//this._arrCalendarPlannedEvents.push(planned);
					var strKeyDate = dateBegin.format('yyyy-MM-dd',dojo.locale);

					this._arrCalendarPlannedEvents[strKeyDate] = true;
				}
				else
				{
					this._arrEventList.push({
						strPrimaryContent: _(ICTouchAPI.tools.getFormatedDate(dateBegin,this._dateFormat), "webapp.agenda"),
						strType: "title",
						date : dateBegin // private property for our data
					});
					boolToday = false;

					var strDateKey = dateBegin.format('yyyy-MM-dd',dojo.locale);

					this._arrCalendarPlannedEvents[strDateKey] = true;
				}

				// sort the elements added previously  by time increase sort
				arrTemp[key].sort(function(a,b) {
					// a and b are two planned events
					// test hours
					if(a.beginDate.datetime.hour > b.beginDate.datetime.hour){
						return 1;
					}
					else if(a.beginDate.datetime.hour < b.beginDate.datetime.hour){
						return -1;
					}
					else //hours =, to test minutes
					{
						if(a.beginDate.datetime.hour > b.beginDate.datetime.hour){
							return 1;
						}
						else if(a.beginDate.datetime.hour < b.beginDate.datetime.hour){
							return -1;
						}
						else{
							return 0;
						}
					}
				});

				// through the table add plannedEvents
				for(var keyTemp in arrTemp[key])
				{
					var obj = arrTemp[key][keyTemp]; // an event
					var strTime = this._formatTime(obj);

					// add planned event to the list
					this._arrEventList.push({
						strPrimaryIcon : (obj.alarmState) ? 'clock' : '',
						strSecondaryContent : strTime,
						strPrimaryContent: obj.label,
						strType: "normal",
						intIndex: obj.id,
						date : dateBegin // private property for our data
					});

					// add planned event to the preview List
					if(boolToday)
					{
						this._arrEventListPreview.push({
							strRightIcon : (obj.alarmState) ? 'clock' : '',
							strPrimaryIcon : (obj.alarmState) ? 'clock' : '',
							strSecondaryContent : strTime,
							strPrimaryContent: obj.label,
							strType: "normal",
							intIndex: obj.id
						});
					}
				}
			}
		}
		this.nbOfEvents = this._arrEventListPreview.length;

		// refresh Lists
		if( webapp.agenda.mainWidget ){
			webapp.agenda.mainWidget.reloadMenu();
		}
		if( webapp.agenda.previewContainer ){
			webapp.agenda.previewContainer.refresh();
		}
		if( webapp.agenda.previewCalendarContainer){
			webapp.agenda.previewCalendarContainer.refresh();
		}
	},

	/**
	 * Format time according to objEvent
	 * if boolStart is defined then it's the first day of the event
	 * if boolEnd is defined then it's the last day
	 * both can be true if it's a one day event
	 * both can be false if it's the middle of the event
	 */
	_formatTime : function(objEvent) {
		// time print format hours:minutes-hours:minutes
		var strTimeStart = ICTouchAPI.tools.getFormatedTime(objEvent.beginDate.datetime.hour, objEvent.beginDate.datetime.minute, this._24hformat);
		if(!objEvent.endDate)
		{
			// We can't have more then one day if we don't have any end date
			return strTimeStart;
		}
		var strTimeEnd = ICTouchAPI.tools.getFormatedTime(objEvent.endDate.datetime.hour, objEvent.endDate.datetime.minute, this._24hformat);
		if( objEvent.boolStart && objEvent.boolEnd )
		{
			return strTimeStart + '-' + strTimeEnd;
		}
		else if( !objEvent.boolStart && objEvent.boolEnd )
		{
			return _(["Ending",strTimeEnd], "webapp.agenda");
		}
		else if( objEvent.boolStart && !objEvent.boolEnd )
		{
			return _(["Starting",strTimeStart], "webapp.agenda");
		}
		else
		{
			return _("Whole day", "webapp.agenda");
		}
	},

	loadDetails : function (plannedEventId) {
		if(plannedEventId!=-1){
			// get a planned event by Id
			ICTouchAPI.APIServices.Agenda.getAppointmentById({
				params:[plannedEventId],
				context:this,
				callback:this.loadedDetails
			}) ;
		//this.currentEvent = plannedEventId;
		}else{
			this.loadInformativeDisplay("The maximum number of appointments has been reached", "Warning", "error");
		}
	},



	loadVeryNextAppDetails : function() {
		//Search the very next appointment
		if(this._arrEventList && this._arrEventList.length > 1){

			ICTouchAPI.APIServices.Agenda.findPlannedEventByType({
				params:[this.TYPE_APPOINTMENT],
				context:this,
				callback:function(_arrApp){
					if(!this.boolPreviewSelected){
						var dateNow = new Date();
						var milli = dateNow.getTime();
						var minMilli = milli;
						var idVeryNext;
						for(var i in _arrApp){
							var dTemp = _arrApp[i].beginDate.datetime;
							var _cBeginDate = new Date(dTemp.year, dTemp.month - 1, dTemp.day, dTemp.hour, dTemp.minute);
							var	_cMilli = _cBeginDate.getTime();
							var _cEcart = _cMilli - milli;
							if( _cEcart > 0 && _cEcart < minMilli){
								minMilli = _cEcart;
								idVeryNext = _arrApp[i].id;
							}
						}
						if(webapp.agenda.objClickableUI && idVeryNext!==null){
							webapp.agenda.objClickableUI.selectItemByIndex(idVeryNext, true);
						//webapp.agenda.data.loadDetails(idVeryNext);
						}
					}
				}
			});
		}
	},

	loadedDetails : function (objPlannedEvent) {
		this.objCurrentEvent = objPlannedEvent;
		// fill details
		this._arrEventListDetails = [];

		if(objPlannedEvent !== null)
		{
			// description
			this._arrEventListDetails.push({
				strLabel: _(["Description", ":"], "webapp.agenda"),
				strContent: objPlannedEvent.description ? objPlannedEvent.description : ""
			});
			// place
			this._arrEventListDetails.push({
				strLabel: _(["Place", ":"], "webapp.agenda"),
				strContent: objPlannedEvent.place ? objPlannedEvent.place : ""
			});
			// dates
			var dateBegin = new Date(objPlannedEvent.beginDate.datetime.year, objPlannedEvent.beginDate.datetime.month - 1, objPlannedEvent.beginDate.datetime.day);
			var dateEnd   = null;
			if(objPlannedEvent.endDate !== null){
				dateEnd = new Date(objPlannedEvent.endDate.datetime.year, objPlannedEvent.endDate.datetime.month - 1, objPlannedEvent.endDate.datetime.day);
			}
			this._arrEventListDetails.push({
				strLabel: _(["Start Date", ":"], "webapp.agenda") ,
				strContent: ICTouchAPI.tools.getFormatedDate(dateBegin,this._dateFormat)
			});
			this._arrEventListDetails.push({
				strLabel: _(["Start Time", ":"], "webapp.agenda"),
				strContent: ICTouchAPI.tools.getFormatedTime(objPlannedEvent.beginDate.datetime.hour, objPlannedEvent.beginDate.datetime.minute, this._24hformat)
			});
			if(dateEnd !== null) {
				this._arrEventListDetails.push({
					strLabel:  _(["End Date", ":"], "webapp.agenda") ,
					strContent: ICTouchAPI.tools.getFormatedDate(dateEnd,this._dateFormat)
				});
				this._arrEventListDetails.push({
					strLabel:  _(["End Time", ":"], "webapp.agenda"),
					strContent: ICTouchAPI.tools.getFormatedTime(objPlannedEvent.endDate.datetime.hour, objPlannedEvent.endDate.datetime.minute, this._24hformat)
				});
			}
			// occurence
			/*this._arrEventListDetails.push({
				strLabel:  _(["Occurrence", ":"], "webapp.agenda"),
				strContent: objPlannedEvent.repetitionPeriod ? objPlannedEvent.repetitionPeriod : ""
			});*/
			// alarm
			this._arrEventListDetails.push({
				strLabel:  _(["Ringing alarm", ":"], "webapp.agenda"),
				strContent: (objPlannedEvent.alarmState)? _("On", "ICTouchAPI") : _("Off", "ICTouchAPI")
			});

			if(objPlannedEvent.alarmState && objPlannedEvent.alarm!=null && objPlannedEvent.alarm.value && objPlannedEvent.alarm.value.idFile!=null) {
				var ringName = _("None", "webapp.agenda");
				var iMax = this.arrRingingSources.length;
				for(var i=0; i<iMax; i++) {
					if(this.arrRingingSources[i].objSource.id===objPlannedEvent.alarm.value.idFile) {
						ringName = this.arrRingingSources[i].strLabel;
						break;
					}
				}
				this._arrEventListDetails.push({
					strLabel:  _(["Alarm source", ":"], "webapp.agenda") ,
					strContent: ringName
				});

			}else{
				this._arrEventListDetails.push({
					strLabel:  _(["Alarm source", ":"], "webapp.agenda"),
					strContent: _("None", "webapp.agenda")
				});
			}
			if(objPlannedEvent.alarmReminderDelay===0){
				this._arrEventListDetails.push({
					strLabel: _(["Alarm time", ":"], "webapp.agenda"),
					strContent: webapp.agenda.data.arrRingingTimes[0].strLabel
				});
			}else{
				for(var i in webapp.agenda.data.arrRingingTimes)
				{
					if(objPlannedEvent.alarmReminderDelay===parseInt(webapp.agenda.data.arrRingingTimes[i].intIndex,10)){
						this._arrEventListDetails.push({
							strLabel: _(["Alarm time", ":"], "webapp.agenda") ,
							strContent: webapp.agenda.data.arrRingingTimes[i].strLabel
						});
						break;
					}

				}
			}
		}
		// set details view
		this.boolPreviewSelected = false;
		this.switchContainer("getAgendaDetails", this.STATUS_DETAILS, _("Appointment Details", "webapp.agenda"));
	},

	// Function called when we create a new event
	newEvent: function(button) {
		this.currentEventStatus = button;
		if(this.currentEventStatus === this.NEW_EVENT_ADD) {
			webapp.agenda.objClickableUI.deselect();
			this.objNewEvent = {};
		} else if (this.currentEventStatus === this.NEW_EVENT_MODIFY){
			this.objNewEvent = dojo.clone(this.objCurrentEvent);
		}
		var dateTime = new Date();
		if(!this.objNewEvent.id){
			this.objNewEvent.id = -1;
		}
		if(!this.objNewEvent.classType){
			this.objNewEvent.classType = "APPOINTMENT";
		}
		if(!this.objNewEvent.beginDate){
			this.objNewEvent.beginDate = {
				datetime:{
					day : dateTime.getDate(),
					month : dateTime.getMonth() + 1,
					year : dateTime.getFullYear(),
					minute : dateTime.getMinutes(),
					hour : dateTime.getHours()
				}
			};
		}
		if(!this.objNewEvent.alarmReminderDelay){
			this.objNewEvent.alarmReminderDelay = 0;
		}
		dateTime.setHours(dateTime.getHours() + 1);
		if(!this.objNewEvent.endDate){
			this.objNewEvent.endDate = {
				datetime:{
					day : dateTime.getDate(),
					month : dateTime.getMonth() + 1,
					year : dateTime.getFullYear(),
					minute : dateTime.getMinutes(),
					hour : dateTime.getHours()
				}
			};
		}
		if(!this.objNewEvent.repetitionPeriod){
			this.objNewEvent.repetitionPeriod = "ONE_TIME";
		}
		//ICTouchAPI.settingServices.getSettingValue("RingingBeforeValues", this, this.loadedRingingTimes);
		if (!this.objNewEvent.alarm) {
			this.objNewEvent.alarm = {
				type: "Alarm",
				value: {
					id: -1,
					idFile: -1,
					idCapabilities: -1,
					volume: 5
				}
			};
		}
		if (this.objNewEvent.description === null) {
			this.objNewEvent.description = "";
		}

		if (this.objNewEvent.place === null) {
			this.objNewEvent.place = "";
		}
		// set editEvent view
		this.switchContainer("getAgendaEditEvent", this.STATUS_EDIT, _("Event Edit","webapp.agenda"));
	},

	loadRingingSources : function() {
		ICTouchAPI.APIServices.FileManager.getFilesInPool({
			params:[ICTouchAPI.tools.POOL_AM,0,50],
			context:this,
			callback:this.loadedRingingSources
		});
	},

	loadedRingingSources : function(_arr) {
		this.arrRingingSources = [];
		for (var i in _arr) {
			this.arrRingingSources.push({
				intIndex: i,
				strLabel: _(_arr[i].name,"webapp.settings"),
				strActionIcon : "filesmanager-play",
				objSource: _arr[i]
			});
		}
	},

	loadedRingingTimes : function(objSetting) {
		this.arrRingingTimes = [];
		for (var i in objSetting.allowedValues) {
			this.arrRingingTimes.push({
				intIndex: objSetting.allowedValues[i].id,
				strLabel: _(objSetting.allowedValues[i].name,"webapp.settings")
			});
		}
	},

	getRingingTimes : function(){
		return this.arrRingingTimes;
	},

	getRingingSources : function(){
		return this.arrRingingSources;
	},

	refreshDetails : function () {
		// set details view
		this._strContainerPath = "webapp.agenda.getAgendaDetails";
		this.intStatus = this.STATUS_DETAILS;
		// refresh
		webapp.agenda.updateActionBar();
		webapp.agenda.container.refresh();
	},

	// go to Today in clickable List
	goToToday : function() {
		// we know were is the element Today (saved at loaded List)
		// if it is set we go to today !
		if(this._intTodayPositionInList) {
			// position selectList at that element
			webapp.agenda.objClickableUI.selectItemByPosition(this._intTodayPositionInList, true);
		} else {
			webapp.agenda.mainWidget.reloadMenu();
		}
	},

	timeSelector : function(startEnd) {
		// startEnd say if it's start or end field that we want to edit
		this.currentStartEnd = startEnd;
		// set timeEdit view
		this.switchContainer("getAgendaTimeEdit", this.STATUS_TIME, _("Time Event Edit","webapp.agenda"));
	},

	participantsSelector : function(){
		// set participantEdit view
		this.switchContainer("getAgendaParticipantEdit", this.STATUS_PARTICIPANTS, _("Participant Event Edit","webapp.agenda"));
	},

	// init the calendar
	// @param <CONST> calendarType (Type are add or gotoday)
	setCalendar : function (calendarType, startEnd) {
		this.currentCalendarType = calendarType;
		if(startEnd){
			this.currentStartEnd = startEnd;
		}
		// set calendar view
		this.switchContainer("getAgendaCalendar", this.STATUS_DATE, _("Date Event Edit","webapp.agenda"), true);
	},

	// return the callback called after a click on a date
	// on the calendar UIElement
	getCalendarCallBack : function () {
		switch(this.currentCalendarType) {
			case this.CALENDAR_TYPE_GOTODAY:
				return {
					context:webapp.agenda,
					func:webapp.agenda.data.goToDay
				};
			case this.CALENDAR_TYPE_ADD:
				return {
					context:webapp.agenda.data,
					func:webapp.agenda.data.setDate
				};
			default:
				return function() {};
		}
	},

	// Set the date after clicking on it
	setDate: function(dateFromCalendar) {
		var currentDate ;
		var otherDate ;
		// Store the date to modify
		if(this.currentStartEnd===this.START){
			currentDate = this.objNewEvent.beginDate.datetime;
			otherDate = this.objNewEvent.endDate.datetime;
			var oldDate = new Date(currentDate.year,currentDate.month-1,currentDate.day);
		}
		if(this.currentStartEnd===this.END){
			currentDate = this.objNewEvent.endDate.datetime;
		}

		var dateString = dojo.date.stamp.toISOString(dateFromCalendar);

		currentDate.day = dateString.substring(8,10);
		currentDate.month = dateString.substring(5,7);
		currentDate.year = dateString.substring(0,4);

		//If end date is lower than begin date, change end date
		if(otherDate && (this.currentEventStatus === this.NEW_EVENT_ADD)
				&& this.compareDateOfEvent(this.objNewEvent)===-1){
			var newDate = new Date(currentDate.year,currentDate.month-1,currentDate.day);
			var delta = dojo.date.difference(oldDate, newDate, "day");
			oldDate = new Date(otherDate.year,otherDate.month-1,otherDate.day);
			newDate = dojo.date.add(oldDate, "day", delta);
			dateString = dojo.date.stamp.toISOString(newDate);
			otherDate.day = dateString.substring(8,10);
			otherDate.month = dateString.substring(5,7);
			otherDate.year = dateString.substring(0,4);
			//If end date is stilllower than begin date, end date = start date
			if(this.compareDateOfEvent(this.objNewEvent)===-1) {
				otherDate.day = currentDate.day;
				otherDate.month = currentDate.month;
				otherDate.year = currentDate.year;
				otherDate.hour = currentDate.hour;
				otherDate.minute = currentDate.minute;
		}
		}

		// set editEvent view
		this.switchContainer("getAgendaEditEvent", this.STATUS_EDIT, _("Event Edit","webapp.agenda"));
	},

	// set a new content for the container of the agenda and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle) {
		if(pageName !== "") {
			this._strContainerPath = "webapp.agenda."+pageName;
		}
		if(pageTitle) {
			this._strTitle = pageTitle;
		}
		if(webapp.agenda.mainWidget) {
			this.updateAppBar(status);
			webapp.agenda.mainWidget.reloadContainer();
		}
	},

	// set the action bar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.agenda.currentStatus = status;

		// button callback
		var backFunc = {
			context:webapp.agenda,
			func:webapp.agenda.buttonCallback,
			param:this.BACK
		};
		ICTouchAPI.AppBarServices.addExitButton("agenda","agendastatus"+status,this.isPreviousHome(), backFunc);

		ICTouchAPI.AppBarServices.setAppBar("agenda", "agendastatus"+status, "getAgenda");
	},

	// return the array of obj width date for the calendar
	getCalendarEvents : function() {
		return this._arrCalendarPlannedEvents;
	},

	// scroll the menuList UIElement to the day (selected
	// via the calendar or) passed in parameter
	// @param <date> dateFromCalendar
	goToDay : function (dateFromCalendar) {
		// search the position of this date in the itemList
		var position = 0;
		var arrEventList = this.data._arrEventList;
		for(var i=arrEventList.length-1;i>=0;i--)
		{
			// we're searching only in title element
			if(arrEventList[i].strType === "title")
			{
				// check next title item
				if(dojo.date.compare(arrEventList[i].date, dateFromCalendar,"date") === 1)
				{
					continue;
				}
				// we find our item
				else if(dojo.date.compare(arrEventList[i].date, dateFromCalendar,"date") === 0)
				{
					position = i+1;
					break;
				}
			}
		}

		// go to this position if we found it
		if(position) {
			webapp.agenda.objClickableUI.selectItemByPosition(position,true);
		}
	},

	deleteEvent: function() {
		var eventId = this.objCurrentEvent.id;
		this.objNewEvent = null;
		ICTouchAPI.APIServices.Agenda.removePlannedEvent({
			params:["APPOINTMENT", eventId],
			context:this,
			callback:function() {}
		}) ;
		this._arrEventListDetails = [];
		webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_HOME, _("Appointment Details", "webapp.agenda"));

	},

	// Open a new popup with a specific type
	deletePopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Confirm deletion","webapp.agenda"),
			strType: "warning",
			strContent: _("Are you sure you want to delete ?","webapp.agenda"),
			arrPopupButtons: [{
				strButtonName: this.YES_BTN,
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				strButtonIcon: "generic-ok",
				callback: function() {
					context.deleteEvent();
					context.closeDeletePopup();
				}
			},{
				strButtonName: this.NO_BTN,
				strButtonLabel:  _("No", 'ICTouchAPI'),
				strButtonIcon: "generic-cancel",
				callback: function() {
					context.closeDeletePopup();
				}
			}]
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},
	// Open a new popup with a specific type
	loadInformativeDisplay : function(infoText, title, type) {
		var context = this;
		var buttons = [];
		buttons.push({
			strButtonLabel:  _("Ok", 'ICTouchAPI'),
			callback: function() {
				context.closeDeletePopup();
				return "ok";
			}
		});
		if (type === "warning"){
			buttons.push({
				strButtonLabel:  _("Cancel", 'ICTouchAPI'),
				callback: function() {
					context.closeDeletePopup();

					return "cancel";
				}
			});
		}
		var popupData = {
			strTitle: _(title,"webapp.agenda"),
			strType: type,
			strContent: _(infoText,"webapp.agenda"),
			arrPopupButtons: buttons
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	loadBackPopUp:function(){
		if(!this.objBackPopup){
			var context = this;
			var popupData = {
				strTitle: _("Save changes","webapp.agenda"),
				strType: "warning",
				strContent: _("Save the changes before exiting ?","webapp.agenda"),
				arrPopupButtons: [{
					strButtonName: this.YES_BTN,
					strButtonLabel:  _("Yes", 'ICTouchAPI'),
					strButtonIcon: "generic-ok",
					callback: function() {
						context.closeBackPopup();
						context.objBackPopup = null;
						webapp.agenda.TrySaveEvent();
					}
				},{
					strButtonName: this.NO_BTN,
					strButtonLabel:  _("No", 'ICTouchAPI'),
					strButtonIcon: "generic-cancel",
					callback: function() {
						context.closeBackPopup();
						context.objBackPopup = null;
						webapp.agenda.data._goBackToHomeAgenda();
					}
				}]
			};
			this.objBackPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		}
	},



	_goBackToHomeAgenda : function(){
		if(this.objCurrentEvent){
			this.switchContainer("getAgendaDetails", this.STATUS_DETAILS, "Calendar: Event details");
		}
		else{
			this.switchContainer("getAgendaDetails", this.STATUS_HOME, "Calendar: Homepage");
		}
	},

	// Hide the popup
	closeDeletePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.objPopup);
	},

	closeBackPopup : function(){
		ICTouchAPI.popupServices.removePopup(this.objBackPopup);
	},
	getAppBarAppButtons : function(){
		return this._arrAppButtons[webapp.agenda.currentStatus];
	},

	getAppBarSysButtons : function(){
		return this._arrSysButtons;
	},

	getContainerTitle : function() {
		return this._strTitle;
	},

	getContainerPath : function(){
		return this._strContainerPath;
	},

	getList : function() {
		return this._arrEventList;
	},

	getDayEvents : function(date){
		var dayEvents = [];
		for (var i=0; i<this._arrEventList.length; i++){
			if(this._arrEventList[i].strType === "normal" && dojo.date.compare(this._arrEventList[i].date, date,"date") === 0){
				dayEvents.push(this._arrEventList[i]);
			}
		}
		return dayEvents;
	},

	getListPreview : function() {
		return this._arrEventListPreview;
	},

	getDetails : function(){
		return this._arrEventListDetails;
	},

	getAgendaListTitle : function(){
		return this._agendaListTitle;
	},

	isPreviousHome : function() {
		if(this._strContainerPath === "webapp.agenda.getAgendaDetails") {
			return true;
		}
		else {
			return false;
		}
	},

	is24HourFormat : function() {
		return this._24hformat;
	},

	//Compare Date of 1 event
	//Return 0 if begin date is equal to end date, -1 if begin begin date is higher to end date, 1 if begin date is lower to end date
	compareDateOfEvent : function(objEvent) {
		var objBeginDate = objEvent.beginDate.datetime;
		var objEndDate = objEvent.endDate.datetime;
		var beginDate = new Date(objBeginDate.year, objBeginDate.month, objBeginDate.day, (objBeginDate.hour), parseInt(objBeginDate.minute), 0);
		var endDate = new Date(objEndDate.year, objEndDate.month, objEndDate.day, parseInt(objEndDate.hour), parseInt(objEndDate.minute), 0);
		return(dojo.date.compare(endDate, beginDate));
	}


});
