dojo.provide("webapp.agenda.controlBase");
dojo.declare("webapp.agenda.controlBase",[ICTouchAPI.webApplication],
{
	currentStatus: 0,
	objAppBar: null,
	uiParticipants: null,
	uiEditEvent: null,
	uiTime: null,
	uiAlarm: null,
	toasterUI: null,
	objEventPopup : null,
	objFunctionPopup : null,
	indexToSelectOnOpen : null,
	_isPreviewPlaying : false,
	popupAlarm : [],

	constructor: function()
	{
//		ICTouchAPI.tools.registerHomepageButton(["webapp.agenda.getAgenda", "AGENDA_BTN", "agenda-application", _('Calendar',"webapp.agenda")]);
//		ICTouchAPI.tools.registerHomepageKey(["webapp.agenda.getAgenda", "AGENDA_BTN", "agenda-application", _('Calendar',"webapp.agenda")]);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getAgendaCalendarContainer","webapp.agenda");
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getAgendaPreview","webapp.agenda");
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp.wakeup","webapp.filesmanager",true,false,true,false);

		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AlarmStarted", this.notifyAlarmStarted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AlarmStopped",this.notifyAlarmStopped);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AgendaContentChanged", this.onAgendaContentChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "PlannedEventNotification", this.updateAgendaNotification);

		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_COMM", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_DIAL", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_USER", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", this.eventOtherPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_EVENT", this.eventPhysicalKeyEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "dayChanged",this.onDayChanged);
		dojo.subscribe("dayChanged", this, this.onDayChanged);
		dojo.subscribe("ReloadPool",this,function() {
			this.data.loadRingingSources();
		});

		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "New_Appointment",
			strNotificationLabel: _("New Appointment", "webapp.agenda"),
			intNotificationValue: 0,
			callback: {
				context:"webapp.agenda",
				func:this.onNotifyNewAppointment
			}
		});
		//listening the enable preview setting
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableAgendaPreview", this._registerHomePageContainer);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableAgendaCalendarPreview", this._registerHomePageCalendarContainer);
		//registering or not hte webapp on initialization
		this.loadEnablePreview();
	},

	//ENABLE PREVIEW
	//loading the enable preview setting
	loadEnablePreview:function(){
		ICTouchAPI.settingServices.getSetting("EnableAgendaPreview", this, this._registerHomePageContainer);
		ICTouchAPI.settingServices.getSetting("EnableAgendaCalendarPreview", this, this._registerHomePageCalendarContainer);
	},
	//registering or unregistering the preview
	_registerHomePageCalendarContainer : function(objSetting){

		if (objSetting){
			if(objSetting.jsValue === true){
				//the calendar preview is only for 8082 targets
				try{
					//calendar preview
					ICTouchAPI.tools.registerHomepageContainer(["webapp.agenda.getAgendaCalendarContainer", this]);
				}catch(err){
					console.error("agenda._registerHomePageContainer called for a 8082 instruction");
				}
			}else{
				try{
					ICTouchAPI.tools.unregisterHomepageContainer(["webapp.agenda.getAgendaCalendarContainer"]);
				}catch(err){
					console.error("agenda._registerHomePageContainer called for a 8082 instruction");
				}
			}
		}
	},

	_registerHomePageContainer : function(objSetting){
		if (objSetting ){
			if(objSetting.jsValue === true){
				ICTouchAPI.tools.registerHomepageContainer(["webapp.agenda.getAgendaPreview", this]);
			}
			else{
				ICTouchAPI.tools.unregisterHomepageContainer(["webapp.agenda.getAgendaPreview"]);
			}
		}
	},
	//END OF ENABLE PREVIEW

	load : function ()
	{
		//help
		var widgetsTab = [];
		var i;
		for(var i=0; i<webapp.agenda.data.NB_STATUS; i++) {
			widgetsTab.push("agendastatus"+i);
		}
		dojo.publish("needHelpEvent",["agenda",widgetsTab]);
		ICTouchAPI.settingServices.subscribeToSetting(this, "RingingBeforeValues", this.data.loadedRingingTimes);
	},

	onDateFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			this.data.loadList();
		}
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data._24hformat = objSetting.jsValue;
			this.data.loadList();
		}
	},

	/**
    * Agenda Content changed.
	*/
	onAgendaContentChanged:function() {
		webapp.agenda.data.loadList();
		this.data._arrEventListDetails = [];
		webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_HOME, _("Appointment Details", "webapp.agenda"));
	},

	/**
	 * Clicked on the topBar Notification
	 */
	onNotifyNewAppointment: function (){
		// we have to reset counter
		webapp.agenda.data.intNbPlannedEventNotified = 0;
		// update the notification element
		ICTouchAPI.notificationServices.setNotificationValue("New_Appointment", 0);
		//manage the LED
		ICTouchAPI.ledServices.desactivate('event', 'ON');
		// Load details of the last notified appointment
		if (webapp.agenda.data.lastNotifiedEventId){
			webapp.agenda.data.loadDetails(webapp.agenda.data.lastNotifiedEventId);
			if(webapp.agenda.objClickableUI) {
				// Update the selected item in the menu list so that it corresponds to the displayed event
				webapp.agenda.objClickableUI.selectItemByIndex(webapp.agenda.data.lastNotifiedEventId,false);
			} else {
				webapp.agenda.indexToSelectOnOpen = webapp.agenda.data.lastNotifiedEventId;
			}
		}
		// show Agenda Webapp
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.agenda.getAgenda",
			params: {}
		});

	},

	eventOtherPhysicalKeyEvent : function() {
		var lstPopup = this.popupAlarm;
		for(var i in lstPopup){
			this.closeAlarmPopup(webapp.agenda, webapp.agenda.stopAlarm, lstPopup[i],lstPopup[i]);
		}
	},

	eventPhysicalKeyEvent : function() {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			// show webapp agenda
			var lstPopup = this.popupAlarm;
			for(var i in lstPopup){
				this.closeAlarmPopup(webapp.agenda, webapp.agenda.stopAlarm, lstPopup[i],lstPopup[i]);
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.agenda.getAgenda",
				params: {}
			});
		}
	},

	/**
	 * Notified a planned event will arrived in XX delay time (set by setting)
	 */
	updateAgendaNotification:function(args){
		//Store the id of the notified event
		webapp.agenda.data.lastNotifiedEventId = args.value.id;
		//Increment the counter of notified events
		webapp.agenda.data.intNbPlannedEventNotified++;
		//manage the LED
		ICTouchAPI.ledServices.activate('event', 'ON');
		//Update the notification bar
		ICTouchAPI.notificationServices.incNotification("New_Appointment");
	},


	notifyAlarmStarted : function(objEvent) {
		objEvent = objEvent.value;
		var data = webapp.agenda.data;
		ICTouchAPI.ledServices.activate('event', 'ON');
		// check if it is an event of type wakeup
		if(objEvent.classType === "APPOINTMENT")
		{
			// flag to alarming status
			//data.boolIsAlarming = true;

			if(objEvent.alarm.value.idCapabilities !== undefined){
				ICTouchAPI.CapabilityServices.getOnceCapabilities("Agenda",objEvent,objEvent.alarm.value.idCapabilities,this, this.displayPopup);
			}


		}
	},

	displayPopup : function(arrCapabilities,objEvent){
		// popup
		var objDate = new Date(0, 0, 0, objEvent.beginDate.datetime.hour, objEvent.beginDate.datetime.minute, 0);
		var strContent = (objEvent.label || _("Appointment","webapp.agenda")) + " - " + ICTouchAPI.tools.getFormatedTime(objDate.getHours(), objDate.getMinutes(), this.data.is24HourFormat());
		var buttonNb = 0;
		var arrButtons = [];
		var popupAlarm = {
			strTitle: _("Appointment alarm", "webapp.agenda"),
			strType: "info",
			strContent: strContent,
			id: objEvent.alarm.value.id
		};
		this.popupAlarm.push(popupAlarm.id);
		if(arrCapabilities && arrCapabilities.Stop && arrCapabilities.Repeat)
		{
			if(arrCapabilities.Stop.state===ICTouchAPI.CapabilityServices.AVAILABLE){
				arrButtons[buttonNb++] = {
					strButtonName : this.data.STOP_BTN,
					strButtonLabel: _('Stop','webapp.agenda'),
					callback : function(){
						webapp.agenda.closeAlarmPopup(webapp.agenda, webapp.agenda.stopAlarm, objEvent.alarm.value.id, popupAlarm.id);
					}
				};
				this.objFunctionPopup = webapp.agenda.stopAlarm;
				this.objEventPopup = objEvent;
			}
			if(arrCapabilities.Repeat.state===ICTouchAPI.CapabilityServices.AVAILABLE) {
				arrButtons[buttonNb++] = {
					strButtonName : this.data.REPEAT_BTN,
					strButtonLabel: _('Repeat','webapp.agenda'),
					callback : function(){
						webapp.agenda.closeAlarmPopup(webapp.agenda, webapp.agenda.repeatAlarm, objEvent, popupAlarm.id);
					}
				};
				this.objFunctionPopup = webapp.agenda.repeatAlarm;
				this.objEventPopup = objEvent;
			}
		}
		popupAlarm.arrPopupButtons = arrButtons;
		if(buttonNb === 0) {
			popupAlarm.arrPopupButtons[0] = {
				strButtonName : this.data.CLOSE_BTN,
				strButtonLabel:  _('Close','webapp.agenda'),
				callback : function(){
					webapp.agenda.closeAlarmPopup(webapp.agenda,null,null,popupAlarm.id);
				}
			};
			this.objFunctionPopup = null;
			this.objEventPopup = null;
		}
		ICTouchAPI.popupServices.addNewPopup(popupAlarm, "MIDDLE");

	},

	getToaster : function(lstChoice) {
		var toasterTitle;
		var ui = null;
		var currentId;
		var i;

		//Time before ringing
		if(lstChoice === "RingingBeforeValues"){
			toasterTitle = this.uiEditEvent.arrTitles[11].strLabel;
			if(this.data.arrRingingTimes.length>0) {
				//Select current value
				currentId = parseInt(this.data.ringingTimesValue.intIndex);
				for (i in this.data.arrRingingTimes) {
					if(parseInt(this.data.arrRingingTimes[i].intIndex) === currentId) {
						this.data.arrRingingTimes[i].boolSelected = true;
					}
					else {
						this.data.arrRingingTimes[i].boolSelected = false;
					}
				}
			}
			//Instentiate time menu
			ui = new UIElements.SelectList.SelectListControl(
			{
				arrItems: webapp.agenda.data.arrRingingTimes,
				_arrSelectedItemsIndex: [0]
			});
		}
		//Audio files ringing
		else{
			toasterTitle = this.uiEditEvent.arrTitles[10].strLabel;
			if(this.data.arrRingingSources.length>0) {
				//Select current value
				currentId = this.data.ringingSourcesValue.objSource.id;
				for (i in this.data.arrRingingSources) {
					if(this.data.arrRingingSources[i].objSource.id === currentId) {
						this.data.arrRingingSources[i].boolSelected = true;
					}
					else {
						this.data.arrRingingSources[i].boolSelected = false;
					}
				}
			}
			//Instentiate ring menu
			ui = new UIElements.SelectList.SelectListControl(
			{
				arrItems: webapp.agenda.data.arrRingingSources,
				buttonCallback : dojo.hitch(webapp.agenda, webapp.agenda.previewMelody),
				_arrSelectedItemsIndex: [0]
			});
		}

		this.toasterUI = ICTouchAPI.toasterServices.showDialogBox(ui, {
			strTitle: toasterTitle,
			funcOk: {
				context:this,
				func:this.getToasterValidated,
				param:lstChoice
			},
			funcCancel: {
				context:this,
				func:this.getToasterCanceled
			}
		});


	},

	getToasterValidated : function(lstChoice){
		var uiSetting = this.toasterUI.getContent();
		if(lstChoice==="RingingBeforeValues"){
			this.data.ringingTimesValue = uiSetting.arrItems[uiSetting.getSelected()[0]];
			this.uiEditEvent._arrPresentationListEntries[11].strContent = webapp.agenda.data.ringingTimesValue.strLabel;
			this.uiEditEvent.listUI.setItemTextContent(11, webapp.agenda.data.ringingTimesValue.strLabel);
			this.data.objNewEvent.alarmReminderDelay = parseInt(webapp.agenda.data.ringingTimesValue.intIndex,10);
		}else{
			if (this._isPreviewPlaying){
				ICTouchAPI.APIServices.IctMPInterface.stopPreview({});
				this._isPreviewPlaying = false;
			}
			this.data.ringingSourcesValue = uiSetting.arrItems[uiSetting.getSelected()[0]];
			this.uiEditEvent._arrPresentationListEntries[10].strContent = webapp.agenda.data.ringingSourcesValue.strLabel;
			this.uiEditEvent.listUI.setItemTextContent(10, webapp.agenda.data.ringingSourcesValue.strLabel);
			this.data.objNewEvent.alarm.value.idFile = this.data.ringingSourcesValue.objSource.id;
		}
		//webapp.agenda.uiEditEvent.refresh();
		this.getToasterCanceled();
	},

	getToasterCanceled: function () {
		if (this._isPreviewPlaying){
			ICTouchAPI.APIServices.IctMPInterface.stopPreview({});
			this._isPreviewPlaying = false;
		}
		ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
        //this.toasterUI.destroy();
		delete this.toasterUI;
	},

	alarmStateChanged : function() {
		if(webapp.agenda.uiEditEvent._arrPresentationListEntries[8].objContent.attr('intIndex')===0){
			webapp.agenda.uiEditEvent._arrPresentationListEntries[9].boolEnabled = false;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(9, true);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[9].objContent.setValue(0);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[9].objContent.setSeekable(false);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[10].boolEnabled = false;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(10, true);
			webapp.agenda.uiEditEvent._arrPresentationListEntries[11].boolEnabled = false;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(11, true);
			webapp.agenda.data.objNewEvent.alarmState=false;
		}else{
			if(webapp.agenda.data.arrRingingSources.length!==0){
				webapp.agenda.uiEditEvent._arrPresentationListEntries[9].boolEnabled = true;
				webapp.agenda.uiEditEvent._arrPresentationListEntries[10].boolEnabled = true;
				webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(9, false);
				webapp.agenda.uiEditEvent._arrPresentationListEntries[9].objContent.setSeekable(true);
				webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(10, false);
			}
			webapp.agenda.uiEditEvent._arrPresentationListEntries[11].boolEnabled = true;
			webapp.agenda.uiEditEvent.listUI.toggleDisabledMode(11, false);

			webapp.agenda.data.objNewEvent.alarmState=true;
		}
	},

	onDayChanged : function(){
		var dateNow = new Date();
		var arr = this.data.getList();
		var tabElem;
		for (var i=0; i<arr.length;i++){
			if (typeof (arr[i].intIndex) == "undefined"){ //If the selectItem in MenuList is not an Appointment (no appointment id)
				tabElem = arr[i];
				if(dojo.date.compare(tabElem.date, dateNow,"date") == 0){ //It is the today list ?
					tabElem.strPrimaryContent = "TODAY";
					this.data._intTodayPositionInList = i; //update int, for the "backToToday" Functionnality
				}
				else{
					tabElem.strPrimaryContent = ICTouchAPI.tools.getFormatedDate(tabElem.date,this.data._dateFormat);
				}
				//Update display if already created
				if (this.objClickableUI){
					this.objClickableUI.updatePrimaryContent(i,tabElem.strPrimaryContent);
				}
				//refresh preview list
			}
		}
		this.data._arrEventListPreview = [];
		var iMax = this.data._arrEventList.length;
		for(i=0; i<iMax; i++) {
			var obj = this.data._arrEventList[i]; // an event
			if(obj.strType==="normal" && dojo.date.compare(obj.date, dateNow,"date") === 0) {
				this.data._arrEventListPreview.push({
					strRightIcon : obj.strPrimaryIcon,
					//strLeftIcon : 'presence-24-offline',
					//strTime:"10:12",
					strPrimaryIcon : obj.strPrimaryIcon,
					strSecondaryContent : obj.strSecondaryContent,
					strPrimaryContent: obj.strPrimaryContent,
					strType: "normal",
					intIndex: obj.intIndex
				});
			}
		}
		//Update preview if already created
		if( this.previewContainer ){
			this.previewContainer.refresh();
		}
		if( this.previewCalendarContainer){
			this.previewCalendarContainer.refresh();
		}
	},

	occurenceChanged : function() {
		var occurenceArr = ["ONE_TIME", "DAILY", "WEEKLY", "MONTHLY"];
		webapp.agenda.data.objNewEvent.repetitionPeriod = occurenceArr[webapp.agenda.uiEditEvent._arrPresentationListEntries[7].objContent.attr('intIndex')];
		//webapp.agenda.uiEditEvent.refresh();
	},

	closeAlarmPopup : function(context, callback, callbackParams, poupupId) {
		// flag in not alarming status
		//this.data.boolIsAlarming = false;
		var lstPopup = ICTouchAPI.popupServices.getPopupsByPriority(1);
		var _popup = null;
		var j;
		for(var i in lstPopup){
			if(lstPopup[i].id!==undefined && lstPopup[i].id!==null){
				if(lstPopup[i].id==poupupId){
					_popup=lstPopup[i];
					for(j=0 ; j <  this.popupAlarm.length ; j++){
						if(this.popupAlarm[j]!==undefined && this.popupAlarm[j]!==null){
							if(this.popupAlarm[j]==poupupId){
								console.error("SPLICE : " + poupupId);
								this.popupAlarm.splice(j,1);
								break;
							}
						}
					}
					break;
				}
			}
		}

		this.objEventPopup = null;
		this.objFunctionPopup = null;

		//if(context.popupAlarm !== null)
		if(_popup !== null)
		{
			ICTouchAPI.popupServices.removePopupByID(_popup);
			//context.popupAlarm = null;
		}
		if (callback){
			callback(callbackParams);
		}
		ICTouchAPI.ledServices.desactivate('event', 'ON');
	},

	notifyAlarmStopped : function(objEvent) {
		//cr 287773 : Reload the list to refresh alarm status
        this.data.loadList();
		objEvent = objEvent.value;
		// check if it is an event of type appointment
		if(objEvent.classType === "APPOINTMENT")
		{
			// remove popup
			this.closeAlarmPopup(this,null,null,objEvent.alarm.value.id);
		}
	},

	stopAlarm:function(id) {
		// call core
		ICTouchAPI.APIServices.Agenda.stopAlarm({
			params:[id],
			context:this
		});
	},

	repeatAlarm:function(objEvent) {
		// call core
		ICTouchAPI.APIServices.Agenda.repeatAlarm({
			params:[objEvent.alarm.value.id],
			context:this
		});
	},

	getAgendaParticipantsAvailability : function() {
		var data = webapp.agenda.data;
		var status = ICTouchAPI.CapabilityServices.getCapability("Agenda","AgendaParticipants");
		if (status === ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.AGENDA_PARTICIPANTS = data.ENABLE;
		} else {
			data.AGENDA_PARTICIPANTS = data.DISABLE;
		}
	},

	previewMelody : function(intIndex) {
		var url = this.data.getRingingSources()[intIndex].objSource.url;
		ICTouchAPI.APIServices.IctMPInterface.preview({params: [url]});
		this._isPreviewPlaying = true;
	}

});
