dojo.require("webapp.agenda.controlBase");
dojo.provide("webapp.agenda");
dojo.declare("webapp.agenda",webapp.agenda.controlBase,{

	_boolChangeScreen : false,

	buttonCallback : function(buttonId) {
		var data = webapp.agenda.data;
		switch(buttonId)
		{
			// The back button load the last container
			case data.BACK:
				switch(data._strContainerPath)
				{
					case "webapp.agenda.getAgendaDetails" :
						dojo.publish("OpenHomepage");
						break;
					case "webapp.agenda.getAgendaEditEvent" :
						data.loadBackPopUp();
						break;
					case "webapp.agenda.getAgendaCalendar" :
						if(data.currentCalendarType === data.CALENDAR_TYPE_GOTODAY){
							if(data.objCurrentEvent){
								data.switchContainer("getAgendaDetails", data.STATUS_DETAILS, _("Calendar: Event details","webapp.agenda"));
							}
							else{
								data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Homepage","webapp.agenda"));
							}
						}
						else{
							data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						}
						break;
					case  "webapp.agenda.getAgendaAlarmEdit" :
						data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					// Participants may be used in next version
					// case "webapp.agenda.getAgendaParticipantEdit" :
					// data._arrParticipants = data.objNewEvent.participant;
					// data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event Edition","webapp.agenda"));
					// break;
					case "webapp.agenda.getAgendaTimeEdit" :
						this.saveTime();
						data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					default :
						data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Event details","webapp.agenda"));
						break;
				}
				break;
			case data.BACK_TO_TODAY:
				this.data.goToToday();
				break;
			case data.GO_TO_DAY:
				this.data.setCalendar(data.CALENDAR_TYPE_GOTODAY, this.data.NONE);
				break;
			case data.DELETE:
				this.data.deletePopup();
				break;
			case data.MODIFY:
				this.data.newEvent(data.NEW_EVENT_MODIFY);
				break;
			case data.ADD:
				if(data._strContainerPath === "webapp.agenda.getAgendaDetails") {
					this.data.newEvent(data.NEW_EVENT_ADD);
				} else if(data._strContainerPath === "webapp.agenda.getAgendaParticipantEdit") {
					this.uiParticipants.push();
				}
				break;
			case data.SAVE:
				this.TrySaveEvent();
				break;
			case data.VALIDATE:
				if(data._strContainerPath === "webapp.agenda.getAgendaAlarmEdit") {
					this.uiAlarm.updateAlarm();
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
				} else if(data._strContainerPath === "webapp.agenda.getAgendaParticipantEdit") {
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
						}
				break;
			case data.SEARCH:
				break;
			case data.REMOVE:
				if(data._strContainerPath === "webapp.agenda.getAgendaParticipantEdit") {
					this.uiParticipants.pop();
				}
				break;
			default:

				break;
		}
	},

	unlock : function(WebappName){

		console.log("unlock webapp agenda");
		var path = this.data.getContainerPath();
		if(path == "webapp.agenda.getAgendaEditEvent" ||
			path == "webapp.agenda.getAgendaTimeEdit" ||
			path == "webapp.agenda.getAgendaCalendar"){
			var context = this;
			if(!this.data.objBackPopup){
				//popup
				var popupData = {
					strTitle: _("Save changes","webapp.agenda"),
					strType: "warning",
					strContent: _("Save the changes before exiting ?","webapp.agenda"),
					arrPopupButtons: [
						{
						strButtonName: context.data.YES_BTN,
						strButtonLabel:  _("Yes", 'ICTouchAPI'),
						strButtonIcon: "generic-ok",
						callback: function() {
							context.data.closeBackPopup();
							context.data.objBackPopup = null;
							if(context.data._strContainerPath === "webapp.agenda.getAgendaTimeEdit") {
									this.saveTime();
							}
							//webapp.agenda.data._goBackToHomeAgenda();
							context.TrySaveEvent();
							delete context;
							dojo.publish("unlockTransition",[context._boolChangeScreen]);
							}
						},
						{
						strButtonName: context.data.NO_BTN,
						strButtonLabel:  _("No", 'ICTouchAPI'),
						strButtonIcon: "generic-cancel",
						callback: function() {
							context.data.closeBackPopup();
							context.data._goBackToHomeAgenda();
							context.data.objBackPopup = null;
							delete context;
							dojo.publish("unlockTransition",[true]);
						}
						}
					]
				};

			}
				var currentScreenSaver = webapp.screensaver.data.getCurrentScreensaverScreen();
				if(WebappName == currentScreenSaver){
					dojo.publish("unlockTransition",[true]);
				}else{
				context.data.objBackPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
				}
			//save
		}else{
			dojo.publish("unlockTransition",[true]);
		}
	},

	saveTime : function(){
		var time = this.uiTime.getTime();
		var data = this.data;
		if(data.currentStartEnd === data.START){
			var objBeginDate = data.objNewEvent.beginDate.datetime;
			var objEndDate = data.objNewEvent.endDate.datetime;
			var delta = (time.hour - objBeginDate.hour)*60 + (time.minute - objBeginDate.minute);
			var base = parseInt(objEndDate.hour) * 60 + parseInt(objEndDate.minute);
			objBeginDate.minute = "" + time.minute;
			objBeginDate.hour = "" + time.hour;
			//Shift end time if edit new event and if end date(include time) is lower thand start date(include time)
			if(data.currentEventStatus === data.NEW_EVENT_ADD) {
				var finale = Math.min(base + delta,(24*60)-1);
				finale = Math.max(finale,0);
				if(data.compareDateOfEvent(data.objNewEvent)===-1) {
					objEndDate.minute = "" + finale % 60;
					objEndDate.hour = "" + ((finale - finale % 60) / 60) % 24;
					//if end date(include time) is still lower thand start date(include time), value of end time is start time
					if(data.compareDateOfEvent(data.objNewEvent)===-1) {
						objEndDate.minute = objBeginDate.minute;
						objEndDate.hour = objBeginDate.hour;
					}
				}
			}
		} else if(data.currentStartEnd === data.END) {
			data.objNewEvent.endDate.datetime.minute = "" + time.minute;
			data.objNewEvent.endDate.datetime.hour = "" + time.hour;
		}
	},

	TrySaveEvent : function(){
		this._boolChangeScreen = false;
		webapp.agenda.data.objNewEvent.alarmState = this.uiEditEvent.getUIElement("ring").attr('intIndex')===1?true:false;
		var _millisec = null;
		if(webapp.agenda.data.objNewEvent.alarmState){

			webapp.agenda.data.objNewEvent.alarm.value.volume = this.uiEditEvent.getUIElement("volume").getValue();
			if(webapp.agenda.data.objNewEvent.alarmState){
				var _date = webapp.agenda.data.objNewEvent.beginDate.datetime;
				var _bdate = new Date(_date.year, _date.month - 1, _date.day, _date.hour, _date.minute);
				_millisec = _bdate.getTime();
				_millisec = _millisec - (parseInt(webapp.agenda.data.objNewEvent.alarmReminderDelay,10)*60000);
			}

			if(webapp.agenda.data.ringingSourcesValue!==null){
				webapp.agenda.data.objNewEvent.alarm.value.idFile = webapp.agenda.data.ringingSourcesValue.objSource.id;
			}
		}else{
			webapp.agenda.data.objNewEvent.alarm.value.volume = 0;
		}
		var bTemp = webapp.agenda.data.objNewEvent.beginDate.datetime;
		var eTemp = webapp.agenda.data.objNewEvent.endDate.datetime;
		var beginDate = new Date(bTemp.year, bTemp.month - 1, bTemp.day, bTemp.hour, bTemp.minute);
		var endDate = new Date(eTemp.year, eTemp.month - 1, eTemp.day, eTemp.hour, eTemp.minute);
		if (webapp.agenda.data.objNewEvent.label !== "" && webapp.agenda.data.objNewEvent.label)
		{
			if (endDate > beginDate)
			{
				if (endDate >= Date.now())
				{
					if(_millisec===null || (_millisec!==null && _millisec >= Date.now() ))
					{
						if(webapp.agenda.data.currentEventStatus === webapp.agenda.data.NEW_EVENT_ADD)
						{
							this._boolChangeScreen = true;
							ICTouchAPI.APIServices.Agenda.addPlannedAppointment({
								params:[webapp.agenda.data.objNewEvent],
								context:this,
								callback:function(id){
									webapp.agenda.data.loadDetails(id);
								}
							});
							webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_DETAILS);
						}
						else if(webapp.agenda.data.currentEventStatus === webapp.agenda.data.NEW_EVENT_MODIFY)
						{//if this as a modification of an already existing event, refresh the details about it
							this._boolChangeScreen = true;
							ICTouchAPI.APIServices.Agenda.modifyPlannedAppointment({
								params:[webapp.agenda.data.objNewEvent],
								context:this
							}) ;
							webapp.agenda.data.loadDetails(webapp.agenda.data.objNewEvent.id);
							webapp.agenda.data.switchContainer("getAgendaDetails", webapp.agenda.data.STATUS_DETAILS);
						}
					}else{
						webapp.agenda.data.loadInformativeDisplay("Alarm date is set in the past!", "Warning", "warning");
					}
				}
				else
				{
					webapp.agenda.data.loadInformativeDisplay("Event is set in the past!", "Warning", "warning");
				}
			}
			else
			{
				webapp.agenda.data.loadInformativeDisplay("End Date is lower than the Begin Date of the Appointment", "Error occured in new Appointment", "error");
			}
		}
		else
		{
			webapp.agenda.data.loadInformativeDisplay("Please complete the Label of your new event", "Warning", "error");
		}
	},

	load : function ()
	{
		this.inherited(arguments);
	},

	setHomepageContainer : function (strWebapp,  div) {
		if(strWebapp==="webapp.agenda.getAgendaCalendarContainer"){
			webapp.agenda.previewCalendarContainer = new webapp.agenda.getAgendaCalendarContainer({}, div);
		}else if(strWebapp==="webapp.agenda.getAgendaPreview"){
			webapp.agenda.previewContainer = new webapp.agenda.getAgendaPreview({}, div);
		}
	}
});

webapp.agenda=new webapp.agenda();
