dojo.require("webapp.agenda.controlBase");
dojo.provide("webapp.agenda");
dojo.declare("webapp.agenda",webapp.agenda.controlBase,
{

	buttonCallback : function(buttonId) {
		var data = webapp.agenda.data;
		switch(buttonId)
		{
			// The back button load the last container
			case data.BACK:
				switch(data._strContainerPath)
				{
					case "webapp.agenda.getAgendaList" :
						dojo.publish("OpenHomepage");
						break;
					case "webapp.agenda.getAgendaDetails" :
						data.switchContainer("getAgendaList", data.STATUS_DETAILS, _("Calendar: Homepage","webapp.agenda"));
						break;
					case "webapp.agenda.getAgendaEditEvent" :
						if(data.objCurrentEvent)
							data.switchContainer("getAgendaDetails", data.STATUS_DETAILS, _("Calendar: Event details","webapp.agenda"));
						else
							data.switchContainer("getAgendaList", data.STATUS_HOME, _("Calendar: Homepage","webapp.agenda"));
						break;
					case "webapp.agenda.getAgendaCalendar" :
						if(data.currentCalendarType == data.CALENDAR_TYPE_GOTODAY)
							if(data.objCurrentEvent)
								data.switchContainer("getAgendaDetails", data.STATUS_DETAILS, _("Calendar: Event details","webapp.agenda"));
							else
								data.switchContainer("getAgendaList", data.STATUS_HOME, _("Calendar: Homepage","webapp.agenda"));
						else
							data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					case  "webapp.agenda.getAgendaAlarmEdit" :
						data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					// Participants may be used in next version
					// case "webapp.agenda.getAgendaParticipantEdit" :
					// data._arrParticipants = data.objNewEvent.participant;
					// data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _(Calendar: Event edition","webapp.agenda"));
					// break;
					case "webapp.agenda.getAgendaTimeEdit" :
						data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, _("Calendar: Event edition","webapp.agenda"));
						break;
					default :
						data.switchContainer("getAgendaDetails", data.STATUS_HOME, _("Calendar: Event details","webapp.agenda"));
						break;
				}
				break;
			case data.BACK_TO_TODAY:
				this.data.goToToday();
				break;
			case data.GO_TO_DAY:
				this.data.setCalendar(data.CALENDAR_TYPE_GOTODAY, this.data.NONE);
				break;
			case data.DELETE:
				this.data.deletePopup();
				break;
			case data.MODIFY:
				this.data.newEvent(data.NEW_EVENT_MODIFY);
				break;
			case data.ADD:
				if(data._strContainerPath == "webapp.agenda.getAgendaDetails" || data._strContainerPath == "webapp.agenda.getAgendaList") {
					this.data.newEvent(data.NEW_EVENT_ADD);
				} else if(data._strContainerPath == "webapp.agenda.getAgendaParticipantEdit") {
					this.uiParticipants.push();
				}
				break;
			case data.SAVE:
				data.objNewEvent.alarm.value.volume = this.uiEditEvent.volumeUI.getValue();
				data.objNewEvent.alarmState = this.uiEditEvent.ringUI.getSelected()=="on"?true:false;
				data.objNewEvent.occurence = this.uiEditEvent.occurenceUI.getSelected();
				break;
			case data.VALIDATE:
				if(data._strContainerPath == "webapp.agenda.getAgendaAlarmEdit") {
					this.uiAlarm.updateAlarm();
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
				} else if(data._strContainerPath == "webapp.agenda.getAgendaParticipantEdit") {
					data.objNewEvent.participant = dojo.clone(data._arrParticipants);
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
				} else if(data._strContainerPath == "webapp.agenda.getAgendaTimeEdit") {
					var time = this.uiTime.getTime();
					if(data.currentStartEnd == data.START){
						data.objNewEvent.beginDate.datetime.minute = time.minute;
						data.objNewEvent.beginDate.datetime.hour = time.hour;
					} else if(data.currentStartEnd == data.END) {
						data.objNewEvent.endDate.datetime.minute = time.minute;
						data.objNewEvent.endDate.datetime.hour = time.hour;
					}
					data.switchContainer("getAgendaEditEvent", data.STATUS_EDIT, "Agenda : Event Edition");
				}
				break;
			case data.SEARCH:
				break;
			case data.REMOVE:
				if(data._strContainerPath == "webapp.agenda.getAgendaParticipantEdit") {
					this.uiParticipants.pop();
				}
				break;
			default:

				break;
		}
	}
});

webapp.agenda=new webapp.agenda();
