dojo.provide("webapp.session.dataBase");
dojo.declare("webapp.session.dataBase",null,{

	strContainerPath 	: "webapp.session.getSessionsList",
	strContainerTitle 	: _("Other Devices", "webapp.session"),
	_arrDetails			: [],

	STATUS_REMOTE		: 0,
	STATUS_SESSIONS_LIST: 1,

	// States available for the devices
	_UNKNOWN	: "UNKNOWN",
	_IN_SERVICE_STATE	: "IN_SERVICE",
	_OUT_OF_SERVICE	: "OUT_OF_SERVICE",

	// Constant values for the button's id
	BACK                : "BACK_BTN",
	OTHER_DEVICES       : "OTHER_DEVICES_BTN",
	GETCALL             : "GETCALL_BTN",
	END_REMOTE_CALL     : "END_REMOTE_CALL_BTN",

	constructor : function() {
		var func = dojo.hitch( webapp.session, webapp.session.buttonCallback);

		// Check if the webapp communication is already loaded before adding the buttons to the webapp communication
		if (webapp.communication) {
			// Add the "Other devices" button to the appbar STATUS_TRANSFER_TO of communication
			var OTHER_DEVICES_BTN = {
				strButtonName: this.OTHER_DEVICES,
				strButtonLabel: _("Other Devices", "webapp.session"),
				strButtonIcon: "communication-deflect-to-mobile",
				arrCapabilities: [{
					module : "Telephony",
					capability : "transferToRemoteDevice",
					instance: -1
				}],
				callback: func
			};
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, OTHER_DEVICES_BTN);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, OTHER_DEVICES_BTN);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CONFERENCE, OTHER_DEVICES_BTN);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED, OTHER_DEVICES_BTN);

			// Add the "Get call" and "End remote call" buttons to the appbar STATUS_REMOTE_SESSION of communication
			var GETCALL_BTN = {
				strButtonName: this.GETCALL,
				strButtonLabel: _("Get Call", "webapp.session"),
				strButtonIcon: "communication-deflect-to-mobile",
				callback: func,
				arrCapabilities: [{
					module : "Telephony",
					capability : "getCall",
					instance: -1
				}]
			};
			var END_REMOTE_CALL_BTN = {
				strButtonName: this.END_REMOTE_CALL,
				strButtonLabel: _("End Remote Call", "webapp.session"),
				strButtonIcon: "communication-cancel-call",
				callback: func,
				arrCapabilities: [{
					module : "Telephony",
					capability : "terminateCallOtherDevice",
					instance: -1
				}]
			};
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_REMOTE_SESSION, GETCALL_BTN);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_REMOTE_SESSION, END_REMOTE_CALL_BTN);
		}
		// If the webapp communication is not loaded yet, subscribe to the event
		// "webapp.communication.loaded" emitted after the creation of the
		// communication view (posteCreate of getCommunicationBase)
		else {
			dojo.subscribe("webapp.communication.loaded", this, function() {
				// Add the "Other devices" button to the appbar STATUS_TRANSFER_TO of communication
				var OTHER_DEVICES_BTN = {
					strButtonName: this.OTHER_DEVICES,
					strButtonLabel: _("Other Devices", "webapp.session"),
					strButtonIcon: "communication-deflect-to-mobile",
					arrCapabilities: [{
						module : "Telephony",
						capability : "transferToRemoteDevice",
						instance: -1
					}],
					callback: func
				};
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, OTHER_DEVICES_BTN);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, OTHER_DEVICES_BTN);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CONFERENCE, OTHER_DEVICES_BTN);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED, OTHER_DEVICES_BTN);

				// Add the "Get call" and "End remote call" buttons to the appbar STATUS_REMOTE_SESSION of communication
				var GETCALL_BTN = {
					strButtonName: this.GETCALL,
					strButtonLabel: _("Get Call", "webapp.session"),
					strButtonIcon: "communication-deflect-to-mobile",
					callback: func,
					arrCapabilities: [{
						module : "Telephony",
						capability : "getCall",
						instance: -1
					}]
				};
				var END_REMOTE_CALL_BTN = {
					strButtonName: this.END_REMOTE_CALL,
					strButtonLabel: _("End Remote Call", "webapp.session"),
					strButtonIcon: "communication-cancel-call",
					callback: func,
					arrCapabilities: [{
						module : "Telephony",
						capability : "terminateCallOtherDevice",
						instance: -1
					}]
				};
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_REMOTE_SESSION, GETCALL_BTN);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_REMOTE_SESSION, END_REMOTE_CALL_BTN);
			});
		}
		// Create the AppBar for the session list screen (containing only the back button)
		var appBar = ICTouchAPI.AppBarServices.getAppBar("session", "session"+this.STATUS_SESSIONS_LIST);
		var backFunc = function() {
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getCommunication",
				params: {}
			});
		};
		ICTouchAPI.AppBarServices.addExitButton("session", "session" + this.STATUS_SESSIONS_LIST, false, backFunc);

	},

	// Load the list of Sessions
	loadSessionsList : function() {
		ICTouchAPI.APIServices.Telephony.getOtherDevicesList({
			context:this,
			callback:this.loadedSessionsList,
			callbackParams:null
		}); // TO DEFINE : name of service.
	},

	// Callback of loadSessionsList
	loadedSessionsList : function(arr) {
		this._arrDetails = [];
		for(var i in arr) {
			if (arr[i].state == this._IN_SERVICE_STATE) {
				this._arrDetails.push({
					intIndex : arr[i].phoneNumber,
					strPrimaryContent : _(arr[i].label, "webapp.session"),
					//strSecondaryContent : arr[i].phoneNumber,
					phoneNumber : arr[i].phoneNumber,
					arrIcons				: ["","","","",""]
				});// Something...
			}
		}
		// Update the view
		if (webapp.session.mainWidget) {
			webapp.session.mainWidget.reload();
		}
		// When we finished loading, we switch to the Session Screen and set the appBar.
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.session.getSession",
			params: {}
		});
		ICTouchAPI.AppBarServices.setAppBar("session", "session" + this.STATUS_SESSIONS_LIST, "getSession");
	},

	// Returns the phone number associated to that device
	getSessionNumberById : function(id) {
		for(var i in this._arrDetails) {
			if(this._arrDetails[i].intIndex == id)
				return this._arrDetails[i].phoneNumber;
		}
		return null;
	},

	addDevice : function(device) {

		if (device.state == this._IN_SERVICE_STATE)
		{

			this._arrDetails.push(device);
		}
	},

	modifyDevice : function(device) {
		var newDevice = true;
		for(var i in this._arrDetails) {
			if(this._arrDetails[i].intIndex == device.intIndex) {
				newDevice = false;
				if(device.state == this._IN_SERVICE_STATE)
					this._arrDetails[i] = device;
				else
					this._arrDetails.splice(i,1);
			}
		}
		if (newDevice)
			this.addDevice(device)
	},

	deleteDevice : function(device) {
		for(var i in this._arrDetails) {
			if(this._arrDetails[i].intIndex == device.intIndex) {
				this._arrDetails.splice(i,1);
			}
		}
	},

	// Getters
	getContainerContent : function() {
		return this._arrDetails;
	},

	getContainerPath : function() {
		return this.strContainerPath;
	},

	getContainerTitle : function() {
		return this.strContainerTitle;
	}

});
