dojo.provide("webapp.session.controlBase");
dojo.declare("webapp.session.controlBase",ICTouchAPI.webApplication,
{
	mainWidget				: null,

	constructor : function() {
		ICTouchAPI.transitionServices.stealth("webapp.session.getSession");

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.session","webapp.communication");
		ICTouchAPI.eventServices.subscribeToEvent(this, "DeviceAddedEvent", this.onDeviceAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "DeviceModifiedEvent", this.onDeviceModified);
		ICTouchAPI.eventServices.subscribeToEvent(this, "DeviceDeletedEvent", this.onDeviceDeleted);
	},

	buttonCallback : function(buttonId) {
		var data = webapp.session.data;
		var call;
		var callId;
		switch(buttonId)
		{
			case data.OTHER_DEVICES:
				data.loadSessionsList();
				break;

			case data.GETCALL:
				if (webapp.communication) {
					call = webapp.communication.data.getSelectedEntry();
					callId = call.objCallData.callId;
					ICTouchAPI.APIServices.Telephony.getCallFromDevice({
						params:[callId]
					});
				}
				else {
					ICTouchAPI.debugServices.warning("webapp.session.controlBase - buttonCallback / GETCALL not possible: webapp communication is not loaded!");
				}
				break;

			case data.END_REMOTE_CALL:
				if (webapp.communication) {
					call = webapp.communication.data.getSelectedEntry();
					callId = call.objCallData.callId;
					ICTouchAPI.APIServices.Telephony.leaveConferenceN({
						params:[callId]
					});
				}
				else {
					ICTouchAPI.debugServices.warning("webapp.session.controlBase - buttonCallback / END_REMOTE_CALL not possible: webapp communication is not loaded!");
				}
				break;

			default:
				console.warn("buttonCallbak : no callback is defined for this button id:"+buttonId);
				break;
		}
	},

	// Public method, called by communication.
	showRemoteSession : function() {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			if (webapp.communication) {
				// Set webapp communication to the right status (remote conference of remote call)
				webapp.communication.data.isInConference() ? webapp.communication.setStatus(webapp.communication.data.STATUS_CONFERENCE_REMOTE_SESSION) : webapp.communication.setStatus(webapp.communication.data.STATUS_REMOTE_SESSION);

				webapp.communication.mainWidget.reloadContainer();
				// Switch to communication screen
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.communication.getCommunication",
					params: {}
				});
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.session.controlBase - showRemoteSession / Action not possible: webapp communication is not loaded!");
			}
		}
	},

	// When we click on the list of other devices
	onClickList : function(item) {
		if (webapp.communication) {
			var data = webapp.session.data;
			var call = webapp.communication.data.getSelectedEntry();
			ICTouchAPI.APIServices.Telephony.switchCallOnDevice({
				params:[call.objCallData.callId, data.getSessionNumberById(item.intIndex)]
			}) ;
			// remove selection Mode and remove transfert icons
			webapp.communication.resetStatus();
			this.showRemoteSession();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.session.controlBase - onClickList / Action not possible: webapp communication is not loaded!");
		}
	},


	onDeviceAdded : function(param) {
		var device = param.value;
		webapp.session.data.addDevice({
			intIndex : device.phoneNumber,
			strPrimaryContent : _(device.label, "webapp.session"),
			//strSecondaryContent : device.phoneNumber,
			phoneNumber : device.phoneNumber,
			state : device.state,
			arrIcons				: ["","","","",""]
		});
		if (webapp.session.mainWidget) {
			webapp.session.mainWidget.reload();
		}
	},

	onDeviceModified : function(param) {
		var device = param.value;
		webapp.session.data.modifyDevice({
			intIndex : device.phoneNumber,
			strPrimaryContent : _(device.label, "webapp.session"),
			//strSecondaryContent : device.phoneNumber,
			phoneNumber : device.phoneNumber,
			state : device.state,
			arrIcons				: ["","","","",""]
		});
		if (webapp.session.mainWidget) {
			webapp.session.mainWidget.reload();
		}
	},

	onDeviceDeleted : function(param) {
		var device = param.value;
		webapp.session.data.deleteDevice({
			intIndex : device.phoneNumber
		});
		if (webapp.session.mainWidget) {
			webapp.session.mainWidget.reload();
		}
	}
});
