dojo.provide("webapp.wakeup.getWakeUpMelodyBase");
dojo.declare("webapp.wakeup.getWakeUpMelodyBase", [ICTouchAPI.webWidget, dijit._Templated], {
	domContent: null,
	_objContainer: null,
	_strTitle: null,

	constructor: function() {
		this._strTitle = _("Sound", "webapp.wakeup");
	},

	destroy: function() {
		this._objContainer.destroy();
		delete this._objContainer;
		delete this.webapp.objMelodySelect;

		this.inherited(arguments);
	},

	_save: function() {
		var index = this.webapp.objMelodySelect.getSelected();
		if( index.length > 0 ) {
			this.webapp.data.setCurrentMelody(index[0]);
		}
		this.webapp.onValidate();
		this.webapp.refreshContent();
		ICTouchAPI.transitionServices.getScreen({ name:"webapp.wakeup.getWakeUp", params:{} });
	},

	// Should be called when we want to discard the local changes
	revert: function() {
		if( this.webapp.objMelodySelect != null ) {
			var index = this.webapp.data.getCurrentMelodyIndex();
			this.webapp.objMelodySelect.unselectAll();
			if( index >= 0 ) {
				this.webapp.objMelodySelect.selectAtIndex(index);
			}
		}
	},

	reloadRingingSources: function() {
		this._objContainer.reload({
			objTitle: {
				strLabel: this._strTitle
			},
			objContent: this._getSelectListParams()
		});
		this.webapp.objMelodySelect = this._objContainer.getContent();

		this._selectCurrentMelody();
	},

	postCreate: function() {
        var full = new UIElements.ApplicationMode.FullControl(
        {
            content : {
                name    : "UIElements.Container.ContainerControl",
                params  : {
					objTitle: {
						strLabel: this._strTitle
					},
					objContent: this._getSelectListParams()
				}
            }
        },this.domContent);
		this._objContainer = full.getContent();
		this.webapp.objMelodySelect = this._objContainer.getContent();

		this._selectCurrentMelody();

		var buttonBack = new UIElements.AppButton.AppButtonControl({
			strButtonName: this.webapp.data.BACK,
			strButtonLabel: _('Back', 'ICTouchAPI'),
			strButtonIcon: 'generic-back',
			callback: dojo.hitch(this, this._save)
		});
		ICTouchAPI.AppBarServices.addStaticButton("wakeup", "getWakeUpMelody", buttonBack);
	},

	_selectCurrentMelody: function() {
		var index = this.webapp.data.getCurrentMelodyIndex();
		if( index >= 0 ) {
			this.webapp.objMelodySelect.selectAtIndex(index);
		}else{
			this.webapp.objMelodySelect.selectAtIndex(0);
			webapp.wakeup.data.setCurrentMelody(0);
			webapp.wakeup.onValidate();
			webapp.wakeup.refreshContent();
		}
	},

	_getSelectListParams: function() {
		return {
			name: "UIElements.SelectList.SelectListControl",
			params: {
				arrItems: this.webapp.data.getRingingSources(),
				boolMultiselect: false,
				buttonCallback : dojo.hitch(webapp.wakeup, webapp.wakeup.previewMelody)/*,
				itemCallback: func*/
			}
		};
	}
});
