/*Wake Up test Webapplication*/
dojo.provide("webapp.wakeup.getWakeUpContentBase");
dojo.declare("webapp.wakeup.getWakeUpContentBase", [ICTouchAPI.webWidget, dojox.dtl._Templated], {

	boolIsVolume				: false,
	boolIsAlarmType				: false,

	domScrollSelectDivHours		: null,
	domScrollSelectDivMinutes	: null,
	domNumeralSelect			: null,
	domVolumeSlider				: null,

	objVolume					: null,

	strTime : null,
	strVolume : null,
	strAlarmType :null,
        strAlarmStatus : "",

	i18n : "webapp.wakeup",

	attributeMap : {
		strTime : { node : "domTime", type: "innerHTML"},
		strVolume : { node : "domVolume", type: "innerHTML"},
		strAlarmType : { node : "domAlarmType", type: "innerHTML"},
		strAlarmStatus : { node : "domAlarmStatus", type: "innerHTML"}
	},

	constructor:function(){
		this.boolIsVolume = webapp.wakeup.data.getWakeUpVolume();
		this.boolIsAlarmType = webapp.wakeup.data.getWakeUpMelody();

		this.strTime = _("Time", "webapp.wakeup");
		this.strAlarmStatus = _("Status", "webapp.wakeup");

		if (this.boolIsVolume){
			this.strVolume = _("Volume", "webapp.wakeup");
		}
		if (this.boolIsAlarmType){
			this.strAlarmType = _("Sound", "webapp.wakeup");
		}
		webapp.wakeup.wakeupContent = this;
	},

	postCreate: function() {
		var data = webapp.wakeup.data;
		var control = this.webapp;
		// 1 is off and 0 is on... so invert it
		var state = data.getStatus() ? 0 : 1;
		data.objStatus = new UIElements.OptionChooser.OptionChooserControl({
			arrItems: [_("on","ICTouchAPI"), _("off","ICTouchAPI")],
			boolShowTouch: false,
			intIndex: state,
			intOptionWidth: 130,
			funcCallback: function(status){
				status = status ? 0 : 1;
				data.setStatus(status);
				control.onValidate();
			}
		}, this.domEnabledSlider);
	},

	createVolumeSelection: function() {
		if (this.boolIsVolume) {
			var data = webapp.wakeup.data;
			var control = this.webapp;
			var volume = data.getVolume();
			// Volume
			this.objVolume = new UIElements.Slider.Graduate({
				intValue: volume,
				intMinimum: 0,
				intMaximum: 9,
				boolSeekable: true
			}, this.domVolumeSlider);
			// Update data when the value has changed
			this.connect(this.objVolume,"slidermouseup",function(){
				data.setVolume(this.objVolume.getValue());
				control.onValidate();
			})
		}
	},

	// when we return to this screen, we have to refresh the UIElements
	update : function () {
		// refresh UIEls
		this.webapp.refreshContent();
	}
});
