dojo.require("webapp.wakeup.getWakeUpContentBase");
dojo.provide("webapp.wakeup.getWakeUpContent");
dojo.declare("webapp.wakeup.getWakeUpContent", webapp.wakeup.getWakeUpContentBase, {
	templatePath: dojo.moduleUrl("webapp.wakeup","templates/getWakeUpContent8082.html"),
	domHour: null,
	objHour: null,
	objMelody: null,
	timeout : null,

	_switchToHour: function() {
		ICTouchAPI.transitionServices.getScreen({ name: "webapp.wakeup.getWakeUpTime", params: {} });
	},

	_switchToMelody: function() {
		ICTouchAPI.transitionServices.getScreen({ name: "webapp.wakeup.getWakeUpMelody", params: {} });
	},

	revert: function() {
		this.inherited(arguments);
		var data = webapp.wakeup.data;
		var dateParams = this.webapp.data.getTime();
		if (this.objHour) {
			this.objHour.set24hourFormat(data.is24HourFormat());
			this.objHour.setValue(dateParams.hour, dateParams.minute);			
		}
		if (this.objMelody) {
			this.objMelody.attr("strValue", this.webapp.data.getCurrentMelodyName());
		}
		if(this.objVolume) {
			this.objVolume.setValue(data.getVolume());
		}
		if(data.objStatus) {
			var status = data.getStatus() ? 0 : 1;
			data.objStatus.setValue(status);
		}
	},

	postCreate: function() {
		var data = webapp.wakeup.data;
		var dateParams = data.getTime();

		this.objHour = new UIElements.ValueSelect.TimeSelect({
			intHourValue: dateParams.hour,
			intMinuteValue: dateParams.minute,
			is24hourFormat : this.webapp.data.is24HourFormat(),
			strHour : _("Hour","webapp.wakeup"),
			strMinute : _("Minute","webapp.wakeup"),
			callback : dojo.hitch(this, function(){
				var values = this.objHour.getValue();
				this.webapp.data.saveTime(values[0], values[1]);
				this.startTimeout();
			})
		}, this.domHour);

		this.objMelody = new UIElements.InputField.Simple({
			funcClicked: dojo.hitch(this, this._switchToMelody),
			strValue: data.getCurrentMelodyName()
		}, this.domSelectList)
		this.createVolumeSelection();
		if (this.objVolume) {
			this.objVolume.setSliderWidth(250);
		}
		this.inherited(arguments);
	},

	startTimeout : function(){
			if (this.timeout){
				clearTimeout(this.timeout);
	}
			this.timeout = setTimeout(
				dojo.hitch(this.webapp, this.webapp.onValidate),
				2000
			)
		}
});
