/*Wake Up test Webapplication*/
dojo.require("webapp.wakeup.getWakeUpContentBase");
dojo.provide("webapp.wakeup.getWakeUpContent");
dojo.declare("webapp.wakeup.getWakeUpContent", webapp.wakeup.getWakeUpContentBase, {
	templatePath: dojo.moduleUrl("webapp.wakeup","templates/getWakeUpContent8052.html"),
	domContent: null,
	strUiType: "main",
	arrFocus: [],
	domFocus: [],
	intFocus: 0,
	
	constructor: function() {

	},
	
	create: function() {
		this.inherited(arguments);
		this.domFocus = [];
	},
	
	postMixInProperties: function() {
		this.inherited(arguments);
		// Call a different template depending on the UI type
		switch(this.strUiType)
		{
			case "time":
			case "volume":
			case "melody":
				break;
			default:
				this.strUiType = "main";
				break;
		}
	},
	
	navigate: function(action) {
		if( action == "OK" && this.strUiType != "main" )
		{
			webapp.wakeup.switchView("main");
			return;
		}
		switch(action)
		{
			// LEFT and RIGHT events are redirected to the element itself
			case "LEFT":
			case "RIGHT":
				var i = this.intFocus;
				if( this.arrFocus[i] && this.arrFocus[i].navigate )
					this.arrFocus[i].navigate(action);
				break;
			case "UP":
				this.intFocus--;
				this.updateFocus();
				break;
			case "DOWN":
				this.intFocus++;
				this.updateFocus();
				break;
		}
	},
	
	updateFocus: function()
	{
		this.intFocus = Math.max(0, Math.min(this.arrFocus.length-1, this.intFocus));
		for(var i=0; i<this.arrFocus.length; ++i)
		{
			dojo.toggleClass(this.domFocus[i], "focus", ( i == this.intFocus ));
		}
	},
	
	postCreate: function() {
		this.arrFocus = [];
		switch(this.strUiType)
		{
			case "time":
				this.postCreateTime();
				break;
			case "volume":
				this.postCreateVolume();
				break;
			case "melody":
				this.postCreateMelody();
				break;
			default:
				this.postCreateMain();
				break;
		}
	},
	
	postCreateMain: function() {
		var list = [];
		list.push({strPrimaryContent: _("Set time", "webapp.wakeup"), intIndex: "time"});
		list.push({strPrimaryContent: _("Set volume", "webapp.wakeup"), intIndex: "volume"});
		list.push({strPrimaryContent: _("Set melody", "webapp.wakeup"), intIndex: "melody"});
		var menuList = new UIElements.MenuList.MenuListControl({ arrItems: list, callback: dojo.hitch(webapp.wakeup, webapp.wakeup.switchView) }, this.domContent);
		ICTouchAPI.navigationServices.changeFocus(menuList);
		menuList.updateFocus();
	},
	
	postCreateTime: function() {
		new UIElements.ContainerTitle.ContainerTitleControl({ strLabel: _("Time", "webapp.wakeup") }, this.domTitle);
		this.createTimeSelection();
		var data = webapp.wakeup.data;
		this.arrFocus.push(data.objAlarmHoursUI);
		this.arrFocus.push(data.objAlarmMinutesUI);
		if( data.objSliderUI != null )
			this.arrFocus.push(data.objSliderUI);
		this.intFocus = 0;
		this.updateFocus();
		ICTouchAPI.navigationServices.changeFocus(this);
	},
	
	postCreateVolume: function() {
		new UIElements.ContainerTitle.ContainerTitleControl({ strLabel: _("Volume", "webapp.wakeup") }, this.domTitle);
		this.createVolumeSelection();
		this.arrFocus[0] = webapp.wakeup.data.objAlarmVolumeUI;
		this.intFocus = 0;
		ICTouchAPI.navigationServices.changeFocus(this);
	},
	
	postCreateMelody: function() {
		new UIElements.ContainerTitle.ContainerTitleControl({ strLabel: _("Melody", "webapp.wakeup") }, this.domTitle);
		this.createMelodySelection();
		this.arrFocus[0] = webapp.wakeup.data.objMelodySelection;
		this.intFocus = 0;
		ICTouchAPI.navigationServices.changeFocus(this);
	},
});
