dojo.provide("webapp.wakeup.dataBase");
dojo.declare("webapp.wakeup.dataBase",null,{
	// Member data used for object construction
	_arrAppButtons      : [],
	arrRingingSources 	: [],

	objWakeup           : {},
	objSliderUI			: {},
	objCalendarUI		: {},
	objTimeUI			: {},
	objStatus			: null,

	// Delay the saving of these until the user validates the new wakeup
	intSavedHour		: null,
	intSavedMinute		: null,
	intSavedIdFile		: null,
	intSavedStatus		: null,
	floatSavedVolume	: null,

	// Settings & capabilities
	_boolCreating		: false,
	_bool24hformat		: false,
	WAKEUP_VOLUME		: null,
	WAKEUP_ALARM_TYPE	: null,
	WAKEUP_SNOOZE		: null,
	WAKEUP_REPEAT		: null,
	WAKEUP_STOP			: null,

	intDefaultAlarmMelodyId : -1,

	homepageButtonCreated	: false,

	ENABLE   : true,
	DISABLE  : false,

	BACK     : "BACK_BTN",
	STOP_BTN : "STOP_BTN",
	REPEAT_BTN : "REPEAT_BTN",
	SNOOZE_BTN : "SNOOZE_BTN",
	CLOSE_BTN : "CLOSE_BTN",
        SAVE_TIME_BTN : "SAVE_TIME_BTN",
	SAVE_MELODY_BTN : "SAVE_MELODY_BTN",

        //VALIDATE : "VALIDATE_BTN",

	constructor : function() {
		this.loadData();
	},

	loadData : function() {// TODO change the length
		ICTouchAPI.APIServices.FileManager.getFilesInPool({params:[ICTouchAPI.tools.POOL_WU,0,1000], context:this, callback:this.loadedRingingSources, callbackParams:null});
		ICTouchAPI.APIServices.FileManager.getDefaultAlarmMelody({context:this, callback:this.gotDefaultMelody});
	},

	gotDefaultMelody : function(objAlarmMelody) {
		if(objAlarmMelody){
			this.intDefaultAlarmMelodyId = objAlarmMelody.id;
		}
	},

	loadedRingingSources : function(_arr) {
		this.arrRingingSources = [];
		var id = 1;
		for (var i in _arr) {
			this.arrRingingSources.push({
				intIndex: id,
				strLabel: _arr[i].name,
				objSource: _arr[i],
				strActionIcon : "filesmanager-play"
			});
			id++;
		}
		this.load24hFormatSetting();

		webapp.wakeup.refreshRingingSources();
	},

	load24hFormatSetting : function() {
		//ICTouchAPI.settingServices.subscribeToSetting(webapp.wakeup, "TimeFormat", webapp.wakeup.timeFormatChanged);
		ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, this.loaded24hFormatSetting);
	},

	loaded24hFormatSetting : function(settingValue) {
		// save setting
		if (settingValue != undefined && settingValue != null)
			this._bool24hformat = settingValue;
		// load data
		this.loadWakeupData();
	},

	loadWakeupData : function() {
		// if no object initialized, find an element else get it by Id
		if(this.objWakeup.id == undefined || this.objWakeup.id == -1)
			ICTouchAPI.APIServices.Agenda.findPlannedEventByType({params:["WAKEUP"], context:this, callback:this.loadedWakeupData, callbackParams:null});
		else
			ICTouchAPI.APIServices.Agenda.getWakeUpById({params:[this.objWakeup.id], context:this, callback:this.loadedWakeupData, callbackParams:null});
	},

	saveTime : function(intHour, intMinute) {
		this.intSavedHour = intHour;
		this.intSavedMinute = intMinute;
	},

	getTime : function() {
		var datetime;
		if( this.intSavedHour == null ) {
			datetime = this.objWakeup.beginDate.datetime;
			// Dont return reference to datetime
			return {hour: datetime.hour, minute: datetime.minute};
		}
		else {
			//return { hour: this.intSavedHour, minute: this.intSavedMinute };
			var newdatetime = new Date(0,0,0,this.intSavedHour,this.intSavedMinute,0);
			return {hour: newdatetime.getHours(), minute: newdatetime.getMinutes()};
		}
		//return { hour: datetime.getHours(), minute: datetime.getMinutes() };
	},

	is24HourFormat : function() {
		return this._bool24hformat;
	},


	loadedWakeupData : function(_arr) {
		var objAlarm = {
			type: "Alarm",
			value: {
				id: -1,
				idFile: this.intDefaultAlarmMelodyId,
				idCapabilities: -1,
				volume: 5
			}
		};

		// If a planned event has been found
		if(_arr && _arr[0]!=undefined)
		{
			// from findPlannedEventByType, result = List
			this._boolCreating = false;
			this.objWakeup = _arr[0];
			if (this.objWakeup.alarm == undefined)
			{
				// reload the element (beacuse findPlannedEventByType dont give alarm object)
				ICTouchAPI.APIServices.Agenda.getWakeUpById({params:[this.objWakeup.id], context:this, callback:this.loadedWakeupData, callbackParams:null});
				return;
			}
		}
		// If no planned event was found, or if getWakeUpById() was called
		else
		{
			// If getWakeUpById() was called
			if (_arr && _arr.id != undefined) {
				// from getWakeUpById result = Object
				this.objWakeup = _arr;
				this._boolCreating = false;
			}
			// If findPlannedEventByType() was called (and not found)
			else {
				// fake object to initialize the webapp
				this.objWakeup = {
					classType:"WAKEUP",
					beginDate: {
						datetime: {
							year: 1,
							month: 1,
							day: 1,
							hour: 8,
							minute: 0,
							second: 0
						}
					},
					id: -1,
					label: "WakeUp",
					alarmState: 0,
					alarm: objAlarm
				}
			}

			//If homepage button is not created, create this, otherwise change homepage button status.
			if (this.homepageButtonCreated!==true) {
				var statusClass;
				if(this.objWakeup.alarmState === 0) {
					statusClass = "notif-off";
				}
				else {
					statusClass = "notif-on";
				}
				ICTouchAPI.tools.registerHomepageButton(["webapp.wakeup.getWakeUp", "WAKEUP_BTN", "alarm-application", _('Alarm',"webapp.wakeup"), statusClass]);
				ICTouchAPI.tools.registerHomepageKey(["webapp.wakeup.getWakeUp", "WAKEUP_BTN", "alarm-application", _('Alarm',"webapp.wakeup"), statusClass, function(){ICTouchAPI.transitionServices.getScreen({name: "webapp.wakeup.getWakeUp", params:{}});}]);
				this.homepageButtonCreated = true;
			}



			//If homepage button is not created, create this, otherwise change homepage button status.
			if (this.homepageButtonCreated!==true) {
				var statusClass;
				if(this.objWakeup.alarmState === 0) {
					statusClass = "notif-off";
		}
				else {
					statusClass = "notif-on";
				}
				ICTouchAPI.tools.registerHomepageButton(["webapp.wakeup.getWakeUp", "WAKEUP_BTN", "alarm-application", _('Alarm',"webapp.wakeup"), statusClass]);
				ICTouchAPI.tools.registerHomepageKey(["webapp.wakeup.getWakeUp", "WAKEUP_BTN", "alarm-application", _('Alarm',"webapp.wakeup"), statusClass, function(){ICTouchAPI.transitionServices.getScreen({name: "webapp.wakeup.getWakeUp", params:{}});}]);
				this.homepageButtonCreated = true;
			}
		}

		this.discardSavedValues();
        webapp.wakeup.refreshContent();
	},

	getWakeUpVolume : function() {
		return this.WAKEUP_VOLUME;
	},

	getWakeUpMelody : function() {
		return this.WAKEUP_ALARM_TYPE;
	},

	getWakeUpSnooze : function() {
		return this.WAKEUP_SNOOZE;
	},

	getWakeUpRepeat : function() {
		return this.WAKEUP_REPEAT;
	},

	getWakeUpStop : function() {
		return this.WAKEUP_STOP;
	},

	getRingingSources : function(){
		return this.arrRingingSources;
	},

    getCurrentMelodyIndex : function() {
		var idFile = this.intSavedIdFile == null ? this.objWakeup.alarm.value.idFile : this.intSavedIdFile;
 		var _arr = this.getRingingSources();
 		for (var i in _arr) {
 			if( idFile == _arr[i].objSource.id ) {
 				return i;
 			}
 		}
 		return -1;
 	},

 	getCurrentMelodyName : function() {
		var idFile = this.intSavedIdFile == null ? this.objWakeup.alarm.value.idFile : this.intSavedIdFile;
 		var _arr = this.getRingingSources();
 		for (var i in _arr) {
 			if( idFile == _arr[i].objSource.id ) {
 				return _arr[i].objSource.name;
 			}
 		}
 		return "";
 	},

 	setCurrentMelody : function(index) {
 		var _arr = this.getRingingSources();
 		var id = _arr[index].objSource.id;
 		if( typeof id != "undefined" ) {
			this.intSavedIdFile = id;
 		}
 	},

	getStatus : function() {
		return this.intSavedStatus == null ? this.objWakeup.alarmState : this.intSavedStatus;
	},

	setStatus : function(status) {
		this.intSavedStatus = status;
	},

	getVolume : function() {
		return this.floatSavedVolume == null ? this.objWakeup.alarm.value.volume : this.floatSavedVolume;
	},

	setVolume : function(volume) {
		this.floatSavedVolume = parseFloat(volume).toFixed(1);
        var id      = this.getCurrentMelodyIndex();
        var _arr    = this.getRingingSources();
		//ICTouchAPI.APIServices.MediaPlayer.playAlarm({params:[id, _arr[id].objSource.url, this.floatSavedVolume, false]});
		ICTouchAPI.APIServices.IctMPInterface.volumePreview({params:[_arr[id].objSource.url, this.floatSavedVolume]});
		webapp.wakeup._isSetVolume = true;
	},

	discardSavedValues : function() {
		this.intSavedIdFile = null;
		this.intSavedHour = null;
		this.intSavedMinute = null;
		this.floatSavedVolume = null;
		this.intSavedStatus = null;
	},

	commitSavedValues : function() {
		// Commit values to objWakeup
		if( this.intSavedIdFile != null ) {
			this.objWakeup.alarm.value.idFile = this.intSavedIdFile;
		}
		if( this.intSavedHour != null ) {
			this.objWakeup.beginDate.datetime.hour = this.intSavedHour;
			this.objWakeup.beginDate.datetime.minute = this.intSavedMinute;
		}
		if( this.intSavedStatus != null ) {
			this.objWakeup.alarmState = this.intSavedStatus;
		}
		if( this.floatSavedVolume != null ) {
			this.objWakeup.alarm.value.volume = this.floatSavedVolume;
		}

		// Everything has been saved, remove saved values
		this.discardSavedValues();
	},

	getAppBarAppButtons : function(){
		return this._arrAppButtons;
	}
});
