dojo.provide("webapp.wakeup.controlBase");
dojo.declare("webapp.wakeup.controlBase",[ICTouchAPI.webApplication],
{
	popupAlarm : null,
	_isPreviewPlaying : false,
	_isSetVolume : false,
	objTimeSelect : null,
	objMelodySelect : null,

	constructor : function() {
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);

		/* Homepage button is created when wakeup state is receveid (data.loadedWakeupData) */

		dojo.subscribe("ReloadPool",this,function() {
			this.data.loadData();
		});
        dojo.subscribe("homepage/refreshHomepage",this,this.refreshWakeupButtonStatus);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.wakeup", true, false, true, false);

	},

	load : function() {
		ICTouchAPI.CapabilityServices.subscribeToCapability("Agenda", "WakeUpVolume", this, this.getVolumeAvailability);
		ICTouchAPI.CapabilityServices.subscribeToCapability("Agenda", "WakeUpMelody", this, this.getMelodyAvailability);
		/*
			the "AlarmState" event didn't appear ont the D-Bus so that this listener never called the callback function
			to be notified
		*/
		ICTouchAPI.eventServices.subscribeToEvent(this,"AlarmState",this.notifyAlarmStateWakeUpEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AlarmStarted", this.notifyAlarmStarted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AlarmStopped", this.notifyAlarmStopped);

		// help
		dojo.publish("needHelpEvent",["wakeup",["getWakeUp"]]);
	},

	buttonCallback : function(buttonId) {
		var data = webapp.wakeup.data;
		switch(buttonId)
		{
			case data.BACK:
				dojo.publish("OpenHomepage");
				break;
		}
	},

	/*
		This function set the UIElements values to the valuesstored into the objWakeup object
		which hold the last validated values for the alarm
	*/
	resetUIE : function(){
		this.data.discardSavedValues();
	},

	onClickRingingSource : function(intIndex) {
		if(intIndex == 0 || intIndex == undefined) return;
		var data = webapp.wakeup.data;
		var _arr = data.getRingingSources();
		data.objWakeup.alarm.value.idFile = _arr[intIndex-1].objSource.id;
	},

	onValidate : function() {

		ICTouchAPI.debugServices.debug("webapp.wakeup.controlBase -  onValidate");
		
		var data = this.data;

		// we have to unsuscribe previous capabilities
		if (data.objWakeup.alarm && data.objWakeup.alarm.value.idCapabilities != undefined && data.objWakeup.alarm.value.idCapabilities != -1) {
			ICTouchAPI.CapabilityServices.unsubscribeInstance("Agenda", data.objWakeup.alarm.value.idCapabilities, "Snooze");
			ICTouchAPI.CapabilityServices.unsubscribeInstance("Agenda", data.objWakeup.alarm.value.idCapabilities, "Stop");
			ICTouchAPI.CapabilityServices.unsubscribeInstance("Agenda", data.objWakeup.alarm.value.idCapabilities, "Repeat");
                 }

		data.commitSavedValues();

		var funcRefreshObject = function() {
			//refresh wakeup object
			data.loadWakeupData();
		};
		if (data.objWakeup.id >= 0) {
			// Wake up object already exists => modify it
			ICTouchAPI.APIServices.Agenda.modifyPlannedWakeUp({params:[data.objWakeup], context:this, callback: funcRefreshObject, callbackParams:null});
		}
		else if (data._boolCreating == false) {
			data._boolCreating = true;
			// Wake up object did not exist => create it
			ICTouchAPI.APIServices.Agenda.addPlannedWakeUp({params:[data.objWakeup], context:this, callback: funcRefreshObject, callbackParams:null});
		}
		else {
			ICTouchAPI.debugServices.debug("webapp.wakeup.controlBase -  onValidate - Prevent the creation of 2 wake up");
		}
	},


	getVolumeAvailability : function(strCapability, intStatus) {
		var data = webapp.wakeup.data;
		if (intStatus == ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.WAKEUP_VOLUME = data.ENABLE;
		} else {
			data.WAKEUP_VOLUME = data.DISABLE;
		}
	},

	getMelodyAvailability : function(strCapability, intStatus) {
		var data = webapp.wakeup.data;
		if (intStatus == ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.WAKEUP_ALARM_TYPE = data.ENABLE;
		} else {
			data.WAKEUP_ALARM_TYPE = data.DISABLE;
		}
	},

	getSnoozeAvailability : function(strCapability, intStatus) {
		var data = webapp.wakeup.data;
		if (intStatus == ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.WAKEUP_SNOOZE = data.ENABLE;
		} else {
			data.WAKEUP_SNOOZE = data.DISABLE;
		}
	},

	getRepeatAvailability : function(strCapability, intStatus) {
		var data = webapp.wakeup.data;
		if (intStatus == ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.WAKEUP_REPEAT = data.ENABLE;
		} else {
			data.WAKEUP_REPEAT = data.DISABLE;
		}
	},

	getStopAvailability : function(strCapability, intStatus) {
		var data = webapp.wakeup.data;
		if (intStatus == ICTouchAPI.CapabilityServices.AVAILABLE) {
			data.WAKEUP_STOP = data.ENABLE;
		} else {
			data.WAKEUP_STOP = data.DISABLE;
		}
	},

	//New method to get Capabilities
	notifyAlarmStarted : function(objEvent) {
		objEvent = objEvent.value;

		// check if it is an event of type wakeup
		if(objEvent.classType == "WAKEUP")
		{

			if(objEvent.alarm.value.idCapabilities != undefined){
				ICTouchAPI.CapabilityServices.getOnceCapabilities("Agenda",objEvent,objEvent.alarm.value.idCapabilities,this, this.displayPopup);
			}


		}
	},

	displayPopup : function(arrCapabilities,objEvent){
		if (this.popupAlarm != null) {
			// don't recreate a popup if there is already one
			ICTouchAPI.debugServices.error("webapp.wakeup.controlBase -  displayPopup, a popup is already displayed");
			return;
		}
            ICTouchAPI.skinServices.linkWebappsStyles("webapp.Popup","webapp.filesmanager",true,false,true,false);
			// popup
			var context = this;
			var objDate = new Date(0, 0, 0, objEvent.beginDate.datetime.hour, objEvent.beginDate.datetime.minute, 0);
            if(objEvent.label != "WakeUp") {
			var strContent = _([objEvent.label || "Alarm", "-", ICTouchAPI.tools.getFormatedTime(objDate.getHours(), objDate.getMinutes(), this.data.is24HourFormat())],"webapp.wakeup");
            } else {
                var strContent = _([ICTouchAPI.tools.getFormatedTime(objDate.getHours(), objDate.getMinutes(), this.data.is24HourFormat())],"webapp.wakeup");
            }
			var buttonNb = 0;
			var arrButtons = [];
			if(arrCapabilities && arrCapabilities["Stop"] && arrCapabilities["Repeat"] && arrCapabilities["Snooze"])
			{
				if(arrCapabilities["Stop"].state==ICTouchAPI.CapabilityServices.AVAILABLE){
					arrButtons[buttonNb++] = {  strButtonName : this.data.STOP_BTN,
                                                strButtonLabel: _('Stop','webapp.wakeup'),
                                                strButtonIcon: 'generic-cancel',
                                                callback : function(){webapp.wakeup.closeAlarmPopup(webapp.wakeup, webapp.wakeup.stopAlarm, objEvent);}
                                            };
				}
				if(arrCapabilities["Repeat"].state==ICTouchAPI.CapabilityServices.AVAILABLE) {
					arrButtons[buttonNb++] = {  strButtonName : this.data.REPEAT_BTN,
                                                strButtonLabel: _('Repeat','webapp.wakeup'),
                                                strButtonIcon: 'filesmanager-repeat',
                                                callback : function(){webapp.wakeup.closeAlarmPopup(webapp.wakeup, webapp.wakeup.repeatAlarm, objEvent);}
                                            };
				}
				if(arrCapabilities["Snooze"].state==ICTouchAPI.CapabilityServices.AVAILABLE) {
					arrButtons[buttonNb++] = {  strButtonName : this.data.SNOOZE_BTN,
                                                strButtonLabel: _('Snooze','webapp.wakeup'),
                                                callback : function(){webapp.wakeup.closeAlarmPopup(webapp.wakeup, webapp.wakeup.snoozeAlarm, objEvent);}
                                            };
				}
			}
			var popupAlarm = {
				 strTitle: _("AlarmShortTtl", "webapp.wakeup"), strType: "info", strContent: strContent,
				 arrPopupButtons: arrButtons, intID : "ALARM" + objEvent.alarm.value.id
			};
			if(buttonNb == 0) {
				popupAlarm.arrPopupButtons[0] = {strButtonName : this.data.CLOSE_BTN, strButtonLabel: _('Close','webapp.wakeup'), callback : function(){context.closeAlarmPopup(context);}};
			}
			this.popupAlarm = ICTouchAPI.popupServices.addNewPopup(popupAlarm, "MEDIUM");

	},


	closeAlarmPopup : function(context, callback, callbackParams) {
		if(context.popupAlarm != null)
		{
		ICTouchAPI.popupServices.removePopupByID(context.popupAlarm);
			context.popupAlarm = null;
		}
		if (callback)
			callback(callbackParams);
	},

	notifyAlarmStopped : function(objEvent) {
		objEvent = objEvent.value;
		// check if it is an event of type wakeup
		if(objEvent.classType == "WAKEUP")
		{
			// remove popup
			if(this.popupAlarm != null){
				this.closeAlarmPopup(this);
		}
		}
	},

	stopAlarm:function(objEvent) {
		// call core
		ICTouchAPI.APIServices.Agenda.stopAlarm({params:[objEvent.alarm.value.id], context:null, callback:null, callbackParams:null});
	},

	repeatAlarm:function(objEvent) {
		// call core
		ICTouchAPI.APIServices.Agenda.repeatAlarm({params:[objEvent.alarm.value.id], context:null, callback:null, callbackParams:null});
	},

	snoozeAlarm:function(objEvent){
		// call core
		ICTouchAPI.APIServices.Agenda.snoozeAlarm({params:[objEvent.alarm.value.id], context:null, callback:null, callbackParams:null}) ;
	},

	onTimeFormatChanged : function (objSetting) {
		this.data.loaded24hFormatSetting(objSetting.jsValue);
		if(this.wakeupContent){
			this.wakeupContent.update();
		}
	},

	/**
	 * Alarm State = change status of buttons
	 */
	notifyAlarmStateWakeUpEvent : function(objEvent)
	{
		// only take care about wakeup type alarmState
		if(objEvent.type != "WakeUp")
			return;

		var objWakeup = objEvent.value;

		// ERROR
		if(objWakeup && objWakeup.id == -1){
			// Used in case of resetToDefault, reload default values for wakeup.
			this.data.loadedWakeupData();
			ICTouchAPI.tools.changeHomepageStatusIcon(["WAKEUP_BTN","notif-off"]);
			return;
		}

		// we have to make some changes
		if(objWakeup && objWakeup.classType == "WAKEUP")
		{
			var statusClass;
			//Refresh homepage button status
			if(objWakeup.alarmState === 0) {
				statusClass = "notif-off";
			}
			else {
				statusClass = "notif-on";
			}
			ICTouchAPI.tools.changeHomepageStatusIcon(["WAKEUP_BTN",statusClass]);

			webapp.wakeup.data.objWakeup = objWakeup;
			this.data.setStatus(objWakeup.alarmState);
			if (this.wakeupContent) {
				this.wakeupContent.update();
			}
		}
	},

	refreshRingingSources: function() {
		// Notify every widget that need to reload their ringing sources
		var list = this.getLoadedWidgets();
		for( var widgetName in list ) {
			if( typeof list[widgetName].reloadRingingSources == "function" ) {
				list[widgetName].reloadRingingSources();
			}
		}
	},

	refreshContent: function() {
		var list = this.getLoadedWidgets();
		// Widget in the sub-views ( getWakeUpMelody & getWakeUpTime ) should revert their values
		for( var widgetName in list ) {
			if( typeof list[widgetName].revert == "function" ) {
				list[widgetName].revert();
			}
		}
	},

    refreshWakeupButtonStatus: function() {
        if(webapp.wakeup.data.objWakeup){
            var status = webapp.wakeup.data.objWakeup.alarmState;
            var statusClass;
            if(status===0){
                statusClass = "notif-off";
            }else{
                statusClass = "notif-on";
            }
            ICTouchAPI.tools.changeHomepageStatusIcon(["WAKEUP_BTN",statusClass]);
        }

    },

	previewMelody : function(id){
		var url = this.data.arrRingingSources[id-1].objSource.url;
		ICTouchAPI.APIServices.IctMPInterface.preview({params: [url]});
		this._isPreviewPlaying = true;
	},

	unlock : function (webappName) {
		if(webappName !== "webapp.wakeup.getWakeUpTime" && webappName !== "webapp.wakeup.getWakeUpMelody"){
			if(webapp.wakeup._isPreviewPlaying){
			ICTouchAPI.APIServices.IctMPInterface.stopPreview({});
				webapp.wakeup._isPreviewPlaying = false;
    }

            if(webapp.wakeup._isSetVolume) {
                var id      = webapp.wakeup.data.getCurrentMelodyIndex();
                ICTouchAPI.APIServices.MediaPlayer.moduleStop({params:[id]});
                webapp.wakeup._isSetVolume = false;
            }

			if(ICTouchAPI.transitionServices.getCurrentScreenName()=="webapp.wakeup.getWakeUpMelody"){
				var modified = false;
				// Save melody
				if(webapp.wakeup.objMelodySelect){
					var index = webapp.wakeup.objMelodySelect.getSelected();
					if( index.length > 0 ) {
						webapp.wakeup.data.setCurrentMelody(index[0]);
					}
					modified = true;
				}
				if(modified){
					webapp.wakeup.refreshContent();
					webapp.wakeup.onValidate();
				}
			}
		}
		dojo.publish("unlockTransition",[true]);
	}
});
