dojo.require("webapp.haptic.getHapticBase");
dojo.provide("webapp.haptic.getHaptic");
dojo.declare("webapp.haptic.getHaptic",
	webapp.haptic.getHapticBase,
	{
		templatePath: dojo.moduleUrl("webapp.haptic","templates/getHaptic8082.html"),
		cssFile : ['main8082.css'],

		postCreate:function() {
			var data = webapp.haptic.data;

			// BACK BUTTON
			var backFunc = dojo.hitch( webapp.haptic, webapp.haptic.buttonCallback, data.BACK);
			ICTouchAPI.AppBarServices.addExitButton("haptic", "getHaptic", true, backFunc);

			ICTouchAPI.AppBarServices.setAppBar("haptic", "getHaptic", "getHaptic");

			// CHOICELIST
			data.intChoiceListSelected = 0;
			var _arrChoice = new Array();
			_arrChoice.push({
				intIndex: 0,
				strLabel: data.hapticTypes[0],
				boolSelected: true
			});

			for (var i=1; i<webapp.haptic.data.hapticTypes.length; i++) {
				_arrChoice.push({
					intIndex: i,
					strLabel: data.hapticTypes[i],
					boolSelected: false
				});
			}


			var choiceListCallback = dojo.hitch(webapp.haptic, webapp.haptic.onChoiceClicked);
			var selectList = new UIElements.SelectList.SelectListControl({
				arrItems: _arrChoice,
				intContainerSize: 6,
				itemCallback: choiceListCallback
			}, this.domChoiceList);
		}
	}
);