dojo.provide("webapp.userinfo.getUserInfoBase");
dojo.declare("webapp.userinfo.getUserInfoBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objUserInfo			: null,
		objUserTextInfo		: _("","webapp.userinfo"),
		_subscribeHandlers	: null,

		objPhoto			: null,

		// Dom references
        domPresenceIcon		: null,
        domForwardIcon		: null,
		domUserTextInfo		: null,
		domNameTop			: null,
		domNameBottom		: null,
		domUserIcons		: null,
		domUserPhotoLi		: null,

		// Variable for dom
		strPresenceIcon		: null,
        strForwardIcon		: null,
		strUserTextInfo		: null,
		strNameTop			: null,
		strNameBottom		: null,
		boolUserIcons		: null,
		strUserPhotoPath	: null,
		strCurrentDndMode	: null,

        postCreate:function(){
            webapp.userinfo.data.objUserInfoWidget = this;

			this._subscribeHandlers = this.objUserTextInfo.fillInnerHTML(this.domUserTextInfo);

			this.reload();
        },

        _clicked : function(){
			if (webapp.userinfo.data.accessRightToUserServices){
				ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
				if(this.webapp.data.boolModeMDR && !webapp.userservices.data.isGetRoutingProfilesMade()){
					ICTouchAPI.APIServices.Telephony.getRoutingProfiles({context: this});
					webapp.userservices.data.setGetRoutingProfilesMade(true);
				}
			}else{
				webapp.userservices.launchDndActivation();
			}
        },


		updateUserTextInfoStyle : function (){
			var data = webapp.userinfo.data;
			var currentDndMode = webapp.userinfo.data.currentDndMode;

			if((currentDndMode == data.DND_RED_MODE || currentDndMode == data.DND_GREEN_MODE) && this.strCurrentDndMode){
				dojo.style(this.domUserTextInfo, "font-size","16px");
				dojo.style(this.domUserTextInfo, "font-weight","bold");
			}
			if (currentDndMode == data.DND_RED_MODE && this.strCurrentDndMode != data.DND_RED_MODE){
				dojo.style(this.domUserTextInfo, "color","#ff1e38");
			}
			else if (currentDndMode == data.DND_GREEN_MODE && this.strCurrentDndMode != data.DND_GREEN_MODE){
				dojo.style(this.domUserTextInfo, "color","#5bac26");
			}

			this.strCurrentDndMode = currentDndMode;
		},

		updatePresenceIcon : function(strIcon) {
			if(!strIcon && !this.strForwardIcon){
				this.hideUserIcons();
			}
			if (this.strPresenceIcon != strIcon) {
				if(this.strPresenceIcon){
					dojo.removeClass(this.domPresenceIcon, this.strPresenceIcon);
				}
				if(strIcon){	
					dojo.addClass(this.domPresenceIcon, strIcon);
					this.showUserIcons();
				}
			}
			this.strPresenceIcon = strIcon;
			strIcon = null;
		},

		updateForwardIcon : function(strIcon) {
			if(!strIcon && !this.strPresenceIcon){
				this.hideUserIcons();
			}
			if (this.strForwardIcon != strIcon) {
				if(this.strForwardIcon){
					dojo.removeClass(this.domForwardIcon, this.strForwardIcon);
				}
				if(strIcon){
					dojo.addClass(this.domForwardIcon, strIcon);
					this.showUserIcons();
				}
			}
			this.strForwardIcon = strIcon;
			strIcon = null;
		},

		updatePhoto : function(strPhotoPath, boolUserPicture) {
			if(strPhotoPath != this.strUserPhotoPath){
				if(this.objPhoto){
					dojo.destroy(this.objPhoto);
					this.objPhoto = null;
				}
				this.objPhoto = dojo.create("img", {src: strPhotoPath || ICTouchAPI.tools.getDefaultPhotoPath("user", "70"), height:"64px", width:"64px"}, this.domUserPhotoLi);
				this.strUserPhotoPath = strPhotoPath;
			}

			if(!boolUserPicture){
				dojo.style(this.domUserPhotoLi, "display", "none");
			}else{
				dojo.style(this.domUserPhotoLi, "display", "table-cell");
			}

			strPhotoPath = null;
			boolUserPicture = null;
		},

		updateUserTextInfo : function(strUserTextInfo) {
			if(!this.webapp.data.boolModeMDR){
				this.objUserTextInfo = _("","webapp.userinfo");
			}else{
				this.objUserTextInfo = _("","webapp.userservices");
			}
			this._subscribeHandlers = this.objUserTextInfo.fillInnerHTML(this.domUserTextInfo);
			// ChangeText function is already verifying if the label changed or not.
			if(strUserTextInfo !== undefined && strUserTextInfo !== null){
				if(strUserTextInfo.isI18Ned){
					this.objUserTextInfo.changeText(strUserTextInfo.toTranslate);
				} else {
					this.objUserTextInfo.changeText(strUserTextInfo);
				}
			}
			strUserTextInfo = null;
		},

		updateNames : function(strFirstName, strLastName) {
			var strNameTop;
			var strNameBottom;

			if (ICTouchAPI.tools.isFirstNameFirstDisplayed() || webapp.userinfo.data.boolModeHotel) {
				strNameTop = strFirstName;
				strNameBottom = strLastName;
			}
			else {
				strNameTop = strLastName;
				strNameBottom = strFirstName;
			}

			if(strNameTop != this.strNameTop){
				this.domNameTop.innerText = strNameTop || "";
				this.strNameTop = strNameTop;
				if(this.strNameTop == ""){
					dojo.addClass(this.domNameTop,"UserNameNoDisplay");
				}else{
					dojo.removeClass(this.domNameTop,"UserNameNoDisplay");
				}
			}

			if(strNameBottom != this.strNameBottom){
				this.domNameBottom.innerText = strNameBottom || "";
				this.strNameBottom = strNameBottom;
			}
			strFirstName = null;
			strLastName = null;
		},

		showUserIcons : function() {
			if(this.boolUserIcons !== true){
				this.boolUserIcons = true;
				dojo.style(this.domUserIcons, "display", "table-cell");
			}
		},

		hideUserIcons : function() {
			if(this.boolUserIcons !== false){
				this.boolUserIcons = false;
				dojo.style(this.domUserIcons, "display", "none");
			}
			
			
		},

		reload : function(){
			var objUserInfo = webapp.userinfo.data.getUserInfo();

			// Update presence and forward
			this.updatePresenceIcon(objUserInfo.strUserPresenceIcon);
			this.updateForwardIcon(objUserInfo.strUserForwardIcon);

			// Update texts
			this.updateUserTextInfo(objUserInfo.strUserTextInfo);
			this.updateNames(objUserInfo.strUserFirstName, objUserInfo.strUserLastName);
			this.updateUserTextInfoStyle();

			// Update photo
			this.updatePhoto(objUserInfo.strUserPhotoPath, objUserInfo.boolUserPicture);
		},

		destroy : function() {
			if(this._subscribeHandlers){
				dojo.unsubscribe(this._subscribeHandlers);
				this._subscribeHandlers = null;
			}
			this.inherited(arguments);
		}

    }
);
