dojo.provide("webapp.userinfo.dataBase");
dojo.declare("webapp.userinfo.dataBase",null,{
	_objUserInfo				: null,
	objUserInfoWidget			: null,
	IMMEDIAT_FORWARD			: "FWD_UNCONDITIONAL",
	arrCurrentRouting			: [],
	boolDND						: false,
	boolShowDoNotDisturbLabel	: true,
	boolModeHotel				: false,
	boolModeMDR					: false,
	boolUserPicture				: true,
	accessRightToUserServices	: true,
	boolRemoveHttps				: true,

	DND_RED_MODE : "red",
	DND_GREEN_MODE : "green",
	DND_DEFAULT_MODE : "",

	currentDndMode	: "",

	constructor : function(){
		this._objUserInfo={
			strUserPresenceIcon				: "",
			strUserFirstName				: "",
			strUserLastName					: "",
			strUserTextInfo					: "",
			strUserForwardIcon              : "",
			strUserPhotoPath				: "",
			objPresence						: null
		};
		this.loadSettings();
	},

	loadSettings : function() {
		ICTouchAPI.settingServices.getSettingsFromIds([
			"EnableUserPicture",
			"UserName",
			"UserFirstName",
			"ActiveRouting",
			"TelephonyDndState",
			"ShowDoNotDisturbLabel"
			], this, this.loadedSettings);
	},

	loadedSettings : function(_arr) {
		if(_arr.EnableUserPicture !== null){
			this._objUserInfo.boolUserPicture = (_arr.EnableUserPicture.jsValue ? true : false);
		}
		if (_arr.UserName !== null) {
			this._objUserInfo.strUserLastName = _arr.UserName.jsValue;
		}
		if (_arr.UserFirstName !== null) {
			this._objUserInfo.strUserFirstName = _arr.UserFirstName.jsValue;
		}
		if (_arr.TelephonyDndState !== null && _arr.TelephonyDndState.jsValue) {
			this.boolDND = true;
		}
		if (_arr.ActiveRouting !== null) {
			if(!this.boolModeMDR){
				if (_arr.ActiveRouting.jsValue === "None" || _arr.ActiveRouting.jsValue === "" || _arr.ActiveRouting.jsValue === null || _arr.ActiveRouting.jsValue === undefined) {
					this.arrCurrentRouting = [];
				} else {
					var arrRoutingData = _arr.ActiveRouting.jsValue.split(":");
					this.arrCurrentRouting = arrRoutingData;
				}
			}
			if (_arr.ShowDoNotDisturbLabel !== null) {
				this.boolShowDoNotDisturbLabel = (_arr.ShowDoNotDisturbLabel.jsValue === true) ? true : false;
			}
		}
		this.setStrUserTextInfo();
		if (this.objUserInfoWidget) {
			this.objUserInfoWidget.reload();
		}
	},

	/**
	 * Set StrUserTextInfo, according to current routing and dnd state.
	 * Priority list :
	 * 1. Immediate forward
	 * 2. DND
	 * 3. Other forward
	 * 4. Presence
	 */
	setStrUserTextInfo : function() {
		if(!this.accessRightToUserServices){
			if (this.boolShowDoNotDisturbLabel) {
				if(this.boolDND) {
					this._objUserInfo.strUserTextInfo = "Do not Disturb - ON";
					this.currentDndMode = this.DND_RED_MODE;
					this._objUserInfo.strUserForwardIcon = "";
				}
				else{
					this._objUserInfo.strUserTextInfo = "Do not Disturb - OFF";
					this.currentDndMode = this.DND_GREEN_MODE;
					this._objUserInfo.strUserForwardIcon = "";
				}
			}
			else {
				// this._objUserInfo.strUserTextInfo = "";
				this._setStrUserTextInfoRouting();
			}
		}
		else{
			this.currentDndMode = this.DND_DEFAULT_MODE;
			if(this.boolDND) {
				if (this.arrCurrentRouting[0] === this.IMMEDIAT_FORWARD) {
					// DND and Immediate forward
					this._setStrUserTextInfoRouting();
				} else {
					// DND and (conditional forward or no forward)
					this._objUserInfo.strUserTextInfo = "Do not Disturb";
					this._objUserInfo.strUserForwardIcon = "";
				}
			} else {
				this._setStrUserTextInfoRouting();
			}
		}
	},

	_setRoutingProfileLabel : function(profile) {
		this.boolModeMDR=true;
		if(profile.profileName!=""){
			this._objUserInfo.strUserTextInfo = _(profile.profileName,"webapp.userservices");
		}else{
			this._objUserInfo.strUserTextInfo = _(profile.profileId.value.id,"webapp.userservices");
		}
		if(profile.profileName == "VOICEMAIL_DEVICE"){
			this._objUserInfo.strUserForwardIcon = ICTouchAPI.tools.getRoutingIcon("DST_VOICE_MAIL");
		}else{
			this._objUserInfo.strUserForwardIcon = ICTouchAPI.tools.getRoutingIcon("Other");
		}
		if (this.objUserInfoWidget) {
			this.objUserInfoWidget.reload();
		}
		profile = null;
	},


	/**
	 * Set the formated current routing as StrUserTextInfo.
	 */
	_setStrUserTextInfoRouting : function() {
		// If no forward enabled or my office phone, do not display icon / text
		if(!this.boolModeMDR){
			if (this.arrCurrentRouting.length == 0) {
				this._objUserInfo.strUserForwardIcon = "";
				this._objUserInfo.strUserTextInfo = "";
			}
			else {
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],this.arrCurrentRouting[2])[0];
				var routingDest = null;
				if(objContact){
					routingDest = objContact.name+" "+objContact.firstName;
				}else{
					routingDest = this.arrCurrentRouting[2];
				}
				var boolOther = (this.arrCurrentRouting[1] === "Other");
				this._objUserInfo.strUserForwardIcon = ICTouchAPI.tools.getRoutingIcon(this.arrCurrentRouting[1]);

				if(this.arrCurrentRouting[0] === this.IMMEDIAT_FORWARD) {
					this._objUserInfo.strUserTextInfo = ICTouchAPI.tools.formatRoutingLabel("", this.arrCurrentRouting[1], routingDest, boolOther, true);
				}
				else {
					if (boolOther) {
						this._objUserInfo.strUserTextInfo = ICTouchAPI.tools.formatRoutingLabel(this.arrCurrentRouting[0], this.arrCurrentRouting[1], routingDest, boolOther, true);
					}
					else {
						this._objUserInfo.strUserTextInfo = [this.arrCurrentRouting[0]];
					}
				}
			}
		}
	},

	getUserInfo : function(){
		return this._objUserInfo;
	},

	getUserLastName : function(){
		return   this._objUserInfo.strUserLastName;
	},

	getUserFirstName : function(){
		return   this._objUserInfo.strUserFirstName;
	}
});
