/*userinfo*/
// Provide and create the userinfo webapp.
dojo.provide("webapp.userinfo.controlBase");
dojo.declare("webapp.userinfo.controlBase",[ICTouchAPI.webApplication],{

boolIMAvailable : true,
boolIMAvailabilityChanged : false,
boolSubscibedPresence : false,

	constructor: function()	{

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userservices", "webapp.userinfo", true, true, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userinfo", "webapp.userinfo", true, true, true);//Load icons in middle iframe
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.notifications", "webapp.userinfo", true, true, true);
		ICTouchAPI.settingServices.subscribeToSetting(this, "IMAvailable",this.onIMActivated);
		ICTouchAPI.settingServices.getSetting("IMAvailable", this, this.onIMActivated);
		ICTouchAPI.settingServices.subscribeToSetting(this, "UserName", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "UserFirstName", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "UserPresence", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserPicture", this.onSettingChanged);
		/*ICTouchAPI.settingServices.subscribeToSetting(this, "RoutingLabel", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "RoutingIcon", this.onSettingChanged);*/
		ICTouchAPI.settingServices.subscribeToSetting(this, "ActiveRouting", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyDndState", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "ShowDoNotDisturbLabel", this.onSettingChanged);

		//ICTouchAPI.skinServices.linkWebappsStyles("webapp.communication","webapp.userinfo",true,true,true);
        ICTouchAPI.skinServices.linkWebappsStyles("webapp.getComlogPreview","webapp.userinfo",true,true,true);
        //ICTouchAPI.skinServices.linkWebappsStyles("webapp.contacts","webapp.userinfo",true,true,true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getContactPreview","webapp.userinfo",true,true,true);

		dojo.subscribe("ModeHotel", this, this.onForbidAccess);
		dojo.subscribe("ModeMultiDeviceRouting", this, this.onMDRMode);

		//dojo.subscribe("IM_AVAILABILITY_CHANGED",this,this.onIMAvailabilityChanged);
	},

	loaded : function(){
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "multideviceRouting", this, this.multiDeviceRoutingSelectionAvailability);
		dojo.subscribe("IM_AVAILABILITY_CHANGED",this,this.onIMAvailabilityChanged);
		dojo.subscribe("TELEPHONY_PRESENCE_AVAILABILITY_CHANGED", this, this.subscribePresence);
		dojo.subscribe("ProfileChanged", this.data, this.data._setRoutingProfileLabel);
		
		ICTouchAPI.eventServices.subscribeToEvent(this, "userPhotoChanged", this.onUserPhotoChanged);
	},

	load: function (){
		this.subscribePresence();
		//help
		dojo.publish("needHelpEvent",["userinfo",[]]);
	},

	onIMActivated : function(objSetting){
		if(objSetting){
			if(objSetting.jsValue==true){
				this.boolIMAvailable=true;
			}
			else{
				this.boolIMAvailable=false;
			}
		}

	},

	onIMAvailabilityChanged : function(imEnabled){
		this.boolIMAvailabilityChanged = imEnabled;
		this.subscribePresence();
	},

	subscribePresence : function() {
		if(this.boolIMAvailabilityChanged && ICTouchAPI.presenceServices.isTelephonyPresenceAvailable()){
			if(!this.boolSubscibedPresence){
				ICTouchAPI.eventServices.subscribeToEvent(this, "IM_SET_PRESENCE_NTF", this.setPresenceNTF);
				this.boolSubscibedPresence = true;
			}
			ICTouchAPI.APIServices.InstantMessaging.getPresence({context : this, params :[], callback: this.setPresenceNTFBoot});
		}
	},
	
	onUserPhotoChanged : function(strPhotoPath) {
		ICTouchAPI.debugServices.info("webapp.userinfo.controlBase - onUserPhotoChanged");
		if(strPhotoPath){
			var fileName = strPhotoPath.value;
			ICTouchAPI.debugServices.debug("webapp.userinfo.controlBase - onUserPhotoChanged / new Photo : " + fileName);
			this.data._objUserInfo.strUserPhotoPath = fileName;

			if (this.data.objUserInfoWidget) {
				this.data.objUserInfoWidget.reload();
			}
		}
		else {
			ICTouchAPI.debugServices.error("webapp.userinfo.controlBase - onUserPhotoChanged / Invalid argument");
		}
	},

	onSettingChanged: function(objSetting) {
		var data = webapp.userinfo.data;
		if(objSetting) {
			switch (objSetting.id) {
				case "EnableUserPicture":
					data._objUserInfo.boolUserPicture = (objSetting.jsValue ? true : false);
					break;
				case "UserName":
					data._objUserInfo.strUserLastName = objSetting.jsValue;
					break;
				case "UserFirstName":
					data._objUserInfo.strUserFirstName = objSetting.jsValue;
					break;
				case "ActiveRouting":
					if(!data.boolModeMDR){
						if (objSetting.jsValue === "None" || objSetting.jsValue === "" || objSetting.jsValue === null || objSetting.jsValue === undefined){
							data.arrCurrentRouting = [];
						}else{
							var arrRoutingData = objSetting.jsValue.split(":");
							data.arrCurrentRouting = arrRoutingData;
						}
						data.setStrUserTextInfo();
					}
					break;
				case "TelephonyDndState":
					if(objSetting.jsValue){
						data.boolDND = true;
					} else {
						data.boolDND = false;
					}
					data.setStrUserTextInfo();
					break;
				case "ShowDoNotDisturbLabel":
					if(objSetting.jsValue){
						data.boolShowDoNotDisturbLabel = true;
					} else {
						data.boolShowDoNotDisturbLabel = false;
					}
					data.setStrUserTextInfo();
					break;
			}
			if (data.objUserInfoWidget) {
				data.objUserInfoWidget.reload();
			}
		}
	},

	setPresenceNTF: function(objPresence) {
		if (objPresence && objPresence.value) {
			this.setMyPresence(objPresence.value);
		}
		objPresence = null;
	},

    setPresenceNTFBoot : function(objPresence){
		if (objPresence && objPresence.length > 0) {
			this.setMyPresence(objPresence.pop());
		}
		objPresence = null;
    },

	setMyPresence : function(objPresence) {
		var data = this.data;
		if (objPresence && objPresence.imPresenceValue) {
			data._objUserInfo.objPresence = objPresence;

			//get the presence icon path
			data._objUserInfo.strUserPresenceIcon = ICTouchAPI.tools.getTelephonyPresenceIconPath(objPresence.telephonicPresenceValue.value.labelStatus, "32");
			data.setStrUserTextInfo();
			//refresh the widget
			if (data.objUserInfoWidget) {
				data.objUserInfoWidget.reload();
			}
			//data._setLEDStatus();
		}
		objPresence = null;
	},

	getUserInfo:function() {
		return this.data.getUserInfo();
	},

	onForbidAccess:function(){
		this.data.boolModeHotel = true;
		this.data.accessRightToUserServices = false;
		this.data.setStrUserTextInfo();
		if (this.data.objUserInfoWidget) {
			this.data.objUserInfoWidget.reload();
		}
	},

	onMDRMode:function(){
		this.data.boolModeMDR=true;
		//dojo.publish("RequestCurrentProfile");
	},


	multiDeviceRoutingSelectionAvailability : function(capability,value){
		if(value == ICTouchAPI.CapabilityServices.AVAILABLE){
			this.data.boolModeMDR=true;
			//dojo.publish("RequestCurrentProfile");
		}
		value=null;
	}
});
