dojo.provide("webapp.date.getDateTimeConfigureContentBase");
dojo.declare("webapp.date.getDateTimeConfigureContentBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
        domScrollSelectDivHours     : null,
        domScrollSelectDivMinutes   : null,
        domNumeralSelect            : null,
        domVolumeSlider             : null,
		strDate : "",
		strTime : "",
		timeout : null,
		 attributeMap: {
            strDate: {node: "domDate",type: "innerText"},
            strTime : { node: "domStrTime", type: "innerText"}
        },


        postMixInProperties:function(){
			this.strDate = _("Date", "webapp.date");
			this.strTime = _("Time", "webapp.date");
        },

        postCreate:function(){
            var data = webapp.date.data;

			webapp.date.data.objTimeUI = new UIElements.ValueSelect.TimeSelect({
				intHourValue: data.objTime.h,
				intMinuteValue: data.objTime.m,
				is24hourFormat : webapp.date.data._bool24hformat,
				callback: dojo.hitch(this, this.startTimeout)
			}, this.domTime);

            // Calendar
            webapp.date.data.objCalendarUI = new UIElements.Calendar.CalendarControl({
				boolShowHeader: true,
				strCalendarType: "small",
				onValueSelectedCallBack : dojo.hitch(this.webapp, this.webapp.onValidate)
			}, this.domCalendar);
            var date = webapp.date.data.objCalendarUI.attr("displayMonth");


            // save this widget
            webapp.date.dateTimeConfigureContent = this;
        },

        destroy : function(){
			webapp.date.data.objTimeUI.destroy();
             webapp.date.data.objCalendarUI.destroy();
             this.inherited(arguments);

        },

		startTimeout : function(){
			if (this.timeout){
				clearTimeout(this.timeout);
        }
			this.timeout = setTimeout(
				dojo.hitch(this.webapp, this.webapp.onValidate),
				2000
			)
		}
});
