dojo.provide("webapp.date.getDateBase");
dojo.declare("webapp.date.getDateBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
        strTime		: "",
        strDate		: "",
        strTimeMode     : "",
		datePattern		: "",
		boolBlinking	: false,

        attributeMap: {
            strTime: {node: "domTime",type: "innerHTML"},
            strTimeMode : { node: "domTimeMode", type: "innerHTML"},
            strDate: {node: "domDate",type: "innerHTML"}
        },

        _setBoolBlinkingAttr: function(blink) {
			this.boolBlinking = ( blink === true );
			dojo.toggleClass(this.domNode, "update", this.boolBlinking);
		},

		postMixInProperties : function() {
			this.boolBlinking = ! webapp.date.isDateSet();
			webapp.date._base = this;
		},

        postCreate : function() {
			var that=this;
            webapp.date.startTime = function(){that.startTime()};
            // launch timer
            webapp.date.startTime();
            webapp.date.objDateTime = this;
        },

        startTime : function() {
            this.updateTime();
            if( this.intervalHandler ){
                clearInterval(this.intervalHandler);
            }
            var that = this;
			var func = function () {
				that.updateTime();
			};
			this.intervalHandler = setInterval(func, 1000);
        },

        updateTime: function () {
            var objDate = new Date();
            var strTime = objDate.format(webapp.date.data.getTimePattern(),dojo.locale);

            //  split to retrieve am and pm
            var tempArr  = strTime.split(' ');
            var strTime2 = tempArr[0]; // always exist
            var strTimeMode  = (tempArr[1])?tempArr[1]:'';

            this.attr("strTime", strTime2);
            this.attr("strTimeMode", strTimeMode.toLowerCase() );
            this.attr("strDate", ICTouchAPI.tools.ucfirst(objDate.format(webapp.date._datePattern/*this.datePattern*/, dojo.locale)));
        },

        destroy: function () {
            if( this.intervalHandler ){
                clearInterval(this.intervalHandler);
            }
        },

        _clicked : function(){
			if(!webapp.date.boolSNTP){
				ICTouchAPI.transitionServices.getScreen({name: "webapp.date.getDateTimeConfigure",params: {}});
				if(this.webapp.data.configureBase){
					webapp.date.data.initObjTime();
					webapp.date.data.objTimeUI.setValue(webapp.date.data.objTime.h, webapp.date.data.objTime.m);

					// refresh UIEls
					webapp.date.data.objTimeUI.set24hourFormat(webapp.date.data._bool24hformat);
					webapp.date.data.objCalendarUI.selectDate(new Date());
			}
				else{
					if(!this._clickHandler){
						this._clickHandler = dojo.subscribe("iframe.show", dojo.hitch(this, this._refreshDateTimeUIs));
		}
    }
			}
		},

		_refreshDateTimeUIs:function(currentIframeId){
			if(currentIframeId == "webapp.date.getDateTimeConfigure"){
				webapp.date.data.initObjTime();
				webapp.date.data.objTimeUI.setValue(webapp.date.data.objTime.h, webapp.date.data.objTime.m);

				// refresh UIEls
				webapp.date.data.objTimeUI.set24hourFormat(webapp.date.data._bool24hformat);
				webapp.date.data.objCalendarUI.selectDate(new Date());
				dojo.unsubscribe(this._clickHandler);
			}
		}


    }
);
