/*date*/
// Provide and create the date webapp.
dojo.provide("webapp.date.controlBase");
dojo.declare("webapp.date.controlBase",ICTouchAPI.webApplication,{

    boolSNTP    : true,
    boolDateSet : true,
    objDateTime : null,
	_datePattern : "EEEE dd MMMM yyyy",


	// SNTP allowed values defined by Platform
	SNTP_YES	: "YES",
	SNTP_NO		: "NO",
	SNTP_SYNC	: "SYNC",

    constructor: function() {
		ICTouchAPI.settingServices.subscribeToSetting(this, "CurrentEnetcfgSntpSyncStatus", this.checkedSNTP);
		ICTouchAPI.settingServices.subscribeToSetting(this, "IsLocalDateSet", this.onLocalDateSet);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "CurrentAdmcfgDateTime", this.onDateTimeSet);
		ICTouchAPI.settingServices.getSetting("CurrentEnetcfgSntpSyncStatus", this, this.checkedSNTP);
		dojo.subscribe("languageChanged",this,this.onLanguageChanged);
    },
    getApplicationName : function(){
		return "webapp.date";
    },

        load : function ()
    {
        // init preview
        dojo.publish("needHelpEvent",["date",["getDateTimeConfigure"]]);
		ICTouchAPI.settingServices.getSetting("DateFormat",this,this.onDateFormatChanged);
    },

    buttonCallback : function(buttonId) {
        var data = webapp.date.data;
        switch(buttonId)
        {
            case data.BACK:
				dojo.publish("OpenHomepage");
                break;
            default:
                console.warn("buttonCallbak : no callback is defined for this button id:"+buttonId);
        }
    },

    //refresh the date container when the systeme date has been changed
    onDateTimeSet : function(){
        //webapp.date.objDateTime.updateTime();
        webapp.date.startTime();
		dojo.publish("dayChanged");
    },

    onDateFormatChanged : function (objSetting) {
            // Changed DateFormat
		var order;
            if (objSetting) {
			order = objSetting.allowedValues[objSetting.jsValue].name.split('/');
		}
		else {			
			order = ICTouchAPI.tools.getDateFormat().split('/');
		}

		if(ICTouchAPI.i18nServices.getLocale() === "ja") {
			//d日M月y年 EEEE
			webapp.date._datePattern = "";					
			var func = function(item){
				if(item){
					switch(item){
						case "dd" :
							return "dd日";// break;
						case "mm" :
							return "MMMM"; //break;
						case "YYYY" :
							return "yyyy年"; //break
						default :
							return ""; //break;
					}
				}else{
					return "";
				}
			};
			for(var i in order){
				order[i] = func(order[i]);
				webapp.date._datePattern += order[i];						
			}
			webapp.date._datePattern += " EEEE";
		}
		else if (ICTouchAPI.i18nServices.getLocale() === "ko") {
			// y년 M월 d일 EEEE
			webapp.date._datePattern = "";
			var func = function(item){
				if(item){
					switch(item){
						case "dd" : return "d일";// break;
						case "mm" : return "MMMM"; //break;
						case "YYYY" : return "yyyy년"; //break
						default : return ""; //break;
					}
				}else{
					return "";
				}
			};
			for(var i in order){
				order[i] = func(order[i]);
				webapp.date._datePattern += order[i]+" ";
			}
			webapp.date._datePattern += " EEEE";
		} else if(ICTouchAPI.i18nServices.getLocale() === "zh-cn" || ICTouchAPI.i18nServices.getLocale() === "zh-tw") {
			//2006年1月29日
			webapp.date._datePattern = "";
			var func = function(item){
				if(item){
					switch(item){
						case "dd" :
							return "dd日";// break;
						case "mm" :
							return "MMMM"; //break;
						case "YYYY" :
							return "yyyy年"; //break
						default :
							return ""; //break;
					}
				}else{
					return "";
				}
			};
			webapp.date._datePattern += "EEEE ";
			for(var i in order){
				order[i] = func(order[i]);
				webapp.date._datePattern += order[i];
			}
		}else{
                    //"EEEE dd MMMM yyyy"
					webapp.date._datePattern = "EEEE ";
					var func = function(item){
						if(item){
							switch(item){
						case "dd" :
							return "dd";// break;
						case "mm" :
							return "MMMM"; //break;
						case "YYYY" :
							return "yyyy"; //break
						default :
							return ""; //break;
							}
						}else{
							return "";
						}
					};
					for(var i in order){
						order[i] = func(order[i]);
						webapp.date._datePattern += order[i]+" ";
					}
            }

		webapp.date.objDateTime.updateTime();		
    },

    onTimeFormatChanged : function (objSetting) {
		// Changed timeFormat
		if (objSetting) {
				this.data._bool24hformat = objSetting.jsValue;
			try{
				webapp.date.data.objTimeUI.is24hourFormat = webapp.date.data._bool24hformat;
				webapp.date.data.objTimeUI.setValue(webapp.date.data.objTime.h, webapp.date.data.objTime.m);
				// refresh UIEls
				webapp.date.objDateTime.updateTime();
			}catch(err){
				console.error(err);
			}

		}
    },

    onLocalDateSet : function (objSetting) {
		if (objSetting) {
			this.checkedLocalDateSet(objSetting.jsValue);
		}
    },

	onLanguageChanged : function() {
		this.onDateFormatChanged();
	},

    checkedSNTP : function (setting) {
        this.boolSNTP = (setting && setting.value != this.SNTP_NO);
			if (!this.boolSNTP) {
				ICTouchAPI.settingServices.setSettingValue("IsLocalDateSet", false, this);
				this.checkedLocalDateSet(false);
			}
    },

    checkedLocalDateSet : function (settingValue) {
        this.boolDateSet = settingValue;
        if (this.objDateTime){
            this.objDateTime.attr("boolBlinking", !settingValue);
        }
    },

    isDateSet : function () {
        return this.boolDateSet;
    },

    onValidate : function () {
        // gets datas from UIElement
		var values = this.data.objTimeUI.getValue();
        this.data.objTime.h = values[0];
        this.data.objTime.m = values[1];
        this.data.objDate   = this.data.objCalendarUI.getValue();

        var hours = this.data.objTime.h;
        var minutes = this.data.objTime.m;

        // am pm correction, cause system need a 24h format time
        if(!webapp.date.data._bool24hformat && webapp.date.data.objSliderUI)
        {
            if(webapp.date.data.objSliderUI.intIndex === 1)
            {
                // pm
                hours  = hours + 12;
				if(hours == 24) {
					hours = 12;
				}
			} else {
				if(hours == 12) {
					hours = 0;
				}
			}
        }

        this.data.objDate.setHours(hours);
        this.data.objDate.setMinutes(minutes);
        var strToSave = this.data.objDate.format('yyyy-MM-dd HH:mm',dojo.locale);

        this.saveDateTime(strToSave);
        this.checkedLocalDateSet(true);
    },

    saveDateTime : function (strToSave) {
        ICTouchAPI.settingServices.setSettingValue("CurrentAdmcfgDateTime", strToSave);
    }
});
