#!/bin/sh
#
# sntpd.sh
#
# start the sntp pseudo daemon

# exec > /dev/null 2>&1

PIDFILE=/var/run/sntp.pid
WAITPIDFILE=/var/run/sntpd_wait.pid
STATEFILE=/var/tmp/sntpd.state

FIRST_SEC=2
RETRY_SEC=30

Trace_Emerg() {
  logger -t sntpd -p local1.emerg $*
}

Trace_Debug() {
  logger -t sntpd -p local1.info $*
}

WaitSec() {
  sleep $1 &
  SLEEP_PID=$!
  echo $SLEEP_PID > $WAITPIDFILE
  wait $SLIP_PID
  rm $WAITPIDFILE
}

update_time() {
   # -r     : reset by settimeofday
   # -P no  : no prompt
   # -x <n> : refresh all <n> minutes
   # -4     : force IPv4 DNS resolution
   # -6     : force IPv6 DNS resolution
   logEmerg=$1
   firstErr=0
   while [ 1 ]; do
     sntpFreeze=`ls /tmp/sntp_freeze.* 2>/dev/null | wc -w`
     if [ $sntpFreeze != 0 ] ; then
        WaitSec $RETRY_SEC
     else
           if [ $firstErr = 0 ]; then
              Trace_Debug -t "Connecting to sntp server $NTP_SERVER ..."
           fi
           sntp -r -P no -c 1 -d 15 -l $PIDFILE $NTP_SERVER
           status=$?
           if [ $status != 0 ]; then
              if [ $firstErr = 0 ]; then
                 firstErr=1
                 Trace_Debug "Failed. Will retry each $RETRY_SEC seconds"
                 CLISettings set CURRENT ENETCFG_SNTP_SYNC_STATUS NO > /dev/null 2>&1
              fi
              WaitSec $RETRY_SEC
           else
              if [ $logEmerg = 1 ]; then
                 Trace_Emerg "Connection to sntp server $NTP_SERVER: OK"
              else
                 Trace_Debug "Connection to sntp server $NTP_SERVER: OK"
              fi
              CLISettings set CURRENT ENETCFG_SNTP_SYNC_STATUS YES > /dev/null 2>&1
              /etc/cron.hourly/updateTimestamp
              break
           fi
     fi
   done
}

# Main 

if [ ! -f /usr/bin/sntp ]; then
   Trace_Emerg "No sntp daemon found"
   exit 1
fi

# Killing running processes and remove attached files
killall -q sntp
rm -f $PIDFILE
rm -f $STATEFILE
rm -f $WAITPIDFILE

# get and check NTP server
NTP_SERVER=$1
if [ -z $NTP_SERVER ] ; then
   Trace_Emerg "No NTP server defined"
   exit 1
fi

# get refresh tempo
REFRESH_SEC=$2
if [ -z $2 ] ; then
   REFRESH_SEC=3600
fi

# 1st call 
WaitSec $FIRST_SEC
update_time 1
# restart as pseudo-daemon
while [ 1 ]; do
  Trace_Debug "Next refresh into $REFRESH_SEC seconds"
  WaitSec $REFRESH_SEC
  update_time 0
done


