#/bin/sh

# get_ubinames.sh
# written by G.CATTO
#
# in 1 call, retrieve the ubi partition's name associated to its version
# for all the available partitions on all possible flashs

VOL=0
PART=0
UBIVOLS=$(ubinfo | tail -n 3 | head -n 1 | tr -d ' ' |cut -d':' -f2) 

while [[ $VOL -lt $UBIVOLS ]]
do
	UBIPARTS=$(ubinfo --devn=$VOL | head -n 2 | tail -n 1 | tr -d ' ' |cut -d':' -f2) 
	while [[ $PART -lt $UBIPARTS ]]
	do
		PARTNAME=$(ubinfo --devn=$VOL --vol_id=$PART | tail -n 2 | head -n 1 | tr -d ' ' | cut -d ':' -f2)
		echo "$PART-$PARTNAME"
		PART=$(expr $PART + 1)
	done
	VOL=$(expr $VOL + 1)
done

