/*lock*/
// Provide and create the lock webapp.
dojo.provide("webapp.lock.controlBase");
dojo.declare("webapp.lock.controlBase",[ICTouchAPI.webApplication],{

	uiLock : null,
	LOCK : "LOCK_BTN",
	passwordType : null,
	emergencySize		: 3,
	strDTMFPatern : null,
	boolEnableLockOnHomepage : false,

	loaded: function() {
		// Subscribe to the event UserPwdRequiredEvent (ICE, OXO).
		// Subscription to this event is done in the loaded function because the UserPwdRequiredEvent event
		// is sent (if it has to be sent) by WSManager after that the presentationLoaded event is sent by
		// presentation. This presentationLoaded event is sent before the webapp constructors are called,
		// but after the webapp loaded function execution.
		ICTouchAPI.eventServices.subscribeToEvent(this, "UserPwdRequiredEvent", this.pwdRequired);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.lock","webapp.communication",true,false,true,false);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.lock","webapp.audiosetting",true,false,true,false);

		ICTouchAPI.CapabilityServices.subscribeToCapability("IctUser", "Lock", this, this.lockCapabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("IctUser", "Unlock", this, this.unlockCapabilityCallback);

		dojo.subscribe("customExitForLockVVM", this.data, this.data.setCustomExitForVVM);

		this.loadSettings();
	},

	constructor: function() {
		//dojo.addOnLoad(this, this.loaded);
		// add button to homepage appbar
		var func = dojo.hitch( this, this.lock);

		ICTouchAPI.settingServices.subscribeToSetting(this, "DTMFPattern", this.onDTMFPaternChanged);
		ICTouchAPI.settingServices.getSetting("DTMFPattern", this, this.onDTMFPaternChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableLockOnHomepage", this.onEnableLockOnHomepageChanged);
		ICTouchAPI.settingServices.getSetting("EnableLockOnHomepage", this, this.onEnableLockOnHomepageChanged);

		ICTouchAPI.eventServices.subscribeToEvent(this, "LockEvent", this.notifyLockEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "lockTerminalEvent", this.notifyLockTerminalEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "unlockTerminalEvent", this.notifyUnlockTerminalEvent);

		ICTouchAPI.tools.onLoadedWebapp("webapp.settings", this, this._overrideSettingChangeOXOPwd);
	},

	lockCapabilityCallback : function(capability, value) {
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.lockCapability = true;
		} else {
			this.data.lockCapability = false;
		}
	},

	unlockCapabilityCallback : function(capability, value) {
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.unlockCapability = true;
		} else {
			this.data.unlockCapability = false;
		}
	},

	// Callback of event UserPwdRequiredEvent
	pwdRequired : function () {
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var type = args["pwdType"];
		//console.log(arguments);
		//console.log(args);
		//console.log(type);
                // Test vobs
		if(type == "ICS_Password"){
			var func = function () {
				webapp.lock.passwordType = "ICS";
				ICTouchAPI.transitionServices.getScreen({
					name:"webapp.lock.getICSPassword",
					params:{},
					position: "FullScreen"});
				webapp.lock.deployICSPasswordKeyboard();
			};
			setTimeout(func, 100);
		}
		if(type == "Change_Password"){
			var that = this;
			var func = function () {
				that.switchToChangePasswordView(false);
			};
			setTimeout(func, 100);
		}
		if(type == "ICS_change_Password_failed"){
			var comment = args["comment"];
			if(comment =="ERROR_AUTHENTICATION_FAILED"){
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The entered old password is wrong.","webapp.lock"), "OK");
			}
			if(comment =="ERROR_BAD_PARAMETER_VALUE"){
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The entered new password is not correct.","webapp.lock"), "OK");
			}
			if(comment =="REQUEST_FAILED"){
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The password change has encountered an unexpected error.","webapp.lock"), "OK");
			}
		}
	},

	onDTMFPaternChanged : function(objSetting) {
		if(objSetting){
			this.strDTMFPatern = objSetting.jsValue;
		}
	},

	onEnableLockOnHomepageChanged : function(objSetting) {
		if(objSetting && objSetting.jsValue != this.boolEnableLockOnHomepage){
			this.boolEnableLockOnHomepage = objSetting.jsValue;
			if(this.boolEnableLockOnHomepage) {
				ICTouchAPI.tools.registerHomepageButton(["webapp.lock.getLockConfirmation", this.LOCK, "generic-lock", _('Lock',"webapp.lock"), null, null, null/*, [{module : "IctUser", capability :"Lock"}]*/]);
				ICTouchAPI.tools.registerHomepageKey(["webapp.lock.getLockConfirmation", this.LOCK, "generic-lock", _('Lock',"webapp.lock"), null, function(){ICTouchAPI.transitionServices.getScreen({name: "webapp.lock.getLockConfirmation", params:{}})}, null/*, [{module : "IctUser", capability :"Lock"}]*/]);
			} else {
				ICTouchAPI.tools.unregisterHomepageButton([this.LOCK]);
				ICTouchAPI.tools.unregisterHomepageKey([this.LOCK]);
			}
		}
	},

	// Public function
	load: function() {
		//help
		dojo.publish("needHelpEvent",["lock",["getLock"]]);
	},

	// Lock the phone and throw the event to ICTGate
	lock : function() {
		ICTouchAPI.APIServices.IctUser.lockRequest({context:this, callback:null, callbackParams:null}) ;
	},

// End of public function

	/** Function for Settings **/
    // get settings for the webapp
    loadSettings : function() {
		ICTouchAPI.settingServices.subscribeToSetting(this, "IctUserLocked", this.lockSettingChanged);
		ICTouchAPI.settingServices.getSettingValue("IctUserLocked", this, function(setting){
			this.setLockSettingData(setting);
		});
        // gets the emergency numbers
		var arrEmergencySettings = [];
		for (var i=1;i <= this.emergencySize;i=i+1){
			// Subscribe to change of number settings
			ICTouchAPI.settingServices.subscribeToSetting(this, "EmergencyNumber"+i, this.numberChanged);
			// Subscribe to change of label settings
			ICTouchAPI.settingServices.subscribeToSetting(this, "EmergencyLabel"+i, this.labelChanged);
			// Subscribe to change of icon settings
			ICTouchAPI.settingServices.subscribeToSetting(this, "EmergencyIcon"+i, this.iconChanged);
			arrEmergencySettings.push("EmergencyNumber"+i);
			arrEmergencySettings.push("EmergencyLabel"+i);
			arrEmergencySettings.push("EmergencyIcon"+i);
		}
		ICTouchAPI.settingServices.getSettingsFromIds(arrEmergencySettings, this, this.loadedSettings);
    },

    loadedSettings : function(_arr) {
		var func = this.buttonCallback;
		for (var i=1;i <= this.emergencySize;i=i+1){
			if (_arr["EmergencyNumber"+i] && _arr["EmergencyNumber"+i].jsValue) {
				var objButton = {
					strButtonName: this.data.EMERGENCY_BTNS[i-1],
					strButtonLabel: _arr["EmergencyLabel"+i].jsValue,
					strButtonIcon: _arr["EmergencyIcon"+i].jsValue,
					strNumber: _arr["EmergencyNumber"+i].jsValue,
					capabilities: [{module : "Telephony", capability : "makeCall"}],
					callback: dojo.hitch( this, func)
				};
				this.data.addButton(objButton);
			}
		}
    },

	// Override ChangeOXOPassword setting : allow the user to change his OXO password from the settings (go to the change password view)
	_overrideSettingChangeOXOPwd : function()
	{
		var that = this;
		var func = function() {that.switchToChangePasswordView(true)};
		webapp.settings.overrideSetting("ChangePassword",func);
	},
    /** End settings function **/

	goToConfirmLockScreen: function() {
		var isLocked = this.data.getLockPhone();
		if(isLocked == false) {
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.lock.getLockConfirmation",
				params:  {}
			});
		}
	},

	// Lock the Phone (show Lock screen)
	lockPhone: function() {
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.lock.getLock",
			params:  {},
			position: "FullScreen"
		});
		if(webapp.communication) {
			webapp.communication.checkForCallToDisplay();
		}
		dojo.publish("phoneLocked");
	},

	// unlock the phone (hide Lock Screen)
	unlockPhone: function() {
		//// reset password
		if(this.data.objInputPassword) {
			this.data.objInputPassword.setValue("");
		}
		if(!this.data.customExit){
			dojo.publish("OpenHomepage");
		}else{
			dojo.publish("resetCustomExit",["lock"]);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.voicemail.getVoicemail",
				params: {}
			});
		}
		if(webapp.communication) {
			webapp.communication.deleteAllPopupCall();
			webapp.communication.cleanseTimerPopup();
		}
	},

    // handlers for buttons clicks
    buttonCallback : function(buttonId) {
		var data = webapp.lock.data;
		switch(buttonId)
		{
			case data.CONFIRM_CHANGE_PWD:
				this.confirmChangePwdCallback();
				break;

			case data.DISMISS_CHANGE_PWD:
			case data.HOME:
				dojo.publish("OpenHomepage");
				break;

			case data.CONFIRM_LOCK :
				this.lock();
				break;

			case data.UNLOCK :
				this.deployICSPasswordKeyboard();
				break;

			// If buttonId is not CONFIRM_CHANGE_PWD or DISMISS_CHANGE_PWD, check for emergency buttons
			default:
			var buttons = webapp.lock.data.getButtons();
			var number;
			for (var i in buttons) {
				if (buttons[i].strButtonName == buttonId){
					number = buttons[i].strNumber;
					var boolDTMF = false;
					if(number.indexOf(this.strDTMFPatern) === 0){
						boolDTMF = true;
						number = number.substr(this.strDTMFPatern.length, number.length - this.strDTMFPatern.length);
					}
					ICTouchAPI.APIServices.Telephony.startPhoneCall({params:[number, false, true, boolDTMF], context:this}) ;
				}
			}
		}
    },

	isLocked : function() {
		if(this.data) {
			return this.data.getLockSetting();
		}
		return false;
    },


	/*
	 * Allow the user to change his OXO password from the settings : go to the change password view.
	 */
	switchToChangePasswordView: function(_boolDisplayLabel){
		this.data.boolChangePasswordInitByUser=_boolDisplayLabel;
		if(this.data.changePasswordView){
			this.data.changePasswordView.displayPasswordInfo();
		}
		ICTouchAPI.transitionServices.getScreen({
			name:"webapp.lock.getChangePassword",
			params:{}
		});
	},

	// function called for the change password view when user press on OK button
	// Check if the new password is not empty and if the new password and check new password fields are
	// identical before calling the buiness function which set the new password
	confirmChangePwdCallback : function() {
		var data = webapp.lock.data;
		if (data.objNewPassword && data.objCheckNewPassword) {
			// Check if the 2 entered passwords are identical
			if (data.objNewPassword.getInputFieldContent() == data.objCheckNewPassword.getInputFieldContent() ){
				// Check if the 2 entered passwords are not an empty string
				if (data.objNewPassword.getInputFieldContent()!="" && data.objOldPassword.getInputFieldContent()!="") {
					ICTouchAPI.APIServices.WSManager.changePassword({params:[data.objOldPassword.getInputFieldContent(),data.objNewPassword.getInputFieldContent()]});
					if(this.isLocked()) {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.lock.getLock",
							params:  {},
							position: "FullScreen"
						});
					} else {
					dojo.publish("OpenHomepage");
				}
				}
				else { // Password are empty strings, ask the user to enter passwords
					ICTouchAPI.popupServices.basicPopup("warning", "", _("Passwords are not specified.","webapp.lock"), "OK");
				}
			}
			else { // Entered passwords are different, display a warning popup telling the user that he have to enter identical passwords
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The entered passwords are not identical.","webapp.lock"), "OK");
			}
			data.objNewPassword.setInputFieldContent("",false,true);
			data.objCheckNewPassword.setInputFieldContent("",false,true);
			data.objOldPassword.setInputFieldContent("",false,true);
		}

	},
	// handler for password entry
	passwordCallback : function(password) {
		var that = this;
		if(this.passwordType == "ICS"){
			ICTouchAPI.APIServices.WSManager.submitUserPassword({params:[password, false], context:that, callback:that.gotICSPassword});
			// To remove when we will have a callback for submitUserPassword
			//this.back();
		} else {
			if(webapp.communication && webapp.communication.data) {
				if(webapp.communication.data.getCountCalls() > 0 && webapp.lock.data && !webapp.lock.data.unlockCapability) {
					var strMessage = _("You cannot unlock the phone during a phone call.", "webapp.lock");
					ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("Ok", "ICTouchAPI"));
					return ;
				}
			}
			if(webapp.lock.data.unlockCapability) {
				ICTouchAPI.APIServices.IctUser.unLockRequest({params:[password]});
			}
		}
		//this.data.objInputPassword.setInputFieldContent("",false);
		//this.data.objInputPassword.setValue("");
	},

	onExitPassword : function() {

	},

	onExitICSPassword : function() {
		if(this.passwordType == "ICS") {
			var that = this;
			ICTouchAPI.APIServices.WSManager.submitUserPassword({params:["", true], context:that, callback:that.gotICSPassword});
			//this.back();
		}
	},

	// Return of core function submitUserPassword
	gotICSPassword : function(intReturn) {
		if(intReturn) { // Success, intReturn to validate
			this.back();
		} else {
			return;
			//TODO : print something to show that it failed
		}
	},

	// Back function of ICS Password
	back : function() {
		this.passwordType = null;
		this.data.objInputPassword.setValue("");
		dojo.publish("OpenHomepage");
	},

	closePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.popupError);
	},

	// call a number via communication webapp
	callSpecialNumber : function(number) {
		webapp.communication.apiCall(number, false);
	},

    notifyLockEvent : function(objState) {
		if(!this.data) {return;}

		var state = objState.value;
		if(state){
			dojo.publish("requestCustomVVMExit",["lock"]);
		}
		this.data.setLockPhone(state || state == "true");

		this.lockUnlock();
    },

	lockUnlock : function() {
		if(!this.data) {return;}

		var isLocked = this.data.getLockPhone();
		var isSettingLocked = this.data.getLockSetting() ;

		if(!isLocked && !isSettingLocked) {
			this.unlockPhone();
		} else if(isLocked && isSettingLocked) {
			this.lockPhone();
		}
	},

    notifyLockTerminalEvent : function() {
		//this.lockPhone();
    },

	notifyUnlockTerminalEvent : function(boolOK) {
		if(boolOK) {// Good password
			//this.unlockPhone();
		} else { // Wrong password
			// confirmation popup
			var context = this;
			var strContent = _("You entered an invalid password.","webapp.lock");
			var popupError = {
				strTitle: _("Invalid password", "webapp.lock"),
				strType: "error",
				strContent: strContent,
				arrPopupButtons: []
			};
			this.popupError = ICTouchAPI.popupServices.addNewPopup(popupError, "MEDIUM");
			var that = this;
			var func = function () {
				that.closePopup();
			}
			setTimeout(func,4000); // 4 seconds
		}
	},

	// Callback when an emergency number changes
	numberChanged : function(objSetting) {
		var button = this.data.getButton(objSetting.id);
		if(button){
			if(objSetting.value == "") {
				button.hide();
			} else {
				button.strNumber = objSetting.value;
				button.show();
			}
		}
	},

	// Callback when an emergency label changes
	labelChanged : function(objSetting) {
		var button = this.data.getButton(objSetting.id);
		button.attr("strButtonLabel", _(objSetting.value, "webapp.lock"));
	},

	// Callback when an emergency icon changes
	iconChanged : function(objSetting) {
		var button = this.data.getButton(objSetting.id);
		button._setStrButtonIconAttr(objSetting.value);
	},

	lockSettingChanged : function(setting){
		if(!this.data) {return;}

		this.data.setLockSetting(setting.value);

		this.lockUnlock();
	},

	deployICSPasswordKeyboard : function() {
		if (this.data.objInputPassword) {
			this.data.objInputPassword.deployKeyboard();
		}
	},

	deployUnlockKeyboard : function() {
		if(this.data.objKeyboard) {
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.PASSWORD,null,webapp.lock.data.objKeyboard);
		}
	},

	setLockSettingData : function(setting) {
		this.data.setLockSetting(setting);
	}
});
/*lock*/
dojo.require("webapp.lock.controlBase");
// Provide and create the lock webapp.
dojo.provide("webapp.lock");
dojo.declare("webapp.lock",webapp.lock.controlBase,{

});

webapp.lock = new webapp.lock();
dojo.provide("webapp.lock.dataBase");
dojo.declare("webapp.lock.dataBase",null,{
    // divs dom
    domGlobalLock : null, // Global Div for the Lock

    // vars
    /* strLogin    : "", */
    strPassword : "",
    _arrButtons : [],
	_arrButtonsData : [],
	objAppBar			: null,
	objAppBarICS			: null,
	objKeyboard			: null,
	_boolLockedSetting	: false,
	_boolLockPhone		: false,
	objAppBarChangePwd	: {},
	lockCapability : false,
	unlockCapability : false,
	changePasswordView : null,
	boolChangePasswordInitByUser : false,
	customExit : false,
    // Buttons Id
    EMERGENCY_BTNS	: [
		"EMERGENCY1_BTN","EMERGENCY2_BTN","EMERGENCY3_BTN",
		"EMERGENCY4_BTN","EMERGENCY5_BTN","EMERGENCY6_BTN",
		"EMERGENCY7_BTN","EMERGENCY8_BTN","EMERGENCY9_BTN"
	],

    CONFIRM_CHANGE_PWD	: "CONFIRM_CHANGE_PWD_BTN",
    DISMISS_CHANGE_PWD	: "DISMISS_CHANGE_PWD_BTN",
	HOME				: "HOME_BTN",
	CONFIRM_LOCK		: "CONFIRM_LOCK_BTN",
	UNLOCK				: "UNLOCK_BTN",

    constructor : function(){

		var dataLockButton = {
                    strButtonName: webapp.lock.LOCK,
                    strButtonLabel: _("Lock", "webapp.lock"),
                    strButtonIcon: 'generic-lock',
                    strStatusText:'',
                    strStatusIcon:'',
                    callback: dojo.hitch(webapp.lock,webapp.lock.goToConfirmLockScreen),
                    arrCapabilities :[{
                            module : "IctUser",
                            capability :"Lock"}
                            ]
                    };
		ICTouchAPI.AppBarServices.addOtherWebAppButton("userservices", "userservicesstatus"+webapp.userservices.data.PRESENCE_IM_SCREEN, new UIElements.AppButton.AppButtonControl(dataLockButton));
		ICTouchAPI.AppBarServices.addOtherWebAppButton("userservices", "userservicesstatus"+webapp.userservices.data.USER_INFO_SCREEN, new UIElements.AppButton.AppButtonControl(dataLockButton));

		var func = dojo.hitch( webapp.lock, webapp.lock.buttonCallback);
		// Create the appbar with the buttons OK and DISMISS
		this.objAppBarChangePwd = ICTouchAPI.AppBarServices.getAppBar("lock", "getChangePassword"); //new UIElements.AppBar.AppBarWidget({webAppName:"lock",widgetName:"getChangePassword"});
		var okButton = new UIElements.AppButton.AppButtonControl({
			strButtonName: this.CONFIRM_CHANGE_PWD,
			strButtonLabel: _('Ok','ICTouchAPI'),
			strButtonIcon: "generic-ok",
			callback: func}
		);
		this.objAppBarChangePwd.addActionButton(okButton);
		var dissmissButton = new UIElements.AppButton.AppButtonControl({
			strButtonName: this.DISMISS_CHANGE_PWD,
			strButtonLabel: _('Cancel','ICTouchAPI'),
			strButtonIcon: "generic-cancel",
			callback: func}
		);
		//this.objAppBarChangePwd.addActionButton(dissmissButton);
		ICTouchAPI.AppBarServices.addStaticButton("lock","getChangePassword", dissmissButton);

		this.objAppBar = new UIElements.AppBar.AppBarWidget({
			webAppName:"lock",
			widgetName:"getLock"
		});
		this.objAppBarICS = new UIElements.AppBar.AppBarWidget({
			webAppName:"lock",
			widgetName:"getPasswordICS"
		});



		this.objAppBarConfirmation = ICTouchAPI.AppBarServices.getAppBar("lock", "getLockConfirmation");
		// Create the static back button
		var buttonBack = new UIElements.AppButton.AppButtonControl({
			strButtonName: this.HOME,
			strButtonLabel: _("Home", "ICTouchAPI"),
			strButtonIcon: 'generic-homepage',
			callback: func
		});
		ICTouchAPI.AppBarServices.addStaticButton("lock","getLockConfirmation", buttonBack);
		var lockConfirmedButton = new UIElements.AppButton.AppButtonControl({
			strButtonName: this.CONFIRM_LOCK,
			strButtonLabel: _("Lock", "webapp.lock"),
			strButtonIcon: "generic-lock",
			strButtonIconName: "generic-lock",
			callback: func}
		);
		this.objAppBarConfirmation.addActionButton(lockConfirmedButton);

    },

	addButton : function(button) {
		this._arrButtonsData.push(button);
		var objButton = new UIElements.AppButton.AppButtonControl(button);

		this._arrButtons.push(objButton);
		this.objAppBar.addActionButton(objButton);

		var objButtonICS = new UIElements.AppButton.AppButtonControl(button);
		this.objAppBarICS.addActionButton(objButtonICS);
	},

	getButtonDataFromNumber : function(phoneNumber) {
		var buttons = this.getButtons();
		var buttonsData = this.getButtonsData();
		for(var i in this.getButtons()) {
			if(phoneNumber == buttons[i].strNumber) {
				return buttonsData[i];
			}
		}
		return null;
	},

    getPassword : function() {
        return this.strPassword;
    },

    getButtons : function() {
        return this._arrButtons;
    },

    getButtonsData : function() {
        return this._arrButtonsData;
    },

	getLockSetting : function() {
		return this._boolLockedSetting;
	},

	getLockPhone : function() {
		return this._boolLockPhone;
	},

	getButton : function(strId){
		var strType, button;
		if(strId.search(/EmergencyIcon/i) != -1){
			strType = "EmergencyIcon";
		} else if(strId.search(/EmergencyLabel/i) != -1){
			strType = "EmergencyLabel";
		} else if(strId.search(/EmergencyNumber/i) != -1){
			strType = "EmergencyNumber";
		}
		if(strType){
			var id = strId.replace(strType,"");
			button = this.objAppBar.getButton("EMERGENCY"+id+"_BTN");
		}
		return button;
	},
    /** End getters **/

    /** setters **/

	setLockSetting : function(setting) {
		this._boolLockedSetting = (setting == true || setting == "true" || setting == 1);
	},

	setLockPhone : function(locked) {
		this._boolLockPhone = locked;
	},

    /** End setters **/

	updateAppBar : function() {
		var button	= this.objAppBarConfirmation.getButton("MAGNIFY");
		if(button) {
		    button.hide();
		}
	},

	setCustomExitForVVM : function(boolExit){
		this.customExit = boolExit;
	}
});
dojo.require("webapp.lock.dataBase");
dojo.provide("webapp.lock.data");
dojo.declare("webapp.lock.data",webapp.lock.dataBase,{

});

webapp.lock.data=new webapp.lock.data;dojo.provide("webapp.lock.getLockBase");
dojo.declare("webapp.lock.getLockBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		passwordCallback	: null,
		callbackOk			: null,
		callbackExit		: null,
		actionOutsideClick	: null,
		strPassword			: "",
		strTitle			: "",

		constructor : function() {
		},

		postMixInProperties : function() {
			this.passwordCallback = webapp.lock.passwordCallback;
			this.actionOutsideClick = ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE;
			this.strTitle = _("Please enter your password :", "webapp.lock");
			this.strPassword = _("Password", "webapp.lock");
			this.callbackExit = webapp.lock.onExitPassword;
		},

		postCreate : function() {
			var data = webapp.lock.data;
			// create Inputs
			// var strLogin    = webapp.lock.data.getLogin();
			var strPassword = data.getPassword();

			data.objKeyboard = {
				boolPassword: true,
				keyboardType: ICTouchAPI.KeyboardTypes.PASSWORD,
				strDefaultText: strPassword,
				strInputTitle : this.strTitle,
				funcCallback : this.passwordCallback,
				funcCallbackOk : this.passwordCallback,
				funcCallbackExit : this.callbackExit,
				actionOutsideClick : ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE,
				hideStarsIfPasswordEmpty : true
			};

			// place AppBar
			data.objAppBar.placeAt(this.domButtons);
			data.objAppBar.updateAppBar();

			var unlockButton = new UIElements.AppButton.ButtonControl({
				strButtonName: data.UNLOCK,
				strButtonLabel: _("Unlock", "webapp.lock"),
				strButtonIcon: "generic-lock",
				callback: function() {
					webapp.lock.deployUnlockKeyboard();
				}
			}
			);
			unlockButton.placeAt(this.domMainButton);

			this.inherited(arguments);
		},

		destroy : function() {
			// webapp.lock.data.objInputLogin.destroy();
			webapp.lock.data.objInputPassword.destroy();
		}
	});
dojo.require("webapp.lock.getLockBase");
dojo.provide("webapp.lock.getLock");
dojo.declare("webapp.lock.getLock",
    webapp.lock.getLockBase,
    {
        templatePath: dojo.moduleUrl("webapp.lock","templates/getLock8082.html"),
    });dojo.provide("webapp.lock.getLockConfirmationBase");
dojo.declare("webapp.lock.getLockConfirmationBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		strMessage : "",
		_objSpinner	: null,

		constructor : function() {
		},

		postMixInProperties : function() {
			this.strMessage = _("Press Lock to confirm or Home to cancel.", "webapp.lock");
		},

		postCreate : function() {
			// place AppBar
			/*data.objAppBarConfirmation.placeAt(this.domButtonsConfirmation);*/
			var data = webapp.lock.data;
			data.updateAppBar();

			this.inherited(arguments);
			this._objSpinner = new UIElements.Spinner.SpinnerControl({strMessage : this.strMessage, boolForeground:true}, this.domZone);
		},

		destroy : function() {
			if(this._objSpinner){
				this._objSpinner.destroy();
				this._objSpinner = null;
			}
		}
	});
dojo.require("webapp.lock.getLockConfirmationBase");
dojo.provide("webapp.lock.getLockConfirmation");
dojo.declare("webapp.lock.getLockConfirmation",
    webapp.lock.getLockConfirmationBase,
    {
        templatePath: dojo.moduleUrl("webapp.lock","templates/getLockConfirmation8082.html"),
        cssFile : ['main8082.css','icons.css'],
    });dojo.provide("webapp.lock.getICSPasswordBase");
dojo.declare("webapp.lock.getICSPasswordBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

		passwordCallback	: null,
		//callbackOk			: null,
		callbackExit		: null,
		actionOutsideClick	: null,
		strPassword			: "",

		constructor : function() {
		},

		postMixInProperties : function() {
			this.passwordCallback = dojo.hitch(webapp.lock, webapp.lock.passwordCallback);
			this.actionOutsideClick = ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE;
			this.strPassword = _("User Password", "webapp.lock");
			this.callbackExit = dojo.hitch(webapp.lock, webapp.lock.onExitICSPassword);
		},

		postCreate : function() {
			var data = webapp.lock.data;
			// create Inputs
			// var strLogin    = webapp.lock.data.getLogin();
			var strPassword = data.getPassword();

			// webapp.lock.data.objInputLogin    = new UIElements.InputField.InputFieldControl({ keyboardType: "alphaNum", strInputText: strLogin }, this.domLogin);
			data.objInputPassword = new UIElements.InputField.InputFieldControl({boolPassword: true, keyboardType: "password", strInputText: strPassword, funcCallback: this.passwordCallback, funcCallbackOk : this.passwordCallback, funcCallbackExit : this.callbackExit, actionOutsideClick : this.actionOutsideClick, hideStarsIfPasswordEmpty : true}, this.domPassICS);

			// place AppBar
			data.objAppBarICS.placeAt(this.domButtons);
			data.objAppBarICS.updateAppBar();

			this.inherited(arguments);
		},

		destroy : function() {
			// webapp.lock.data.objInputLogin.destroy();
			webapp.lock.data.objInputPassword.destroy();
		}
	});
dojo.require("webapp.lock.getICSPasswordBase");
dojo.provide("webapp.lock.getICSPassword");
dojo.declare("webapp.lock.getICSPassword",
    webapp.lock.getICSPasswordBase,
    {
        templatePath: dojo.moduleUrl("webapp.lock","templates/getICSPassword8082.html"),
        cssFile : ['main8082.css','icons.css'],
    });
dojo.require("webapp.lock.getICSPassword");
dojo.provide("webapp.lock.getChangePasswordBase");
dojo.declare("webapp.lock.getChangePasswordBase",
    webapp.lock.getICSPassword,
	{

		strChangePasswordInfo				: null,
		strChangePasswordLabelOld			: null,
		strChangePasswordLabelNew			: null,
		strChangePasswordLabelCheckNew		: null,

		attributeMap : {
			strChangePasswordInfo : { node : "domChangePasswordInfo", type: "innerHTML"},
			strChangePasswordLabelOld : { node : "domChangePasswordLabel1", type: "innerHTML"},
			strChangePasswordLabelNew : { node : "domChangePasswordLabel2", type: "innerHTML"},
			strChangePasswordLabelCheckNew : { node : "domChangePasswordLabel3", type: "innerHTML"}
		},

		constructor : function() {

		},

		postMixInProperties : function() {
			this.strChangePasswordInfo = _("The current password is the one by default.","webapp.lock");
			this.strChangePasswordLabelOld = _("Enter your old password","webapp.lock");
			this.strChangePasswordLabelNew = _("Enter your new password","webapp.lock");
			this.strChangePasswordLabelCheckNew	= _("Confirm your new password","webapp.lock");
		},

		displayPasswordInfo : function(){
			dojo.toggleClass(this.domChangePasswordInfo, "lockInfoDisplay", webapp.lock.data.boolChangePasswordInitByUser);
		},



		postCreate : function() {
			var data = webapp.lock.data;

			// create Inputs
			data.objOldPassword = new UIElements.InputField.InputFieldControl({boolPassword: true, keyboardType: "password", strKeyboardDefaultText:"", hideStarsIfPasswordEmpty : true}, this.domOldPass);
			data.objNewPassword = new UIElements.InputField.InputFieldControl({boolPassword: true, keyboardType: "password", strKeyboardDefaultText:"", hideStarsIfPasswordEmpty : true}, this.domNewPass);
			data.objCheckNewPassword = new UIElements.InputField.InputFieldControl({boolPassword: true, keyboardType: "password", strKeyboardDefaultText:"", hideStarsIfPasswordEmpty : true}, this.domCheckNewPass);
			data.changePasswordView = this;
			// place AppBar
			/*data.objAppBarChangePwd.placeAt(this.domButtons);
			data.objAppBarChangePwd.updateAppBar();*/
			this.displayPasswordInfo();
		},

		destroy : function() {
				webapp.lock.data.objOldPassword.destroy();
			webapp.lock.data.objNewPassword.destroy();
				webapp.lock.data.objCheckNewPassword.destroy();
			}
	});
dojo.require("webapp.lock.getChangePasswordBase");
dojo.provide("webapp.lock.getChangePassword");
dojo.declare("webapp.lock.getChangePassword",
    webapp.lock.getChangePasswordBase,
    {
		templatePath: dojo.moduleUrl("webapp.lock","templates/getChangePassword8082.html"),
		cssFile : ['main8082.css','icons.css']
    });
