dojo.provide("webapp.lock.getLockBase");
dojo.declare("webapp.lock.getLockBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		passwordCallback	: null,
		callbackOk			: null,
		callbackExit		: null,
		actionOutsideClick	: null,
		strPassword			: "",
		strTitle			: "",

		constructor : function() {
		},

		postMixInProperties : function() {
			this.passwordCallback = webapp.lock.passwordCallback;
			this.actionOutsideClick = ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE;
			this.strTitle = _("Please enter your password :", "webapp.lock");
			this.strPassword = _("Password", "webapp.lock");
			this.callbackExit = webapp.lock.onExitPassword;
		},

		postCreate : function() {
			var data = webapp.lock.data;
			// create Inputs
			// var strLogin    = webapp.lock.data.getLogin();
			var strPassword = data.getPassword();

			data.objKeyboard = {
				boolPassword: true,
				keyboardType: ICTouchAPI.KeyboardTypes.PASSWORD,
				strDefaultText: strPassword,
				strInputTitle : this.strTitle,
				funcCallback : this.passwordCallback,
				funcCallbackOk : this.passwordCallback,
				funcCallbackExit : this.callbackExit,
				actionOutsideClick : ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE,
				hideStarsIfPasswordEmpty : true
			};

			// place AppBar
			data.objAppBar.placeAt(this.domButtons);
			data.objAppBar.updateAppBar();

			var unlockButton = new UIElements.AppButton.ButtonControl({
				strButtonName: data.UNLOCK,
				strButtonLabel: _("Unlock", "webapp.lock"),
				strButtonIcon: "generic-lock",
				callback: function() {
					webapp.lock.deployUnlockKeyboard();
				}
			}
			);
			unlockButton.placeAt(this.domMainButton);

			this.inherited(arguments);
		},

		destroy : function() {
			// webapp.lock.data.objInputLogin.destroy();
			webapp.lock.data.objInputPassword.destroy();
		}
	});
