/*lock*/
// Provide and create the lock webapp.
dojo.provide("webapp.lock.controlBase");
dojo.declare("webapp.lock.controlBase",[ICTouchAPI.webApplication],{

	uiLock : null,
	LOCK : "LOCK_BTN",
	passwordType : null,
	emergencySize		: 3,
	strDTMFPatern : null,
	boolEnableLockOnHomepage : false,

	loaded: function() {
		// Subscribe to the event UserPwdRequiredEvent (ICE, OXO).
		// Subscription to this event is done in the loaded function because the UserPwdRequiredEvent event
		// is sent (if it has to be sent) by WSManager after that the presentationLoaded event is sent by
		// presentation. This presentationLoaded event is sent before the webapp constructors are called,
		// but after the webapp loaded function execution.
		ICTouchAPI.eventServices.subscribeToEvent(this, "UserPwdRequiredEvent", this.pwdRequired);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.lock","webapp.communication",true,false,true,false);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.lock","webapp.audiosetting",true,false,true,false);

		ICTouchAPI.CapabilityServices.subscribeToCapability("IctUser", "Lock", this, this.lockCapabilityCallback);
		ICTouchAPI.CapabilityServices.subscribeToCapability("IctUser", "Unlock", this, this.unlockCapabilityCallback);

		dojo.subscribe("customExitForLockVVM", this.data, this.data.setCustomExitForVVM);

		this.loadSettings();
	},

	constructor: function() {
		//dojo.addOnLoad(this, this.loaded);
		// add button to homepage appbar
		var func = dojo.hitch( this, this.lock);

		ICTouchAPI.settingServices.subscribeToSetting(this, "DTMFPattern", this.onDTMFPaternChanged);
		ICTouchAPI.settingServices.getSetting("DTMFPattern", this, this.onDTMFPaternChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableLockOnHomepage", this.onEnableLockOnHomepageChanged);
		ICTouchAPI.settingServices.getSetting("EnableLockOnHomepage", this, this.onEnableLockOnHomepageChanged);

		ICTouchAPI.eventServices.subscribeToEvent(this, "LockEvent", this.notifyLockEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "lockTerminalEvent", this.notifyLockTerminalEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "unlockTerminalEvent", this.notifyUnlockTerminalEvent);

		ICTouchAPI.tools.onLoadedWebapp("webapp.settings", this, this._overrideSettingChangeOXOPwd);
	},

	lockCapabilityCallback : function(capability, value) {
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.lockCapability = true;
		} else {
			this.data.lockCapability = false;
		}
	},

	unlockCapabilityCallback : function(capability, value) {
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.unlockCapability = true;
		} else {
			this.data.unlockCapability = false;
		}
	},

	// Callback of event UserPwdRequiredEvent
	pwdRequired : function () {
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var type = args["pwdType"];
		//console.log(arguments);
		//console.log(args);
		//console.log(type);
                // Test vobs
		if(type == "ICS_Password"){
			var func = function () {
				webapp.lock.passwordType = "ICS";
				ICTouchAPI.transitionServices.getScreen({
					name:"webapp.lock.getICSPassword",
					params:{},
					position: "FullScreen"});
				webapp.lock.deployICSPasswordKeyboard();
			};
			setTimeout(func, 100);
		}
		if(type == "Change_Password"){
			var that = this;
			var func = function () {
				that.switchToChangePasswordView(false);
			};
			setTimeout(func, 100);
		}
		if(type == "ICS_change_Password_failed"){
			var comment = args["comment"];
			if(comment =="ERROR_AUTHENTICATION_FAILED"){
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The entered old password is wrong.","webapp.lock"), "OK");
			}
			if(comment =="ERROR_BAD_PARAMETER_VALUE"){
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The entered new password is not correct.","webapp.lock"), "OK");
			}
			if(comment =="REQUEST_FAILED"){
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The password change has encountered an unexpected error.","webapp.lock"), "OK");
			}
		}
	},

	onDTMFPaternChanged : function(objSetting) {
		if(objSetting){
			this.strDTMFPatern = objSetting.jsValue;
		}
	},

	onEnableLockOnHomepageChanged : function(objSetting) {
		if(objSetting && objSetting.jsValue != this.boolEnableLockOnHomepage){
			this.boolEnableLockOnHomepage = objSetting.jsValue;
			if(this.boolEnableLockOnHomepage) {
				ICTouchAPI.tools.registerHomepageButton(["webapp.lock.getLockConfirmation", this.LOCK, "generic-lock", _('Lock',"webapp.lock"), null, null, null/*, [{module : "IctUser", capability :"Lock"}]*/]);
				ICTouchAPI.tools.registerHomepageKey(["webapp.lock.getLockConfirmation", this.LOCK, "generic-lock", _('Lock',"webapp.lock"), null, function(){ICTouchAPI.transitionServices.getScreen({name: "webapp.lock.getLockConfirmation", params:{}})}, null/*, [{module : "IctUser", capability :"Lock"}]*/]);
			} else {
				ICTouchAPI.tools.unregisterHomepageButton([this.LOCK]);
				ICTouchAPI.tools.unregisterHomepageKey([this.LOCK]);
			}
		}
	},

	// Public function
	load: function() {
		//help
		dojo.publish("needHelpEvent",["lock",["getLock"]]);
	},

	// Lock the phone and throw the event to ICTGate
	lock : function() {
		ICTouchAPI.APIServices.IctUser.lockRequest({context:this, callback:null, callbackParams:null}) ;
	},

// End of public function

	/** Function for Settings **/
    // get settings for the webapp
    loadSettings : function() {
		ICTouchAPI.settingServices.subscribeToSetting(this, "IctUserLocked", this.lockSettingChanged);
		ICTouchAPI.settingServices.getSettingValue("IctUserLocked", this, function(setting){
			this.setLockSettingData(setting);
		});
        // gets the emergency numbers
		var arrEmergencySettings = [];
		for (var i=1;i <= this.emergencySize;i=i+1){
			// Subscribe to change of number settings
			ICTouchAPI.settingServices.subscribeToSetting(this, "EmergencyNumber"+i, this.numberChanged);
			// Subscribe to change of label settings
			ICTouchAPI.settingServices.subscribeToSetting(this, "EmergencyLabel"+i, this.labelChanged);
			// Subscribe to change of icon settings
			ICTouchAPI.settingServices.subscribeToSetting(this, "EmergencyIcon"+i, this.iconChanged);
			arrEmergencySettings.push("EmergencyNumber"+i);
			arrEmergencySettings.push("EmergencyLabel"+i);
			arrEmergencySettings.push("EmergencyIcon"+i);
		}
		ICTouchAPI.settingServices.getSettingsFromIds(arrEmergencySettings, this, this.loadedSettings);
    },

    loadedSettings : function(_arr) {
		var func = this.buttonCallback;
		for (var i=1;i <= this.emergencySize;i=i+1){
			if (_arr["EmergencyNumber"+i] && _arr["EmergencyNumber"+i].jsValue) {
				var objButton = {
					strButtonName: this.data.EMERGENCY_BTNS[i-1],
					strButtonLabel: _arr["EmergencyLabel"+i].jsValue,
					strButtonIcon: _arr["EmergencyIcon"+i].jsValue,
					strNumber: _arr["EmergencyNumber"+i].jsValue,
					capabilities: [{module : "Telephony", capability : "makeCall"}],
					callback: dojo.hitch( this, func)
				};
				this.data.addButton(objButton);
			}
		}
    },

	// Override ChangeOXOPassword setting : allow the user to change his OXO password from the settings (go to the change password view)
	_overrideSettingChangeOXOPwd : function()
	{
		var that = this;
		var func = function() {that.switchToChangePasswordView(true)};
		webapp.settings.overrideSetting("ChangePassword",func);
	},
    /** End settings function **/

	goToConfirmLockScreen: function() {
		var isLocked = this.data.getLockPhone();
		if(isLocked == false) {
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.lock.getLockConfirmation",
				params:  {}
			});
		}
	},

	// Lock the Phone (show Lock screen)
	lockPhone: function() {
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.lock.getLock",
			params:  {},
			position: "FullScreen"
		});
		if(webapp.communication) {
			webapp.communication.checkForCallToDisplay();
		}
		dojo.publish("phoneLocked");
	},

	// unlock the phone (hide Lock Screen)
	unlockPhone: function() {
		//// reset password
		if(this.data.objInputPassword) {
			this.data.objInputPassword.setValue("");
		}
		if(!this.data.customExit){
			dojo.publish("OpenHomepage");
		}else{
			dojo.publish("resetCustomExit",["lock"]);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.voicemail.getVoicemail",
				params: {}
			});
		}
		if(webapp.communication) {
			webapp.communication.deleteAllPopupCall();
			webapp.communication.cleanseTimerPopup();
		}
	},

    // handlers for buttons clicks
    buttonCallback : function(buttonId) {
		var data = webapp.lock.data;
		switch(buttonId)
		{
			case data.CONFIRM_CHANGE_PWD:
				this.confirmChangePwdCallback();
				break;

			case data.DISMISS_CHANGE_PWD:
			case data.HOME:
				dojo.publish("OpenHomepage");
				break;

			case data.CONFIRM_LOCK :
				this.lock();
				break;

			case data.UNLOCK :
				this.deployICSPasswordKeyboard();
				break;

			// If buttonId is not CONFIRM_CHANGE_PWD or DISMISS_CHANGE_PWD, check for emergency buttons
			default:
			var buttons = webapp.lock.data.getButtons();
			var number;
			for (var i in buttons) {
				if (buttons[i].strButtonName == buttonId){
					number = buttons[i].strNumber;
					var boolDTMF = false;
					if(number.indexOf(this.strDTMFPatern) === 0){
						boolDTMF = true;
						number = number.substr(this.strDTMFPatern.length, number.length - this.strDTMFPatern.length);
					}
					ICTouchAPI.APIServices.Telephony.startPhoneCall({params:[number, false, true, boolDTMF], context:this}) ;
				}
			}
		}
    },

	isLocked : function() {
		if(this.data) {
			return this.data.getLockSetting();
		}
		return false;
    },


	/*
	 * Allow the user to change his OXO password from the settings : go to the change password view.
	 */
	switchToChangePasswordView: function(_boolDisplayLabel){
		this.data.boolChangePasswordInitByUser=_boolDisplayLabel;
		if(this.data.changePasswordView){
			this.data.changePasswordView.displayPasswordInfo();
		}
		ICTouchAPI.transitionServices.getScreen({
			name:"webapp.lock.getChangePassword",
			params:{}
		});
	},

	// function called for the change password view when user press on OK button
	// Check if the new password is not empty and if the new password and check new password fields are
	// identical before calling the buiness function which set the new password
	confirmChangePwdCallback : function() {
		var data = webapp.lock.data;
		if (data.objNewPassword && data.objCheckNewPassword) {
			// Check if the 2 entered passwords are identical
			if (data.objNewPassword.getInputFieldContent() == data.objCheckNewPassword.getInputFieldContent() ){
				// Check if the 2 entered passwords are not an empty string
				if (data.objNewPassword.getInputFieldContent()!="" && data.objOldPassword.getInputFieldContent()!="") {
					ICTouchAPI.APIServices.WSManager.changePassword({params:[data.objOldPassword.getInputFieldContent(),data.objNewPassword.getInputFieldContent()]});
					if(this.isLocked()) {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.lock.getLock",
							params:  {},
							position: "FullScreen"
						});
					} else {
					dojo.publish("OpenHomepage");
				}
				}
				else { // Password are empty strings, ask the user to enter passwords
					ICTouchAPI.popupServices.basicPopup("warning", "", _("Passwords are not specified.","webapp.lock"), "OK");
				}
			}
			else { // Entered passwords are different, display a warning popup telling the user that he have to enter identical passwords
				ICTouchAPI.popupServices.basicPopup("warning", "", _("The entered passwords are not identical.","webapp.lock"), "OK");
			}
			data.objNewPassword.setInputFieldContent("",false,true);
			data.objCheckNewPassword.setInputFieldContent("",false,true);
			data.objOldPassword.setInputFieldContent("",false,true);
		}

	},
	// handler for password entry
	passwordCallback : function(password) {
		var that = this;
		if(this.passwordType == "ICS"){
			ICTouchAPI.APIServices.WSManager.submitUserPassword({params:[password, false], context:that, callback:that.gotICSPassword});
			// To remove when we will have a callback for submitUserPassword
			//this.back();
		} else {
			if(webapp.communication && webapp.communication.data) {
				if(webapp.communication.data.getCountCalls() > 0 && webapp.lock.data && !webapp.lock.data.unlockCapability) {
					var strMessage = _("You cannot unlock the phone during a phone call.", "webapp.lock");
					ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("Ok", "ICTouchAPI"));
					return ;
				}
			}
			if(webapp.lock.data.unlockCapability) {
				ICTouchAPI.APIServices.IctUser.unLockRequest({params:[password]});
			}
		}
		//this.data.objInputPassword.setInputFieldContent("",false);
		//this.data.objInputPassword.setValue("");
	},

	onExitPassword : function() {

	},

	onExitICSPassword : function() {
		if(this.passwordType == "ICS") {
			var that = this;
			ICTouchAPI.APIServices.WSManager.submitUserPassword({params:["", true], context:that, callback:that.gotICSPassword});
			//this.back();
		}
	},

	// Return of core function submitUserPassword
	gotICSPassword : function(intReturn) {
		if(intReturn) { // Success, intReturn to validate
			this.back();
		} else {
			return;
			//TODO : print something to show that it failed
		}
	},

	// Back function of ICS Password
	back : function() {
		this.passwordType = null;
		this.data.objInputPassword.setValue("");
		dojo.publish("OpenHomepage");
	},

	closePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.popupError);
	},

	// call a number via communication webapp
	callSpecialNumber : function(number) {
		webapp.communication.apiCall(number, false);
	},

    notifyLockEvent : function(objState) {
		if(!this.data) {return;}

		var state = objState.value;
		if(state){
			dojo.publish("requestCustomVVMExit",["lock"]);
		}
		this.data.setLockPhone(state || state == "true");

		this.lockUnlock();
    },

	lockUnlock : function() {
		if(!this.data) {return;}

		var isLocked = this.data.getLockPhone();
		var isSettingLocked = this.data.getLockSetting() ;

		if(!isLocked && !isSettingLocked) {
			this.unlockPhone();
		} else if(isLocked && isSettingLocked) {
			this.lockPhone();
		}
	},

    notifyLockTerminalEvent : function() {
		//this.lockPhone();
    },

	notifyUnlockTerminalEvent : function(boolOK) {
		if(boolOK) {// Good password
			//this.unlockPhone();
		} else { // Wrong password
			// confirmation popup
			var context = this;
			var strContent = _("You entered an invalid password.","webapp.lock");
			var popupError = {
				strTitle: _("Invalid password", "webapp.lock"),
				strType: "error",
				strContent: strContent,
				arrPopupButtons: []
			};
			this.popupError = ICTouchAPI.popupServices.addNewPopup(popupError, "MEDIUM");
			var that = this;
			var func = function () {
				that.closePopup();
			}
			setTimeout(func,4000); // 4 seconds
		}
	},

	// Callback when an emergency number changes
	numberChanged : function(objSetting) {
		var button = this.data.getButton(objSetting.id);
		if(button){
			if(objSetting.value == "") {
				button.hide();
			} else {
				button.strNumber = objSetting.value;
				button.show();
			}
		}
	},

	// Callback when an emergency label changes
	labelChanged : function(objSetting) {
		var button = this.data.getButton(objSetting.id);
		button.attr("strButtonLabel", _(objSetting.value, "webapp.lock"));
	},

	// Callback when an emergency icon changes
	iconChanged : function(objSetting) {
		var button = this.data.getButton(objSetting.id);
		button._setStrButtonIconAttr(objSetting.value);
	},

	lockSettingChanged : function(setting){
		if(!this.data) {return;}

		this.data.setLockSetting(setting.value);

		this.lockUnlock();
	},

	deployICSPasswordKeyboard : function() {
		if (this.data.objInputPassword) {
			this.data.objInputPassword.deployKeyboard();
		}
	},

	deployUnlockKeyboard : function() {
		if(this.data.objKeyboard) {
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.PASSWORD,null,webapp.lock.data.objKeyboard);
		}
	},

	setLockSettingData : function(setting) {
		this.data.setLockSetting(setting);
	}
});
