dojo.provide("webapp.synchronization.controlBase");
dojo.declare("webapp.synchronization.controlBase",[ICTouchAPI.webApplication],{
	// application name
	APPLICATION_NAME : 'webapp.synchronization',

	CLOSE_BTN : 'CLOSE_BTN',
	CONTINUE_BTN : 'CONTINUE_BTN',
	CANCEL_BTN : 'CANCEL_BTN',
	NOTIF_BTN : 'SYNCHRO_NOTIF_BTN',
	SYNCHRO_BTN : 'SYNCHRONIZATION_BTN',

	SYNCHRO_KEY : 'SYNCHRONIZATION_KEY',

	// event received when synchronization has completed
	SYNC_FINISHED_EVT : 'SyncfinishedEvent',
	// event received when the user say 'yes' to configure the settings
	SYNC_SETTINGS_EVT : 'SyncSettingsEvent',

	// event received when the homepage webapp has been load
	HOMEPAGE_LOADED_EVT : 'HomepageLoaded',

	// settings name
	SYNC_STARTED_STNG : 'SyncStarted',
	SYNC_KEY_IN_HOME_PAGE_STNG  : 'SyncKeyInHomePage',
	ENABLE_SYNC_WEBAPP_STNG : 'EnableWebappSynchronization',

	// ongoing synchronization popup handle
	ongoingPopup : null,

	// crms00378903: Counter for not calling more than twice the syncStart business function (otherwise PCSync business module crash)
	nbSyncPressedButton : 0,

	// value of the SyncKeyInHomePage setting
	syncKeyInHomePage : false,

	// true if synchronization button is shown in the homepage
	syncButtonShownInHomePage : false,

	constructor:function(){
		// get notified when SyncStarted setting change
		ICTouchAPI.settingServices.subscribeToSetting(this,
			this.SYNC_STARTED_STNG, this._onSyncStartedChanged);
		// get notified when SyncKeyInHomePage setting change
		ICTouchAPI.settingServices.subscribeToSetting(this,
			this.SYNC_KEY_IN_HOME_PAGE_STNG, this._onSyncKeyInHomePageChanged);

		// subscribe to events
		ICTouchAPI.eventServices.subscribeToEvent(this,
			this.SYNC_FINISHED_EVT, this._onSyncFinishedEvt);
		ICTouchAPI.eventServices.subscribeToEvent(this,
			this.SYNC_SETTINGS_EVT, this._onSyncSettingsEvt);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.notifications","webapp.synchronization", true, true, true);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.synchronization", true, false, true, false);
	},

	// return the web application name
	getApplicationName : function(){
		return this.APPLICATION_NAME;
	},

	// add the synchronization button to the app bar
	addSynchronizationButton: function(){
		if(!this.syncButtonShownInHomePage){
			this.syncButtonShownInHomePage = true;
			ICTouchAPI.tools.registerHomepageButton(["webapp.synchronization.getSynchronization",
				this.SYNCHRO_BTN , "synchronization-application", _("PCSync", "webapp.synchronization"),
				null, dojo.hitch(this, this._onSynchronizeBtn), 0]);

			ICTouchAPI.tools.registerHomepageKey(["webapp.synchronization.getSynchronization",
				this.SYNCHRO_KEY, "synchronization-application", _("PCSync", "webapp.synchronization"),
				null, dojo.hitch(this, this._onSynchronizeBtn), 0]);
		}
	},

	// remove the synchronization button from the app bar
	removeSynchronizationButton: function(){
		if(this.syncButtonShownInHomePage){
			this.syncButtonShownInHomePage = false;
			ICTouchAPI.tools.unregisterHomepageButton([this.SYNCHRO_BTN]);
			ICTouchAPI.tools.unregisterHomepageKey([this.SYNCHRO_KEY]);

		}
	},

	// add the notification button in the top bar
	addSynchronizationNotifButton: function(){
		ICTouchAPI.notificationServices.addNotification({
			strNotificationName : this.NOTIF_BTN,
			strNotificationLabel: _('Synchronization',this.APPLICATION_NAME),
			strNotificationTypeIcon: true,
			strNotificationIcon: "synchronization-notif-icon",
			//intNotificationValue: 1,
			callback: dojo.hitch(this, this._onClickNotificationButton)
		});
	},

	// remove the notification button from the top bar
	removeSynchronizationNotifButton: function(){
		ICTouchAPI.notificationServices.removeNotification(this.NOTIF_BTN);
	},

	// called when the webapp has been loaded
	loaded : function() {
		// get the initial value of the SyncStarted setting
		ICTouchAPI.settingServices.getSettingValue(this.SYNC_STARTED_STNG,
			this, this._onSyncStartedGetValue, null);
		// get the initial value of the SyncKeyInHomePage setting
		ICTouchAPI.settingServices.getSettingValue(this.SYNC_KEY_IN_HOME_PAGE_STNG,
			this, this._onSyncKeyInHomePageGetValue, null);
	},

	// start the synchronization
	syncStart : function() {
		this.nbSyncPressedButton++;
		if (this.nbSyncPressedButton == 1) { // add the notif only on the first call of syncStart
			this.addSynchronizationNotifButton();
		}
		if (this.nbSyncPressedButton <= 2) { // crms00378903: only call the syncStart function if the user didn't clicked more than twice on PCSync button
			ICTouchAPI.APIServices.Sync.syncStart({});
		}
	},

	// stop the synchronization if it is ongoing
	syncStop : function() {
		this.nbSyncPressedButton = 0; // crms00378903: reinit the counter when sync is finished
		ICTouchAPI.notificationServices.removeNotification(this.NOTIF_BTN);
		ICTouchAPI.APIServices.Sync.syncStop({});

	},

	// display a popup with a string for debugging purpose
	displayPopup : function(str) {
		var popup = ICTouchAPI.popupServices.addNewPopup({
			strTitle: _("Synchronization", this.APPLICATION_NAME),
			strContent: str,
			strIcon: "synchronization-application-64",
			arrPopupButtons: [
			{
				strButtonName : this.CLOSE_BTN,
				strButtonLabel: _('Close',this.APPLICATION_NAME),
				callback : function(){
					ICTouchAPI.popupServices.removePopup(popup)
					}
			}
			]
		}, "HIGH");
	},

	// popup displayed when user click on status icon when a synchronization is ongoing
	displayOngoingPopup : function() {
		// do nothing if the popup is already displayed
		if(this.ongoingPopup){
			return
		}
		var strContent = _('Synchronization is ongoing',this.APPLICATION_NAME);
		var arrButtons = [];
		arrButtons[0] = {
			strButtonName : this.CONTINUE_BTN,
			strButtonLabel: _('Continue',this.APPLICATION_NAME),
			strButtonIcon : 'icon-32-validate',
			callback : dojo.hitch(this, this.continueOngoingPopup)
		};
		arrButtons[1] = {
			strButtonName : this.CANCEL_BTN,
			strButtonLabel: _('Cancel','ICTouchAPI'),
			strButtonIcon : 'icon-32-cancel',
			callback : dojo.hitch(this, this.cancelOngoingPopup)
		};
		var popupSynchro = {
			strTitle: _("Synchronization", this.APPLICATION_NAME),
			strContent: strContent,
			strIcon: "synchronization-application-64",
			arrPopupButtons: arrButtons,
			intID : "ONGOING"
		};

		this.ongoingPopup = ICTouchAPI.popupServices.addNewPopup(popupSynchro, "MEDIUM");
	},

	// dismiss the ongoing popup
	continueOngoingPopup : function() {
		if(this.ongoingPopup != null) {
			ICTouchAPI.popupServices.removePopup(this.ongoingPopup);
			this.ongoingPopup = null;
		}
	},

	// dismiss the ongoing popup and cancel the current synchronization
	cancelOngoingPopup : function() {
		if(this.ongoingPopup != null) {
			ICTouchAPI.popupServices.removePopup(this.ongoingPopup);
			this.ongoingPopup = null;
		}
		this.syncStop();
	},

	// callback called to provide the initial value of SyncStarted setting
	_onSyncStartedGetValue : function (value, cbParam) {
		if(value){
			//this.displayPopup("Setting SyncStarted is already true !");
			this.addSynchronizationNotifButton();
		}
	},

	// called when the SyncStarted value change in the settings
	_onSyncStartedChanged : function (objSetting) {
		//this.displayPopup("Setting syncStarted changed to "+objSetting.jsValue.toString());
		if(objSetting.jsValue){
			this.addSynchronizationNotifButton();
		}
	},

	// callback called to provide the initial value of SyncKeyInHomePage setting
	_onSyncKeyInHomePageGetValue: function (value, cbParam) {
		this.syncKeyInHomePage = value;
		if(this.syncKeyInHomePage){
			this.addSynchronizationButton();
		}
	},

	// called when the SyncKeyInHomePage value change in the settings
	_onSyncKeyInHomePageChanged : function (objSetting) {
		this.syncKeyInHomePage = objSetting.jsValue;
		if(this.syncKeyInHomePage){
			this.addSynchronizationButton();
		} else {
			this.removeSynchronizationButton();
		}
	},

	// Called when syncFinishedEvt is received that is when a synchronization
	// has just been completed.
	_onSyncFinishedEvt : function (objEvt) {
		//this.displayPopup("syncFinishedEvt");
		this.nbSyncPressedButton = 0; // crms00378903: reinit the counter when sync is finished
		this.removeSynchronizationNotifButton();
	},

	// callback called when the user click on the notification icon
	_onClickNotificationButton : function () {
		// don't show our popup, instead throw a syncStart message to the
		// application
		//this.displayOngoingPopup();
		this.nbSyncPressedButton++;
		if (this.nbSyncPressedButton <= 2) { // crms00378903: only call the syncStart function if the user didn't clicked more than twice on PCSync button
			ICTouchAPI.APIServices.Sync.syncStart({});
		}
	},

	// callback called when the user click on the synchronize button in the
	// application bar
	_onSynchronizeBtn : function () {
		this.syncStart();
	},

	// show the synchronization webapp settings if the webapp settings is already
	// loaded
	_showSyncSettings : function() {
		if(!webapp.settings.categoriesListUI){
			return
		}
		// search the index in the MenuList of the Synchronization settings
		var arrItems = webapp.settings.categoriesListUI.arrItems;
		var foundIndex = -1;
		for(var i=0; i<arrItems.length; i++){
			if (arrItems[i].strSubCat === "Synchronization"){
				foundIndex=i;
				break
			}
		}
		if(foundIndex>=0){
			// select (display) the item with the previously found index
			webapp.settings.categoriesListUI.selectItemByIndex(foundIndex, true);
		}
		arrItems = null;
	},

	// show the synchronization webapp settings
	// wait until the settings webapp has been really loaded
	_showSyncSettingsWithWait : function(){
		if(webapp.settings.categoriesListUI){
			webapp.synchronization._showSyncSettings();
		} else {
			setTimeout(webapp.synchronization._showSyncSettingsWithWait, 250);
		}
	},

	// open the settings
	_onSyncSettingsEvt : function () {
		ICTouchAPI.transitionServices.getScreen({
			name:"webapp.settings.getSettings",
			params:{}
		});
		this._showSyncSettingsWithWait();
	}
});
dojo.require("webapp.synchronization.controlBase");
dojo.provide("webapp.synchronization");
dojo.declare("webapp.synchronization",webapp.synchronization.controlBase,{});
webapp.synchronization=new webapp.synchronization();dojo.provide("webapp.synchronization.dataBase");
dojo.declare("webapp.synchronization.dataBase",null,{
	constructor:function(){
	}
});
dojo.require("webapp.synchronization.dataBase");
dojo.provide("webapp.synchronization.data");
dojo.declare("webapp.synchronization.data",webapp.synchronization.dataBase,{});
webapp.synchronization.data=new webapp.synchronization.data();dojo.provide("webapp.synchronization.getSynchronizationBase");
dojo.declare("webapp.synchronization.getSynchronizationBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
	}
);
dojo.require("webapp.synchronization.getSynchronizationBase");
dojo.provide("webapp.synchronization.getSynchronization");
dojo.declare("webapp.synchronization.getSynchronization",
    webapp.synchronization.getSynchronizationBase,
	{
		templatePath: dojo.moduleUrl("webapp.synchronization","templates/getSynchronization8082.html"),
    }
);