dojo.provide("webapp.audiosetting.controlBase");
dojo.declare("webapp.audiosetting.controlBase",[ICTouchAPI.webApplication],{constructor:function(){ICTouchAPI.settingServices.subscribeToSetting(this,"AudioRingLock",this.onAudioRingLockChanged)
},onAudioRingLockChanged:function(audioRingLockSetting){this.data.isRingVolumeLocked=audioRingLockSetting.jsValue;
audioRingLockSetting=null
}});
dojo.require("webapp.audiosetting.controlBase");
dojo.provide("webapp.audiosetting");
dojo.declare("webapp.audiosetting",webapp.audiosetting.controlBase,{objToasterUI:null,oldToasterContentId:"",constructor:function(){ICTouchAPI.skinServices.linkWebappsStyles("webapp.audiosetting","webapp.audiosetting",true,true,true);
ICTouchAPI.eventServices.subscribeToEvent(this,"audio_key_event",this.onAudioKeyEvent);
ICTouchAPI.eventServices.subscribeToEvent(this,"voicemode_trans",this.onVoicemodeTrans);
ICTouchAPI.eventServices.subscribeToEvent(this,"presentationLoaded",this._presentationLoaded);
ICTouchAPI.eventServices.subscribeToEvent(this,"CallStartedEvent",this.closeAudioToaster);
ICTouchAPI.eventServices.subscribeToEvent(this,"send_sense_key_event",this.handsFreeCallback);
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioRingVolume",this.onVolumeValueChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioHandsetVolume",this.onVolumeValueChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioHeadsetVolume",this.onVolumeValueChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioSpeakerPhoneVolume",this.onVolumeValueChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"MPSpeakerPhoneVolume",this.onMediaVolumeChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"MPHandsetVolume",this.onMediaVolumeChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"MPHeadsetVolume",this.onMediaVolumeChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"MPPreviewVolume",this.onMediaVolumeChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioRingLock",this.onAudioRingLockChanged);
ICTouchAPI.eventServices.subscribeToEvent(this,"SENSKEY_HOME",this.eventPhysicalKeyHome)
},_presentationLoaded:function(){ICTouchAPI.eventServices.unsubscribeToEvent(this,"presentationLoaded");
this.buildAll();
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioVoiceSignalLimitation",this.onAudioVoiceSignalLimitation);
ICTouchAPI.settingServices.getSetting("AudioVoiceSignalLimitation",this,this.onAudioVoiceSignalLimitation);
ICTouchAPI.settingServices.subscribeToSetting(this,"AudioVoiceSignalLimitationState",this.onAudioVoiceSignalLimitationState);
ICTouchAPI.settingServices.getSetting("AudioVoiceSignalLimitationState",this,this.onAudioVoiceSignalLimitationState)
},buildAll:function(){this.objToasterUI=new webapp.audiosetting.getAudioToaster({},null);
this.objToasterUI.setVoicemodeText(this.data.getCurrentVoicemodeText());
this.objToasterUI.setMaxSlider(this.data.getCurrentVoicemodeMaxVolume());
ICTouchAPI.toasterServices.preloadContent(this.objToasterUI)
},onAudioVoiceSignalLimitation:function(objAVSLSetting){if(objAVSLSetting){this.data.setBoolQualityAudioDisplay(objAVSLSetting.jsValue)
}},onAudioVoiceSignalLimitationState:function(objAVSLSSetting){if(objAVSLSSetting){this.data.setBoolQualityAudio(objAVSLSSetting.jsValue)
}},handleButtons:function(buttonId){this.resetTimer(true);
if(buttonId==this.data.MUTE_BTN){ICTouchAPI.APIServices.IctAudio.setMute({params:[!this.data.muteStatus],context:this})
}else{if(buttonId==this.data.HIDE_BTN){this.closeAudioToaster()
}else{if(buttonId==this.data.QUALITY_AUDIO_BTN){var bool_audioQuality=this.data.getBoolQualityAudio();
if(bool_audioQuality){ICTouchAPI.APIServices.IctAudio.enableAutoVolume({params:[0],context:this});
this.data.setBoolQualityAudio(false);
this.objToasterUI.qualityAudioButtonUi.setStatusIcon("notif-off")
}else{ICTouchAPI.APIServices.IctAudio.enableAutoVolume({params:[1],context:this});
this.data.setBoolQualityAudio(true);
this.objToasterUI.qualityAudioButtonUi.setStatusIcon("notif-on")
}}else{var voicemode=this.data.getcorrespondingVoicemodeToButton(buttonId);
if(voicemode){ICTouchAPI.APIServices.IctAudio.setVoicemode({params:[voicemode],context:this})
}}}}buttonId=null
},eventPhysicalKeyHome:function(objEvent){if(objEvent&&objEvent.value!==0){this.oldToasterContentId=""
}},handsFreeCallback:function(){var objArguments=ICTouchAPI.tools.getEventArguments(arguments);
if(objArguments.senseKey==1){this.openAudioToaster()
}},updateAutoVolumeButton:function(){if(this.objToasterUI){if(this.data.getBoolQualityAudioDisplay()){this.objToasterUI.qualityAudioButtonUi.show()
}else{this.objToasterUI.qualityAudioButtonUi.hide()
}if(this.data.getBoolQualityAudio()){this.objToasterUI.qualityAudioButtonUi.setStatusIcon(this.data.STATUS_ON_ICON)
}else{this.objToasterUI.qualityAudioButtonUi.setStatusIcon(this.data.STATUS_OFF_ICON)
}}},openAudioToaster:function(){if(this.objToasterUI){this.objToasterUI.volumeSliderUI.refreshDisplay();
webapp.audiosetting.data.boolShownToaster=true;
if(this.oldToasterContentId==""&&ICTouchAPI.toasterServices.getContentDisplayedId()!=this.objToasterUI.id){this.oldToasterContentId=ICTouchAPI.toasterServices.getContentDisplayedId()
}ICTouchAPI.toasterServices.showContent({toasterContent:this.objToasterUI});
this.startTimer(true)
}},closeAudioToaster:function(){ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({params:["presentationHideAudiotoaster"]});
ICTouchAPI.toasterServices.hideContent(webapp.audiosetting.objToasterUI);
webapp.audiosetting.resetTimer(false);
if(webapp.audiosetting.oldToasterContentId!=""){ICTouchAPI.toasterServices.showContent({toasterContent:{id:webapp.audiosetting.oldToasterContentId}})
}webapp.audiosetting.oldToasterContentId="";
if(webapp.audiosetting.data.boolShownToaster){webapp.audiosetting.data.boolShownToaster=false
}},resetTimer:function(restart){if(this.timerHandler){clearTimeout(this.timerHandler);
this.timerHandler=null
}if(restart){this.startTimer()
}restart=null
},startTimer:function(){if(this.timerHandler){this.resetTimer(false)
}this.timerHandler=setTimeout(this.closeAudioToaster,10000)
},onAudioKeyEvent:function(){var objArguments=ICTouchAPI.tools.getEventArguments(arguments);
var showToaster=false;
if(objArguments.audioevt===this.data.EVT_MUTE_ON&&this.data.getMuteStatus()!==true){this.muteValueChanged(true);
showToaster=true
}else{if(objArguments.audioevt===this.data.EVT_MUTE_OFF&&this.data.getMuteStatus()!==false){this.muteValueChanged(false);
showToaster=true
}else{if(objArguments.audioevt===this.data.EVT_VOL_MINUS||objArguments.audioevt===this.data.EVT_VOL_PLUS){showToaster=true
}else{if(objArguments.keyevent===this.data.EVT_KEY_MINUS||objArguments.keyevent===this.data.EVT_KEY_PLUS){showToaster=true
}}}}if(showToaster){this.openAudioToaster()
}},onVoicemodeTrans:function(){this.data.getCurrentVoicemode();
this.data.getVoicemodesStatus()
},onVolumeValueChanged:function(volumeSetting){this.data.arrVolumeValues[volumeSetting.id]=volumeSetting.jsValue;
if(this.objToasterUI&&this.data.isCurrentVoicemodeLinkedToSetting(volumeSetting.id)&&this.objToasterUI.getVolumeValue()!=volumeSetting.jsValue){this.objToasterUI.setSliderValue(volumeSetting.jsValue)
}volumeSetting=null
},onMediaVolumeChanged:function(volumeSetting){volumeSetting.jsValue=parseFloat(volumeSetting.jsValue*5);
this.onVolumeValueChanged(volumeSetting);
volumeSetting=null
},onAudioRingLockChanged:function(lockSetting){this.data.gotRingLockValue(lockSetting.jsValue);
lockSetting=null
},muteValueChanged:function(value){this.data.muteStatus=value;
if(value){this.data.objMuteButton.strStatusIcon=this.data.STATUS_ON_ICON;
ICTouchAPI.ledServices.activate("mute","ON")
}else{this.data.objMuteButton.strStatusIcon=this.data.STATUS_OFF_ICON;
ICTouchAPI.ledServices.desactivate("mute","ON")
}if(this.objToasterUI){this.objToasterUI.changeMuteStatusIcon(this.data.objMuteButton.strStatusIcon)
}value=null
},voicemodeChanged:function(oldVoicemode,newVoicemode){if(oldVoicemode==newVoicemode){return
}this.resetTimer(true);
if(oldVoicemode&&this.data.arrObjVoicemodeButtons[oldVoicemode]){this.data.arrObjVoicemodeButtons[oldVoicemode].strStatusIcon=this.data.STATUS_OFF_ICON;
if(this.objToasterUI){this.objToasterUI.changeVoicemodeStatusIcon(oldVoicemode,this.data.STATUS_OFF_ICON)
}}if(oldVoicemode==this.data.VOICEMODE_INTERNAL_HANDFREE||oldVoicemode==this.data.VOICEMODE_INTERNAL_GROUP_LISTENING||oldVoicemode==this.data.VOICEMODE_EXTERNAL_HANDFREE||oldVoicemode==this.data.VOICEMODE_EXTERNAL_GROUP_LISTENING){ICTouchAPI.ledServices.desactivate("handsFree","ON")
}this.data.currentVoicemode=newVoicemode;
if(this.data.arrObjVoicemodeButtons[newVoicemode]){this.data.arrObjVoicemodeButtons[newVoicemode].strStatusIcon=this.data.STATUS_ON_ICON;
if(!this.data.arrMaxVolumes[newVoicemode]){this.askForMaxVolume(newVoicemode)
}if(this.objToasterUI){if(this.data.arrMaxVolumes[newVoicemode]){this.objToasterUI.setMaxSlider(this.data.arrMaxVolumes[newVoicemode])
}this.objToasterUI.setSliderSeekable(this.data.isVoicemodeVolumeChangeable(newVoicemode));
this.objToasterUI.changeVoicemodeStatusIcon(newVoicemode,this.data.STATUS_ON_ICON);
this.objToasterUI.setSliderValue(this.data.getCurrentVoicemodeVolume());
this.objToasterUI.setVoicemodeText(this.data.getCurrentVoicemodeText())
}}if(newVoicemode==this.data.VOICEMODE_INTERNAL_HANDFREE||newVoicemode==this.data.VOICEMODE_INTERNAL_GROUP_LISTENING||newVoicemode==this.data.VOICEMODE_EXTERNAL_HANDFREE||newVoicemode==this.data.VOICEMODE_EXTERNAL_GROUP_LISTENING){ICTouchAPI.ledServices.activate("handsFree","ON")
}if(this.objToasterUI&&oldVoicemode&&!(oldVoicemode==this.data.VOICEMODE_IDLE&&newVoicemode==this.data.VOICEMODE_RING)&&oldVoicemode!=this.data.VOICEMODE_RING&&oldVoicemode!=this.data.VOICEMODE_IDLE&&oldVoicemode!=this.data.VOICEMODE_STREAMING&&newVoicemode!=this.data.VOICEMODE_IDLE){this.openAudioToaster()
}else{if(this.objToasterUI&&ICTouchAPI.toasterServices.getContentDisplayedId()==this.objToasterUI.id){this.closeAudioToaster()
}}oldVoicemode=null;
newVoicemode=null
},voicemodeStatusChanged:function(voicemode,status){this.data.arrObjVoicemodeButtons[voicemode].voicemodeStatus=status;
if(this.objToasterUI){if(status==this.data.STATUS_UNAVAILABLE){this.objToasterUI.hideButton(voicemode)
}else{if(status==this.data.STATUS_DISABLE){this.objToasterUI.greyButton(voicemode)
}else{if(status==this.data.STATUS_ENABLE){this.objToasterUI.showButton(voicemode)
}}}}voicemode=null;
status=null
},seekableChanged:function(newValue){if(this.objToasterUI){this.objToasterUI.setSliderSeekable(newValue)
}newValue=null
},askForMaxVolume:function(voicemode){if(voicemode==this.data.VOICEMODE_IDLE){voicemode=this.data.VOICEMODE_RING
}this.data.getMaxVolume(voicemode);
voicemode=null
},maxVolumeChanged:function(mode,maxVol){if(mode==this.data.currentVoicemode&&this.objToasterUI){this.objToasterUI.setMaxSlider(maxVol);
this.objToasterUI.setSliderValue(this.data.getCurrentVoicemodeVolume())
}mode=null;
maxVol=null
},handleVolumeSliderEndChange:function(){var value=this.objToasterUI.getSliderValue();
var setting=this.data.getCurrentVoicemodeSetting();
if(setting==this.data.getVoicemodeSetting(this.data.VOICEMODE_STREAMING)){value=value/5
}ICTouchAPI.settingServices.setSettingValue(setting,value);
this.resetTimer(true)
},handleVolumeSliderBeginChange:function(){this.resetTimer(false)
}});
webapp.audiosetting=new webapp.audiosetting();
dojo.provide("webapp.audiosetting.dataBase");
dojo.declare("webapp.audiosetting.dataBase",null,{isRingVolumeLocked:false,arrVolumeValues:[],constructor:function(){ICTouchAPI.settingServices.getSettingValue("AudioRingLock",this,this.gotRingLockValue)
},getMuteValue:function(){ICTouchAPI.APIServices.IctAudio.getMute({context:this,callback:this.gotMuteValue})
},getCurrentVoicemode:function(){ICTouchAPI.APIServices.IctAudio.getCurrentVoicemode({context:this,callback:this.gotCurrentVoicemode})
},getVoicemodesStatus:function(){ICTouchAPI.APIServices.IctAudio.getVoicemodeStatus({context:this,callback:this.gotVoicemodesStatus})
},getMaxVolume:function(voicemode){ICTouchAPI.APIServices.IctAudio.getVoicemodeMaxVol({params:[voicemode],context:this,callback:this.gotVoicemodeMaxVolume,callbackParams:voicemode});
voicemode=null
}});
dojo.require("webapp.audiosetting.dataBase");
dojo.provide("webapp.audiosetting.data");
dojo.declare("webapp.audiosetting.data",webapp.audiosetting.dataBase,{control:webapp.audiosetting,VOICEMODE_IDLE:0,VOICEMODE_HANDSET:1,VOICEMODE_HEADSET:2,VOICEMODE_INTERNAL_HANDFREE:3,VOICEMODE_INTERNAL_GROUP_LISTENING:4,VOICEMODE_EXTERNAL_HANDFREE:5,VOICEMODE_EXTERNAL_GROUP_LISTENING:6,VOICEMODE_RING:7,VOICEMODE_STREAMING:8,EVT_NOTHING:0,EVT_OFFHOOK:1,EVT_ONHOOK:2,EVT_VOL_PLUS:3,EVT_VOL_MINUS:4,EVT_MUTE_ON:5,EVT_MUTE_OFF:6,EVT_ROUTING_CHANGED:7,EVT_KEY_PLUS:17,EVT_KEY_MINUS:18,STATUS_NEVER:-1,STATUS_DISABLE:0,STATUS_UNAVAILABLE:2,STATUS_ENABLE:1,QUALITY_AUDIO_BTN:"QUALITY_AUDIO_BTN",MUTE_BTN:"MUTE_BTN",HIDE_BTN:"HIDE_BTN",HANDSET_BTN:"HANDSET_BTN",HEADSET_BTN:"HEADSET_BTN",EXTERNAL_HANDSFREE_BTN:"EXTERNAL_HANDSFREE_BTN",INTERNAL_HANDSFREE_BTN:"INTERNAL_HANDSFREE_BTN",INTERNAL_GROUP_BTN:"INTERNAL_GROUP_BTN",EXTERNAL_GROUP_BTN:"EXTERNAL_GROUP_BTN",IDLE_BTN:"IDLE_BTN",STREAMING_BTN:"STREAMING_BTN",RING_BTN:"RING_BTN",STATUS_ON_ICON:"notif-on",STATUS_OFF_ICON:"notif-off",arrMaxVolumes:[],arrVoicemodeLabels:[],arrObjVoicemodeButtons:[],arrVoicemodeSettings:[],arrSecondaryVoicemodeSettings:[],arrVolumeValues:[],streamingVolume:0,objMuteButton:{},objQualityAudioButton:null,currentVoicemode:null,muteStatus:false,boolShownToaster:false,boolQualityAudio:false,boolQualityAudioDisplay:false,_arrAppBarSkeleton:[],APPBAR_CLOSE:0,APPBAR_AUDIOOPTIONS:1,APPBAR_AUDIOVOICEMODE:2,constructor:function(){var func={context:this.control,func:this.control.handleButtons};
this._arrAppBarSkeleton[this.APPBAR_CLOSE]=[this.HIDE_BTN];
this._arrAppBarSkeleton[this.APPBAR_AUDIOOPTIONS]=[this.MUTE_BTN,this.QUALITY_AUDIO_BTN];
this._arrAppBarSkeleton[this.APPBAR_AUDIOVOICEMODE]=[this.IDLE_BTN,this.HANDSET_BTN,this.HEADSET_BTN,this.INTERNAL_HANDSFREE_BTN,this.INTERNAL_GROUP_BTN,this.EXTERNAL_HANDSFREE_BTN,this.EXTERNAL_GROUP_BTN,this.RING_BTN,this.STREAMING_BTN];
this.objMuteButton={strButtonName:this.MUTE_BTN,strButtonLabel:_("Mute","webapp.audiosetting"),strButtonIcon:"audiosetting-mute",strStatusIcon:this.STATUS_OFF_ICON,callback:func};
this.objQualityAudioButton={strButtonName:this.QUALITY_AUDIO_BTN,strButtonLabel:"Auto",strButtonIcon:"audiosetting-quality-audio",strStatusIcon:this.STATUS_OFF_ICON,callback:func};
this.objHideButton={strButtonName:this.HIDE_BTN,strButtonLabel:_("Hide","ICTouchAPI"),strButtonIcon:"generic-down",callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_IDLE]={strButtonName:this.IDLE_BTN,strButtonLabel:_("Idle","webapp.audiosetting"),intVoicemode:this.VOICEMODE_IDLE,strButtonIcon:"audiosetting-handset",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_NEVER,isVolumeChangeable:this.isRingVolumeLocked,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_HANDSET]={strButtonName:this.HANDSET_BTN,strButtonLabel:_("Handset","webapp.audiosetting"),intVoicemode:this.VOICEMODE_HANDSET,strButtonIcon:"audiosetting-handset",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_AVAILABLE,isVolumeChangeable:true,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_HEADSET]={strButtonName:this.HEADSET_BTN,strButtonLabel:_("Headset","webapp.audiosetting"),intVoicemode:this.VOICEMODE_HEADSET,strButtonIcon:"audiosetting-headset",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_AVAILABLE,isVolumeChangeable:true,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_INTERNAL_HANDFREE]={strButtonName:this.INTERNAL_HANDSFREE_BTN,strButtonLabel:_("Internal Handsfree","webapp.audiosetting"),intVoicemode:this.VOICEMODE_INTERNAL_HANDFREE,strButtonIcon:"audiosetting-handsfree",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_AVAILABLE,isVolumeChangeable:true,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_INTERNAL_GROUP_LISTENING]={strButtonName:this.INTERNAL_GROUP_BTN,strButtonLabel:_("Internal Group Listening","webapp.audiosetting"),intVoicemode:this.VOICEMODE_INTERNAL_GROUP_LISTENING,strButtonIcon:"audiosetting-group-listening",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_AVAILABLE,isVolumeChangeable:true,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_EXTERNAL_HANDFREE]={strButtonName:this.EXTERNAL_HANDSFREE_BTN,strButtonLabel:_("External Handsfree","webapp.audiosetting"),intVoicemode:this.VOICEMODE_EXTERNAL_HANDFREE,strButtonIcon:"audiosetting-bluetooth-handsfree",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_AVAILABLE,isVolumeChangeable:true,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_EXTERNAL_GROUP_LISTENING]={strButtonName:this.EXTERNAL_GROUP_BTN,strButtonLabel:_("External Group Listening","webapp.audiosetting"),intVoicemode:this.VOICEMODE_EXTERNAL_GROUP_LISTENING,strButtonIcon:"audiosetting-externalaudio",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_AVAILABLE,isVolumeChangeable:true,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_RING]={strButtonName:this.RING_BTN,strButtonLabel:_("Ring","webapp.audiosetting"),intVoicemode:this.VOICEMODE_RING,strButtonIcon:"audiosetting-externalaudio",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_NEVER,isVolumeChangeable:this.isRingVolumeLocked,callback:func};
this.arrObjVoicemodeButtons[this.VOICEMODE_STREAMING]={strButtonName:this.STREAMING_BTN,strButtonLabel:_("Streaming","webapp.audiosetting"),intVoicemode:this.VOICEMODE_STREAMING,strButtonIcon:"audiosetting-externalaudio",strStatusIcon:this.STATUS_OFF_ICON,voicemodeStatus:this.STATUS_NEVER,isVolumeChangeable:true,callback:func};
this.arrVoicemodeLabels[this.VOICEMODE_IDLE]="Ring Volume";
this.arrVoicemodeLabels[this.VOICEMODE_HANDSET]="Handset Volume";
this.arrVoicemodeLabels[this.VOICEMODE_HEADSET]="Headset Volume";
this.arrVoicemodeLabels[this.VOICEMODE_INTERNAL_HANDFREE]="Speaker Volume";
this.arrVoicemodeLabels[this.VOICEMODE_INTERNAL_GROUP_LISTENING]="Speaker Volume";
this.arrVoicemodeLabels[this.VOICEMODE_EXTERNAL_HANDFREE]="Speaker Volume";
this.arrVoicemodeLabels[this.VOICEMODE_EXTERNAL_GROUP_LISTENING]="Speaker Volume";
this.arrVoicemodeLabels[this.VOICEMODE_RING]="Ring Volume";
this.arrVoicemodeLabels[this.VOICEMODE_STREAMING]="Streaming Volume";
this.arrVoicemodeSettings[this.VOICEMODE_IDLE]="AudioRingVolume";
this.arrVoicemodeSettings[this.VOICEMODE_HANDSET]="AudioHandsetVolume";
this.arrVoicemodeSettings[this.VOICEMODE_HEADSET]="AudioHeadsetVolume";
this.arrVoicemodeSettings[this.VOICEMODE_INTERNAL_HANDFREE]="AudioSpeakerPhoneVolume";
this.arrVoicemodeSettings[this.VOICEMODE_INTERNAL_GROUP_LISTENING]="AudioSpeakerPhoneVolume";
this.arrVoicemodeSettings[this.VOICEMODE_EXTERNAL_HANDFREE]="AudioSpeakerPhoneVolume";
this.arrVoicemodeSettings[this.VOICEMODE_EXTERNAL_GROUP_LISTENING]="AudioSpeakerPhoneVolume";
this.arrVoicemodeSettings[this.VOICEMODE_RING]="AudioRingVolume";
this.arrVoicemodeSettings[this.VOICEMODE_STREAMING]="MPSpeakerPhoneVolume";
this.arrSecondaryVoicemodeSettings[this.VOICEMODE_STREAMING]=[];
this.arrSecondaryVoicemodeSettings[this.VOICEMODE_STREAMING].push("MPHandsetVolume");
this.arrSecondaryVoicemodeSettings[this.VOICEMODE_STREAMING].push("MPHeadsetVolume");
this.arrSecondaryVoicemodeSettings[this.VOICEMODE_STREAMING].push("MPAlarmVolume");
this.arrSecondaryVoicemodeSettings[this.VOICEMODE_STREAMING].push("MPPreviewVolume");
this.arrMaxVolumes[this.VOICEMODE_STREAMING]=7;
this.getMuteValue();
this.getVoicemodesStatus();
this.getCurrentVoicemode();
this.getVolumesValues()
},gotMuteValue:function(value){this.control.muteValueChanged(value);
value=null
},gotCurrentVoicemode:function(intVoicemode){this.control.voicemodeChanged(this.currentVoicemode,intVoicemode);
intVoicemode=null
},gotVoicemodesStatus:function(arrStatus){for(var i=0;
i<arrStatus.length;
i++){if(this.arrObjVoicemodeButtons[i].voicemodeStatus!=this.STATUS_NEVER&&this.arrObjVoicemodeButtons[i].voicemodeStatus!=arrStatus[i]){this.control.voicemodeStatusChanged(i,arrStatus[i])
}}arrStatus=null
},getVolumesValues:function(){for(var i=0;
i<this.arrVoicemodeSettings.length;
i++){if(typeof(this.arrVolumeValues[this.arrVoicemodeSettings[i]])=="undefined"){this.arrVolumeValues[this.arrVoicemodeSettings[i]]=-1;
ICTouchAPI.settingServices.getSetting(this.arrVoicemodeSettings[i],this,this.gotVolumeValue)
}}},gotVolumeValue:function(objSetting){this.arrVolumeValues[objSetting.id]=objSetting.jsValue;
objSetting=null
},gotRingLockValue:function(value){this.isRingVolumeLocked=value;
this.updateVoicemodeChangeable(!value);
value=null
},updateVoicemodeChangeable:function(value){for(var i=0;
i<this.arrVoicemodeSettings.length;
i++){if(this.arrVoicemodeSettings[i]=="AudioRingVolume"){this.arrObjVoicemodeButtons[i].isVolumeChangeable=value;
if(i==this.currentVoicemode){this.control.seekableChanged(value)
}}}value=null
},gotVoicemodeMaxVolume:function(maxVol,mode){this.arrMaxVolumes[mode]=maxVol;
this.control.maxVolumeChanged(mode,maxVol);
if(mode==this.VOICEMODE_RING){this.gotVoicemodeMaxVolume(maxVol,this.VOICEMODE_IDLE)
}maxVol=null;
mode=null
},getArrVoicemodeButtons:function(){return this.arrObjVoicemodeButtons
},getMuteObjButton:function(){return this.objMuteButton
},getHideObjButton:function(){return this.objHideButton
},isCurrentVoicemodeLinkedToSetting:function(settingName){if(this.arrVoicemodeSettings[this.currentVoicemode]==settingName){settingName=null;
return true
}if(this.arrSecondaryVoicemodeSettings[this.currentVoicemode]){for(var i=0;
i<this.arrSecondaryVoicemodeSettings[this.currentVoicemode].length;
i++){if(this.arrSecondaryVoicemodeSettings[this.currentVoicemode][i]==settingName){settingName=null;
return true
}}}settingName=null;
return false
},getCurrentVoicemodeVolume:function(){return this.arrVolumeValues[this.arrVoicemodeSettings[this.currentVoicemode]]
},getCurrentVoicemodeMaxVolume:function(){return this.arrMaxVolumes[this.currentVoicemode]
},getCurrentVoicemodeText:function(){return this.arrVoicemodeLabels[this.currentVoicemode]
},getcorrespondingVoicemodeToButton:function(buttonId){for(var i=0;
i<this.arrObjVoicemodeButtons.length;
i++){if(this.arrObjVoicemodeButtons[i].strButtonName==buttonId){buttonId=null;
return this.arrObjVoicemodeButtons[i].intVoicemode
}}buttonId=null;
return null
},getCurrentVoicemodeSetting:function(){return this.arrVoicemodeSettings[this.currentVoicemode]
},getVoicemodeSetting:function(voicemode){return this.arrVoicemodeSettings[voicemode];
voicemode=null
},isVoicemodeVolumeChangeable:function(voicemode){return this.arrObjVoicemodeButtons[voicemode].isVolumeChangeable;
voicemode=null
},getMuteStatus:function(){return this.muteStatus
},isCurrentVoicemodeVolumeMax:function(){return this.arrVolumeValues[this.arrVoicemodeSettings[this.currentVoicemode]]===this.arrMaxVolumes[this.currentVoicemode]
},isCurrentVoicemodeVolumeMin:function(){return this.arrVolumeValues[this.arrVoicemodeSettings[this.currentVoicemode]]===0
},getObjQualityAudioButton:function(){this.objQualityAudioButton.strStatusIcon=(this.getBoolQualityAudio())?this.STATUS_ON_ICON:this.STATUS_OFF_ICON;
return this.objQualityAudioButton
},getBoolQualityAudio:function(){return this.boolQualityAudio
},setBoolQualityAudio:function(_bool){if(this.boolQualityAudio!=_bool){this.boolQualityAudio=_bool;
this.control.updateAutoVolumeButton()
}},getBoolQualityAudioDisplay:function(){return this.boolQualityAudioDisplay
},setBoolQualityAudioDisplay:function(_bool){if(this.boolQualityAudioDisplay!=_bool){this.boolQualityAudioDisplay=_bool;
this.control.updateAutoVolumeButton()
}}});
webapp.audiosetting.data=new webapp.audiosetting.data();
dojo.provide("webapp.audiosetting.getAudioToasterBase");
dojo.declare("webapp.audiosetting.getAudioToasterBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{});
dojo.require("webapp.audiosetting.getAudioToasterBase");
dojo.provide("webapp.audiosetting.getAudioToaster");
dojo.declare("webapp.audiosetting.getAudioToaster",webapp.audiosetting.getAudioToasterBase,{templatePath:dojo.moduleUrl("webapp.audiosetting","templates/getAudioToaster8082.html"),domAppBarClose:null,domAppBarAudioOptions:null,domAppBarAudioVoicemode:null,domVolumeLabel:null,domVolumeSlider:null,strVolumeLabel:"",volumeSliderUI:null,appBarUiClose:null,appBarUiAudioOptions:null,appBarUiAudioVoicemode:null,muteButtonUi:null,arrVoicemodeButtonUi:[],volumeValue:0,appBars:[],attributeMap:{strVolumeLabel:{node:"domVolumeLabel",type:"innerHTML"}},postCreate:function(){this.strVolumeLabel=_("Ring Volume","webapp.audiosetting");
this.buildAppBar();
this.buildSlider()
},buildAppBar:function(){this.appBarUiClose=ICTouchAPI.AppBarServices.createAppBar("audiosetting","getAudioToaster0",this.webapp.data._arrAppBarSkeleton[0]);
this.appBarUiAudioOptions=ICTouchAPI.AppBarServices.createAppBar("audiosetting","getAudioToaster1",this.webapp.data._arrAppBarSkeleton[1]);
this.appBarUiAudioVoicemode=ICTouchAPI.AppBarServices.createAppBar("audiosetting","getAudioToaster2",this.webapp.data._arrAppBarSkeleton[2],true);
this.hideButtonUi=new UIElements.AppButton.AppButtonControl(this.webapp.data.getHideObjButton());
this.appBarUiClose.addAppButton(this.hideButtonUi,false);
this.appBarUiClose.buildDom();
this.muteButtonUi=new UIElements.AppButton.AppButtonControl(this.webapp.data.getMuteObjButton());
this.appBarUiAudioOptions.addAppButton(this.muteButtonUi,false);
this.qualityAudioButtonUi=new UIElements.AppButton.AppButtonControl(this.webapp.data.getObjQualityAudioButton());
this.appBarUiAudioOptions.addAppButton(this.qualityAudioButtonUi,false);
this.appBarUiAudioOptions.buildDom();
if(!this.webapp.data.getBoolQualityAudioDisplay()){this.qualityAudioButtonUi.hide()
}var voicemodesButtons=this.webapp.data.getArrVoicemodeButtons();
for(var i in voicemodesButtons){var uiButton=new UIElements.AppButton.AppButtonControl(voicemodesButtons[i]);
this.arrVoicemodeButtonUi[voicemodesButtons[i].intVoicemode]=uiButton;
if(voicemodesButtons[i].voicemodeStatus!=this.webapp.data.STATUS_NEVER){this.appBarUiAudioVoicemode.addAppButton(uiButton,false);
if(voicemodesButtons[i].voicemodeStatus==this.webapp.data.STATUS_UNAVAILABLE){uiButton.hide()
}else{if(voicemodesButtons[i].voicemodeStatus==this.webapp.data.STATUS_DISABLE){uiButton.greyTint()
}else{ICTouchAPI.debugServices.error("webapp.audiosettings -- getAudioToaster -- buildAppBar -- Unknow voicemode status")
}}}}this.appBarUiAudioVoicemode.buildDom();
this.appBarUiClose.placeAt(this.domAppBarClose);
this.appBarUiAudioOptions.placeAt(this.domAppBarAudioOptions);
this.appBarUiAudioVoicemode.placeAt(this.domAppBarAudioVoicemode)
},buildSlider:function(){this.volumeSliderUI=new UIElements.Slider.Graduate({intValue:this.webapp.data.getCurrentVoicemodeVolume(),intMinimum:0,intMaximum:this.webapp.data.getCurrentVoicemodeMaxVolume(),boolShowTime:false,boolShowButtonLabel:false,boolSeekable:true},this.domVolumeSlider);
this.volumeSliderUI.seekingstart=dojo.hitch(webapp.audiosetting,webapp.audiosetting.handleVolumeSliderBeginChange);
this.volumeSliderUI.seekingend=dojo.hitch(webapp.audiosetting,webapp.audiosetting.handleVolumeSliderEndChange)
},changeMuteStatusIcon:function(statusValue){this.muteButtonUi.setStatusIcon(statusValue);
statusValue=null
},changeVoicemodeStatusIcon:function(intVoicemode,statusValue){if(this.arrVoicemodeButtonUi[intVoicemode]){this.arrVoicemodeButtonUi[intVoicemode].setStatusIcon(statusValue)
}intVoicemode=null;
statusValue=null
},hideButton:function(intVoicemode){if(this.arrVoicemodeButtonUi[intVoicemode]){this.arrVoicemodeButtonUi[intVoicemode].hide()
}intVoicemode=null
},greyButton:function(intVoicemode){if(this.arrVoicemodeButtonUi[intVoicemode]){this.arrVoicemodeButtonUi[intVoicemode].greyTint()
}intVoicemode=null
},showButton:function(intVoicemode){if(this.arrVoicemodeButtonUi[intVoicemode]){this.arrVoicemodeButtonUi[intVoicemode].show()
}intVoicemode=null
},setSliderValue:function(value){this.volumeValue=value;
var intValue=Math.round(value);
this.volumeSliderUI.setValue(intValue);
value=null
},setVoicemodeText:function(newText){this.strVolumeLabel.changeText(newText);
ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this.strVolumeLabel);
var i18nHandler=this.strVolumeLabel.fillInnerHTML(this.domVolumeLabel);
ICTouchAPI.i18nServices.addI18nHandler(this.strVolumeLabel,i18nHandler);
newText=null
},setMaxSlider:function(intMax){this.volumeSliderUI.intMaximum=intMax;
intMax=null
},getSliderValue:function(){return this.volumeSliderUI.getValue()
},getVolumeValue:function(){return this.volumeValue
},setSliderSeekable:function(boolValue){this.volumeSliderUI.setSeekable(boolValue);
boolValue=null
}});