/**
 * @class webapp.audiosetting.getAudioToaster
 * @namespace webapp.audiosetting
 * @extends webapp.audiosetting.getAudioToasterBase
 */
dojo.require("webapp.audiosetting.getAudioToasterBase");
dojo.provide("webapp.audiosetting.getAudioToaster");
dojo.declare("webapp.audiosetting.getAudioToaster",
	webapp.audiosetting.getAudioToasterBase,
	{
		templatePath: dojo.moduleUrl("webapp.audiosetting","templates/getAudioToaster8082.html"),

		/**
		 * DomElement of the Bar
		 * @property
		 * @type domElement
		 */
		domAppBarClose				: null,
		domAppBarAudioOptions		: null,
		domAppBarAudioVoicemode		: null,
		/**
		 * DomElement of the Label
		 * @property
		 * @type domElement
		 */
		domVolumeLabel			: null,
		/**
		 * DomElement of the Slider
		 * @property
		 * @type domElement
		 */
		domVolumeSlider			: null,

		/**
		 * Current Displayed label
		 * @property
		 * @type String
		 */
		strVolumeLabel			: "",

		/**
		 * Slider UIElement
		 * @property
		 * @type GraduateSlider
		 */
		volumeSliderUI			: null,

		/**
		 * Appbar UIElement
		 * @property
		 * @type AppBar
		 */
		appBarUiClose			: null,
		appBarUiAudioOptions	: null,
		appBarUiAudioVoicemode	: null,
		/**
		 * Mute AppButton
		 * @property
		 * @type AppButton
		 */
		muteButtonUi			: null,
		/**
		 * Voicemode AppButtons
		 * @property
		 * @type AppButtonArray
		 */
		arrVoicemodeButtonUi	: [],

		/**
		 * Current Volume value
		 * @property
		 * @type Float
		 */
		volumeValue				: 0,

		appBars					: [],

		attributeMap: {
			strVolumeLabel: {
				node: "domVolumeLabel",
				type: "innerHTML"
			}
		},

		postCreate : function(){
			this.strVolumeLabel = _("Ring Volume", "webapp.audiosetting");
			this.buildAppBar();
			this.buildSlider();
		},

		/**
		 * Build the appbar
		 */
		buildAppBar: function() {
			//Create the appbar
			this.appBarUiClose = ICTouchAPI.AppBarServices.createAppBar("audiosetting","getAudioToaster0",this.webapp.data._arrAppBarSkeleton[0]);
			this.appBarUiAudioOptions = ICTouchAPI.AppBarServices.createAppBar("audiosetting","getAudioToaster1",this.webapp.data._arrAppBarSkeleton[1]);
			this.appBarUiAudioVoicemode = ICTouchAPI.AppBarServices.createAppBar("audiosetting","getAudioToaster2",this.webapp.data._arrAppBarSkeleton[2], true);

			//Build AppBarUiClose
			this.hideButtonUi = new UIElements.AppButton.AppButtonControl(this.webapp.data.getHideObjButton());
			this.appBarUiClose.addAppButton(this.hideButtonUi,false);
			this.appBarUiClose.buildDom();

			//Build AppBarUiAudioOptions
			this.muteButtonUi = new UIElements.AppButton.AppButtonControl(this.webapp.data.getMuteObjButton());
			this.appBarUiAudioOptions.addAppButton(this.muteButtonUi,false);
			this.qualityAudioButtonUi = new UIElements.AppButton.AppButtonControl(this.webapp.data.getObjQualityAudioButton());
			this.appBarUiAudioOptions.addAppButton(this.qualityAudioButtonUi,false);
			this.appBarUiAudioOptions.buildDom();
			if(!this.webapp.data.getBoolQualityAudioDisplay()){
				this.qualityAudioButtonUi.hide();
			}

			var voicemodesButtons = this.webapp.data.getArrVoicemodeButtons();
			for(var i in voicemodesButtons){
				var uiButton = new UIElements.AppButton.AppButtonControl(voicemodesButtons[i]);
				this.arrVoicemodeButtonUi[voicemodesButtons[i].intVoicemode] = uiButton;
				if (voicemodesButtons[i].voicemodeStatus != this.webapp.data.STATUS_NEVER){
					//Add it to the appbar
					this.appBarUiAudioVoicemode.addAppButton(uiButton,false);
					if (voicemodesButtons[i].voicemodeStatus == this.webapp.data.STATUS_UNAVAILABLE){
						uiButton.hide();
					}else if(voicemodesButtons[i].voicemodeStatus == this.webapp.data.STATUS_DISABLE){
						uiButton.greyTint();
					}else{
						ICTouchAPI.debugServices.error("webapp.audiosettings -- getAudioToaster -- buildAppBar -- Unknow voicemode status");
					}
				}
			}
			this.appBarUiAudioVoicemode.buildDom();

			//Place appBars in the dom
			this.appBarUiClose.placeAt(this.domAppBarClose);
			this.appBarUiAudioOptions.placeAt(this.domAppBarAudioOptions);
			this.appBarUiAudioVoicemode.placeAt(this.domAppBarAudioVoicemode);
		},

		/**
		 * Build the slider
		 */
		buildSlider : function(){
			//Create the ui
			this.volumeSliderUI = new UIElements.Slider.Graduate({
				intValue: this.webapp.data.getCurrentVoicemodeVolume(),
				intMinimum: 0,
				intMaximum: this.webapp.data.getCurrentVoicemodeMaxVolume(),
				boolShowTime: false,
				boolShowButtonLabel : false,
				boolSeekable: true
			}, this.domVolumeSlider);
			//Add it a callback
			this.volumeSliderUI.seekingstart = dojo.hitch(webapp.audiosetting, webapp.audiosetting.handleVolumeSliderBeginChange);
			this.volumeSliderUI.seekingend = dojo.hitch(webapp.audiosetting, webapp.audiosetting.handleVolumeSliderEndChange);
		},

		/**
		 * Change the status icon of the mute button
		 * @param {Boolean} statusValue new status
		 */
		changeMuteStatusIcon : function(statusValue){
			this.muteButtonUi.setStatusIcon(statusValue);
			statusValue = null;
		},

		/**
		 * Change the status icon of any voicemode button
		 * @param {Int} intVoicemode the concernede voicemode
		 * @param {Boolean} statusValue new status
		 */
		changeVoicemodeStatusIcon : function(intVoicemode,statusValue){
			if (this.arrVoicemodeButtonUi[intVoicemode]){
				this.arrVoicemodeButtonUi[intVoicemode].setStatusIcon(statusValue);
			}
			intVoicemode=null;
			statusValue=null;
		},

		/**
		 * Hide a voicemode button
		 * @param {Int} intVoicemode The voicemode to hide
		 */
		hideButton : function(intVoicemode){
			if (this.arrVoicemodeButtonUi[intVoicemode]){
				this.arrVoicemodeButtonUi[intVoicemode].hide();
			}
			intVoicemode=null;
		},

		/**
		 * Grey a voicemode button
		 * @param {Int} intVoicemode The voicemode to Grey
		 */
		greyButton : function(intVoicemode){
			if (this.arrVoicemodeButtonUi[intVoicemode]){
				this.arrVoicemodeButtonUi[intVoicemode].greyTint();
			}
			intVoicemode=null;
		},

		/**
		 * Show a voicemode button
		 * @param {Int} intVoicemode The voicemode to Show
		 */
		showButton : function(intVoicemode){
			if (this.arrVoicemodeButtonUi[intVoicemode]){
				this.arrVoicemodeButtonUi[intVoicemode].show();
			}
			intVoicemode=null;
		},

		/**
		 * Change the slider value
		 * @param {Int} value New slider value
		 */
		setSliderValue: function(value){
			this.volumeValue = value;
			var intValue = Math.round(value);
			this.volumeSliderUI.setValue(intValue);
			value=null;
		},

		/**
		 * Change the voicemode label
		 * @param {String} newText The new Text to display
		 */
		setVoicemodeText : function(newText){
			this.strVolumeLabel.changeText(newText);
			ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this.strVolumeLabel);
			var i18nHandler = this.strVolumeLabel.fillInnerHTML(this.domVolumeLabel);
			ICTouchAPI.i18nServices.addI18nHandler(this.strVolumeLabel, i18nHandler);
			newText=null;
		},

		/**
		 * Change the max value of the volume slider
		 * @param {Int} intMax New max slider value
		 */
		setMaxSlider : function(intMax){
			this.volumeSliderUI.intMaximum = intMax;
			intMax=null;
		},

		/**
		 * Get the current slider value
		 * @return {Int} the current displayed Value
		 */
		getSliderValue : function(){
			return this.volumeSliderUI.getValue();
		},

		/**
		 * Get the saved value, not the slider one
		 * @return {Float} the current Saved Value
		 */
		getVolumeValue : function(){
			return this.volumeValue;
		},

		/**
		 * Change the seekable behaviour of the volume slider
		 * @param {Boolean} boolValue The new seekable value
		 */
		setSliderSeekable : function(boolValue){
			this.volumeSliderUI.setSeekable(boolValue);
			boolValue=null;
		}


	}
	);